#!/bin/bash

rm -f tls/private/ca.key tls/private/ca.csr tls/certs/ca.crt

mkdir -p tls/certs
mkdir -p tls/private

# Generate private key 
openssl genrsa -out tls/private/ca.key 2048 

# Generate CSR 
openssl req -nodes -new -key tls/private/ca.key -out tls/private/ca.csr -subj "/C=IT/L=Pesaro/O=TeamSystem S.p.A."

# Generate Self Signed Key
openssl x509 -req -days 365 -in tls/private/ca.csr -signkey tls/private/ca.key -out tls/certs/ca.crt

