BEGIN;
--------------------------------------------------------------------------------
-- Patch DB admin ver. 20210006 to 20220001
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Patch DB admin ver. 20220001 to 20220002
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Patch DB admin ver. 20220002 to 20220003
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Patch DB admin ver. 20220003 to 20220004
--------------------------------------------------------------------------------
ALTER TABLE admin010_tbfiletransfer
  ADD COLUMN admin010_procedura_id_bp090 integer;

COMMENT ON COLUMN admin010_tbfiletransfer.admin010_procedura_id_bp090
IS 'ID procedura';

ALTER TABLE admin010_tbfiletransfer ADD CONSTRAINT admin010_c02fk FOREIGN KEY (admin010_procedura_id_bp090) REFERENCES bp090_tbprocedure (bp090_id) ON UPDATE CASCADE ON DELETE CASCADE;

ALTER TABLE admin010_tbfiletransfer
  ADD COLUMN admin010_tipologia text DEFAULT 'tsx' NOT NULL;

COMMENT ON COLUMN admin010_tbfiletransfer.admin010_tipologia
IS 'Tipologia';

ALTER TABLE admin010_tbfiletransfer
  ADD COLUMN admin010_rootdir_folder text;

COMMENT ON COLUMN admin010_tbfiletransfer.admin010_rootdir_folder
IS 'Rootdir cartella TS Studio';-- Table public.admin013_tbconf_digital
CREATE TABLE admin013_tbconf_digital(
 admin013_id BigSerial NOT NULL,
 admin013_codice INTEGER NOT NULL DEFAULT 1,
 admin013_tipo_int VARCHAR(2) NOT NULL DEFAULT '0',
 admin013_ambiente VARCHAR(64),
 admin013_start VARCHAR(64),
 admin013_id_int VARCHAR(255),
 admin013_secret VARCHAR(255)
) WITH (OIDS=FALSE);

COMMENT ON TABLE admin013_tbconf_digital IS 'Tabella configurazione Ts Digital'
;
COMMENT ON COLUMN admin013_tbconf_digital.admin013_id IS 'Id'
;
COMMENT ON COLUMN admin013_tbconf_digital.admin013_codice IS 'Codice configurazione'
;
COMMENT ON COLUMN admin013_tbconf_digital.admin013_tipo_int IS 'Tipo di intermediario 0 = Ts studio ; 1 = Manuale '
;
COMMENT ON COLUMN admin013_tbconf_digital.admin013_ambiente IS 'Ambente'
;
COMMENT ON COLUMN admin013_tbconf_digital.admin013_start IS 'Start'
;
COMMENT ON COLUMN admin013_tbconf_digital.admin013_id_int IS 'Id intermediario'
;
COMMENT ON COLUMN admin013_tbconf_digital.admin013_secret IS 'Secret'
;
-- Add keys for table public.admin013_tbconf_digital
ALTER TABLE admin013_tbconf_digital ADD CONSTRAINT admin013_c01pk PRIMARY KEY (admin013_id)
;
ALTER TABLE admin013_tbconf_digital ADD CONSTRAINT admin013_c01uq UNIQUE (admin013_ambiente,admin013_start)
;

-- 
---------------------------------------------------------------------------------------------------------
-- Admin - stored functions
---------------------------------------------------------------------------------------------------------

-- OBSOLETE  --

DROP FUNCTION IF EXISTS spbp001_get_id_users_azienda(int, int, varchar);
DROP FUNCTION IF EXISTS spapi_is_external_user(integer, varchar, integer, integer);
DROP FUNCTION IF EXISTS sputils_is_external_user(integer, integer);

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spadmin_get_error_code(code_name varchar)
  RETURNS int AS
$BODY$
-- Ritorna il codice dell'errore dato il nome
BEGIN
	RETURN admin001_code FROM admin001_tbreturn_code WHERE admin001_code_name = code_name;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spadmin_get_error_info(code_name varchar)
  RETURNS RECORD AS
$BODY$
-- Ritorna il codice e la descrizione dell'errore dato il nome
BEGIN
    RETURN (admin001_code, admin001_code_description) FROM admin001_tbreturn_code WHERE admin001_code_name = code_name;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spadmin_get_dati_licenza_base()
  RETURNS RECORD AS
$BODY$
-- Ritorna l'id nazione + p.iva/c.fiscale + ragione sociale legati alla licenza base 5008
DECLARE
err_cod                     int;
err_msg                     text;
w_bp131_cap                 bp131_tbclienti.bp131_cap%TYPE;
w_bp131_citta               bp131_tbclienti.bp131_citta%TYPE;
w_bp131_piva_codicefiscale  bp131_tbclienti.bp131_piva_codicefiscale%TYPE;
w_bp131_cognomeragsoc       bp131_tbclienti.bp131_cognomeragsoc%TYPE;
w_id_bp018                  bp018_tbnazioni.bp018_id%TYPE;
BEGIN
    w_id_bp018 = NULL;

    -- get record cliente
    SELECT trim(bp131_cap), trim(bp131_citta), trim(bp131_piva_codicefiscale), trim(bp131_cognomeragsoc)
      INTO w_bp131_cap, w_bp131_citta, w_bp131_piva_codicefiscale, w_bp131_cognomeragsoc
      FROM bp131_tbclienti
     WHERE bp131_id = (SELECT bp132_cliente_id_bp131 FROM bp132_tblicenze WHERE bp132_codice_licenza = 5008 LIMIT 1);
    IF NOT FOUND THEN
        err_cod = 1;
        err_msg = 'Effettuare il caricamento della licenza base 5008';
        RETURN (err_cod, err_msg, w_bp131_piva_codicefiscale, w_bp131_cognomeragsoc, w_id_bp018)::RECORD;
    END IF;

    -- check cap/citta della licenza 5008
    IF (w_bp131_cap IS NULL OR w_bp131_cap = '') AND
       (w_bp131_citta IS NULL OR w_bp131_citta = '') THEN
        err_cod = 2;
        err_msg = 'Città e CAP non valorizzati nei dati della licenza 5008';
        RETURN (err_cod, err_msg, w_bp131_piva_codicefiscale, w_bp131_cognomeragsoc, w_id_bp018)::RECORD;
    END IF;

    IF w_bp131_cap IS NULL OR w_bp131_cap = '' OR NOT EXISTS (SELECT 1 FROM bp005_tbcitta WHERE trim(bp005_cap) = w_bp131_cap) THEN
        IF w_bp131_citta IS NULL OR w_bp131_citta = '' OR NOT EXISTS (SELECT 1 FROM bp005_tbcitta WHERE trim(bp005_citta) ILIKE w_bp131_citta) THEN
            err_cod = 3;
            err_msg = 'Città "' || COALESCE(w_bp131_citta, ' ') || '" non trovata nella tabella delle città bp005_tbcitta';
            RETURN (err_cod, err_msg, w_bp131_piva_codicefiscale, w_bp131_cognomeragsoc, w_id_bp018)::RECORD;
        END IF;
    END IF;

    -- primo tentativo get id nazione - by CAP
    IF w_bp131_cap IS NOT NULL AND w_bp131_cap <> '' THEN
        SELECT bp005_nazione_id_bp018 INTO w_id_bp018 FROM bp005_tbcitta WHERE trim(bp005_cap) = w_bp131_cap;
    END IF;

    -- secondo tentativo get id nazione - by CITTA
    IF w_id_bp018 IS NULL THEN
        SELECT bp005_nazione_id_bp018 INTO w_id_bp018 FROM bp005_tbcitta WHERE trim(bp005_citta) ILIKE w_bp131_citta;
        IF NOT FOUND THEN
            err_cod = 4;
            err_msg = 'Impossibile determinare la Nazione dato il CAP o la Città della licenza base';
            RETURN (err_cod, err_msg, w_bp131_piva_codicefiscale, w_bp131_cognomeragsoc, w_id_bp018)::RECORD;
        END IF;
    END IF;

    -- OK
    err_cod = 0;
    err_msg = NULL;
    RETURN (err_cod, err_msg, w_bp131_piva_codicefiscale, w_bp131_cognomeragsoc, w_id_bp018)::RECORD;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

-----------------------------------------------------------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION sputils_get_dati_azienda_base()
  RETURNS record AS
$BODY$
-- Get dati azienda base
DECLARE
w_bp131_piva_codicefiscale  bp131_tbclienti.bp131_piva_codicefiscale%TYPE;
w_bp131_cognomeragsoc       bp131_tbclienti.bp131_cognomeragsoc%TYPE;
w_id_bp018                  bp018_tbnazioni.bp018_id%TYPE;
ret_cod                     int = 0;
ret_msg                     text;
ret_id_azienda              int;
ret_cod_azienda             int;
ret_des_azienda             text;
BEGIN
    ret_id_azienda = Null;
    ret_cod_azienda = Null;
    ret_des_azienda = Null;

    -- get dati licenza base
    SELECT * INTO ret_cod, ret_msg, w_bp131_piva_codicefiscale, w_bp131_cognomeragsoc, w_id_bp018
      FROM spadmin_get_dati_licenza_base()
        AS (ret_cod int, ret_msg text, w_bp131_piva_codicefiscale varchar, w_bp131_cognomeragsoc varchar, w_id_bp018 int) ;
    IF ret_cod <> 0 THEN
        RETURN (ret_cod, ret_msg, ret_id_azienda, ret_cod_azienda, ret_des_azienda)::RECORD;
    END IF;

    -- get dati azienda se già inserita

    -- cerco anagrafica con Partita IVA
    SELECT bp003_id, bp003_codice, bp004_denominazione
      INTO ret_id_azienda, ret_cod_azienda, ret_des_azienda
      FROM bp004_tbanagrafiche
      JOIN bp003_tbaziende ON bp003_anagrafica_id_bp004 = bp004_id
     WHERE bp004_master_id_bp004 IS Null
       AND bp004_partitaiva = w_bp131_piva_codicefiscale;

    IF NOT FOUND THEN
        -- cerco anagrafica con Codice Fiscale
        SELECT bp003_id, bp003_codice, bp004_denominazione
        INTO ret_id_azienda, ret_cod_azienda, ret_des_azienda
        FROM bp004_tbanagrafiche
        JOIN bp003_tbaziende ON bp003_anagrafica_id_bp004 = bp004_id
        WHERE bp004_master_id_bp004 IS Null
        AND bp004_codicefiscale = w_bp131_piva_codicefiscale;
    END IF;

    -- se non trovata determino dati per successivo inserimento
    IF NOT FOUND THEN
        -- get prossimo codice azienda disponibile
        SELECT MAX(bp003_codice) + 1 INTO ret_cod_azienda FROM bp003_tbaziende;
        -- get ragione sociale della licenza 5008
        ret_des_azienda = w_bp131_cognomeragsoc;
    END IF;

    RETURN (ret_cod, ret_msg, ret_id_azienda, ret_cod_azienda, ret_des_azienda)::RECORD;

END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

-----------------------------------------------------------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION sputils_set_azienda_base()
  RETURNS record AS
$BODY$
-- Crea azienda base
DECLARE
ret_cod                     int;
ret_msg                     text;
ret_id_azienda              int;
w_id_bp004                  bp004_tbanagrafiche.bp004_id%TYPE;
w_id_bp018                  bp018_tbnazioni.bp018_id%TYPE;
w_id_bp034                  bp034_tbtipi_generazione.bp034_id%TYPE;
w_bp131_piva_codicefiscale  bp131_tbclienti.bp131_piva_codicefiscale%TYPE;
w_bp131_cognomeragsoc       bp131_tbclienti.bp131_cognomeragsoc%TYPE;
BEGIN
    ret_cod = 0;
    -- get id generatore (se non trovato viene creato)
    w_id_bp034 = spbp034_set_generatore('avvio_rapido', 'inserimento in avvio rapido');

    -- get dati licenza base
    SELECT * INTO ret_cod, ret_msg, w_bp131_piva_codicefiscale, w_bp131_cognomeragsoc, w_id_bp018
      FROM spadmin_get_dati_licenza_base()
        AS (ret_cod int, ret_msg text, w_bp131_piva_codicefiscale varchar, w_bp131_cognomeragsoc varchar, w_id_bp018 int) ;
    IF ret_cod <> 0 THEN
        RETURN (ret_cod, ret_msg, ret_id_azienda);
    END IF;

    -- get id anagrafica azienda base
    SELECT bp004_id INTO w_id_bp004 FROM bp004_tbanagrafiche WHERE bp004_master_id_bp004 IS Null AND bp004_codicefiscale = w_bp131_piva_codicefiscale OR bp004_partitaiva = w_bp131_piva_codicefiscale;
    IF NOT FOUND THEN
        -- generazione record anagrafica per azienda base
        INSERT INTO bp004_tbanagrafiche (
            bp004_generatore_id_bp034,
            bp004_sesso,
            bp004_flg_persona_fisica,
            bp004_cognomeragsoc,
            bp004_denominazione,
            bp004_denominazione_estesa,
            bp004_nazione_nascita_id_bp018,
            bp004_codicefiscale,
            bp004_partitaiva
            )
            VALUES (
            w_id_bp034,
            '*',
            False,
            w_bp131_cognomeragsoc,
            w_bp131_cognomeragsoc,
            w_bp131_cognomeragsoc,
            w_id_bp018,
            w_bp131_piva_codicefiscale,
            CASE WHEN char_length(w_bp131_piva_codicefiscale) = 11 THEN w_bp131_piva_codicefiscale ELSE Null END
            ) RETURNING bp004_id INTO w_id_bp004;
    END IF;

    -- get id azienda base
    SELECT bp003_id INTO ret_id_azienda FROM bp003_tbaziende WHERE bp003_anagrafica_id_bp004 = w_id_bp004;
    IF NOT FOUND THEN
        -- generazione record azienda base
        INSERT INTO bp003_tbaziende (
            bp003_codice,
            bp003_anagrafica_id_bp004,
            bp003_categoria_id_bp017,
            bp003_sottocategoria_id_bp032,
            bp003_generatore_id_bp034,
            bp003_flg_licadmin
            )
            VALUES (
            (SELECT MAX(bp003_codice) + 1 FROM bp003_tbaziende),
            w_id_bp004,
            0,
            0,
            w_id_bp034,
            True
            ) RETURNING bp003_id INTO ret_id_azienda;
    END IF;

    RETURN (ret_cod, ret_msg, ret_id_azienda);
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

-----------------------------------------------------------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION sputils_startup_utente_ins(id_azienda int, cognome varchar, nome varchar, login varchar, pwd varchar, codfis varchar, email varchar)
  RETURNS record AS
$BODY$
-- Crea utente allo startup
DECLARE
w_id_bp018                  bp018_tbnazioni.bp018_id%TYPE;
w_id_bp034                  bp034_tbtipi_generazione.bp034_id%TYPE;
w_bp131_piva_codicefiscale  bp131_tbclienti.bp131_piva_codicefiscale%TYPE;
w_bp131_cognomeragsoc       bp131_tbclienti.bp131_cognomeragsoc%TYPE;
ret_cod                     int = 0;
ret_msg                     text;
ret_id_bp004                bp004_tbanagrafiche.bp004_id%TYPE;
ret_id_bp001                bp001_tbutenti.bp001_id%TYPE;
ret_id_bp010                bp010_tbutentiaziende.bp010_id%TYPE;
BEGIN
    ret_cod = 0;
    -- get id generatore (se non trovato viene creato)
    w_id_bp034 = spbp034_set_generatore('avvio_rapido', 'inserimento in avvio rapido');

    -- get dati licenza base
    SELECT * INTO ret_cod, ret_msg, w_bp131_piva_codicefiscale, w_bp131_cognomeragsoc, w_id_bp018
      FROM spadmin_get_dati_licenza_base()
        AS (ret_cod int, ret_msg text, w_bp131_piva_codicefiscale varchar, w_bp131_cognomeragsoc varchar, w_id_bp018 int) ;
    IF ret_cod <> 0 THEN
        RETURN (ret_cod, ret_msg, ret_id_bp004, ret_id_bp001, ret_id_bp010)::RECORD;
    END IF;

    -- verifico se il codice fiscale è già presente in anagrafica
    IF codfis IS NOT Null AND EXISTS(SELECT 1 FROM bp004_tbanagrafiche WHERE bp004_master_id_bp004 IS Null AND bp004_codicefiscale = codfis) THEN
        -- errore
        ret_cod = 3;
        ret_msg = 'Il codice fiscale "' || codfis || '" inserito per l''utente ' || cognome || ' ' || nome || ' è già presente in anagrafica e non può essere inserito di nuovo.';
        RETURN (ret_cod, ret_msg, ret_id_bp004, ret_id_bp001, ret_id_bp010)::RECORD;
    END IF;

    -- se anagrafica utente non trovata
    IF ret_id_bp004 IS Null THEN
        -- generazione record anagrafica per utente
        INSERT INTO bp004_tbanagrafiche (
            bp004_generatore_id_bp034,
            bp004_flg_persona_fisica,
            bp004_nome,
            bp004_cognomeragsoc,
            bp004_denominazione,
            bp004_denominazione_estesa,
            bp004_nazione_nascita_id_bp018,
            bp004_codicefiscale,
            bp004_email
            )
            VALUES (
            w_id_bp034,
            True,
            nome,
            cognome,
            cognome || ' ' || nome,
            cognome || ' ' || nome,
            w_id_bp018,
            codfis,
            email
            ) RETURNING bp004_id INTO ret_id_bp004;
    END IF;

    -- get id utente
    SELECT bp001_id INTO ret_id_bp001 FROM bp001_tbutenti WHERE bp001_anagrafica_id_bp004 = ret_id_bp004;
    IF NOT FOUND THEN
        -- generazione record utente
        INSERT INTO bp001_tbutenti (
            bp001_anagrafica_id_bp004,
            bp001_nomeutente,
            bp001_password,
            bp001_cambio_pass,
            bp001_generatore_id_bp034,
            bp001_dataora_mod
            )
            VALUES (
            ret_id_bp004,
            login,
            pwd,
            True,
            w_id_bp034,
            now()  -- FIXME la mettiamo ?
            ) RETURNING bp001_id INTO ret_id_bp001;
    END IF;
    -- associa utente ad azienda
    SELECT bp010_id INTO ret_id_bp010 FROM bp010_tbutentiaziende WHERE bp010_azienda_id_bp003 = id_azienda AND bp010_utente_id_bp001 = ret_id_bp001;
    IF NOT FOUND THEN
        -- generazione record utente aziendale
        INSERT INTO bp010_tbutentiaziende (
            bp010_azienda_id_bp003,
            bp010_utente_id_bp001
            )
            VALUES (
            id_azienda,
            ret_id_bp001
            ) RETURNING bp010_id INTO ret_id_bp010;
    END IF;

    RETURN (ret_cod, ret_msg, ret_id_bp004, ret_id_bp001, ret_id_bp010)::RECORD;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

 -----------------------------------------------------------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION sputils_startup_utente_dlt(id_azienda int, int[])
  RETURNS void AS
$BODY$
-- Riceve: id_azienda
--         lista id_utenti_aziendali attualmente in essere
-- Elimina tutti gli utenti dell'azienda che non fanno parte della lista id_utenti ricevuta
DECLARE
lst_current_id_bp010    ALIAS FOR $2;
curs                    REFCURSOR;
w_bp010_id              bp010_tbutentiaziende.bp010_id%TYPE;
w_bp001_id              bp001_tbutenti.bp001_id%TYPE;
BEGIN
    OPEN curs FOR SELECT bp010_id, bp010_utente_id_bp001
                    FROM bp010_tbutentiaziende
                   WHERE bp010_azienda_id_bp003 = id_azienda
                     AND bp010_id != ALL (lst_current_id_bp010);

    LOOP FETCH curs INTO w_bp010_id, w_bp001_id;
        EXIT WHEN NOT FOUND;

        -- eliminare l'utente come capogruppo da tutti i gruppi aziendali in cui ricopre tale carica
        UPDATE bp021_tbga SET bp021_capogruppo_id_bp022 = NULL
         WHERE bp021_capogruppo_id_bp022 IN (SELECT bp022_id FROM bp022_tbutentiga
                                                            WHERE bp021_azienda_id_bp003 = id_azienda
                                                              AND bp022_utente_id_bp001 = w_bp001_id);

        -- elimina l'utente da tutti i gruppi aziendali di appartenenza
        DELETE FROM bp022_tbutentiga
               USING bp021_tbga
         WHERE bp021_azienda_id_bp003 = id_azienda
           AND bp022_utente_id_bp001 = w_bp001_id;

        -- elimina l'utente dall'azienda
        DELETE FROM bp010_tbutentiaziende WHERE bp010_id = w_bp010_id;

        -- se l'utente appartiene alla sola azienda in esame allora elimino anche bp004 e bp001
        IF NOT EXISTS(SELECT 1 FROM bp010_tbutentiaziende WHERE bp010_utente_id_bp001 = w_bp001_id) THEN

            -- elimina l'utente da tutti i gruppi portale di appartenenza
            DELETE FROM bp009_tbutentigruppi
                  WHERE bp009_utente_id_bp001 = w_bp001_id;

            -- se l'utente era il supervisore aziendale va eliminato da tale carica
            UPDATE bp003_tbaziende SET bp003_supervisor_id_bp001 = NULL
             WHERE bp003_id = id_azienda
               AND bp003_supervisor_id_bp001 = w_bp001_id;

            -- elimina l'utente dal portale
            DELETE FROM bp001_tbutenti WHERE bp001_id = w_bp001_id;

            -- elimina l'anagrafica dell'utente
            DELETE FROM bp004_tbanagrafiche
                  USING bp001_tbutenti
                  WHERE bp001_id = w_bp001_id
                    AND bp004_id = bp001_anagrafica_id_bp004;
        END IF;

    END LOOP;
    CLOSE curs;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

 -----------------------------------------------------------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION sputils_startup_utente_upd(id_utente int, id_anag bigint, cognome varchar, nome varchar, codfis varchar, email varchar, login varchar)
  RETURNS void AS
$BODY$
-- Aggiorna dati utente allo startup
DECLARE
w_denominazione   varchar;
BEGIN
    -- aggiorna utente
    UPDATE bp001_tbutenti SET bp001_nomeutente = login WHERE bp001_id = id_utente;
    IF nome IS NULL THEN
        w_denominazione = cognome;
    ELSE
        w_denominazione = cognome || ' ' || nome;
    END IF;
    -- aggiorna anagrafica
    UPDATE bp004_tbanagrafiche
    SET bp004_cognomeragsoc = cognome,
        bp004_nome = nome,
        bp004_denominazione = w_denominazione,
        bp004_denominazione_estesa = w_denominazione,
        bp004_codicefiscale = codfis,
        bp004_email = email
    WHERE bp004_id = id_anag;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

----------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp081_get_user_menu_items(id_user integer, id_company integer, id_proc integer, mod_exe varchar)
  RETURNS SETOF record AS
$BODY$
/*
  # Ritorna il menu della procedura visibile all'utente
  #----------------------------------------------------------------------------------------------------
  # Idx Colonna                             Tipo
  #----------------------------------------------------------------------------------------------------
  #  0  bp081_id                            bigint
  #  1  id_first_lic                        bigint (id della prima licenza trovata, se Null la voce di menu non richiede licenze)
  #----------------------------------------------------------------------------------------------------
*/
DECLARE
w_ses          session_acla_utente;
w_id_root      bigint;
w_cmd          text = '';
w_check_acla   boolean;
BEGIN
        -- get dati sessione utente (gruppi di appartenenza, id filiale, id sede, verifica se amministratore)
        w_ses = sputils_get_session_acla_utente(id_company, id_user);

        -- get id della voce menu root della procedura
        SELECT bp081_id INTO w_id_root
          FROM vbp081_tbvoci_menu_attive
         WHERE ( bp081_procedura_id_bp090 = id_proc AND bp081_voce_menu_padre_id_bp081 IS NULL )
                 OR
               ( bp081_procedura_id_bp090 <> id_proc AND bp081_id = ( SELECT bp081_voce_menu_padre_id_bp081
                                                                        FROM vbp081_tbvoci_menu_attive
                                                                       WHERE bp081_procedura_id_bp090 = id_proc
                                                                    ORDER BY bp081_valore_ordinale
                                                                       LIMIT 1) );
        -- root non trovata !   ---> exit -1
        IF NOT FOUND THEN
            RETURN QUERY SELECT -1::bigint, Null::text, Null::bigint[];
            RETURN;
        END IF;

        -- se procedura Amministrazione e l'utente non e 'admin' né equiparato ad amministratore né poweruser   ---> exit -2
        IF sputils_is_poweruser(id_user) = 0 AND
           w_ses.user_is_admin = 0 AND
           exists(SELECT bp090_id FROM bp090_tbprocedure WHERE bp090_id = id_proc AND bp090_sigla_procedura = 'admin') THEN
            RETURN QUERY SELECT -2::bigint, Null::text, Null::bigint[];
            RETURN;
        END IF;

        -- se l'utente fa parte degli Amministratori                  oppure
        -- se le ACLA sono disabilitate in TP                         oppure
        -- se la procedura non e soggetta ad ACLA                     oppure
        -- se le ACLA sono disabilitate per la procedure
        IF w_ses.user_is_admin = 1 OR
            exists(SELECT bp245_id FROM bp245_tbaclaconfig WHERE bp245_codice = 1 AND bp245_aclaabilitato = False)  OR
            exists(SELECT bp121_id FROM bp121_tbapplicazioni WHERE bp121_procedura_id_bp090 = id_proc AND (bp121_acla = False OR bp121_acla_disabled = True))
        THEN
            w_check_acla = False;
        ELSE
            w_check_acla = True;
        END IF;

        RETURN QUERY

         WITH RECURSIVE menu_recursive(bp081_id, lics ) AS (
                SELECT bp081_id, lics, bp081_codice, bp081_tipo_voce, bp081_flg_acla
                  FROM vbp081_tbvoci_menu_attive
                  LEFT OUTER JOIN ( SELECT array_agg(bp082_id) AS lics, bp082_voce_menu_id_bp081 FROM bp082_tblicenze_voci_menu
                                     GROUP BY bp082_voce_menu_id_bp081) ml ON ml.bp082_voce_menu_id_bp081 = bp081_id

                 WHERE bp081_id = w_id_root
                   AND (position('A' in bp081_modalita_esecuzione) <> 0 OR
                        position(mod_exe in bp081_modalita_esecuzione) <> 0 OR
                        (position('I' in bp081_modalita_esecuzione) <> 0 AND sputils_is_teamsystem() = 1) )

                UNION ALL

                SELECT m.bp081_id, CASE WHEN array_length(mylics, 1) > 0 THEN mylics ELSE mr.lics END as lics, m.bp081_codice, m.bp081_tipo_voce, m.bp081_flg_acla
                  FROM menu_recursive mr, vbp081_tbvoci_menu_attive m
                  LEFT OUTER JOIN ( SELECT array_agg(bp082_id) AS mylics, bp082_voce_menu_id_bp081 FROM bp082_tblicenze_voci_menu
                                     GROUP BY bp082_voce_menu_id_bp081) ml ON ml.bp082_voce_menu_id_bp081 = m.bp081_id

                 WHERE mr.bp081_id = m.bp081_voce_menu_padre_id_bp081
                   AND(position('A' in m.bp081_modalita_esecuzione) <> 0 OR
                       position(mod_exe in m.bp081_modalita_esecuzione) <> 0 OR
                       (position('I' in m.bp081_modalita_esecuzione) <> 0 AND sputils_is_teamsystem() = 1) )
            )
              SELECT bp081_id, bp081_codice, lics
              FROM menu_recursive
             WHERE NOT w_check_acla
                OR NOT bp081_flg_acla
                OR ( bp081_tipo_voce in (1, 2, 3, 4) AND sputils_check_acla_rule( bp081_id, w_ses) )
                OR ( bp081_tipo_voce in (0, 20, 30, 40) AND sputils_has_one_leaf_consenti( bp081_id, w_ses, mod_exe, False) );
        RETURN;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100
  ROWS 1000;

----------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION sputils_is_user_in_company(id_user integer, id_company integer)
  RETURNS boolean AS
$BODY$
-- Ritorna True se l'utente fa parte dell'azienda ricevuta
BEGIN
    RETURN CASE WHEN EXISTS (SELECT 1 FROM bp010_tbutentiaziende
                                     WHERE bp010_utente_id_bp001 = id_user
                                       AND bp010_azienda_id_bp003 = id_company)
           THEN True
           ELSE False
           END;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp002_ins_gruppo_portale(sigla varchar, descrizione varchar)
  RETURNS character varying[] AS
$BODY$
-- Inserisce un gruppo portale
DECLARE
ret_id	bp002_tbgruppi.bp002_id%TYPE;
BEGIN
    IF sigla IS NULL OR trim(sigla) = '' THEN
	-- sigla mancante
	RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'sigla gruppo non valorizzata', NULL];
    ELSIF descrizione IS NULL OR trim(descrizione) = '' THEN
	-- descrizione mancante
	RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'descrizione gruppo non valorizzata', NULL];
    END IF;

    -- elimino spazi superflui
    sigla = trim(sigla);
    descrizione = trim(descrizione);

    IF EXISTS (SELECT 1 FROM bp002_tbgruppi WHERE bp002_nomegruppo = sigla) THEN
	    -- sigla gruppo già esistente
	    RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DUP_KEY')::varchar,'sigla ' || sigla || ' gruppo già esistente', NULL];
    END IF;

    INSERT INTO bp002_tbgruppi (bp002_nomegruppo, bp002_descrizione) VALUES (sigla, descrizione) RETURNING bp002_id INTO ret_id;
	-- id del gruppo inserito
	RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar,'gruppo inserito', ret_id::varchar];

    EXCEPTION
	WHEN string_data_right_truncation THEN
		-- sigla o descrizione troppo lunga
		RETURN ARRAY[spadmin_get_error_code('ERR_CODE_STRING_DATA_RIGHT_TRUNCATION')::varchar,'sigla o descrizione gruppo troppo lunga', NULL];
	WHEN others THEN
		-- errore DB non gestito
		RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp002_ins_gruppo_portale', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp002_upd_gruppo_portale(id_grp integer, sigla character varying, descrizione character varying)
  RETURNS character varying[] AS
$BODY$
-- Aggiorna la descrizione di un gruppo portale
DECLARE
ret_des    bp002_tbgruppi.bp002_descrizione%TYPE;
BEGIN
	ret_des = '';
	CASE
	    WHEN id_grp IS NULL AND (sigla IS NULL OR trim(sigla) = '') THEN
	        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave gruppo non valorizzata (richiesto id o sigla gruppo)', NULL];

	    WHEN id_grp IS NOT NULL AND sigla IS NOT NULL THEN
	        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o sigla gruppo', NULL];

	    WHEN descrizione IS NULL OR trim(descrizione) = '' THEN
	        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'descrizione gruppo non valorizzata', NULL];

	    WHEN id_grp IS NOT NULL THEN
                SELECT bp002_descrizione INTO ret_des FROM bp002_tbgruppi WHERE bp002_id = id_grp;
	        IF NOT FOUND THEN
	            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo inesistente (id non trovato)', NULL];
                END IF;
	        -- aggiorno tramite id
                UPDATE bp002_tbgruppi SET bp002_descrizione = trim(descrizione) WHERE bp002_id = id_grp;

            WHEN sigla IS NOT NULL THEN
                SELECT bp002_descrizione INTO ret_des FROM bp002_tbgruppi WHERE bp002_nomegruppo = sigla;
	        IF NOT FOUND THEN
	            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo inesistente (sigla non trovata)', NULL];
                END IF;
                -- aggiorno tramite sigla
                UPDATE bp002_tbgruppi SET bp002_descrizione = trim(descrizione) WHERE bp002_nomegruppo = sigla;
            ELSE
                -- errore DB non gestito
		RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito', NULL];
        END CASE;

        -- OK - ritorna la vecchia descrizione
        RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, 'descrizione gruppo aggiornata', ret_des];

        EXCEPTION
	    WHEN string_data_right_truncation THEN
	        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_STRING_DATA_RIGHT_TRUNCATION')::varchar,'descrizione gruppo troppo lunga', NULL];
	    WHEN others THEN
	        -- errore DB non gestito
		RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp002_upd_gruppo_portale', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp002_dlt_gruppo_portale(id_grp integer, sigla character varying)
  RETURNS character varying[] AS
$BODY$
-- Elimina un gruppo portale
BEGIN
	CASE
	    WHEN id_grp IS NULL AND (sigla IS NULL OR sigla = '') THEN
	        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave gruppo non valorizzata (richiesto id o sigla gruppo)', NULL];

	    WHEN id_grp IS NOT NULL AND sigla IS NOT NULL THEN
	        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o sigla gruppo', NULL];

	    WHEN id_grp IS NOT NULL THEN

	        IF NOT EXISTS (SELECT 1 FROM bp002_tbgruppi WHERE bp002_id = id_grp) THEN
	            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo inesistente (id non trovato)', NULL];
                END IF;
	        -- elimino gruppo tramite id
                DELETE FROM bp002_tbgruppi WHERE bp002_id = id_grp;

            WHEN sigla IS NOT NULL THEN

                IF NOT EXISTS (SELECT 1 FROM bp002_tbgruppi WHERE bp002_nomegruppo = sigla) THEN
	            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo inesistente (sigla non trovata)', NULL];
                END IF;
                -- elimino gruppo tramite sigla
                DELETE FROM bp002_tbgruppi WHERE bp002_nomegruppo = sigla;
            ELSE
                -- errore DB non gestito
	        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito', NULL];
        END CASE;

        -- OK
        RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, 'gruppo eliminato', NULL];

        EXCEPTION
	    WHEN others THEN
	        -- errore DB non gestito
		RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp002_dlt_gruppo_portale', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp021_ins_gruppo_aziendale(id_azienda integer, cod_azienda integer, sigla varchar, descrizione varchar)
  RETURNS character varying[] AS
$BODY$
-- Inserisce un gruppo aziendale
DECLARE
ret_id          bp021_tbga.bp021_id%TYPE;
w_id_azienda    bp021_tbga.bp021_azienda_id_bp003%TYPE;
BEGIN
    w_id_azienda = NULL;
    -- check parameter validity
    IF id_azienda IS NULL AND cod_azienda IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave azienda non valorizzata (richiesto id o codice azienda)', NULL];
    ELSIF id_azienda IS NOT NULL AND cod_azienda IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o codice azienda', NULL];
    ELSIF sigla IS NULL OR trim(sigla) = '' THEN
        -- sigla mancante
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'sigla gruppo aziendale non valorizzata', NULL];
    ELSIF descrizione IS NULL OR trim(descrizione) = '' THEN
        -- descrizione mancante
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'descrizione gruppo aziendale non valorizzata', NULL];
    END IF;

    IF cod_azienda IS NOT NULL THEN
        -- check esistenza azienda dato il codice  (get id azienda)
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_codice = cod_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (codice non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza azienda dato l'id (metto in comodo ID)
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_id = id_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (id non trovato)', NULL];
        END IF;
    END IF;

    -- elimino spazi superflui
    sigla = trim(sigla);
    descrizione = trim(descrizione);

    -- check esistenza gruppo aziendale
    IF EXISTS (SELECT 1 FROM bp021_tbga WHERE bp021_azienda_id_bp003 = w_id_azienda AND bp021_siglaga = sigla) THEN
        -- sigla gruppo già esistente
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DUP_KEY')::varchar,'sigla ' || sigla || ' gruppo aziendale già esistente', NULL];
    END IF;

    -- creazione gruppo aziendale
    INSERT INTO bp021_tbga (bp021_azienda_id_bp003, bp021_siglaga, bp021_ga) VALUES (w_id_azienda, sigla, descrizione) RETURNING bp021_id INTO ret_id;

    -- id del gruppo inserito
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar,'gruppo aziendale inserito', ret_id::varchar];

    EXCEPTION
    WHEN string_data_right_truncation THEN
        -- sigla o descrizione troppo lunga
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_STRING_DATA_RIGHT_TRUNCATION')::varchar,'sigla o descrizione gruppo aziendale troppo lunga', NULL];
    WHEN others THEN
        -- errore DB non gestito
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp021_ins_gruppo_aziendale', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

-- wrapper per compatibilità pregresso
DROP FUNCTION IF EXISTS spbp021_upd_gruppo_aziendale(integer, integer, varchar, varchar);
CREATE OR REPLACE FUNCTION spbp021_upd_gruppo_aziendale(id_azienda integer, cod_azienda integer, sigla_grp character varying, descrizione character varying)
  RETURNS character varying[] AS
$BODY$
BEGIN
   RETURN spbp021_upd_gruppo_aziendale(integer, integer, varchar, varchar, -1);
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

DROP FUNCTION IF EXISTS spbp021_upd_gruppo_aziendale(integer, integer, varchar, integer, varchar);

CREATE OR REPLACE FUNCTION spbp021_upd_gruppo_aziendale(id_azienda integer, cod_azienda integer, sigla_grp character varying, id_utente_capogruppo integer, descrizione character varying)
  RETURNS character varying[] AS
$BODY$
-- Aggiorna la descrizione di un gruppo aziendale
DECLARE
w_id_azienda    bp003_tbaziende.bp003_id%TYPE;
w_id_ga         bp021_tbga.bp021_id%TYPE;
w_id_bp022      bp022_tbutentiga.bp022_id%TYPE;
ret_des      	bp021_tbga.bp021_ga%TYPE;
BEGIN
	ret_des = '';
	-- check parametri
	IF sigla_grp IS NULL OR trim(sigla_grp) = '' THEN
	    RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'sigla gruppo aziendale non valorizzata', NULL];
	ELSIF id_azienda IS NULL AND cod_azienda IS NULL THEN
	    RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave azienda non valorizzata (richiesto id o codice azienda)', NULL];
	ELSIF id_azienda IS NOT NULL AND cod_azienda IS NOT NULL THEN
	    RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o codice azienda', NULL];
	ELSIF descrizione IS NULL OR trim(descrizione) = '' THEN
	    RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'descrizione gruppo aziendale non valorizzata', NULL];
	END IF;

	-- check azienda
        IF cod_azienda IS NOT NULL THEN
	    -- check esistenza azienda dato il codice  (get id azienda)
	    SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_codice = cod_azienda;
	    IF NOT FOUND THEN
                RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (codice non trovato)', NULL];
	    END IF;
        ELSIF id_azienda IS NOT NULL THEN
	    -- check esistenza azienda dato l'id (metto in comodo ID)
	    SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_id = id_azienda;
	    IF NOT FOUND THEN
	        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (id non trovato)', NULL];
	    END IF;
        END IF;

        -- check esistenza gruppo aziendale + get vecchia descrizione
        SELECT bp021_id, bp021_ga INTO w_id_ga, ret_des FROM bp021_tbga WHERE bp021_azienda_id_bp003 = w_id_azienda AND bp021_siglaga = sigla_grp;
	    IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo aziendale inesistente', NULL];
        END IF;

        -- verifica se l'utente capogruppo appartiene al gruppo aziendale
        w_id_bp022 = NULL;
        IF id_utente_capogruppo IS NOT NULL AND id_utente_capogruppo <> -1 THEN
            SELECT bp022_id INTO w_id_bp022 FROM bp022_tbutentiga WHERE bp022_ga_id_bp021 = w_id_ga AND bp022_utente_id_bp001 = id_utente_capogruppo;
            IF NOT FOUND THEN
                RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente non appartenente al gruppo. Impossibile nominarlo capogruppo', NULL];
            END IF;
        END IF;

        IF id_utente_capogruppo IS NOT NULL AND id_utente_capogruppo = -1 THEN
	        -- aggiorno descrizione gruppo aziendale
	        UPDATE bp021_tbga SET bp021_ga = trim(descrizione) WHERE bp021_azienda_id_bp003 = w_id_azienda AND bp021_siglaga = sigla_grp;
        ELSE
	        -- aggiorno descrizione gruppo aziendale e capogruppo
	        UPDATE bp021_tbga SET bp021_ga = trim(descrizione), bp021_capogruppo_id_bp022 = w_id_bp022 WHERE bp021_azienda_id_bp003 = w_id_azienda AND bp021_siglaga = sigla_grp;
        END IF;

        -- OK - ritorna la vecchia descrizione
        RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, 'gruppo aziendale aggiornato correttamente', ret_des];

        EXCEPTION
	    WHEN string_data_right_truncation THEN
	        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_STRING_DATA_RIGHT_TRUNCATION')::varchar,'descrizione gruppo aziendale troppo lunga', NULL];
	    WHEN others THEN
	        -- errore DB non gestito
		    RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp021_upd_gruppo_aziendale', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp021_dlt_gruppo_aziendale(id_azienda integer, cod_azienda integer, sigla_grp character varying)
  RETURNS character varying[] AS
$BODY$
-- Elimina un gruppo aziendale
DECLARE
w_id_azienda    bp003_tbaziende.bp003_id%TYPE;
BEGIN
    -- check parametri
    IF sigla_grp IS NULL OR trim(sigla_grp) = '' THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'sigla gruppo aziendale non valorizzata', NULL];
    ELSIF id_azienda IS NULL AND cod_azienda IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave azienda non valorizzata (richiesto id o codice azienda)', NULL];
    ELSIF id_azienda IS NOT NULL AND cod_azienda IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o codice azienda', NULL];
    END IF;

    -- check azienda
    IF cod_azienda IS NOT NULL THEN
        -- check esistenza azienda dato il codice  (get id azienda)
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_codice = cod_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (codice non trovato)', NULL];
        END IF;
    ELSIF id_azienda IS NOT NULL THEN
        -- check esistenza azienda dato l'id (metto in comodo ID)
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_id = id_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (id non trovato)', NULL];
        END IF;
    END IF;

    -- check esistenza gruppo aziendale
    IF NOT EXISTS(SELECT 1 FROM bp021_tbga WHERE bp021_azienda_id_bp003 = w_id_azienda AND bp021_siglaga = sigla_grp) THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo aziendale inesistente', NULL];
    END IF;

    -- elimino gruppo aziendale
    DELETE FROM bp021_tbga WHERE bp021_azienda_id_bp003 = w_id_azienda AND bp021_siglaga = sigla_grp;

    -- OK
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, 'gruppo aziendale eliminato', NULL];

    EXCEPTION
        WHEN others THEN
            -- errore DB non gestito
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp021_dlt_gruppo_aziendale', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp003_get_id_company_by_piva_cfis(piva_cfis varchar)
  RETURNS character varying[] AS
$BODY$
-- Riceve: partita iva o codice fiscale
-- Ritorna: l'id dell'azienda alla quale è associata la partita iva o il codice fiscale ricevuto
-- N.B.: ricerca solo in anagrafiche master
DECLARE
w_id_company    bp003_tbaziende.bp003_id%TYPE;
BEGIN
    -- check parametri
    IF piva_cfis IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'valorizzare partita iva/cod.fiscale', NULL];
    END IF;

    -- cerco azienda con p.iva
    SELECT bp003_id INTO w_id_company FROM bp003_tbaziende
                    JOIN bp004_tbanagrafiche ON bp004_id = bp003_anagrafica_id_bp004 AND bp004_master_id_bp004 IS NULL
                   WHERE bp004_partitaiva = piva_cfis;
    IF w_id_company IS NULL THEN
        -- cerco azienda con c.fiscale
        SELECT bp003_id INTO w_id_company FROM bp003_tbaziende
                    JOIN bp004_tbanagrafiche ON bp004_id = bp003_anagrafica_id_bp004 AND bp004_master_id_bp004 IS NULL
                   WHERE bp004_codicefiscale = piva_cfis;
    END IF;
    IF w_id_company IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'partita iva/cod.fiscale non associato ad alcuna azienda', NULL];
    ELSE
        RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar,'azienda trovata', w_id_company::varchar];
    END IF;

    EXCEPTION
        WHEN others THEN
            -- errore DB non gestito
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp003_get_id_company_by_piva_cfis', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------
DROP FUNCTION IF EXISTS spbp003_create_company(varchar, int, varchar, bigint, int, boolean);

CREATE OR REPLACE FUNCTION spbp003_create_company(id_generatore int, codice int, ragsoc varchar, id_anag bigint, uic_code int, flg_persona_fisica boolean)
  RETURNS character varying[] AS
$BODY$
-- Inserisce una nuova azienda
DECLARE
ret_id		bp003_tbaziende.bp003_id%TYPE;
w_id_bp018	bp018_tbnazioni.bp018_id%TYPE;
ret_data        varchar = '';
BEGIN
    -- check parametri
    IF id_anag IS NOT NULL AND ragsoc IS NOT NULL AND ragsoc <> '' THEN
    	RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id anagrafica o ragione sociale', NULL];
    ELSIF id_anag IS NULL AND (ragsoc IS NULL OR trim(ragsoc) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'valorizzare id anagrafica o ragione sociale', NULL];
    ELSIF id_anag IS NULL AND flg_persona_fisica IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'flag persona fisica non valorizzato', NULL];
    END IF;

    -- chekc id generatore
    IF NOT EXISTS (SELECT 1 FROM bp034_tbtipi_generazione WHERE bp034_id = id_generatore) THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'id generatore non valido, ricevuto id bp034 = ' || id_generatore::varchar, NULL];
    END IF;

    -- check codice azienda
    IF codice IS NOT NULL THEN
    	-- esiste già ?
        IF EXISTS (SELECT 1 FROM bp003_tbaziende WHERE bp003_codice = codice)THEN
        	RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DUP_KEY')::varchar,'azienda già esistente con codice: ' || codice::varchar, NULL];
        END IF;
    END IF;

    -- set default UIC Italia
    IF uic_code IS NULL THEN
    	uic_code = 86;
    END IF;

    -- get id nazione dato l'UIC code
    w_id_bp018 = spbp018_get_id_nazione_by_uic_code(uic_code);
    IF w_id_bp018 IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'UIC code inesistente (impossibile determinare la nazione di origine)', NULL];
    END IF;

    -- check ID anagrafica
    IF id_anag IS NOT NULL THEN
    	-- ID valido ?
        IF NOT EXISTS (SELECT 1 FROM bp004_tbanagrafiche WHERE bp004_id = id_anag)THEN
    		RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'ID anagrafica inesistente', NULL];
    	END IF;
    	-- esiste già un'azienda con questo id anagrafica ?
    	IF EXISTS (SELECT 1 FROM bp003_tbaziende WHERE bp003_anagrafica_id_bp004 = id_anag)THEN
    		RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DUP_KEY')::varchar,'azienda già esistente con ID anagrafica: ' || id_anag::varchar, NULL];
    	END IF;
    END IF;

    -- trim stringhe
    ragsoc = trim(ragsoc);

    IF id_anag IS NULL THEN
	-- generazione anagrafica azienda - solo dati base
	INSERT INTO bp004_tbanagrafiche (
		bp004_generatore_id_bp034,
		bp004_sesso,
		bp004_flg_persona_fisica, -- NB: se ditta individuale allora flag = True e valorizzati sia CF che PI con dati diversi
					  --     se società allora flag = False e valorizzati sia CF che PI con stesso dato
		bp004_cognomeragsoc,
		bp004_denominazione,
		bp004_denominazione_estesa,
		bp004_nazione_nascita_id_bp018
		)
		VALUES (
		id_generatore,
		'*',
		flg_persona_fisica,
		ragsoc,
		ragsoc,
		ragsoc,
		w_id_bp018
		) RETURNING bp004_id INTO id_anag;
    END IF;

    -- errore
    IF id_anag IS NULL THEN
    	RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'non è stato possibile generare l''anagrafica, azienda non generata', NULL];
    END IF;

    -- generazione azienda
    INSERT INTO bp003_tbaziende (
		bp003_codice,
		bp003_anagrafica_id_bp004,
		bp003_categoria_id_bp017,
		bp003_sottocategoria_id_bp032,
		bp003_generatore_id_bp034,
		bp003_flg_licadmin
		)
		VALUES (
		CASE WHEN codice IS NULL THEN (SELECT MAX(bp003_codice) + 1 FROM bp003_tbaziende) ELSE codice END,
		id_anag,
		0,
		0,
		id_generatore,
		False
		) RETURNING bp003_id INTO ret_id;

    -- errore
    IF ret_id IS NULL THEN
    	RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore nella generazione azienda, azienda non generata', NULL];
    END IF;

    ret_data = ret_id || ',' || id_anag;
    -- ritorna: cod, messaggio, id_azienda
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar,'azienda generata', ret_data::varchar];

END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION spbp003_remove_company(id_company integer, cod_company integer, liv integer, dlt_acla boolean, dlt_acle boolean, dlt_acll boolean)
  RETURNS character varying[] AS
$BODY$
-- Elimina un azienda e relativi dati dipendenti
--
-- liv = 0  Elimina solo dati base (azienda, anagrafica azienda, preferenze azienda, gruppo supervisors, utente supervisore)
-- liv = 1  Elimina dati base e struttura aziendale (filiali, sedi, gruppi aziendali)
-- liv = 2  Elimina dati base, struttura aziendale e se azienda consociata/gestita la rimuove dallo studio (non la rimuove se trattasi di azienda master)

DECLARE
--v_state       text;
--v_hint    	text;
--v_context 	text;
v_msg     	text;
v_detail  	text;
w_id_azienda   	bp003_tbaziende.bp003_id%TYPE;
w_id_anag      	bp004_tbanagrafiche.bp004_id%TYPE;
w_id_anag_user 	bp004_tbanagrafiche.bp004_id%TYPE;
w_id_user_super bp003_tbaziende.bp003_supervisor_id_bp001%TYPE;
w_id_bp010     	bp010_tbutentiaziende.bp010_id%TYPE;
cur_bp010      	CURSOR (id_az integer) FOR SELECT bp010_id, bp010_utente_id_bp001 FROM bp010_tbutentiaziende WHERE bp010_azienda_id_bp003 = id_az;
rec_bp010      	RECORD;
BEGIN
    IF id_company IS NULL AND cod_company IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave azienda non valorizzata (richiesto id o codice azienda)', NULL];
    ELSIF id_company IS NOT NULL AND cod_company IS NOT NULL THEN
	    RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o codice azienda', NULL];
    ELSIF id_company IS NULL THEN
	    -- get id azienda e id anagrafica azienda dato il codice azienda
	    SELECT bp003_id, bp003_anagrafica_id_bp004, bp003_supervisor_id_bp001 INTO w_id_azienda, w_id_anag, w_id_user_super FROM bp003_tbaziende WHERE bp003_codice = cod_company;
    ELSIF id_company IS NOT NULL THEN
        -- in comodo id azienda + geti id anagrafica azienda
        SELECT bp003_id, bp003_anagrafica_id_bp004, bp003_supervisor_id_bp001 INTO w_id_azienda, w_id_anag, w_id_user_super FROM bp003_tbaziende WHERE bp003_id = id_company;
    END IF;

    -- disabilito trigger per poter eliminare il gruppo supervisors e service
    ALTER TABLE bp021_tbga DISABLE TRIGGER bp021_groups_protected;

    -- annullo il supervisore aziendale
    UPDATE bp003_tbaziende SET bp003_supervisor_id_bp001 = NULL WHERE bp003_id = w_id_azienda;

    -- annullo l'ultima azienda di login per tutti gli utenti del portale che si sono loggati con tale azienda
    UPDATE bp001_tbutenti SET bp001_ult_az_login_id_bp003 = NULL WHERE bp001_ult_az_login_id_bp003 IS NOT NULL AND bp001_ult_az_login_id_bp003 = w_id_azienda ;

    -- annullo gli utenti capigruppo nei gruppi aziendali
    UPDATE bp021_tbga SET bp021_capogruppo_id_bp022 = NULL WHERE bp021_capogruppo_id_bp022 IS NOT NULL AND bp021_azienda_id_bp003 = w_id_azienda;

    -- annullo il ga preferenziale per tutti gli utenti aziendali
    UPDATE bp010_tbutentiaziende SET bp010_ga_preferenziale_id_bp021 = NULL WHERE bp010_ga_preferenziale_id_bp021 IS NOT NULL AND bp010_azienda_id_bp003 = w_id_azienda;

    IF dlt_acla THEN
	-- eliminazione permessi ACLA
        DELETE FROM bp240_tbaclautenti WHERE bp240_azienda_id_bp003 = w_id_azienda;
	DELETE FROM bp242_tbaclaaziende WHERE bp242_azienda_id_bp003 = w_id_azienda;
	DELETE FROM bp244_tbaclafiliali WHERE bp244_azienda_id_bp003 = w_id_azienda;
	DELETE FROM bp246_tbaclasedi WHERE bp246_azienda_id_bp003 = w_id_azienda;
	DELETE FROM bp247_tbaclaga WHERE bp247_azienda_id_bp003 = w_id_azienda;
    END IF;

    IF dlt_acle THEN
	-- eliminazione permessi ACLE
        DELETE FROM bp350_tbacleutenti WHERE bp350_azienda_id_bp003 = w_id_azienda;
	DELETE FROM bp352_tbacleaziende WHERE bp352_azienda_id_bp003 = w_id_azienda;
	DELETE FROM bp354_tbaclefiliali WHERE bp354_azienda_id_bp003 = w_id_azienda;
	DELETE FROM bp356_tbaclesedi WHERE bp356_azienda_id_bp003 = w_id_azienda;
	DELETE FROM bp357_tbaclega WHERE bp357_azienda_id_bp003 = w_id_azienda;
    END IF;

    IF dlt_acll THEN
	-- eliminazione permessi ACLL
        DELETE FROM bp460_tbacllutenti WHERE bp460_azienda_id_bp003 = w_id_azienda;
	DELETE FROM bp462_tbacllaziende WHERE bp462_azienda_id_bp003 = w_id_azienda;
	DELETE FROM bp464_tbacllfiliali WHERE bp464_azienda_id_bp003 = w_id_azienda;
	DELETE FROM bp466_tbacllsedi WHERE bp466_azienda_id_bp003 = w_id_azienda;
	DELETE FROM bp467_tbacllga WHERE bp467_azienda_id_bp003 = w_id_azienda;
    END IF;

    IF liv = 0 THEN
        -- elimino l'utente supervisore dal gruppo 'supervisors'
        DELETE FROM bp022_tbutentiga WHERE bp022_utente_id_bp001 = w_id_user_super AND bp022_ga_id_bp021 IN (SELECT bp021_id FROM bp021_tbga WHERE bp021_azienda_id_bp003 = w_id_azienda AND bp021_siglaga = 'supervisors');

        -- elimino il gruppo 'supervisors'
        DELETE FROM bp021_tbga WHERE bp021_azienda_id_bp003 = w_id_azienda AND bp021_siglaga = 'supervisors';
    END IF;

    IF liv >= 1 THEN
        -- elimino tutte le sedi aziendali
        DELETE FROM bp020_tbaziendesedi WHERE bp020_azienda_id_bp003 = w_id_azienda;

        -- elimino tutte le filiali aziendali
        DELETE FROM bp015_tbaziendefiliali WHERE bp015_azienda_id_bp003 = w_id_azienda;

        -- elimino tutti gli utenti dai gruppi aziendali
        DELETE FROM bp022_tbutentiga WHERE bp022_ga_id_bp021 IN (SELECT bp021_id FROM bp021_tbga WHERE bp021_azienda_id_bp003 = w_id_azienda);

        -- elimino tutti i gruppi aziendali
        DELETE FROM bp021_tbga WHERE bp021_azienda_id_bp003 = w_id_azienda;

        -- elimino le preferenze dell'azienda
        DELETE FROM bp011_tbpreferenze WHERE bp011_azienda_id_bp003 = w_id_azienda;
    END IF;

    IF liv >= 2 THEN
        -- rimozione azienda da tutti gli studi di cui fa parte solo se non si tratta dell'azienda master
        DELETE FROM bp013_tbaziendestudi WHERE bp013_azienda_id_bp003 = w_id_azienda
                                           AND NOT EXISTS (SELECT 1 FROM bp008_tbstudi WHERE bp008_master_id_bp003 = w_id_azienda);
    END IF;

    -- loop su tutti gli utenti dell'azienda
    OPEN cur_bp010(w_id_azienda);
    LOOP FETCH cur_bp010 INTO rec_bp010;
	EXIT WHEN NOT FOUND;

	IF LIV = 0 AND rec_bp010.bp010_utente_id_bp001 <> w_id_user_super THEN
	    -- se richiesto livello di cancellazione 0 allora elaboro solo il supervisore aziendale
	    CONTINUE;
	END IF;

	-- sgancio l'utente dall'azienda
        DELETE FROM bp010_tbutentiaziende WHERE bp010_id = rec_bp010.bp010_id;

	-- se l'utente non è associato ad altre aziende lo elimino dal portale
	IF NOT EXISTS (SELECT 1 FROM bp010_tbutentiaziende WHERE bp010_utente_id_bp001 = rec_bp010.bp010_utente_id_bp001 AND bp010_id <> rec_bp010.bp010_id) THEN

	    IF dlt_acla THEN
                -- elimino ACLA utente portale
	        DELETE FROM bp243_tbaclautenti_portale WHERE bp243_utente_id_bp001 = rec_bp010.bp010_utente_id_bp001;
	    END IF;

	    IF dlt_acle THEN
	        -- eliminazione permessi ACLE
	        DELETE FROM bp353_tbacleutenti_portale WHERE bp353_utente_id_bp001 = rec_bp010.bp010_utente_id_bp001;
	    END IF;

	    IF dlt_acll THEN
	        -- eliminazione permessi ACLL
	        DELETE FROM bp463_tbacllutenti_portale WHERE bp463_utente_id_bp001 = rec_bp010.bp010_utente_id_bp001;
	    END IF;

            -- elimino le preferenze dell'utente
            DELETE FROM bp011_tbpreferenze WHERE bp011_utente_id_bp001 = rec_bp010.bp010_utente_id_bp001;

	    -- elimino l'utente dai gruppi portale
            DELETE FROM bp009_tbutentigruppi WHERE bp009_utente_id_bp001 = rec_bp010.bp010_utente_id_bp001;

	    -- get id anagrafica utente
	    SELECT bp001_anagrafica_id_bp004 INTO w_id_anag_user FROM bp001_tbutenti WHERE bp001_id = rec_bp010.bp010_utente_id_bp001;

	    -- elimino l'utente
	    DELETE FROM bp001_tbutenti WHERE bp001_id = rec_bp010.bp010_utente_id_bp001;

	    -- elimino gli indirizzi dell'utente
	    DELETE FROM bp066_tbtipi_indirizzi WHERE bp066_anagrafica_id_bp004 = w_id_anag_user;
            DELETE FROM bp051_tbindirizzi WHERE bp051_anagrafica_id_bp004 = w_id_anag_user;

            IF w_id_anag_user <> w_id_anag THEN
                -- elimino l'anagrafica dell'utente se non si tratta dell'anagrafica azienda (es. caso in cui anagrafica supervisore coincide con anagrafica azienda)
                DELETE FROM bp004_tbanagrafiche WHERE bp004_id = w_id_anag_user;
            END IF;
        END IF;
    END LOOP;

    -- rimozione anagrafiche associate all'azienda
    DELETE FROM bp031_tbanag_aziende WHERE bp031_azienda_id_bp003 = w_id_azienda;

    -- elimino l'azienda
    DELETE FROM bp003_tbaziende WHERE bp003_id = w_id_azienda;

    -- elimino gli indirizzi dell'azienda
    DELETE FROM bp066_tbtipi_indirizzi WHERE bp066_anagrafica_id_bp004 = w_id_anag;
    DELETE FROM bp051_tbindirizzi WHERE bp051_anagrafica_id_bp004 = w_id_anag;

    -- elimino l'anagrafica dell'azienda
    DELETE FROM bp004_tbanagrafiche WHERE bp004_id = w_id_anag;

    -- riabilito trigger che impedisce la modifica e la eliminazione del gruppo supervisors e service
    ALTER TABLE bp021_tbga ENABLE TRIGGER bp021_groups_protected;

    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, 'azienda eliminata', NULL];

    EXCEPTION
        WHEN FOREIGN_KEY_VIOLATION THEN
            --GET STACKED DIAGNOSTICS   v_state = RETURNED_SQLSTATE, v_msg = MESSAGE_TEXT, v_detail = PG_EXCEPTION_DETAIL, v_hint = PG_EXCEPTION_HINT, v_context = PG_EXCEPTION_CONTEXT;
            GET STACKED DIAGNOSTICS v_msg = MESSAGE_TEXT, v_detail = PG_EXCEPTION_DETAIL;
	    RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar, E'impossibile eliminare l''azienda in quanto sono presenti dei dati che lo impediscono.\nDB error: ' || v_msg || E'\n' || v_detail, NULL];
	WHEN others THEN
	    -- errore DB non gestito
	    RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar, 'errore DB ' || SQLSTATE || ' non gestito in stored function spbp003_remove_company', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION spbp003_company_on_off(id_company integer, cod_company integer, enable boolean)
  RETURNS character varying[] AS
$BODY$
-- Enable/Disable a company
DECLARE
ret_abilitata   bp003_tbaziende.bp003_abilitata%TYPE;
BEGIN
    ret_abilitata = NULL;

    -- check flag abilita
    IF enable IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'flag enable non valorizzato', NULL];
    END IF;
    CASE
	WHEN id_company IS NULL AND cod_company IS NULL THEN
	    RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave azienda non valorizzata (richiesto id o codice azienda)', NULL];

	WHEN id_company IS NOT NULL AND cod_company IS NOT NULL THEN
	    RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o codice azienda', NULL];

	WHEN id_company IS NOT NULL THEN

	    SELECT bp003_abilitata INTO ret_abilitata FROM bp003_tbaziende WHERE bp003_id = id_company;
	    IF NOT FOUND THEN
	        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (id non trovato)', NULL];
            END IF;
	        -- abilito/disabilito azienda tramite id
            UPDATE bp003_tbaziende SET bp003_abilitata = enable WHERE bp003_id = id_company;

        WHEN cod_company IS NOT NULL THEN

            SELECT bp003_abilitata INTO ret_abilitata FROM bp003_tbaziende WHERE bp003_codice = cod_company;
            IF NOT FOUND THEN
	            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (codice non trovato)', NULL];
            END IF;
            -- abilito/disabilito azienda tramite id
            UPDATE bp003_tbaziende SET bp003_abilitata = enable WHERE bp003_codice = cod_company;
        ELSE
            -- errore DB non gestito
	    RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito', NULL];
    END CASE;

    -- OK
    IF enable THEN
    	RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, 'azienda abilitata', ret_abilitata::varchar];
    ELSE
    	RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, 'azienda disabilitata', ret_abilitata::varchar];
    END IF;

    EXCEPTION
	    WHEN others THEN
	        -- errore DB non gestito
		    RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp003_company_on_off', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------
DROP FUNCTION IF EXISTS spbp003_set_user_supervisor(integer, integer, integer);

CREATE OR REPLACE FUNCTION spbp003_set_user_supervisor(id_azienda integer, cod_azienda integer, id_user integer)
  RETURNS character varying[] AS
$BODY$
-- Imposta l'utente supervisore aziendale
DECLARE
w_id_azienda                bp003_tbaziende.bp003_id%TYPE;
ret_id_user_supervisor      bp003_tbaziende.bp003_supervisor_id_bp001%TYPE;
BEGIN
    ret_id_user_supervisor = NULL;

    IF id_azienda IS NULL AND cod_azienda IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave azienda non valorizzata (richiesto id o codice azienda)', NULL];
    END IF;
    IF id_azienda IS NOT NULL AND cod_azienda IS NOT NULL THEN
	RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o codice azienda', NULL];
    END IF;
    IF id_user IS NULL THEN
	RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'id utente supervisore non valorizzato', NULL];
    END IF;

    -- check azienda
    IF cod_azienda IS NOT NULL THEN
        -- check esistenza azienda dato il codice  (get id azienda)
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_codice = cod_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (codice non trovato)', NULL];
        END IF;
    ELSIF id_azienda IS NOT NULL THEN
        -- check esistenza azienda dato l'id (metto in comodo ID)
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_id = id_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (id non trovato)', NULL];
        END IF;
    END IF;

    -- check id user supervisors
    IF NOT EXISTS( SELECT 1 FROM bp022_tbutentiga
             JOIN bp021_tbga ON bp021_id = bp022_ga_id_bp021
            WHERE bp021_azienda_id_bp003 = w_id_azienda
              AND bp021_siglaga = 'supervisors'
              AND bp022_utente_id_bp001 = id_user) THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_INVALID_VALUE')::varchar, quote_literal(E'L\'utente ricevuto da impostare come supervisore NON fa parte del gruppo aziendale \'supervisors\' dell\'azienda'), NULL];
    END IF;

    -- get ex user supervisor
    SELECT bp003_supervisor_id_bp001 INTO ret_id_user_supervisor FROM bp003_tbaziende WHERE bp003_id = w_id_azienda;

    -- set new user supervisor
    UPDATE bp003_tbaziende SET bp003_supervisor_id_bp001 = id_user WHERE bp003_id = w_id_azienda;

    -- OK
    IF FOUND THEN
    	RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, 'Aggiornato utente supervisore aziendale', ret_id_user_supervisor::varchar];
    ELSE
    	RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar, 'Impossibile aggiornare utente supervisore aziendale', ret_id_user_supervisor::varchar];
    END IF;

    EXCEPTION
	WHEN others THEN
	    -- errore DB non gestito
	    RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp003_set_user_supervisor', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp001_user_on_off(id_user integer, login_name varchar, id_company integer, cod_company integer, enable boolean)
  RETURNS character varying[] AS
$BODY$
-- Funzione per abilitare/disabilitare un Utente a livello portale o aziendale
--    Per ABILITAZIONE:
--        se passato solo l'utente (id o login) viene abilitato solo a livello portale.
--        se passata anche l'azienda (id o codice) viene abilitato sia a livello portale che a livello aziendale
--    Per DISABILITAZIONE:
--        se passato solo l'utente (id o login) viene disabilitato solo a livello portale.
--        se passata anche l'azienda (id o codice) viene disabilitato a livello aziendale e se l'utente
--                   non risulta abilitato in altre aziende viene disabilitato anche a livello portale
DECLARE
w_id_user                 bp001_tbutenti.bp001_id%TYPE;
w_id_company              bp003_tbaziende.bp003_id%TYPE;
ret_enabled_into_portal   bp001_tbutenti.bp001_disabilitato%TYPE;
ret_enabled_into_company  bp010_tbutentiaziende.bp010_disabilitato%TYPE;
ret_livello               varchar;
ret_msg                   varchar;
BEGIN
    w_id_company = NULL;
    ret_enabled_into_portal = False;
    ret_enabled_into_company = False;
    ret_livello = '';
    ret_msg = '';

    -- check parametri obbligatori
    IF enable IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'flag enable non valorizzato', NULL];
    ELSIF id_user IS NULL AND (login_name IS NULL OR trim(login_name) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave utente non valorizzata (richiesto id o nome login)', NULL];
    ELSIF id_user IS NOT NULL AND login_name IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o nome login utente', NULL];
    ELSIF id_company IS NOT NULL AND cod_company IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o codice azienda', NULL];
    END IF;

    -- check utente e get ex valore abilitazione
    IF id_user IS NOT NULL THEN
        -- check esistenza utente dato id utente
        SELECT bp001_id, NOT bp001_disabilitato INTO w_id_user, ret_enabled_into_portal FROM bp001_tbutenti WHERE bp001_id = id_user;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza utente dato login name + get id utente ed ex valore abilitazione
        SELECT bp001_id, NOT bp001_disabilitato INTO w_id_user, ret_enabled_into_portal FROM bp001_tbutenti WHERE bp001_nomeutente = login_name;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (nome login non trovato)', NULL];
        END IF;
    END IF;

    -- check azienda
    IF cod_company IS NOT NULL THEN
        -- check esistenza azienda dato il codice  (get id azienda)
        SELECT bp003_id INTO w_id_company FROM bp003_tbaziende WHERE bp003_codice = cod_company;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (codice non trovato)', NULL];
        END IF;
    ELSIF id_company IS NOT NULL THEN
        -- check esistenza azienda dato l'id (metto in comodo ID)
        SELECT bp003_id INTO w_id_company FROM bp003_tbaziende WHERE bp003_id = id_company;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (id non trovato)', NULL];
        END IF;
    END IF;

    IF w_id_company IS NULL THEN
        -- abilito/disabilito a livello PORTALE
        UPDATE bp001_tbutenti SET bp001_disabilitato = NOT enable WHERE bp001_id = w_id_user;
        IF FOUND THEN
	    ret_livello = 'portale';
	END IF;
    ELSE
        -- check esistenza utente in azienda e get ex valore abilitazione
        SELECT NOT bp010_disabilitato INTO ret_enabled_into_company FROM bp010_tbutentiaziende WHERE bp010_azienda_id_bp003 = w_id_company AND bp010_utente_id_bp001 = w_id_user;
	IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente non presente in azienda', NULL];
        END IF;

        -- abilito/disabilito a livello AZIENDALE
        UPDATE bp010_tbutentiaziende SET bp010_disabilitato = NOT enable WHERE bp010_azienda_id_bp003 = w_id_company AND bp010_utente_id_bp001 = w_id_user;
        IF FOUND THEN
	    ret_livello = 'aziendale';
	END IF;
        IF enable THEN
            -- abilito a livello PORTALE se risulta disabilitato
            UPDATE bp001_tbutenti SET bp001_disabilitato = False WHERE bp001_id = w_id_user AND bp001_disabilitato;
	    IF FOUND THEN
                ret_livello = ret_livello || ' e portale';
            END IF;
        ELSE
            -- disabilito a livello PORTALE se l'utente era abilitato e se NON risulta abilitato in altre aziende
            IF NOT EXISTS (SELECT 1 FROM bp010_tbutentiaziende WHERE bp010_utente_id_bp001 = w_id_user AND NOT bp010_disabilitato) THEN
                UPDATE bp001_tbutenti SET bp001_disabilitato = True WHERE bp001_id = w_id_user AND NOT bp001_disabilitato;
		IF FOUND THEN
                    ret_livello = ret_livello || ' e portale';
                END IF;
            END IF;
        END IF;
    END IF;

    IF enable THEN
        ret_msg = 'utente abilitato a livello ' || ret_livello;
    ELSE
        ret_msg = 'utente disabilitato a livello ' || ret_livello;
    END IF;
    -- OK
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, ret_msg, ret_enabled_into_portal::varchar || ';' || ret_enabled_into_company::varchar ];

    EXCEPTION
        WHEN others THEN
            -- errore DB non gestito
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp001_user_on_off', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------
-- drop old version
DROP FUNCTION IF EXISTS spbp001_create_user(varchar, varchar, varchar, varchar, bigint, int, boolean, varchar, varchar);
DROP FUNCTION IF EXISTS spbp001_create_user(varchar, varchar, varchar, varchar, bigint, int, boolean, varchar, varchar, boolean);
DROP FUNCTION IF EXISTS spbp001_create_user(int, varchar, varchar, varchar, bigint, int, boolean, varchar, varchar, boolean);
DROP FUNCTION IF EXISTS spbp001_create_user(int, varchar, varchar, varchar, bigint, int, boolean, varchar, varchar, boolean, boolean, integer);


-- wrapper per mantenere compatibile con chiamate pregresse senza parametro signup

CREATE OR REPLACE FUNCTION spbp001_create_user(id_generatore int, login_name varchar, cognome varchar, nome varchar, id_anag bigint, uic_code int, flg_persona_fisica boolean, email varchar, password varchar, change_password boolean, flg_sso boolean)
  RETURNS character varying[] AS
$BODY$
DECLARE
w_signup	bp001_tbutenti.bp001_signup%TYPE;
w_ggvalpass	bp001_tbutenti.bp001_ggvalpass%TYPE;
BEGIN
    w_signup = Null;
    w_ggvalpass = 90;
    RETURN spbp001_create_user(id_generatore, login_name, cognome, nome, id_anag, uic_code, flg_persona_fisica, email, password, change_password, flg_sso, w_signup, w_ggvalpass);
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

-- wrapper per mantenere compatibile con chiamate pregresse senza parametro cod_fiscale

CREATE OR REPLACE FUNCTION spbp001_create_user(id_generatore int, login_name varchar, cognome varchar, nome varchar, id_anag bigint, uic_code int, flg_persona_fisica boolean, email varchar, password varchar, change_password boolean, flg_sso boolean, signup integer, ggvalpass integer)
  RETURNS character varying[] AS
$BODY$
DECLARE
w_cod_fiscale	bp004_tbanagrafiche.bp004_codicefiscale%TYPE;
BEGIN
    w_cod_fiscale = Null;
    RETURN spbp001_create_user(id_generatore, login_name, cognome, nome, id_anag, uic_code, flg_persona_fisica, email, password, change_password, flg_sso, signup, ggvalpass, w_cod_fiscale);
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

CREATE OR REPLACE FUNCTION spbp001_create_user(id_generatore int, login_name varchar, cognome varchar, nome varchar, id_anag bigint, uic_code int, flg_persona_fisica boolean, email varchar, password varchar, change_password boolean, flg_sso boolean, signup integer, ggvalpass integer, cod_fiscale varchar)
  RETURNS character varying[] AS
$BODY$
-- Inserisce una nuova azienda
DECLARE
ret_id					bp001_tbutenti.bp001_id%TYPE;
w_id_bp018				bp018_tbnazioni.bp018_id%TYPE;
w_denominazione         bp004_tbanagrafiche.bp004_denominazione%TYPE;
w_denominazione_estesa  bp004_tbanagrafiche.bp004_denominazione_estesa%TYPE;
BEGIN
    -- check parametri
    IF id_anag IS NOT NULL AND cognome IS NOT NULL AND cognome <> '' THEN
    	RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id anagrafica o cognome', NULL];
    ELSIF login_name IS NULL OR trim(login_name) = '' THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'nome login non valorizzato', NULL];
    ELSIF id_anag IS NULL AND (cognome IS NULL OR trim(cognome) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'valorizzare id anagrafica o cognome', NULL];
    ELSIF password IS NULL OR trim(password) = '' THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'password non valorizzata', NULL];
    ELSIF id_anag IS NULL AND flg_persona_fisica IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'flag persona fisica non valorizzato', NULL];
    ELSIF change_password IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'flag cambio password non valorizzato', NULL];
    ELSIF flg_sso IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'flag SSO non valorizzato', NULL];
    END IF;

    -- check id generatore
    IF NOT EXISTS (SELECT 1 FROM bp034_tbtipi_generazione WHERE bp034_id = id_generatore) THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'id generatore non valido, ricevuto id bp034 = ' || id_generatore::varchar, NULL];
    END IF;

    -- check login_name
    IF login_name IS NOT NULL THEN
    	-- esiste già login_name ?
        IF EXISTS (SELECT 1 FROM bp001_tbutenti WHERE bp001_nomeutente = trim(login_name))THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DUP_KEY')::varchar,'Nome login ' || trim(login_name) || ' già esistente', NULL];
        END IF;
    END IF;

    -- check lunghezza cod. fiscale
    IF cod_fiscale IS NOT NULL AND char_length(trim(cod_fiscale)) > 16 THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_STRING_DATA_RIGHT_TRUNCATION')::varchar,'Codice fiscale troppo lungo ' || trim(cod_fiscale), NULL];
    END IF;

    -- set default UIC Italia
    IF uic_code IS NULL THEN
    	uic_code = 86;
    END IF;

    -- get id nazione dato l'UIC code
    w_id_bp018 = spbp018_get_id_nazione_by_uic_code(uic_code);
    IF w_id_bp018 IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'UIC code inesistente (impossibile determinare la nazione di origine)', NULL];
    END IF;

    -- check ID anagrafica
    IF id_anag IS NOT NULL THEN
    	-- ID valido ?
        IF NOT EXISTS (SELECT 1 FROM bp004_tbanagrafiche WHERE bp004_id = id_anag) THEN
    	    RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'ID anagrafica inesistente', NULL];
    	END IF;
    END IF;

    -- trim stringhe
    cognome = trim(cognome);
    nome = trim(nome);
    login_name = trim(login_name);
    IF nome IS NULL THEN
	w_denominazione = cognome;
        w_denominazione_estesa = cognome;
    ELSE
	w_denominazione = cognome || ' ' || nome;
        w_denominazione_estesa = cognome || ' ' || nome;
    END IF;

    IF id_anag IS NULL THEN
	-- generazione anagrafica utente - solo dati base
	INSERT INTO bp004_tbanagrafiche (
		bp004_generatore_id_bp034,
		bp004_sesso,
		bp004_flg_persona_fisica, -- NB: se ditta individuale allora flag = True e valorizzati sia CF che PI con dati diversi
							  --     se società allora flag = False e valorizzati sia CF che PI con stesso dato
		bp004_cognomeragsoc,
		bp004_nome,
		bp004_denominazione,
		bp004_denominazione_estesa,
        bp004_codicefiscale,
		bp004_email,
		bp004_nazione_nascita_id_bp018
		)
		VALUES (
		id_generatore,
		'*',
		flg_persona_fisica,
		cognome,
		nome,
		w_denominazione,
		w_denominazione_estesa,
        cod_fiscale,
		email,
		w_id_bp018
		) RETURNING bp004_id INTO id_anag;
    END IF;

    -- errore
    IF id_anag IS NULL THEN
    	RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'non è stato possibile generare la anagrafica, utente non generato', NULL];
    END IF;

    -- generazione utente
    INSERT INTO bp001_tbutenti (
		bp001_anagrafica_id_bp004,
		bp001_nomeutente,
		bp001_password,
		bp001_generatore_id_bp034,
		bp001_dataora_mod,
		bp001_cambio_pass,
		bp001_flg_sso,
		bp001_signup,
        bp001_ggvalpass
  		)
		VALUES (
		id_anag,
		login_name,
		password,
		id_generatore,
		current_timestamp,
		change_password,
		flg_sso,
		signup,
        ggvalpass
		) RETURNING bp001_id INTO ret_id;

    -- errore
    IF ret_id IS NULL THEN
    	RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore nella generazione utente, utente non generato', NULL];
    END IF;

    -- ritorna: cod, messaggio, id_utente
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar,'utente generato', ret_id::varchar];

END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------
DROP FUNCTION IF EXISTS spbp001_modify_user(integer, varchar, varchar, boolean);
DROP FUNCTION IF EXISTS spbp001_modify_user(integer, varchar, varchar, boolean, boolean);

CREATE OR REPLACE FUNCTION spbp001_modify_user(id_user integer, login_name varchar, pwd varchar, change_password boolean, flg_sso boolean, ggvalpass integer)
  RETURNS character varying[] AS
$BODY$
-- Funzione per modificare la password o il flag cambio password di Utente
DECLARE
w_id_user                 bp001_tbutenti.bp001_id%TYPE;
ret_msg                   varchar;
BEGIN
    ret_msg = '';

    -- check parametri obbligatori
    IF id_user IS NULL AND (login_name IS NULL OR trim(login_name) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave utente non valorizzata (richiesto id o nome login)', NULL];
    ELSIF id_user IS NOT NULL AND login_name IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o nome login utente', NULL];
    END IF;

    -- check utente
    IF id_user IS NOT NULL THEN
        -- check esistenza utente dato id utente
        SELECT bp001_id INTO w_id_user FROM bp001_tbutenti WHERE bp001_id = id_user;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza utente dato login name
        SELECT bp001_id INTO w_id_user FROM bp001_tbutenti WHERE bp001_nomeutente = login_name;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (nome login non trovato)', NULL];
        END IF;
    END IF;

    CASE
        WHEN pwd IS NOT NULL AND change_password IS NOT NULL THEN
            UPDATE bp001_tbutenti SET bp001_password = pwd, bp001_cambio_pass = change_password WHERE bp001_id = w_id_user;
        WHEN pwd IS NOT NULL AND change_password IS NULL THEN
            UPDATE bp001_tbutenti SET bp001_password = pwd WHERE bp001_id = w_id_user;
        WHEN pwd IS NULL AND change_password IS NOT NULL THEN
            UPDATE bp001_tbutenti SET bp001_cambio_pass = change_password WHERE bp001_id = w_id_user;
        ELSE
	    RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar, 'Richiesto aggiornamento dati utente, ma i dati da aggiornare non sono stati passati', Null ];
    END CASE;
    IF NOT FOUND THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar, 'modifica password fallita', Null ];
    END IF;

    IF flg_sso IS NOT NULL THEN
        UPDATE bp001_tbutenti SET bp001_flg_sso = flg_sso WHERE bp001_id = w_id_user;
    END IF;

    IF ggvalpass IS NOT NULL THEN
        UPDATE bp001_tbutenti SET bp001_ggvalpass = ggvalpass WHERE bp001_id = w_id_user;
    END IF;

    -- verifico se i dati sono stati aggiornati
    IF FOUND THEN
        -- OK
        RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, 'dati utente modificati', Null ];
    ELSE
        -- KO
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar, 'modifica dati utente fallita', Null ];
    END IF;

    EXCEPTION
        WHEN others THEN
            -- errore DB non gestito
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp001_modify_user', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp001_remove_user(user_id int, remove_anag boolean)
  RETURNS void AS
$BODY$
DECLARE
anag_id   bigint;
BEGIN
    IF remove_anag THEN
        -- get id anag
        SELECT bp001_anagrafica_id_bp004 INTO anag_id FROM bp001_tbutenti WHERE bp001_id = user_id;
    END IF;
    -- rimuove utente come supervisore aziendale
    UPDATE bp003_tbaziende SET bp003_supervisor_id_bp001 = NULL WHERE bp003_supervisor_id_bp001 = user_id;
    -- rimuove associazione ad azienda/e
    DELETE FROM bp010_tbutentiaziende WHERE bp010_utente_id_bp001 = user_id;
    -- rimuove associazione a gruppo/i aziendale
    DELETE FROM bp022_tbutentiga WHERE bp022_utente_id_bp001 = user_id;
    -- rimuove associazione a gruppo/i portale
    DELETE FROM bp009_tbutentigruppi WHERE bp009_utente_id_bp001 = user_id;
    -- rimuove preferenze
    DELETE FROM bp011_tbpreferenze WHERE bp011_utente_id_bp001 = user_id;
    DELETE FROM bp037_tblookup_prefs WHERE bp037_utente_id_bp001 = user_id;
    -- rimuove ACLA
    DELETE FROM bp240_tbaclautenti WHERE bp240_utente_id_bp001 = user_id;
    DELETE FROM bp243_tbaclautenti_portale WHERE bp243_utente_id_bp001 = user_id;
    -- rimuove ACLE
    DELETE FROM bp350_tbacleutenti WHERE bp350_utente_id_bp001 = user_id;
    DELETE FROM bp353_tbacleutenti_portale WHERE bp353_utente_id_bp001 = user_id;
    -- rimuove ACLL
    DELETE FROM bp460_tbacllutenti WHERE bp460_utente_id_bp001 = user_id;
    DELETE FROM bp463_tbacllutenti_portale WHERE bp463_utente_id_bp001 = user_id;
    -- rimuove ruoli utente
    DELETE FROM bp151_tbruoli_utenti WHERE bp151_utente_id_bp001 = user_id;
    -- rimuove menu utente
    DELETE FROM bp101_tbmain_menu_utente_tmp WHERE bp101_utente_id_bp001 = user_id;
    DELETE FROM bp083_tbmenu_utente WHERE bp083_utente_id_bp001 = user_id;
    DELETE FROM bp600_tbmenu_batch_build_locks WHERE bp600_utente_id_bp001 = user_id;  --- ?????
    -- rimuove dati password reset
    DELETE FROM bp093_tbpassword_reset WHERE bp093_utente_id_bp001 = user_id;
    -- rimuove storico password
    DELETE FROM bp094_tbpassword_storico WHERE bp094_utente_id_bp001 = user_id;
    -- rimuove ISP token
    DELETE FROM bp102_tbutenti_isptoken WHERE bp102_utente_id_bp001 = user_id;
    DELETE FROM admin004_tbtokens_sso WHERE admin004_utente_sso_id_bp001 = user_id;
    -- rimuove associazione a domain
    DELETE FROM bp501_tbdomain_users WHERE bp501_utente_id_bp001 = user_id;
    -- rimuove utente/i
    DELETE FROM bp001_tbutenti WHERE bp001_id = user_id;
    -- rimozione ANAGRAFICHE
    IF remove_anag THEN
        -- rimuove storico anagrafiche
        DELETE FROM bp077_tbanagrafiche_storico WHERE bp077_anagrafica_id_bp004 = anag_id;
        -- rimuove associazione a tipo indirizzi
        DELETE FROM bp066_tbtipi_indirizzi WHERE bp066_anagrafica_id_bp004 = anag_id;
        -- rimuove indirizzi
        DELETE FROM bp051_tbindirizzi WHERE bp051_anagrafica_id_bp004 = anag_id;
        -- rimuove associazione a tipo anagrafiche
        DELETE FROM bp068_tbanagrafiche_tipizzate WHERE bp068_anagrafica_id_bp004 = anag_id;
        -- rimuove anagrafiche
        DELETE FROM bp004_tbanagrafiche WHERE bp004_id = anag_id;
    END IF;
    RETURN;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp001_remove_users(int[], remove_anag boolean)
  RETURNS void AS
$BODY$
DECLARE
lst_users_id  ALIAS FOR $1;
lst_anag_id   bigint[];
BEGIN
    IF remove_anag THEN
        -- get list id anag
        SELECT ARRAY[bp001_anagrafica_id_bp004] INTO lst_anag_id FROM bp001_tbutenti WHERE ARRAY[bp001_id] <@ lst_users_id;
    END IF;
    -- rimuove utente come supervisore aziendale
    UPDATE bp003_tbaziende SET bp003_supervisor_id_bp001 = NULL WHERE ARRAY[bp003_supervisor_id_bp001] <@ lst_users_id;
    -- rimuove associazione ad azienda/e
    DELETE FROM bp010_tbutentiaziende WHERE ARRAY[bp010_utente_id_bp001] <@ lst_users_id;
    -- rimuove associazione a gruppo/i aziendale
    DELETE FROM bp022_tbutentiga WHERE ARRAY[bp022_utente_id_bp001] <@ lst_users_id;
    -- rimuove associazione a gruppo/i portale
    DELETE FROM bp009_tbutentigruppi WHERE ARRAY[bp009_utente_id_bp001] <@ lst_users_id;
    -- rimuove preferenze
    DELETE FROM bp011_tbpreferenze WHERE ARRAY[bp011_utente_id_bp001] <@ lst_users_id;
    DELETE FROM bp037_tblookup_prefs WHERE ARRAY[bp037_utente_id_bp001] <@ lst_users_id;
    -- rimuove ACLA
    DELETE FROM bp240_tbaclautenti WHERE ARRAY[bp240_utente_id_bp001] <@ lst_users_id;
    DELETE FROM bp243_tbaclautenti_portale WHERE ARRAY[bp243_utente_id_bp001] <@ lst_users_id;
    -- rimuove ACLE
    DELETE FROM bp350_tbacleutenti WHERE ARRAY[bp350_utente_id_bp001] <@ lst_users_id;
    DELETE FROM bp353_tbacleutenti_portale WHERE ARRAY[bp353_utente_id_bp001] <@ lst_users_id;
    -- rimuove ACLL
    DELETE FROM bp460_tbacllutenti WHERE ARRAY[bp460_utente_id_bp001] <@ lst_users_id;
    DELETE FROM bp463_tbacllutenti_portale WHERE ARRAY[bp463_utente_id_bp001] <@ lst_users_id;
    -- rimuove ruoli utente
    DELETE FROM bp151_tbruoli_utenti WHERE ARRAY[bp151_utente_id_bp001] <@ lst_users_id;
    -- rimuove menu utente
    DELETE FROM bp101_tbmain_menu_utente_tmp WHERE ARRAY[bp101_utente_id_bp001] <@ lst_users_id;
    DELETE FROM bp083_tbmenu_utente WHERE ARRAY[bp083_utente_id_bp001] <@ lst_users_id;
    DELETE FROM bp600_tbmenu_batch_build_locks WHERE ARRAY[bp600_utente_id_bp001] <@ lst_users_id;  --- ?????
    -- rimuove dati password reset
    DELETE FROM bp093_tbpassword_reset WHERE ARRAY[bp093_utente_id_bp001] <@ lst_users_id;
    -- rimuove storico password
    DELETE FROM bp094_tbpassword_storico WHERE ARRAY[bp094_utente_id_bp001] <@ lst_users_id;
    -- rimuove ISP token
    DELETE FROM bp102_tbutenti_isptoken WHERE ARRAY[bp102_utente_id_bp001] <@ lst_users_id;
    DELETE FROM admin004_tbtokens_sso WHERE ARRAY[admin004_utente_sso_id_bp001] <@ lst_users_id;
    -- rimuove associazione a domain
    DELETE FROM bp501_tbdomain_users WHERE ARRAY[bp501_utente_id_bp001] <@ lst_users_id;
    -- rimuove utente/i
    DELETE FROM bp001_tbutenti WHERE ARRAY[bp001_id] <@ lst_users_id;
    -- rimozione ANAGRAFICHE
    IF remove_anag THEN
        -- rimuove storico anagrafiche
        DELETE FROM bp077_tbanagrafiche_storico WHERE ARRAY[bp077_anagrafica_id_bp004] <@ lst_anag_id;
        -- rimuove associazione a tipo indirizzi
        DELETE FROM bp066_tbtipi_indirizzi WHERE ARRAY[bp066_anagrafica_id_bp004] <@ lst_anag_id;
        -- rimuove indirizzi
        DELETE FROM bp051_tbindirizzi WHERE ARRAY[bp051_anagrafica_id_bp004] <@ lst_anag_id;
        -- rimuove associazione a tipo anagrafiche
        DELETE FROM bp068_tbanagrafiche_tipizzate WHERE ARRAY[bp068_anagrafica_id_bp004] <@ lst_anag_id;
        -- rimuove anagrafiche
        DELETE FROM bp004_tbanagrafiche WHERE ARRAY[bp004_id] <@ lst_anag_id;
    END IF;
    RETURN;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------
-- wrapper per compatibilità pregresso
DROP FUNCTION IF EXISTS spbp010_add_user_to_company(integer, integer, integer, varchar);
CREATE OR REPLACE FUNCTION spbp010_add_user_to_company(id_user integer, login_name varchar, id_azienda integer, cod_azienda integer)
  RETURNS character varying[] AS
$BODY$
BEGIN
   RETURN spbp010_add_user_to_company(id_user, login_name, id_azienda, cod_azienda, NULL);
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;


DROP FUNCTION IF EXISTS spbp010_add_user_to_company(integer, integer, integer, varchar, integer);

CREATE OR REPLACE FUNCTION spbp010_add_user_to_company(id_user integer, login_name varchar, id_azienda integer, cod_azienda integer, id_ga integer)
  RETURNS character varying[] AS
$BODY$
-- Aggiunge un utente in un'azienda
DECLARE
w_id_user       bp001_tbutenti.bp001_id%TYPE;
w_id_azienda    bp003_tbaziende.bp003_id%TYPE;
ret_id          bp010_tbutentiaziende.bp010_id%TYPE;
ret_enabled     bp010_tbutentiaziende.bp010_disabilitato%TYPE;
ret_msg		varchar;
BEGIN
    -- check parameter validity
    IF id_azienda IS NOT NULL AND cod_azienda IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o codice azienda', NULL];
    ELSIF id_user IS NOT NULL AND login_name IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id utente o nome login', NULL];
    ELSIF id_azienda IS NULL AND cod_azienda IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave azienda non valorizzata (richiesto id o codice azienda)', NULL];
    ELSIF id_user IS NULL AND (login_name IS NULL OR trim(login_name) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave utente non valorizzata (richiesto id utente o nome login)', NULL];
    END IF;

    -- check azienda
    IF id_azienda IS NOT NULL THEN
        -- check esistenza azienda dato id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_id = id_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza azienda dato codice azienda + get id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_codice = cod_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (codice non trovato)', NULL];
        END IF;
    END IF;

    -- check utente
    IF id_user IS NOT NULL THEN
        -- check esistenza utente dato id utente
        SELECT bp001_id INTO w_id_user FROM bp001_tbutenti WHERE bp001_id = id_user;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza utente dato login name + get id utente
        SELECT bp001_id INTO w_id_user FROM bp001_tbutenti WHERE bp001_nomeutente = login_name;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (nome login non trovato)', NULL];
        END IF;
    END IF;

    -- check gruppo aziendale
    IF id_ga IS NOT NULL THEN
        -- check esistenza gruppo aziendale
        IF NOT EXISTS(SELECT 1 FROM bp021_tbga WHERE bp021_id = id_ga and bp021_azienda_id_bp003 = w_id_azienda) THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo aziendale inesistente o non appartenente all''azienda (id non trovato)', NULL];
        END IF;

        -- se l'utente non appartiene al gruppo
        IF NOT EXISTS (SELECT 1 FROM bp022_tbutentiga WHERE bp022_ga_id_bp021 = id_ga AND bp022_utente_id_bp001 = w_id_user) THEN
            -- inserimento dell'utente nel gruppo aziendale
            INSERT INTO bp022_tbutentiga (bp022_ga_id_bp021, bp022_utente_id_bp001) VALUES (id_ga, w_id_user);
        END IF;
    END IF;

    -- check utente già in azienda ?
    ret_id = 0;
    SELECT NOT bp010_disabilitato INTO ret_enabled FROM bp010_tbutentiaziende WHERE bp010_azienda_id_bp003 = w_id_azienda AND bp010_utente_id_bp001 = w_id_user;
    IF FOUND THEN
        ret_msg = 'utente già presente in azienda';
    ELSE
	    -- inserimento utente in azienda
	    ret_enabled = True;  -- l'utente viene inserito ABILITATO
	    INSERT INTO bp010_tbutentiaziende (bp010_azienda_id_bp003, bp010_utente_id_bp001, bp010_disabilitato, bp010_ga_preferenziale_id_bp021) VALUES (w_id_azienda, w_id_user, NOT ret_enabled, id_ga) RETURNING bp010_id INTO ret_id;
	    ret_msg = 'utente aggiunto in azienda';
    END IF;

    -- OK
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, ret_msg, ret_id::varchar || ';' || ret_enabled::varchar];

    EXCEPTION
        WHEN others THEN
            -- errore DB non gestito
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp010_add_user_to_company', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------
DROP FUNCTION IF EXISTS spbp010_remove_user_from_company(integer, integer, integer, varchar);

CREATE OR REPLACE FUNCTION spbp010_remove_user_from_company(id_user integer, login_name varchar, id_azienda integer, cod_azienda integer)
  RETURNS character varying[] AS
$BODY$
-- Rimuove un utente da un'azienda
DECLARE
w_id_user       bp001_tbutenti.bp001_id%TYPE;
w_id_azienda    bp003_tbaziende.bp003_id%TYPE;
ret_id          bp010_tbutentiaziende.bp010_id%TYPE;
ret_msg		varchar;
BEGIN
    -- check parameter validity
    IF id_azienda IS NOT NULL AND cod_azienda IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o codice azienda', NULL];
    ELSIF id_user IS NOT NULL AND login_name IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id utente o nome login', NULL];
    ELSIF id_azienda IS NULL AND cod_azienda IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave azienda non valorizzata (richiesto id o codice azienda)', NULL];
    ELSIF id_user IS NULL AND (login_name IS NULL OR trim(login_name) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave utente non valorizzata (richiesto id utente o nome login)', NULL];
    END IF;

    -- check azienda
    IF id_azienda IS NOT NULL THEN
        -- check esistenza azienda dato id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_id = id_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza azienda dato codice azienda + get id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_codice = cod_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (codice non trovato)', NULL];
        END IF;
    END IF;

    -- check utente
    IF id_user IS NOT NULL THEN
        -- check esistenza utente dato id utente
        SELECT bp001_id INTO w_id_user FROM bp001_tbutenti WHERE bp001_id = id_user;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza utente dato login name + get id utente
        SELECT bp001_id INTO w_id_user FROM bp001_tbutenti WHERE bp001_nomeutente = login_name;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (nome login non trovato)', NULL];
        END IF;
    END IF;

    -- check utente in azienda ?
    IF NOT EXISTS (SELECT 1 FROM bp010_tbutentiaziende WHERE bp010_azienda_id_bp003 = w_id_azienda AND bp010_utente_id_bp001 = w_id_user) THEN
        ret_msg = 'l''utente non era presente nell''azienda';
    ELSE
	    -- elimina l'utente dall'azienda
	    DELETE FROM bp010_tbutentiaziende WHERE bp010_azienda_id_bp003 = w_id_azienda AND bp010_utente_id_bp001 = w_id_user;
	    ret_msg = 'utente rimosso dall''azienda';
    END IF;

    -- OK
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, ret_msg, NULL];

    EXCEPTION
        WHEN others THEN
            -- errore DB non gestito
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp010_remove_user_from_company', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp009_put_user_in_portal_group(id_user integer, login_name varchar, id_grp integer, sigla_grp varchar)
  RETURNS character varying[] AS
$BODY$
-- Ingresso di un utente in un gruppo portale
DECLARE
w_id_grp    bp002_tbgruppi.bp002_id%TYPE;
w_id_user   bp001_tbutenti.bp001_id%TYPE;
ret_id      bp009_tbutentigruppi.bp009_id%TYPE;
BEGIN
    -- check parameter validity
    IF id_user IS NOT NULL AND login_name IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id utente o nome login', NULL];
    ELSIF id_grp IS NOT NULL AND sigla_grp IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o sigla del gruppo portale', NULL];
    ELSIF id_user IS NULL AND (login_name IS NULL OR trim(login_name) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave utente non valorizzata (richiesto id utente o nome login)', NULL];
    ELSIF id_grp IS NULL AND (sigla_grp IS NULL OR trim(sigla_grp) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave gruppo portale non valorizzata (richiesto id o sigla)', NULL];
    END IF;

    -- check utente
    IF id_user IS NOT NULL THEN
        -- check esistenza utente dato id utente
        SELECT bp001_id INTO w_id_user FROM bp001_tbutenti WHERE bp001_id = id_user;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza utente dato login name + get id utente
        SELECT bp001_id INTO w_id_user FROM bp001_tbutenti WHERE bp001_nomeutente = login_name;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (nome login non trovato)', NULL];
        END IF;
    END IF;

    -- check gruppo portale
    IF id_grp IS NOT NULL THEN
        -- check esistenza gruppo dato id gruppo
        SELECT bp002_id INTO w_id_grp FROM bp002_tbgruppi WHERE bp002_id = id_grp;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo portale inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza gruppo data sigla gruppo + get id gruppo portale
        SELECT bp002_id INTO w_id_grp FROM bp002_tbgruppi WHERE bp002_nomegruppo = sigla_grp;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo portale inesistente (sigla non trovata)', NULL];
        END IF;
    END IF;

    -- check utente già nel gruppo ?
    IF EXISTS (SELECT 1 FROM bp009_tbutentigruppi WHERE bp009_utente_id_bp001 = w_id_user AND bp009_gruppo_id_bp002 = w_id_grp) THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DUP_KEY')::varchar,'utente già presente nel gruppo portale', NULL];
    END IF;

    -- inserimento utente nel gruppo portale
    INSERT INTO bp009_tbutentigruppi (bp009_utente_id_bp001, bp009_gruppo_id_bp002) VALUES (w_id_user, w_id_grp) RETURNING bp009_id INTO ret_id;

    -- OK
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, 'utente inserito nel gruppo portale', ret_id::varchar];

    EXCEPTION
        WHEN others THEN
            -- errore DB non gestito
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp009_put_user_in_portal_group', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp009_pull_out_user_from_portal_group(id_user integer, login_name varchar, id_grp integer, sigla_grp varchar)
  RETURNS character varying[] AS
$BODY$
-- Uscita di un utente da un gruppo portale
DECLARE
w_id_grp        bp002_tbgruppi.bp002_id%TYPE;
w_id_user       bp001_tbutenti.bp001_id%TYPE;
count_deleted   int;
ret_msg         varchar;
BEGIN
    -- check parameter validity
    IF  id_user IS NOT NULL AND login_name IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id utente o nome login', NULL];
    ELSIF id_grp IS NOT NULL AND sigla_grp IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o sigla del gruppo portale', NULL];
    ELSIF id_user IS NULL AND (login_name IS NULL OR trim(login_name) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave utente non valorizzata (richiesto id utente o nome login)', NULL];
    ELSIF id_grp IS NULL AND (sigla_grp IS NULL OR trim(sigla_grp) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave gruppo portale non valorizzata (richiesto id o sigla)', NULL];
    END IF;

    -- check utente
    IF id_user IS NOT NULL THEN
        -- check esistenza utente dato id utente
        SELECT bp001_id INTO w_id_user FROM bp001_tbutenti WHERE bp001_id = id_user;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza utente dato login name + get id utente
        SELECT bp001_id INTO w_id_user FROM bp001_tbutenti WHERE bp001_nomeutente = login_name;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (nome login non trovato)', NULL];
        END IF;
    END IF;

    -- check gruppo portale
    IF id_grp IS NOT NULL THEN
        -- check esistenza gruppo dato id gruppo
        SELECT bp002_id INTO w_id_grp FROM bp002_tbgruppi WHERE bp002_id = id_grp;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo portale inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza gruppo data sigla gruppo + get id gruppo portale
        SELECT bp002_id INTO w_id_grp FROM bp002_tbgruppi WHERE bp002_nomegruppo = sigla_grp;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo portale inesistente (sigla non trovata)', NULL];
        END IF;
    END IF;

    -- elimino utente dal gruppo portale
    WITH deleted AS
        (DELETE FROM bp009_tbutentigruppi WHERE bp009_utente_id_bp001 = w_id_user AND bp009_gruppo_id_bp002 = w_id_grp RETURNING *)
        SELECT count(*) INTO count_deleted FROM deleted;

    ret_msg = '';
    IF count_deleted = 0 THEN
        ret_msg = 'utente non presente nel gruppo portale';
    ELSE
        ret_msg = 'utente rimosso dal gruppo portale';
    END IF;

    -- OK - N.B.: ritorna OK se l'utente è stato eliminato o non era presente nel gruppo
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, ret_msg, NULL];

    EXCEPTION
        WHEN others THEN
            -- errore DB non gestito
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp009_pull_out_user_from_portal_group', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp022_put_user_in_company_group(id_azienda integer, cod_azienda integer, id_user integer, login_name varchar, id_grp integer, sigla_grp varchar)
  RETURNS character varying[] AS
$BODY$
-- Ingresso di un utente in un gruppo aziendale
DECLARE
w_id_grp        bp021_tbga.bp021_id%TYPE;
w_id_user       bp001_tbutenti.bp001_id%TYPE;
w_id_azienda    bp003_tbaziende.bp003_id%TYPE;
ret_id          bp022_tbutentiga.bp022_id%TYPE;
ret_msg         varchar;
BEGIN
    -- check parameter validity
    IF id_azienda IS NOT NULL AND cod_azienda IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o codice azienda', NULL];
    ELSIF id_user IS NOT NULL AND login_name IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id utente o nome login', NULL];
    ELSIF id_grp IS NOT NULL AND sigla_grp IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o sigla gruppo', NULL];
    ELSIF id_azienda IS NULL AND cod_azienda IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave azienda non valorizzata (richiesto id o codice azienda)', NULL];
    ELSIF id_user IS NULL AND (login_name IS NULL OR trim(login_name) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave utente non valorizzata (richiesto id utente o nome login)', NULL];
    ELSIF id_grp IS NULL AND (sigla_grp IS NULL OR trim(sigla_grp) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave gruppo non valorizzata (richiesto id o sigla gruppo)', NULL];
    END IF;

    -- check azienda
    IF id_azienda IS NOT NULL THEN
        -- check esistenza azienda dato id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_id = id_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza azienda dato codice azienda + get id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_codice = cod_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (codice non trovato)', NULL];
        END IF;
    END IF;

    -- check utente
    IF id_user IS NOT NULL THEN
        -- check esistenza utente dato id utente
        SELECT bp001_id INTO w_id_user FROM bp001_tbutenti WHERE bp001_id = id_user;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza utente dato login name + get id utente
        SELECT bp001_id INTO w_id_user FROM bp001_tbutenti WHERE bp001_nomeutente = login_name;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (nome login non trovato)', NULL];
        END IF;
    END IF;

    -- check utente in azienda ?
    IF NOT sputils_is_user_in_company(w_id_user, w_id_azienda) THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar, quote_literal(E'L\'utente non è associato all\'azienda'), NULL];
    END IF;

    -- check gruppo aziendale
    IF id_grp IS NOT NULL THEN
        -- check esistenza gruppo dato id gruppo
        SELECT bp021_id INTO w_id_grp FROM bp021_tbga WHERE bp021_id = id_grp;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo aziendale inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza gruppo data sigla gruppo + id azienda sopra determinato
        SELECT bp021_id INTO w_id_grp FROM bp021_tbga WHERE bp021_azienda_id_bp003 = w_id_azienda AND bp021_siglaga = sigla_grp;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo aziendale inesistente (sigla non trovata in azienda)', NULL];
        END IF;
    END IF;

    -- check utente già nel gruppo ?
    SELECT bp022_id INTO ret_id FROM bp022_tbutentiga WHERE bp022_ga_id_bp021 = w_id_grp AND bp022_utente_id_bp001 = w_id_user;
    IF FOUND THEN
        ret_msg = 'utente già presente nel gruppo aziendale';
    ELSE
        -- se non presente lo inserisco nel gruppo aziendale
        ret_msg = 'utente inserito nel gruppo aziendale';
        INSERT INTO bp022_tbutentiga (bp022_ga_id_bp021, bp022_utente_id_bp001) VALUES (w_id_grp, w_id_user) RETURNING bp022_id INTO ret_id;
    END IF;

    -- OK
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, ret_msg, ret_id::varchar];

    EXCEPTION
        WHEN others THEN
            -- errore DB non gestito
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp022_put_user_in_company_group', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp022_pull_out_user_from_company_group(id_azienda integer, cod_azienda integer, id_user integer, login_name varchar, id_grp integer, sigla_grp varchar)
  RETURNS character varying[] AS
$BODY$
-- Uscita di un utente da un gruppo aziendale
DECLARE
w_id_grp        bp021_tbga.bp021_id%TYPE;
w_id_user       bp001_tbutenti.bp001_id%TYPE;
w_id_azienda    bp003_tbaziende.bp003_id%TYPE;
ret_id          bp022_tbutentiga.bp022_id%TYPE;
count_deleted   int;
ret_msg         varchar;
BEGIN
    -- check parameter validity
    IF  id_azienda IS NOT NULL AND cod_azienda IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o codice azienda', NULL];
    ELSIF id_user IS NOT NULL AND login_name IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id utente o nome login', NULL];
    ELSIF id_grp IS NOT NULL AND sigla_grp IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o sigla gruppo', NULL];
    ELSIF id_azienda IS NULL AND cod_azienda IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave azienda non valorizzata (richiesto id o codice azienda)', NULL];
    ELSIF id_user IS NULL AND (login_name IS NULL OR trim(login_name) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave utente non valorizzata (richiesto id utente o nome login)', NULL];
    ELSIF id_grp IS NULL AND (sigla_grp IS NULL OR trim(sigla_grp) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave gruppo non valorizzata (richiesto id o sigla gruppo)', NULL];
    END IF;

    -- check azienda
    IF id_azienda IS NOT NULL THEN
        -- check esistenza azienda dato id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_id = id_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza azienda dato codice azienda + get id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_codice = cod_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (codice non trovato)', NULL];
        END IF;
    END IF;

    -- check utente
    IF id_user IS NOT NULL THEN
        -- check esistenza utente dato id utente
        SELECT bp001_id INTO w_id_user FROM bp001_tbutenti WHERE bp001_id = id_user;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza utente dato login name + get id utente
        SELECT bp001_id INTO w_id_user FROM bp001_tbutenti WHERE bp001_nomeutente = login_name;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (nome login non trovato)', NULL];
        END IF;
    END IF;

    -- check utente in azienda ?
    IF NOT sputils_is_user_in_company(w_id_user, w_id_azienda) THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar, quote_literal(E'L\'utente non è associato all\'azienda'), NULL];
    END IF;

    -- check gruppo aziendale
    IF id_grp IS NOT NULL THEN
        -- check esistenza gruppo dato id gruppo
        SELECT bp021_id INTO w_id_grp FROM bp021_tbga WHERE bp021_id = id_grp;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo aziendale inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza gruppo data sigla gruppo + id azienda sopra determinato
        SELECT bp021_id INTO w_id_grp FROM bp021_tbga WHERE bp021_azienda_id_bp003 = w_id_azienda AND bp021_siglaga = sigla_grp;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo aziendale inesistente (sigla non trovata in azienda)', NULL];
        END IF;
    END IF;

     -- elimino utente dal gruppo aziendale
    WITH deleted AS
        (DELETE FROM bp022_tbutentiga WHERE bp022_ga_id_bp021 = w_id_grp AND bp022_utente_id_bp001 = w_id_user RETURNING *)
        SELECT count(*) INTO count_deleted FROM deleted;

    ret_msg = '';
    IF count_deleted = 0 THEN
        ret_msg = 'utente non presente nel gruppo aziendale';
    ELSE
        ret_msg = 'utente rimosso dal gruppo aziendale';
    END IF;

    -- OK - N.B.: ritorna OK se l'utente è stato eliminato o non era presente nel gruppo
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, ret_msg, NULL];

    EXCEPTION
        WHEN others THEN
            -- errore DB non gestito
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp022_pull_out_user_from_company_group', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------
DROP FUNCTION IF EXISTS spbp24x_set_acla_portal_group(integer, integer, varchar, bigint[], text[], boolean);

CREATE OR REPLACE FUNCTION spbp24x_set_acla_portal_group(id_proc integer, id_grp integer, sigla_grp varchar, lst_id_item_menu bigint[], lst_cod_item_menu text[], enable boolean)
  RETURNS character varying[] AS
$BODY$
--
-- set ACLA gruppi portale (abilita/disabilita/rimuove)
--
DECLARE
w_id_grp                    bp002_tbgruppi.bp002_id%TYPE;
w_lst_id_item_menu          bigint[];
w_lst_cod_item_menu         text[];
w_lst_item_menu_not_found   text[];
w_count_id                  int;
w_count_cod                 int;
BEGIN
    w_count_id = 0;
    w_count_cod = 0;
    IF lst_id_item_menu IS NOT NULL AND lst_id_item_menu <> '{}' THEN
        w_count_id = array_length(lst_id_item_menu, 1);
    END IF;
    IF lst_cod_item_menu IS NOT NULL AND lst_cod_item_menu <> '{}' THEN
        w_count_cod = array_length(lst_cod_item_menu, 1);
    END IF;

    -- check parameter validity
    IF id_grp IS NOT NULL AND sigla_grp IS NOT NULL THEN
	    RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o sigla gruppo', NULL];
    ELSIF w_count_id > 0 AND w_count_cod > 0 THEN
	    RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesti id o codici funzioni', NULL];
    ELSIF id_proc IS NULL THEN
	    RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'id procedura non valorizzato', NULL];
    ELSIF id_grp IS NULL AND (sigla_grp IS NULL OR trim(sigla_grp) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave gruppo non valorizzata (richiesto id o sigla gruppo)', NULL];
    ELSIF w_count_id = 0 AND w_count_cod = 0 THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiavi funzioni non valorizzate (richiesti id o codici funzioni)', NULL];
    END IF;

    -- check procedura
    IF NOT EXISTS(SELECT 1 FROM bp090_tbprocedure WHERE bp090_id = id_proc) THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'procedura inesistente (id non trovato)', NULL];
    END IF;

    -- check gruppo portale
    IF id_grp IS NOT NULL THEN
        -- check esistenza gruppo dato id gruppo
        SELECT bp002_id INTO w_id_grp FROM bp002_tbgruppi WHERE bp002_id = id_grp;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo portale inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza gruppo data sigla gruppo + get id gruppo portale
        SELECT bp002_id INTO w_id_grp FROM bp002_tbgruppi WHERE bp002_nomegruppo = sigla_grp;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo portale inesistente (sigla non trovata)', NULL];
        END IF;
    END IF;

    -- popolo lista id item menu di comodo filtrate per procedura
    IF w_count_cod > 0 THEN
        -- get id by cod
        SELECT ARRAY_AGG(bp081_id), ARRAY_AGG(bp081_codice) INTO w_lst_id_item_menu, w_lst_cod_item_menu
          FROM vbp081_tbvoci_menu_attive
         WHERE bp081_procedura_id_bp090 = id_proc
           AND ARRAY[bp081_codice] <@ lst_cod_item_menu;

        -- se ci sono dei codici voce menu non trovati nella bp081
        IF  w_lst_id_item_menu IS NULL OR w_count_cod <> array_length(w_lst_cod_item_menu, 1) THEN
            w_lst_item_menu_not_found = sputils_get_item_array1_not_in_array2(lst_cod_item_menu, w_lst_cod_item_menu);
        END IF;
    ELSE
        -- get id by id
        -- N.B. precauzione per filtrare gli item menu per procedura
        SELECT ARRAY_AGG(bp081_id) INTO w_lst_id_item_menu
          FROM vbp081_tbvoci_menu_attive
         WHERE bp081_procedura_id_bp090 = id_proc
           AND ARRAY[bp081_id] <@ lst_id_item_menu;

        -- se ci sono degli id voce menu non trovati nella bp081
        IF  w_lst_id_item_menu IS NULL OR w_count_id <> array_length(w_lst_id_item_menu, 1) THEN
            w_lst_item_menu_not_found = sputils_get_item_array1_not_in_array2(lst_id_item_menu, w_lst_id_item_menu);
        END IF;

    END IF;

    IF enable IS NULL THEN
        -- elimina i permessi
        DELETE FROM bp241_tbaclagruppi
         WHERE bp241_gruppo_id_bp002 = w_id_grp
           AND ARRAY[bp241_voce_menu_id_bp081] <@ w_lst_id_item_menu;
    ELSE
        -- abilita/disabilita i permessi esistenti
        UPDATE bp241_tbaclagruppi SET bp241_consenti = enable
         WHERE bp241_gruppo_id_bp002 = w_id_grp
           AND ARRAY[bp241_voce_menu_id_bp081] <@ w_lst_id_item_menu;

        -- abilita/disabilita nuovi permessi
        INSERT INTO bp241_tbaclagruppi (bp241_gruppo_id_bp002, bp241_voce_menu_id_bp081, bp241_consenti)
             SELECT w_id_grp, bp081_id, enable
               FROM vbp081_tbvoci_menu_attive
              WHERE ARRAY[bp081_id] <@ w_lst_id_item_menu
                AND NOT EXISTS (SELECT 1 FROM bp241_tbaclagruppi
                                      WHERE bp241_gruppo_id_bp002 = w_id_grp
                                        AND bp241_voce_menu_id_bp081 = bp081_id);
    END IF;

    -- OK
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, 'permessi ACLA impostati correttamente per il gruppo postale', w_lst_item_menu_not_found::varchar];

    EXCEPTION
        WHEN others THEN
            -- errore DB non gestito
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp24x_set_acla_portal_group', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp24x_set_acla_company(id_proc integer, id_azienda integer, cod_azienda integer, lst_id_item_menu bigint[], lst_cod_item_menu text[], enable boolean)
    RETURNS character varying[] AS
$BODY$
--
-- set ACLA azienda (abilita/disabilita/rimuove)
--
DECLARE
w_id_azienda                bp003_tbaziende.bp003_id%TYPE;
w_lst_id_item_menu          bigint[];
w_lst_cod_item_menu         text[];
w_lst_item_menu_not_found   text[];
w_count_id                  int;
w_count_cod                 int;
BEGIN
    w_count_id = 0;
    w_count_cod = 0;
    IF lst_id_item_menu IS NOT NULL AND lst_id_item_menu <> '{}' THEN
        w_count_id = array_length(lst_id_item_menu, 1);
    END IF;
    IF lst_cod_item_menu IS NOT NULL AND lst_cod_item_menu <> '{}' THEN
        w_count_cod = array_length(lst_cod_item_menu, 1);
    END IF;

    -- check parameter validity
    IF id_azienda IS NOT NULL AND cod_azienda IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o codice azienda', NULL];
    ELSIF w_count_id > 0 AND w_count_cod > 0 THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesti id o codici funzioni', NULL];
    ELSIF id_proc IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'id procedura non valorizzato', NULL];
    ELSIF id_azienda IS NULL AND cod_azienda IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave azienda non valorizzata (richiesto id o codice azienda)', NULL];
    ELSIF w_count_id = 0 AND w_count_cod = 0 THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiavi funzioni non valorizzate (richiesti id o codici funzioni)', NULL];
    END IF;

    -- check procedura
    IF NOT EXISTS(SELECT 1 FROM bp090_tbprocedure WHERE bp090_id = id_proc) THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'procedura inesistente (id non trovato)', NULL];
    END IF;

    -- check azienda
    IF id_azienda IS NOT NULL THEN
        -- check esistenza azienda dato id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_id = id_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza azienda dato codice azienda + get id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_codice = cod_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (codice non trovato)', NULL];
        END IF;
    END IF;

    -- popolo lista id item menu di comodo filtrate per procedura
    IF w_count_cod > 0 THEN
        -- get id by cod
        SELECT ARRAY_AGG(bp081_id), ARRAY_AGG(bp081_codice) INTO w_lst_id_item_menu, w_lst_cod_item_menu
          FROM vbp081_tbvoci_menu_attive
         WHERE bp081_procedura_id_bp090 = id_proc
           AND ARRAY[bp081_codice] <@ lst_cod_item_menu;

        -- se ci sono dei codici voce menu non trovati nella bp081
        IF  w_lst_id_item_menu IS NULL OR w_count_cod <> array_length(w_lst_cod_item_menu, 1) THEN
            w_lst_item_menu_not_found = sputils_get_item_array1_not_in_array2(lst_cod_item_menu, w_lst_cod_item_menu);
        END IF;
    ELSE
        -- get id by id
        -- N.B. precauzione per filtrare gli item menu per procedura
        SELECT ARRAY_AGG(bp081_id) INTO w_lst_id_item_menu
          FROM vbp081_tbvoci_menu_attive
         WHERE bp081_procedura_id_bp090 = id_proc
           AND ARRAY[bp081_id] <@ lst_id_item_menu;

        -- se ci sono degli id voce menu non trovati nella bp081
        IF  w_lst_id_item_menu IS NULL OR w_count_id <> array_length(w_lst_id_item_menu, 1) THEN
            w_lst_item_menu_not_found = sputils_get_item_array1_not_in_array2(lst_id_item_menu, w_lst_id_item_menu);
        END IF;
    END IF;

    IF enable IS NULL THEN
        -- elimina i permessi
        DELETE FROM bp242_tbaclaaziende
         WHERE bp242_azienda_id_bp003 = w_id_azienda
           AND ARRAY[bp242_voce_menu_id_bp081] <@ w_lst_id_item_menu;
    ELSE
        -- abilita/disabilita i permessi esistenti
        UPDATE bp242_tbaclaaziende SET bp242_consenti = enable
         WHERE bp242_azienda_id_bp003 = w_id_azienda
           AND ARRAY[bp242_voce_menu_id_bp081] <@ w_lst_id_item_menu;

        -- abilita/disabilita nuovi permessi
        INSERT INTO bp242_tbaclaaziende (bp242_azienda_id_bp003, bp242_voce_menu_id_bp081, bp242_consenti)
             SELECT w_id_azienda, bp081_id, enable
               FROM vbp081_tbvoci_menu_attive
              WHERE ARRAY[bp081_id] <@ w_lst_id_item_menu
                AND NOT EXISTS (SELECT 1 FROM bp242_tbaclaaziende
                                      WHERE bp242_azienda_id_bp003 = w_id_azienda
                                        AND bp242_voce_menu_id_bp081 = bp081_id);
    END IF;

    -- OK
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, 'permessi ACLA impostati correttamente per azienda', w_lst_item_menu_not_found::varchar];

    EXCEPTION
        WHEN others THEN
            -- errore DB non gestito
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp24x_set_acla_company', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp24x_set_acla_portal_user(id_proc integer, id_user integer, login_name varchar, lst_id_item_menu bigint[], lst_cod_item_menu text[], enable boolean)
    RETURNS character varying[] AS
$BODY$
--
-- set ACLA utente portale (abilita/disabilita/rimuove)
--
DECLARE
w_id_user                   bp001_tbutenti.bp001_id%TYPE;
w_lst_id_item_menu          bigint[];
w_lst_cod_item_menu         text[];
w_lst_item_menu_not_found   text[];
w_count_id                  int;
w_count_cod                 int;
BEGIN
    w_count_id = 0;
    w_count_cod = 0;
    IF lst_id_item_menu IS NOT NULL AND lst_id_item_menu <> '{}' THEN
        w_count_id = array_length(lst_id_item_menu, 1);
    END IF;
    IF lst_cod_item_menu IS NOT NULL AND lst_cod_item_menu <> '{}' THEN
        w_count_cod = array_length(lst_cod_item_menu, 1);
    END IF;

    -- check parameter validity
    IF id_user IS NOT NULL AND login_name IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id utente o nome login', NULL];
    ELSIF w_count_id > 0 AND w_count_cod > 0 THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesti id o codici funzioni', NULL];
    ELSIF id_proc IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'id procedura non valorizzato', NULL];
    ELSIF id_user IS NULL AND (login_name IS NULL OR trim(login_name) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave utente non valorizzata (richiesto id utente o nome login)', NULL];
    ELSIF w_count_id = 0 AND w_count_cod = 0 THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiavi funzioni non valorizzate (richiesti id o codici funzioni)', NULL];
    END IF;

    -- check procedura
    IF NOT EXISTS(SELECT 1 FROM bp090_tbprocedure WHERE bp090_id = id_proc) THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'procedura inesistente (id non trovato)', NULL];
    END IF;

    -- check utente
    IF id_user IS NOT NULL THEN
        -- check esistenza utente dato id utente
        SELECT bp001_id INTO w_id_user FROM bp001_tbutenti WHERE bp001_id = id_user;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza utente dato login name + get id utente
        SELECT bp001_id INTO w_id_user FROM bp001_tbutenti WHERE bp001_nomeutente = login_name;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (nome login non trovato)', NULL];
        END IF;
    END IF;

    -- popolo lista id item menu di comodo filtrate per procedura
    IF w_count_cod > 0 THEN
        -- get id by cod
        SELECT ARRAY_AGG(bp081_id), ARRAY_AGG(bp081_codice) INTO w_lst_id_item_menu, w_lst_cod_item_menu
          FROM vbp081_tbvoci_menu_attive
         WHERE bp081_procedura_id_bp090 = id_proc
           AND ARRAY[bp081_codice] <@ lst_cod_item_menu;

        -- se ci sono dei codici voce menu non trovati nella bp081
        IF  w_lst_id_item_menu IS NULL OR w_count_cod <> array_length(w_lst_cod_item_menu, 1) THEN
            w_lst_item_menu_not_found = sputils_get_item_array1_not_in_array2(lst_cod_item_menu, w_lst_cod_item_menu);
        END IF;
    ELSE
        -- get id by id
        -- N.B. precauzione per filtrare gli item menu per procedura
        SELECT ARRAY_AGG(bp081_id) INTO w_lst_id_item_menu
          FROM vbp081_tbvoci_menu_attive
         WHERE bp081_procedura_id_bp090 = id_proc
           AND ARRAY[bp081_id] <@ lst_id_item_menu;

        -- se ci sono degli id voce menu non trovati nella bp081
        IF  w_lst_id_item_menu IS NULL OR w_count_id <> array_length(w_lst_id_item_menu, 1) THEN
            w_lst_item_menu_not_found = sputils_get_item_array1_not_in_array2(lst_id_item_menu, w_lst_id_item_menu);
        END IF;
    END IF;

    IF enable IS NULL THEN
        -- elimina i permessi
        DELETE FROM bp243_tbaclautenti_portale
         WHERE bp243_utente_id_bp001 = w_id_user
           AND ARRAY[bp243_voce_menu_id_bp081] <@ w_lst_id_item_menu;
    ELSE
        -- abilita/disabilita i permessi esistenti
        UPDATE bp243_tbaclautenti_portale SET bp243_consenti = enable
         WHERE bp243_utente_id_bp001 = w_id_user
           AND ARRAY[bp243_voce_menu_id_bp081] <@ w_lst_id_item_menu;

        -- abilita/disabilita nuovi permessi
        INSERT INTO bp243_tbaclautenti_portale (bp243_utente_id_bp001, bp243_voce_menu_id_bp081, bp243_consenti)
             SELECT w_id_user, bp081_id, enable
               FROM vbp081_tbvoci_menu_attive
              WHERE ARRAY[bp081_id] <@ w_lst_id_item_menu
                AND NOT EXISTS (SELECT 1 FROM bp243_tbaclautenti_portale
                                      WHERE bp243_utente_id_bp001 = w_id_user
                                        AND bp243_voce_menu_id_bp081 = bp081_id);
    END IF;

    -- OK
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, 'permessi ACLA impostati correttamente per utente portale', w_lst_item_menu_not_found::varchar];

    EXCEPTION
        WHEN others THEN
            -- errore DB non gestito
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp24x_set_acla_portal_user', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------
DROP FUNCTION IF EXISTS spbp24x_set_acla_company_user(integer, integer, integer, integer, varchar, bigint[], text[], boolean);

CREATE OR REPLACE FUNCTION spbp24x_set_acla_company_user(id_proc integer, id_azienda integer, cod_azienda integer, id_user integer, login_name varchar, lst_id_item_menu bigint[], lst_cod_item_menu text[], enable boolean)
    RETURNS character varying[] AS
$BODY$
--
-- set ACLA utente aziendale (abilita/disabilita/rimuove)
--
DECLARE
w_id_user                   bp001_tbutenti.bp001_id%TYPE;
w_id_azienda                bp003_tbaziende.bp003_id%TYPE;
w_lst_id_item_menu          bigint[];
w_lst_cod_item_menu         text[];
w_lst_item_menu_not_found   text[];
w_count_id                  int;
w_count_cod                 int;
BEGIN
    w_count_id = 0;
    w_count_cod = 0;
    IF lst_id_item_menu IS NOT NULL AND lst_id_item_menu <> '{}' THEN
        w_count_id = array_length(lst_id_item_menu, 1);
    END IF;
    IF lst_cod_item_menu IS NOT NULL AND lst_cod_item_menu <> '{}' THEN
        w_count_cod = array_length(lst_cod_item_menu, 1);
    END IF;

    -- check parameter validity
    IF id_azienda IS NOT NULL AND cod_azienda IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o codice azienda', NULL];
    ELSIF id_user IS NOT NULL AND login_name IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id utente o nome login', NULL];
    ELSIF w_count_id > 0 AND w_count_cod > 0 THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesti id o codici funzioni', NULL];
    ELSIF id_proc IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'id procedura non valorizzato', NULL];
    ELSIF id_azienda IS NULL AND cod_azienda IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave azienda non valorizzata (richiesto id o codice azienda)', NULL];
    ELSIF id_user IS NULL AND (login_name IS NULL OR trim(login_name) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave utente non valorizzata (richiesto id utente o nome login)', NULL];
    ELSIF w_count_id = 0 AND w_count_cod = 0 THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiavi funzioni non valorizzate (richiesti id o codici funzioni)', NULL];
    END IF;

    -- check procedura
    IF NOT EXISTS(SELECT 1 FROM bp090_tbprocedure WHERE bp090_id = id_proc) THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'procedura inesistente (id non trovato)', NULL];
    END IF;

    -- check azienda
    IF id_azienda IS NOT NULL THEN
        -- check esistenza azienda dato id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_id = id_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza azienda dato codice azienda + get id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_codice = cod_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (codice non trovato)', NULL];
        END IF;
    END IF;

    -- check utente
    IF id_user IS NOT NULL THEN
        -- check esistenza utente dato id utente
        SELECT bp001_id INTO w_id_user FROM bp001_tbutenti WHERE bp001_id = id_user;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza utente dato login name + get id utente
        SELECT bp001_id INTO w_id_user FROM bp001_tbutenti WHERE bp001_nomeutente = login_name;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (nome login non trovato)', NULL];
        END IF;
    END IF;

    -- check utente in azienda ?
    IF NOT sputils_is_user_in_company(w_id_user, w_id_azienda) THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar, quote_literal(E'L\'utente non è associato all\'azienda'), NULL];
    END IF;

    -- popolo lista id item menu di comodo filtrate per procedura
    IF w_count_cod > 0 THEN
        -- get id by cod
        SELECT ARRAY_AGG(bp081_id), ARRAY_AGG(bp081_codice) INTO w_lst_id_item_menu, w_lst_cod_item_menu
          FROM vbp081_tbvoci_menu_attive
         WHERE bp081_procedura_id_bp090 = id_proc
           AND ARRAY[bp081_codice] <@ lst_cod_item_menu;

        -- se ci sono dei codici voce menu non trovati nella bp081
        IF  w_lst_id_item_menu IS NULL OR w_count_cod <> array_length(w_lst_cod_item_menu, 1) THEN
            w_lst_item_menu_not_found = sputils_get_item_array1_not_in_array2(lst_cod_item_menu, w_lst_cod_item_menu);
        END IF;
    ELSE
        -- get id by id
        -- N.B. precauzione per filtrare gli item menu per procedura
        SELECT ARRAY_AGG(bp081_id) INTO w_lst_id_item_menu
          FROM vbp081_tbvoci_menu_attive
         WHERE bp081_procedura_id_bp090 = id_proc
           AND ARRAY[bp081_id] <@ lst_id_item_menu;

        -- se ci sono degli id voce menu non trovati nella bp081
        IF  w_lst_id_item_menu IS NULL OR w_count_id <> array_length(w_lst_id_item_menu, 1) THEN
            w_lst_item_menu_not_found = sputils_get_item_array1_not_in_array2(lst_id_item_menu, w_lst_id_item_menu);
        END IF;
    END IF;

    IF enable IS NULL THEN
        -- elimina i permessi
        DELETE FROM bp240_tbaclautenti
         WHERE bp240_azienda_id_bp003 = w_id_azienda
           AND bp240_utente_id_bp001 = w_id_user
           AND ARRAY[bp240_voce_menu_id_bp081] <@ w_lst_id_item_menu;
    ELSE
        -- abilita/disabilita i permessi esistenti
        UPDATE bp240_tbaclautenti SET bp240_consenti = enable
         WHERE bp240_azienda_id_bp003 = w_id_azienda
           AND bp240_utente_id_bp001 = w_id_user
           AND ARRAY[bp240_voce_menu_id_bp081] <@ w_lst_id_item_menu;

        -- abilita/disabilita nuovi permessi
        INSERT INTO bp240_tbaclautenti (bp240_azienda_id_bp003, bp240_utente_id_bp001, bp240_voce_menu_id_bp081, bp240_consenti)
             SELECT w_id_azienda, w_id_user, bp081_id, enable
               FROM vbp081_tbvoci_menu_attive
              WHERE ARRAY[bp081_id] <@ w_lst_id_item_menu
                AND NOT EXISTS (SELECT 1 FROM bp240_tbaclautenti
                                      WHERE bp240_azienda_id_bp003 = w_id_azienda
                                        AND bp240_utente_id_bp001 = w_id_user
                                        AND bp240_voce_menu_id_bp081 = bp081_id);
    END IF;

    -- OK
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, 'permessi ACLA impostati correttamente per utente aziendale', w_lst_item_menu_not_found::varchar];

    EXCEPTION
        WHEN others THEN
            -- errore DB non gestito
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp24x_set_acla_company_user', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp24x_set_acla_company_group(id_proc integer, id_azienda integer, cod_azienda integer, id_grp integer, sigla_grp varchar, lst_id_item_menu bigint[], lst_cod_item_menu text[], enable boolean)
    RETURNS character varying[] AS
$BODY$
--
-- set ACLA gruppo aziendale (abilita/disabilita/rimuove)
--
DECLARE
w_id_grp                    bp021_tbga.bp021_id%TYPE;
w_id_azienda                bp003_tbaziende.bp003_id%TYPE;
w_lst_id_item_menu          bigint[];
w_lst_cod_item_menu         text[];
w_lst_item_menu_not_found   text[];
w_count_id                  int;
w_count_cod                 int;
BEGIN
    w_count_id = 0;
    w_count_cod = 0;
    IF lst_id_item_menu IS NOT NULL AND lst_id_item_menu <> '{}' THEN
        w_count_id = array_length(lst_id_item_menu, 1);
    END IF;
    IF lst_cod_item_menu IS NOT NULL AND lst_cod_item_menu <> '{}' THEN
        w_count_cod = array_length(lst_cod_item_menu, 1);
    END IF;

    -- check parameter validity
    IF id_azienda IS NOT NULL AND cod_azienda IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o codice azienda', NULL];
    ELSIF id_grp IS NOT NULL AND sigla_grp IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o sigla gruppo aziendale', NULL];
    ELSIF w_count_id > 0 AND w_count_cod > 0 THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesti id o codici funzioni', NULL];
    ELSIF id_proc IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'id procedura non valorizzato', NULL];
    ELSIF id_azienda IS NULL AND cod_azienda IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave azienda non valorizzata (richiesto id o codice azienda)', NULL];
    ELSIF id_grp IS NULL AND (sigla_grp IS NULL OR trim(sigla_grp) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave gruppo aziendale non valorizzata (richiesto id o sigla gruppo aziendale)', NULL];
    ELSIF w_count_id = 0 AND w_count_cod = 0 THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiavi funzioni non valorizzate (richiesti id o codici funzioni)', NULL];
    END IF;

    -- check procedura
    IF NOT EXISTS(SELECT 1 FROM bp090_tbprocedure WHERE bp090_id = id_proc) THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'procedura inesistente (id non trovato)', NULL];
    END IF;

    -- check azienda
    IF id_azienda IS NOT NULL THEN
        -- check esistenza azienda dato id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_id = id_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza azienda dato codice azienda + get id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_codice = cod_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (codice non trovato)', NULL];
        END IF;
    END IF;

    -- check gruppo aziendale
    IF id_grp IS NOT NULL THEN
        -- check esistenza gruppo dato id gruppo
        SELECT bp021_id INTO w_id_grp FROM bp021_tbga WHERE bp021_id = id_grp;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo aziendale inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza gruppo data sigla gruppo + id azienda sopra determinato
        SELECT bp021_id INTO w_id_grp FROM bp021_tbga WHERE bp021_azienda_id_bp003 = w_id_azienda AND bp021_siglaga = sigla_grp;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo aziendale inesistente (sigla non trovata in azienda)', NULL];
        END IF;
    END IF;

    -- popolo lista id item menu di comodo filtrate per procedura
    IF w_count_cod > 0 THEN
        -- get id by cod
        SELECT ARRAY_AGG(bp081_id), ARRAY_AGG(bp081_codice) INTO w_lst_id_item_menu, w_lst_cod_item_menu
          FROM vbp081_tbvoci_menu_attive
         WHERE bp081_procedura_id_bp090 = id_proc
           AND ARRAY[bp081_codice] <@ lst_cod_item_menu;

        -- se ci sono dei codici voce menu non trovati nella bp081
        IF  w_lst_id_item_menu IS NULL OR w_count_cod <> array_length(w_lst_cod_item_menu, 1) THEN
            w_lst_item_menu_not_found = sputils_get_item_array1_not_in_array2(lst_cod_item_menu, w_lst_cod_item_menu);
        END IF;
    ELSE
        -- get id by id
        -- N.B. precauzione per filtrare gli item menu per procedura
        SELECT ARRAY_AGG(bp081_id) INTO w_lst_id_item_menu
          FROM vbp081_tbvoci_menu_attive
         WHERE bp081_procedura_id_bp090 = id_proc
           AND ARRAY[bp081_id] <@ lst_id_item_menu;

        -- se ci sono degli id voce menu non trovati nella bp081
        IF  w_lst_id_item_menu IS NULL OR w_count_id <> array_length(w_lst_id_item_menu, 1) THEN
            w_lst_item_menu_not_found = sputils_get_item_array1_not_in_array2(lst_id_item_menu, w_lst_id_item_menu);
        END IF;
    END IF;

    IF enable IS NULL THEN
        -- elimina i permessi
        DELETE FROM bp247_tbaclaga
         WHERE bp247_azienda_id_bp003 = w_id_azienda
           AND bp247_ga_id_bp021 = w_id_grp
           AND ARRAY[bp247_voce_menu_id_bp081] <@ w_lst_id_item_menu;
    ELSE
        -- abilita/disabilita i permessi esistenti
        UPDATE bp247_tbaclaga SET bp247_consenti = enable
         WHERE bp247_azienda_id_bp003 = w_id_azienda
           AND bp247_ga_id_bp021 = w_id_grp
           AND ARRAY[bp247_voce_menu_id_bp081] <@ w_lst_id_item_menu;

        -- abilita/disabilita nuovi permessi
        INSERT INTO bp247_tbaclaga (bp247_azienda_id_bp003, bp247_ga_id_bp021, bp247_voce_menu_id_bp081, bp247_consenti)
             SELECT w_id_azienda, w_id_grp, bp081_id, enable
               FROM vbp081_tbvoci_menu_attive
              WHERE ARRAY[bp081_id] <@ w_lst_id_item_menu
                AND NOT EXISTS (SELECT 1 FROM bp247_tbaclaga
                                      WHERE bp247_azienda_id_bp003 = w_id_azienda
                                        AND bp247_ga_id_bp021 = w_id_grp
                                        AND bp247_voce_menu_id_bp081 = bp081_id);
    END IF;

    -- OK
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, 'permessi ACLA impostati correttamente per gruppo aziendale', w_lst_item_menu_not_found::varchar];

    EXCEPTION
        WHEN others THEN
            -- errore DB non gestito
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp24x_set_acla_company_group', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp24x_set_acla_company_fil(id_proc integer, id_azienda integer, cod_azienda integer, id_fil integer, cod_fil varchar, lst_id_item_menu bigint[], lst_cod_item_menu text[], enable boolean)
    RETURNS character varying[] AS
$BODY$
--
-- set ACLA gruppo aziendale (abilita/disabilita/rimuove)
--
DECLARE
w_id_fil                    bp015_tbaziendefiliali.bp015_id%TYPE;
w_id_azienda                bp003_tbaziende.bp003_id%TYPE;
w_lst_id_item_menu          bigint[];
w_lst_cod_item_menu         text[];
w_lst_item_menu_not_found   text[];
w_count_id                  int;
w_count_cod                 int;
BEGIN
    w_count_id = 0;
    w_count_cod = 0;
    IF lst_id_item_menu IS NOT NULL AND lst_id_item_menu <> '{}' THEN
        w_count_id = array_length(lst_id_item_menu, 1);
    END IF;
    IF lst_cod_item_menu IS NOT NULL AND lst_cod_item_menu <> '{}' THEN
        w_count_cod = array_length(lst_cod_item_menu, 1);
    END IF;

    -- check parameter validity
    IF id_azienda IS NOT NULL AND cod_azienda IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o codice azienda', NULL];
    ELSIF id_fil IS NOT NULL AND cod_fil IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o codice filiale', NULL];
    ELSIF w_count_id > 0 AND w_count_cod > 0 THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesti id o codici funzioni', NULL];
    ELSIF id_proc IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'id procedura non valorizzato', NULL];
    ELSIF id_azienda IS NULL AND cod_azienda IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave azienda non valorizzata (richiesto id o codice azienda)', NULL];
    ELSIF id_fil IS NULL AND (cod_fil IS NULL OR trim(cod_fil) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave filiale non valorizzata (richiesto id o codice filiale)', NULL];
    ELSIF w_count_id = 0 AND w_count_cod = 0 THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiavi funzioni non valorizzate (richiesti id o codici funzioni)', NULL];
    END IF;

    -- check procedura
    IF NOT EXISTS(SELECT 1 FROM bp090_tbprocedure WHERE bp090_id = id_proc) THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'procedura inesistente (id non trovato)', NULL];
    END IF;

    -- check azienda
    IF id_azienda IS NOT NULL THEN
        -- check esistenza azienda dato id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_id = id_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza azienda dato codice azienda + get id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_codice = cod_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (codice non trovato)', NULL];
        END IF;
    END IF;

    -- check filiale
    IF id_fil IS NOT NULL THEN
        -- check esistenza filiale dato id filiale
        SELECT bp015_id INTO w_id_fil FROM bp015_tbaziendefiliali WHERE bp015_id = id_fil;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'filiale aziendale inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza filiale dato codice filiale + id azienda sopra determinato
        SELECT bp015_id INTO w_id_fil FROM bp015_tbaziendefiliali WHERE bp015_azienda_id_bp003 = w_id_azienda AND bp015_codice = cod_fil;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'filiale aziendale inesistente (filiale non trovata in azienda)', NULL];
        END IF;
    END IF;

    -- popolo lista id item menu di comodo filtrate per procedura
    IF w_count_cod > 0 THEN
        -- get id by cod
        SELECT ARRAY_AGG(bp081_id), ARRAY_AGG(bp081_codice) INTO w_lst_id_item_menu, w_lst_cod_item_menu
          FROM vbp081_tbvoci_menu_attive
         WHERE bp081_procedura_id_bp090 = id_proc
           AND ARRAY[bp081_codice] <@ lst_cod_item_menu;

        -- se ci sono dei codici voce menu non trovati nella bp081
        IF  w_lst_id_item_menu IS NULL OR w_count_cod <> array_length(w_lst_cod_item_menu, 1) THEN
            w_lst_item_menu_not_found = sputils_get_item_array1_not_in_array2(lst_cod_item_menu, w_lst_cod_item_menu);
        END IF;
    ELSE
        -- get id by id
        -- N.B. precauzione per filtrare gli item menu per procedura
        SELECT ARRAY_AGG(bp081_id) INTO w_lst_id_item_menu
          FROM vbp081_tbvoci_menu_attive
         WHERE bp081_procedura_id_bp090 = id_proc
           AND ARRAY[bp081_id] <@ lst_id_item_menu;

        -- se ci sono degli id voce menu non trovati nella bp081
        IF  w_lst_id_item_menu IS NULL OR w_count_id <> array_length(w_lst_id_item_menu, 1) THEN
            w_lst_item_menu_not_found = sputils_get_item_array1_not_in_array2(lst_id_item_menu, w_lst_id_item_menu);
        END IF;
    END IF;

    IF enable IS NULL THEN
        -- elimina i permessi
        DELETE FROM bp244_tbaclafiliali
         WHERE bp244_azienda_id_bp003 = w_id_azienda
           AND bp244_filiale_id_bp015 = w_id_fil
           AND ARRAY[bp244_voce_menu_id_bp081] <@ w_lst_id_item_menu;
    ELSE
        -- abilita/disabilita i permessi esistenti
        UPDATE bp244_tbaclafiliali SET bp244_consenti = enable
         WHERE bp244_azienda_id_bp003 = w_id_azienda
           AND bp244_filiale_id_bp015 = w_id_fil
           AND ARRAY[bp244_voce_menu_id_bp081] <@ w_lst_id_item_menu;

        -- abilita/disabilita nuovi permessi
        INSERT INTO bp244_tbaclafiliali (bp244_azienda_id_bp003, bp244_filiale_id_bp015, bp244_voce_menu_id_bp081, bp244_consenti)
             SELECT w_id_azienda, w_id_fil, bp081_id, enable
               FROM vbp081_tbvoci_menu_attive
              WHERE ARRAY[bp081_id] <@ w_lst_id_item_menu
                AND NOT EXISTS (SELECT 1 FROM bp244_tbaclafiliali
                                      WHERE bp244_azienda_id_bp003 = w_id_azienda
                                        AND bp244_filiale_id_bp015 = w_id_fil
                                        AND bp244_voce_menu_id_bp081 = bp081_id);
    END IF;

    -- OK
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, 'permessi ACLA impostati correttamente per filiale', w_lst_item_menu_not_found::varchar];

    EXCEPTION
        WHEN others THEN
            -- errore DB non gestito
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp24x_set_acla_company_fil', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp24x_set_acla_company_sed(id_proc integer, id_azienda integer, cod_azienda integer, id_sed integer, cod_sed varchar, lst_id_item_menu bigint[], lst_cod_item_menu text[], enable boolean)
    RETURNS character varying[] AS
$BODY$
--
-- set ACLA sede aziendale (abilita/disabilita/rimuove)
--
DECLARE
w_id_sed                    bp020_tbaziendesedi.bp020_id%TYPE;
w_id_azienda                bp003_tbaziende.bp003_id%TYPE;
w_lst_id_item_menu          bigint[];
w_lst_cod_item_menu         text[];
w_lst_item_menu_not_found   text[];
w_count_id                  int;
w_count_cod                 int;
BEGIN
    w_count_id = 0;
    w_count_cod = 0;
    IF lst_id_item_menu IS NOT NULL AND lst_id_item_menu <> '{}' THEN
        w_count_id = array_length(lst_id_item_menu, 1);
    END IF;
    IF lst_cod_item_menu IS NOT NULL AND lst_cod_item_menu <> '{}' THEN
        w_count_cod = array_length(lst_cod_item_menu, 1);
    END IF;

    -- check parameter validity
    IF id_azienda IS NOT NULL AND cod_azienda IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o codice azienda', NULL];
    ELSIF id_sed IS NOT NULL AND cod_sed IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o codice sede', NULL];
    ELSIF w_count_id > 0 AND w_count_cod > 0 THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesti id o codici funzioni', NULL];
    ELSIF id_proc IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'id procedura non valorizzato', NULL];
    ELSIF id_azienda IS NULL AND cod_azienda IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave azienda non valorizzata (richiesto id o codice azienda)', NULL];
    ELSIF id_sed IS NULL AND (cod_sed IS NULL OR trim(cod_sed) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave filiale non valorizzata (richiesto id o codice sed)', NULL];
    ELSIF w_count_id = 0 AND w_count_cod = 0 THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiavi funzioni non valorizzate (richiesti id o codici funzioni)', NULL];
    END IF;

    -- check procedura
    IF NOT EXISTS(SELECT 1 FROM bp090_tbprocedure WHERE bp090_id = id_proc) THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'procedura inesistente (id non trovato)', NULL];
    END IF;

    -- check azienda
    IF id_azienda IS NOT NULL THEN
        -- check esistenza azienda dato id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_id = id_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza azienda dato codice azienda + get id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_codice = cod_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (codice non trovato)', NULL];
        END IF;
    END IF;

    -- check sede
    IF id_sed IS NOT NULL THEN
        -- check esistenza sede dato id sede
        SELECT bp020_id INTO w_id_sed FROM bp020_tbaziendesedi WHERE bp020_id = id_sed;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'sede aziendale inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza sede dato codice sede + id azienda sopra determinato
        SELECT bp020_id INTO w_id_sed FROM bp020_tbaziendesedi WHERE bp020_azienda_id_bp003 = w_id_azienda AND bp020_codice = cod_sed;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'sede aziendale inesistente (sede non trovata in azienda)', NULL];
        END IF;
    END IF;

    -- popolo lista id item menu di comodo filtrate per procedura
    IF w_count_cod > 0 THEN
        -- get id by cod
        SELECT ARRAY_AGG(bp081_id), ARRAY_AGG(bp081_codice) INTO w_lst_id_item_menu, w_lst_cod_item_menu
          FROM vbp081_tbvoci_menu_attive
         WHERE bp081_procedura_id_bp090 = id_proc
           AND ARRAY[bp081_codice] <@ lst_cod_item_menu;

        -- se ci sono dei codici voce menu non trovati nella bp081
        IF  w_lst_id_item_menu IS NULL OR w_count_cod <> array_length(w_lst_cod_item_menu, 1) THEN
            w_lst_item_menu_not_found = sputils_get_item_array1_not_in_array2(lst_cod_item_menu, w_lst_cod_item_menu);
        END IF;
    ELSE
        -- get id by id
        -- N.B. precauzione per filtrare gli item menu per procedura
        SELECT ARRAY_AGG(bp081_id) INTO w_lst_id_item_menu
          FROM vbp081_tbvoci_menu_attive
         WHERE bp081_procedura_id_bp090 = id_proc
           AND ARRAY[bp081_id] <@ lst_id_item_menu;

        -- se ci sono degli id voce menu non trovati nella bp081
        IF  w_lst_id_item_menu IS NULL OR w_count_id <> array_length(w_lst_id_item_menu, 1) THEN
            w_lst_item_menu_not_found = sputils_get_item_array1_not_in_array2(lst_id_item_menu, w_lst_id_item_menu);
        END IF;
    END IF;

    IF enable IS NULL THEN
        -- elimina i permessi
        DELETE FROM bp246_tbaclasedi
         WHERE bp246_azienda_id_bp003 = w_id_azienda
           AND bp246_sede_id_bp020 = w_id_sed
           AND ARRAY[bp246_voce_menu_id_bp081] <@ w_lst_id_item_menu;
    ELSE
        -- abilita/disabilita i permessi esistenti
        UPDATE bp246_tbaclasedi SET bp246_consenti = enable
         WHERE bp246_azienda_id_bp003 = w_id_azienda
           AND bp246_sede_id_bp020 = w_id_sed
           AND ARRAY[bp246_voce_menu_id_bp081] <@ w_lst_id_item_menu;

        -- abilita/disabilita nuovi permessi
        INSERT INTO bp246_tbaclasedi (bp246_azienda_id_bp003, bp246_sede_id_bp020, bp246_voce_menu_id_bp081, bp246_consenti)
             SELECT w_id_azienda, w_id_sed, bp081_id, enable
               FROM vbp081_tbvoci_menu_attive
              WHERE ARRAY[bp081_id] <@ w_lst_id_item_menu
                AND NOT EXISTS (SELECT 1 FROM bp246_tbaclasedi
                                      WHERE bp246_azienda_id_bp003 = w_id_azienda
                                        AND bp246_sede_id_bp020 = w_id_sed
                                        AND bp246_voce_menu_id_bp081 = bp081_id);
    END IF;

    -- OK
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, 'permessi ACLA impostati correttamente per sede', w_lst_item_menu_not_found::varchar];

    EXCEPTION
        WHEN others THEN
            -- errore DB non gestito
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp24x_set_acla_company_sed', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp240_api_remove_all(id_proc integer, id_azienda integer, cod_azienda integer, id_user integer, login_name varchar)
    RETURNS character varying[] AS
$BODY$
--
-- elimina ACLA utente aziendale x tutta la procedura
--
DECLARE
w_msg           text;
w_id_user       bp001_tbutenti.bp001_id%TYPE;
w_id_azienda    bp003_tbaziende.bp003_id%TYPE;
BEGIN
    -- check parameter validity
    IF id_azienda IS NOT NULL AND cod_azienda IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o codice azienda', NULL];
    ELSIF id_user IS NOT NULL AND login_name IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id utente o nome login', NULL];
    ELSIF id_proc IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'id procedura non valorizzato', NULL];
    ELSIF id_azienda IS NULL AND cod_azienda IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave azienda non valorizzata (richiesto id o codice azienda)', NULL];
    ELSIF id_user IS NULL AND (login_name IS NULL OR trim(login_name) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave utente non valorizzata (richiesto id utente o nome login)', NULL];
    END IF;

    -- check procedura
    IF NOT EXISTS(SELECT 1 FROM bp090_tbprocedure WHERE bp090_id = id_proc) THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'procedura inesistente (id non trovato)', NULL];
    END IF;

    -- check azienda
    IF id_azienda IS NOT NULL THEN
        -- check esistenza azienda dato id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_id = id_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza azienda dato codice azienda + get id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_codice = cod_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (codice non trovato)', NULL];
        END IF;
    END IF;

    -- check utente
    IF id_user IS NOT NULL THEN
        -- check esistenza utente dato id utente
        SELECT bp001_id INTO w_id_user FROM bp001_tbutenti WHERE bp001_id = id_user;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza utente dato login name + get id utente
        SELECT bp001_id INTO w_id_user FROM bp001_tbutenti WHERE bp001_nomeutente = login_name;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (nome login non trovato)', NULL];
        END IF;
    END IF;

    -- check utente in azienda ?
    IF NOT sputils_is_user_in_company(w_id_user, w_id_azienda) THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar, E'utente non associato all\'azienda', NULL];
    END IF;

    -- elimina i permessi esistenti per l'Utente Aziendale su tutta la procedura
    DELETE FROM bp240_tbaclautenti
          WHERE bp240_azienda_id_bp003 = w_id_azienda
            AND bp240_utente_id_bp001 = w_id_user
            AND bp240_voce_menu_id_bp081 IN (SELECT bp081_id FROM bp081_tbvoci_menu WHERE bp081_procedura_id_bp090 = id_proc);

    IF FOUND THEN
        w_msg = E'permessi ACLA eliminati correttamente per l\'utente aziendale';
    ELSE
        w_msg = E'non trovati permessi ACLA per l\'utente aziendale';
    END IF;

    -- OK
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, w_msg, NULL];

    EXCEPTION
        WHEN others THEN
            -- errore DB non gestito
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp240_api_remove_all', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp241_api_remove_all(id_proc integer, id_grp integer, sigla_grp varchar)
  RETURNS character varying[] AS
$BODY$
--
-- elimina ACLA gruppi portale x tutta la procedura
--
DECLARE
w_msg           text;
w_id_grp        bp002_tbgruppi.bp002_id%TYPE;
BEGIN
    -- check parameter validity
    IF id_grp IS NOT NULL AND sigla_grp IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o sigla gruppo', NULL];
    ELSIF id_proc IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'id procedura non valorizzato', NULL];
    ELSIF id_grp IS NULL AND (sigla_grp IS NULL OR trim(sigla_grp) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave gruppo non valorizzata (richiesto id o sigla gruppo)', NULL];
    END IF;

    -- check procedura
    IF NOT EXISTS(SELECT 1 FROM bp090_tbprocedure WHERE bp090_id = id_proc) THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'procedura inesistente (id non trovato)', NULL];
    END IF;

    -- check gruppo portale
    IF id_grp IS NOT NULL THEN
        -- check esistenza gruppo dato id gruppo
        SELECT bp002_id INTO w_id_grp FROM bp002_tbgruppi WHERE bp002_id = id_grp;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo portale inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza gruppo data sigla gruppo + get id gruppo portale
        SELECT bp002_id INTO w_id_grp FROM bp002_tbgruppi WHERE bp002_nomegruppo = sigla_grp;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo portale inesistente (sigla non trovata)', NULL];
        END IF;
    END IF;

    -- elimina i permessi esistenti per il Gruppo Portale su tutta la procedura
    DELETE FROM bp241_tbaclagruppi
          WHERE bp241_gruppo_id_bp002 = w_id_grp
            AND bp241_voce_menu_id_bp081 IN (SELECT bp081_id FROM bp081_tbvoci_menu WHERE bp081_procedura_id_bp090 = id_proc);

    IF FOUND THEN
        w_msg = E'permessi ACLA eliminati correttamente per il gruppo portale';
    ELSE
        w_msg = E'non trovati permessi ACLA per il gruppo portale';
    END IF;

    -- OK
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, w_msg, NULL];

    EXCEPTION
        WHEN others THEN
            -- errore DB non gestito
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp241_api_remove_all', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp242_api_remove_all(id_proc integer, id_azienda integer, cod_azienda integer)
    RETURNS character varying[] AS
$BODY$
--
-- elimina ACLA azienda x tutta la procedura
--
DECLARE
w_msg           text;
w_id_azienda    bp003_tbaziende.bp003_id%TYPE;
BEGIN
    -- check parameter validity
    IF id_azienda IS NOT NULL AND cod_azienda IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o codice azienda', NULL];
    ELSIF id_proc IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'id procedura non valorizzato', NULL];
    ELSIF id_azienda IS NULL AND cod_azienda IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave azienda non valorizzata (richiesto id o codice azienda)', NULL];
    END IF;

    -- check procedura
    IF NOT EXISTS(SELECT 1 FROM bp090_tbprocedure WHERE bp090_id = id_proc) THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'procedura inesistente (id non trovato)', NULL];
    END IF;

    -- check azienda
    IF id_azienda IS NOT NULL THEN
        -- check esistenza azienda dato id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_id = id_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza azienda dato codice azienda + get id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_codice = cod_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (codice non trovato)', NULL];
        END IF;
    END IF;

    DELETE FROM bp242_tbaclaaziende
          WHERE bp242_azienda_id_bp003 = w_id_azienda
            AND bp242_voce_menu_id_bp081 IN (SELECT bp081_id FROM bp081_tbvoci_menu WHERE bp081_procedura_id_bp090 = id_proc);

    IF FOUND THEN
        w_msg = E'permessi ACLA eliminati correttamente per l\'azienda';
    ELSE
        w_msg = E'non trovati permessi ACLA per l\'azienda';
    END IF;

    -- OK
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, w_msg, NULL];

    EXCEPTION
        WHEN others THEN
            -- errore DB non gestito
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp242_api_remove_all', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp243_api_remove_all(id_proc integer, id_user integer, login_name varchar)
    RETURNS character varying[] AS
$BODY$
--
-- set ACLA utente portale (abilita/disabilita/rimuove)
--
DECLARE
w_msg           text;
w_id_user       bp001_tbutenti.bp001_id%TYPE;
BEGIN
    -- check parameter validity
    IF id_user IS NOT NULL AND login_name IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id utente o nome login', NULL];
    ELSIF id_proc IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'id procedura non valorizzato', NULL];
    ELSIF id_user IS NULL AND (login_name IS NULL OR trim(login_name) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave utente non valorizzata (richiesto id utente o nome login)', NULL];
    END IF;

    -- check procedura
    IF NOT EXISTS(SELECT 1 FROM bp090_tbprocedure WHERE bp090_id = id_proc) THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'procedura inesistente (id non trovato)', NULL];
    END IF;

    -- check utente
    IF id_user IS NOT NULL THEN
        -- check esistenza utente dato id utente
        SELECT bp001_id INTO w_id_user FROM bp001_tbutenti WHERE bp001_id = id_user;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza utente dato login name + get id utente
        SELECT bp001_id INTO w_id_user FROM bp001_tbutenti WHERE bp001_nomeutente = login_name;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'utente inesistente (nome login non trovato)', NULL];
        END IF;
    END IF;

     -- elimina i permessi esistenti per l'Utente Portale su tutta la procedura
    DELETE FROM bp243_tbaclautenti_portale
          WHERE bp243_utente_id_bp001 = w_id_user
            AND bp243_voce_menu_id_bp081 IN (SELECT bp081_id FROM bp081_tbvoci_menu WHERE bp081_procedura_id_bp090 = id_proc);

    IF FOUND THEN
        w_msg = E'permessi ACLA eliminati correttamente per l\'utente portale';
    ELSE
        w_msg = E'non trovati permessi ACLA per l\'utente portale';
    END IF;

    -- OK
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, w_msg, NULL];

    EXCEPTION
        WHEN others THEN
            -- errore DB non gestito
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp243_api_remove_all', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp247_api_remove_all(id_proc integer, id_azienda integer, cod_azienda integer, id_grp integer, sigla_grp varchar)
    RETURNS character varying[] AS
$BODY$
--
-- elimina ACLA gruppo aziendale x tutta la procedura
--
DECLARE
w_msg          text;
w_id_grp       bp021_tbga.bp021_id%TYPE;
w_id_azienda   bp003_tbaziende.bp003_id%TYPE;
BEGIN
    -- check parameter validity
    IF id_azienda IS NOT NULL AND cod_azienda IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o codice azienda', NULL];
    ELSIF id_grp IS NOT NULL AND sigla_grp IS NOT NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o sigla gruppo aziendale', NULL];
    ELSIF id_proc IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'id procedura non valorizzato', NULL];
    ELSIF id_azienda IS NULL AND cod_azienda IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave azienda non valorizzata (richiesto id o codice azienda)', NULL];
    ELSIF id_grp IS NULL AND (sigla_grp IS NULL OR trim(sigla_grp) = '') THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave gruppo aziendale non valorizzata (richiesto id o sigla gruppo aziendale)', NULL];
    END IF;

    -- check procedura
    IF NOT EXISTS(SELECT 1 FROM bp090_tbprocedure WHERE bp090_id = id_proc) THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'procedura inesistente (id non trovato)', NULL];
    END IF;

    -- check azienda
    IF id_azienda IS NOT NULL THEN
        -- check esistenza azienda dato id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_id = id_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza azienda dato codice azienda + get id azienda
        SELECT bp003_id INTO w_id_azienda FROM bp003_tbaziende WHERE bp003_codice = cod_azienda;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'azienda inesistente (codice non trovato)', NULL];
        END IF;
    END IF;

    -- check gruppo aziendale
    IF id_grp IS NOT NULL THEN
        -- check esistenza gruppo dato id gruppo
        SELECT bp021_id INTO w_id_grp FROM bp021_tbga WHERE bp021_id = id_grp;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo aziendale inesistente (id non trovato)', NULL];
        END IF;
    ELSE
        -- check esistenza gruppo data sigla gruppo + id azienda sopra determinato
        SELECT bp021_id INTO w_id_grp FROM bp021_tbga WHERE bp021_azienda_id_bp003 = w_id_azienda AND bp021_siglaga = sigla_grp;
        IF NOT FOUND THEN
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'gruppo aziendale inesistente (sigla non trovata in azienda)', NULL];
        END IF;
    END IF;

    -- elimina i permessi esistenti per il Gruppo Aziendale su tutta la procedura
    DELETE FROM bp247_tbaclaga
          WHERE bp247_voce_menu_id_bp081 IN (SELECT bp081_id FROM bp081_tbvoci_menu WHERE bp081_procedura_id_bp090 = id_proc)
            AND bp247_azienda_id_bp003 = w_id_azienda
            AND bp247_ga_id_bp021 = w_id_grp;

    IF FOUND THEN
        w_msg = E'permessi ACLA eliminati correttamente per il gruppo aziendale';
    ELSE
        w_msg = E'non trovati permessi ACLA per il gruppo aziendale';
    END IF;

    -- OK
    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, w_msg, NULL];

    EXCEPTION
        WHEN others THEN
            -- errore DB non gestito
            RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function spbp247_api_remove_all', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION sputils_get_item_array1_not_in_array2(array_1 anyarray, array_2 anyarray)
    RETURNS character varying[] AS
$BODY$
-- ritorna un ARRAY contenente gli elementi dell'array_1 non presenti nell'array_2
DECLARE
ret_array   varchar[];
BEGIN
    SELECT array_agg(elements) INTO ret_array
      FROM (SELECT unnest(array_1)
              EXCEPT
            SELECT unnest(array_2)
           ) t (elements);
    RETURN ret_array;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------
-- Function: spbp003_remove_empty_company(integer, integer, integer, boolean, boolean, boolean, boolean)

-- DROP FUNCTION spbp003_remove_empty_company(integer, integer, integer, boolean, boolean, boolean, boolean);

CREATE OR REPLACE FUNCTION spbp003_remove_empty_company(
    id_company integer,
    cod_company integer,
    liv integer,
    dlt_acla boolean,
    dlt_acle boolean,
    dlt_acll boolean,
    dlt_anag boolean)
  RETURNS character varying[] AS
$BODY$
-- Elimina un azienda e relativi dati dipendenti
--
-- liv = 0  Elimina solo dati base (azienda, anagrafica azienda, preferenze azienda)
-- liv = 1  Elimina dati base e struttura aziendale (filiali, sedi, gruppi aziendali)
-- liv = 2  Elimina dati base, struttura aziendale e se azienda consociata/gestita la rimuove dallo studio (non la rimuove se trattasi di azienda master)

DECLARE
--v_state       text;
--v_hint    	text;
--v_context 	text;
v_msg     	text;
v_detail  	text;
w_id_azienda   	bp003_tbaziende.bp003_id%TYPE;
w_id_anag      	bp004_tbanagrafiche.bp004_id%TYPE;
w_id_anag_user 	bp004_tbanagrafiche.bp004_id%TYPE;
w_id_user_super bp003_tbaziende.bp003_supervisor_id_bp001%TYPE;
w_id_bp010     	bp010_tbutentiaziende.bp010_id%TYPE;
cur_bp010      	CURSOR (id_az integer) FOR SELECT bp010_id, bp010_utente_id_bp001 FROM bp010_tbutentiaziende WHERE bp010_azienda_id_bp003 = id_az;
rec_bp010      	RECORD;
BEGIN
    IF id_company IS NULL AND cod_company IS NULL THEN
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_MISSING_DATA')::varchar,'chiave azienda non valorizzata (richiesto id o codice azienda)', NULL];
    ELSIF id_company IS NOT NULL AND cod_company IS NOT NULL THEN
	    RETURN ARRAY[spadmin_get_error_code('ERR_CODE_CONFLICTING_PARAMETERS')::varchar,'conflitto nei parametri, richiesto id o codice azienda', NULL];
    ELSIF id_company IS NULL THEN
	    -- get id azienda e id anagrafica azienda dato il codice azienda
	    SELECT bp003_id, bp003_anagrafica_id_bp004, bp003_supervisor_id_bp001 INTO w_id_azienda, w_id_anag, w_id_user_super FROM bp003_tbaziende WHERE bp003_codice = cod_company;
    ELSIF id_company IS NOT NULL THEN
        -- in comodo id azienda + geti id anagrafica azienda
        SELECT bp003_id, bp003_anagrafica_id_bp004, bp003_supervisor_id_bp001 INTO w_id_azienda, w_id_anag, w_id_user_super FROM bp003_tbaziende WHERE bp003_id = id_company;
    END IF;

    -- disabilito trigger per poter eliminare il gruppo supervisors e service
    ALTER TABLE bp021_tbga DISABLE TRIGGER bp021_groups_protected;

    -- annullo il supervisore aziendale
    UPDATE bp003_tbaziende SET bp003_supervisor_id_bp001 = NULL WHERE bp003_id = w_id_azienda;

    -- annullo l'ultima azienda di login per tutti gli utenti del portale che si sono loggati con tale azienda
    UPDATE bp001_tbutenti SET bp001_ult_az_login_id_bp003 = NULL WHERE bp001_ult_az_login_id_bp003 IS NOT NULL AND bp001_ult_az_login_id_bp003 = w_id_azienda ;

    -- annullo gli utenti capigruppo nei gruppi aziendali
    UPDATE bp021_tbga SET bp021_capogruppo_id_bp022 = NULL WHERE bp021_capogruppo_id_bp022 IS NOT NULL AND bp021_azienda_id_bp003 = w_id_azienda;

    -- annullo il ga preferenziale per tutti gli utenti aziendali
    UPDATE bp010_tbutentiaziende SET bp010_ga_preferenziale_id_bp021 = NULL WHERE bp010_ga_preferenziale_id_bp021 IS NOT NULL AND bp010_azienda_id_bp003 = w_id_azienda;

    IF dlt_acla THEN
	-- eliminazione permessi ACLA
        DELETE FROM bp240_tbaclautenti WHERE bp240_azienda_id_bp003 = w_id_azienda;
        DELETE FROM bp242_tbaclaaziende WHERE bp242_azienda_id_bp003 = w_id_azienda;
        DELETE FROM bp244_tbaclafiliali WHERE bp244_azienda_id_bp003 = w_id_azienda;
        DELETE FROM bp246_tbaclasedi WHERE bp246_azienda_id_bp003 = w_id_azienda;
        DELETE FROM bp247_tbaclaga WHERE bp247_azienda_id_bp003 = w_id_azienda;
    END IF;

    IF dlt_acle THEN
	-- eliminazione permessi ACLE
        DELETE FROM bp350_tbacleutenti WHERE bp350_azienda_id_bp003 = w_id_azienda;
        DELETE FROM bp352_tbacleaziende WHERE bp352_azienda_id_bp003 = w_id_azienda;
        DELETE FROM bp354_tbaclefiliali WHERE bp354_azienda_id_bp003 = w_id_azienda;
        DELETE FROM bp356_tbaclesedi WHERE bp356_azienda_id_bp003 = w_id_azienda;
        DELETE FROM bp357_tbaclega WHERE bp357_azienda_id_bp003 = w_id_azienda;
    END IF;

    IF dlt_acll THEN
	-- eliminazione permessi ACLL
        DELETE FROM bp460_tbacllutenti WHERE bp460_azienda_id_bp003 = w_id_azienda;
        DELETE FROM bp462_tbacllaziende WHERE bp462_azienda_id_bp003 = w_id_azienda;
        DELETE FROM bp464_tbacllfiliali WHERE bp464_azienda_id_bp003 = w_id_azienda;
        DELETE FROM bp466_tbacllsedi WHERE bp466_azienda_id_bp003 = w_id_azienda;
        DELETE FROM bp467_tbacllga WHERE bp467_azienda_id_bp003 = w_id_azienda;
    END IF;

    IF liv >= 0 THEN
        -- elimino l'utente supervisore dal gruppo 'supervisors'
        DELETE FROM bp022_tbutentiga
        WHERE bp022_utente_id_bp001 = w_id_user_super
          AND bp022_ga_id_bp021 IN (SELECT bp021_id FROM bp021_tbga WHERE bp021_azienda_id_bp003 = w_id_azienda AND bp021_siglaga = 'supervisors');

        -- elimino il gruppo 'supervisors'
        DELETE FROM bp021_tbga WHERE bp021_azienda_id_bp003 = w_id_azienda AND bp021_siglaga = 'supervisors';
    END IF;

    IF liv >= 1 THEN
        -- elimino tutte le sedi aziendali
        DELETE FROM bp020_tbaziendesedi WHERE bp020_azienda_id_bp003 = w_id_azienda;

        -- elimino tutte le filiali aziendali
        DELETE FROM bp015_tbaziendefiliali WHERE bp015_azienda_id_bp003 = w_id_azienda;

        -- elimino tutti gli utenti dai gruppi aziendali
        DELETE FROM bp022_tbutentiga WHERE bp022_ga_id_bp021 IN (SELECT bp021_id FROM bp021_tbga WHERE bp021_azienda_id_bp003 = w_id_azienda);

        -- elimino tutti i gruppi aziendali
        DELETE FROM bp021_tbga WHERE bp021_azienda_id_bp003 = w_id_azienda;

        -- elimino le preferenze dell'azienda
        DELETE FROM bp011_tbpreferenze WHERE bp011_azienda_id_bp003 = w_id_azienda;
    END IF;

    IF liv >= 2 THEN
        -- rimozione azienda da tutti gli studi di cui fa parte solo se non si tratta dell'azienda master
        DELETE FROM bp013_tbaziendestudi WHERE bp013_azienda_id_bp003 = w_id_azienda
                                           AND NOT EXISTS (SELECT 1 FROM bp008_tbstudi WHERE bp008_master_id_bp003 = w_id_azienda);
    END IF;
    -- ---- NON DEVO ELIMINARE GLI UTENTI

    IF dlt_anag THEN
	    -- rimozione anagrafiche associate all'azienda
	    DELETE FROM bp031_tbanag_aziende WHERE bp031_azienda_id_bp003 = w_id_azienda;
    END IF;

    -- elimino l'azienda
    DELETE FROM bp003_tbaziende WHERE bp003_id = w_id_azienda;

    IF dlt_anag THEN
	    -- elimino gli indirizzi dell'azienda
	    DELETE FROM bp066_tbtipi_indirizzi WHERE bp066_anagrafica_id_bp004 = w_id_anag;
	    DELETE FROM bp051_tbindirizzi WHERE bp051_anagrafica_id_bp004 = w_id_anag;

	    -- elimino l'anagrafica dell'azienda
	    DELETE FROM bp004_tbanagrafiche WHERE bp004_id = w_id_anag;
    END IF;

    -- riabilito trigger che impedisce la modifica e la eliminazione del gruppo supervisors e service
    ALTER TABLE bp021_tbga ENABLE TRIGGER bp021_groups_protected;

    RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, 'azienda eliminata', NULL];

    EXCEPTION
        WHEN FOREIGN_KEY_VIOLATION THEN
            --GET STACKED DIAGNOSTICS   v_state = RETURNED_SQLSTATE, v_msg = MESSAGE_TEXT, v_detail = PG_EXCEPTION_DETAIL, v_hint = PG_EXCEPTION_HINT, v_context = PG_EXCEPTION_CONTEXT;
            GET STACKED DIAGNOSTICS v_msg = MESSAGE_TEXT, v_detail = PG_EXCEPTION_DETAIL;
	    RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar, E'impossibile eliminare l''azienda in quanto sono presenti dei dati che lo impediscono.\nDB error: ' || v_msg || E'\n' || v_detail, NULL];
	WHEN others THEN
	    -- errore DB non gestito
	    RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar, 'errore DB ' || SQLSTATE || ' non gestito in stored function spbp003_remove_company', NULL];
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION sha1(text)
  RETURNS text AS $$
      SELECT encode(digest($1, 'sha1'), 'hex')
    $$ LANGUAGE SQL STRICT IMMUTABLE;
---------------------------------------------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION sputils_get_random_char(str text)
  RETURNS varchar AS
$BODY$
  BEGIN
    RETURN  (string_to_array(str,NULL))
    [floor(random() * length(str) + 1)];
  END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
--------------------------------------------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION sputils_words_shuffle(stringa text)
  RETURNS text AS
$BODY$
DECLARE
curs    REFCURSOR;
rec     record;
ret text = '';
 BEGIN
    OPEN curs FOR select substr(stringa, i, 1) as a from generate_series(1, length(stringa)) i order by random();
    LOOP FETCH curs INTO rec;
    EXIT WHEN NOT FOUND;
        IF rec.a IS NOT NULL THEN
            ret = ret || rec.a;
        END IF;
    END LOOP;
    CLOSE curs;
    RETURN ret;
 END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
---------------------------------------------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION sputils_get_random_password()
  RETURNS text AS
$BODY$
   -- Genera un codice randomico alfanumerico di lunghezza 8 che rispetta il pattern preveisto dalla normativa GDPR
    -- [A-Z][a-z][0-9][.-_]
DECLARE
i               int;
pwd             text;
lower_letters   varchar = 'abcdefghijklmnopqrstuvwxyz';
upper_letters   varchar = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
digits          varchar = '0123456789';
special         varchar = '._-';
BEGIN
    pwd = sputils_get_random_char(lower_letters) ||
          sputils_get_random_char(upper_letters) ||
          sputils_get_random_char(digits) ||
          sputils_get_random_char(special);
    FOR i IN 1..4 LOOP
        pwd = pwd || sputils_get_random_char( lower_letters || upper_letters || digits || special);
    END LOOP;
    pwd = sputils_words_shuffle(pwd);
    RETURN pwd;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
---------------------------------------------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION sputils_encrypt_password(pwd text)
  RETURNS text AS
$BODY$
  -- Ritorna una password criptata e generata con un codice randomico alfanumerico di lunghezza 8 che rispetta il pattern preveisto dalla normativa GDPR
  -- [A-Z][a-z][0-9][.-_]
  -- PYHTON : def pwd_create(raw_password):
  --     	  salt = sha1(str(random.random())).hexdigest()[:5]
  --		  hsh = sha1(salt + raw_password).hexdigest()
  --     	  return "%s$%s" % (salt, hsh)
DECLARE
salt   text;
hsh    text;
BEGIN
    salt = substring(sha1(random()::text) from 1 for 5);
    hsh = sha1(salt || pwd);
    RETURN salt || '$' || hsh;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
---------------------------------------------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION sputils_get_all_branch_items_id(item_code varchar)
  RETURNS SETOF RECORD AS
$BODY$
   -- Ritorna tutti gli id figli dell'item passato (esso compresto)
BEGIN
    RETURN QUERY
      WITH RECURSIVE menu_recursive(bp081_id) AS ( SELECT bp081_id, bp081_codice
                                                     FROM vbp081_tbvoci_menu_attive
                                                    WHERE bp081_codice = item_code
                                        UNION ALL
                                                   SELECT m.bp081_id, m.bp081_codice
                                                     FROM menu_recursive mr, vbp081_tbvoci_menu_attive m
                                                    WHERE m.bp081_voce_menu_padre_id_bp081 = mr.bp081_id)
        SELECT bp081_id FROM menu_recursive;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION spbp240_set_acla_utente(company_id int, user_id int, item_id bigint, consenti boolean)
  RETURNS void AS
$BODY$
   -- Imposta la regola ACLA utente aziendale
DECLARE
tmp_id    bigint;
BEGIN
    SELECT bp240_id INTO tmp_id FROM bp240_tbaclautenti WHERE bp240_azienda_id_bp003 = company_id
                                                          AND bp240_utente_id_bp001 = user_id
                                                          AND bp240_voce_menu_id_bp081  = item_id;
    IF FOUND
    THEN
        UPDATE bp240_tbaclautenti SET bp240_consenti = consenti WHERE bp240_id = tmp_id;
    ELSE
        INSERT INTO bp240_tbaclautenti (bp240_azienda_id_bp003, bp240_utente_id_bp001, bp240_voce_menu_id_bp081, bp240_consenti)
               VALUES (company_id, user_id, item_id, consenti);
    END IF;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

---------------------------------------------------------------------------------------------------------------------------------------------
-- wrapper per compatibilità pregresso in saas dove fanno la chiamata senza passare il parametro is_saas
DROP FUNCTION IF EXISTS sputils_set_admin_l2(text);
CREATE OR REPLACE FUNCTION sputils_set_admin_l2(pwd text)
  RETURNS character varying AS
$BODY$
BEGIN
  -- Riceve la password di adminl2 in chiaro
  RETURN sputils_set_admin_l2(pwd, True);
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
---------------------------------------------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION sputils_set_admin_l2(pwd text)
  RETURNS character varying AS
  -- Riceve la password di adminl2 in chiaro
$BODY$
DECLARE
generator_id        int;
company_id          int;
user_id             int;
anag_id             int;
group_id	        int;
caller              varchar = 'sistema';
username            varchar = 'adminl2';
start_page          varchar = 'ar,ar.ar_start.GET,Avvio Rapido,Sommario';
ret_str             varchar;
ret_sp              varchar[];
item_code           varchar;
item_id             bigint;
tmp_id              bigint;
supervisor_login    varchar;
supervisor_user_id  int;

hidden_items      varchar[] = ARRAY['acge.*', 'cms.*', 'de.*', 'mt.*', 'tu.*', 'tdl.*', 'tsinfo.*', 'wapp.*','rs.*',
                                    'admin.msad.*', 'admin.admin.*', 'admin.admin_portale.filestorage', 'admin.admin_portale.install',
                                    'admin.admin_portale.datasource', 'admin.admin_portale.tomcat_conf','admin.admin_logs.logs_appserv',
                                    'pg.pg_gest.modalita', 'pg.pg_admin.conv_amb', 'pg.pg_gest.Ridotta', 'pg.pg_gest.Carattere',
                                    'pg.pg_admin.acuxdbc', 'pg.pg_admin.server', 'pg.pg_admin.aggiornamenti', 'pg.pg_gest.rileggi', 'pg.pg_admin.navfs',
                                    'pg.pg_admin.configurazione', 'pg.pg_admin.navfs', 'admin.admin_logs.logs_db', 'admin.admin_logs.logs_appserv'];

not_hidden_items  varchar[] = ARRAY['tu.*', 'tu.tu_release_notes.GET'];

enabled_items     varchar[] = ARRAY['ag.*','au.*','as.*','ba.*','uc.*','sd.*','cd.*','oe.*','ld.*','gm.*','nm.*','go.*',
                                    'prefs.*','pg.*','gc.*','sca.*','sched.*','service.*','wfo.*','pw.*','dmslib.*','tu.*',

                                    'admin.admin_ute_az.*',
                                    'admin.admin_importazioni.*',
                                    'admin.admin_portale.wrapper_configurazioni',
                                    'admin.admin_dati_propri.*',
                                    'admin.admin_cron.logs',
                                    'admin.admin_re.*',
                                    'admin.admin_tabelle.*',
                                    'admin.permessi.admin_permessi_acla.*',
                                    'admin.permessi.admin_permessi_acle.*',
                                    'admin.permessi.admin_permessi_acll.*',
                                    'admin.admin_portale.wrapper_licenze',
                                    'admin.admin_portale.wrapper_licenze_utilizzo',
                                    'admin.admin_portale.vista_menu',
                                    'admin.admin_portale.sessions_maintenance',
                                    'admin.admin_portale.intranet',
                                    'admin.admin_upload_lang_catalogs.GET',
                                    'admin.isp.admin_isp_conf.GET',
                                    'admin.ta.admin_ta_personalizzazione.GET',
                                    'admin.admin_logs.logs_accesslog',
                                    'admin.admin_logs.logs_portale',
                                    'admin.admin_logs.logs_httpd',
                                    'admin.admin_logs.logs_errors',
                                    'admin.admin_portale.httpd_conf',
                                    'admin.admin_portale.pg_conf',
                                    'admin.admin_portale.redis_conf',
                                    'admin.admin_portale.rg_conf',
                                    'admin.ar.admin_ar.START',
                                    'admin.sr.admin_sr_servizi_esterni.*',
                                    'admin.sr.admin_sr_servizi_collaboration.collaboration_config',

                                    'rs.rs_report.GET',
                                    'rs.rs_resources.GET',

                                    'smartapp.smartapp_import_data.GET',
                                    'smartapp.smartapp_widget_catalogue.GET',
                                    'smartapp.smartapp_dashboard_administration.GET',

                                    'ar.ar_lic.GET',
                                    'ar.ar_start.GET',
                                    'ar.ar_apps.GET'];

disabled_items    varchar[] = ARRAY['wd.*','ws.*','sr.*','avvisi.*','smartapp.*',

                                    'admin.permessi.*',
                                    'admin.sr.*',
                                    'admin.admin_avvisi.*',
                                    'admin.admin_utilita.*',
                                    'admin.admin_logs.*',
                                    'admin.admin_portale.acl_settings',
                                    'admin.admin_portale.install_proc',
                                    'admin.admin_portale.sc_gestione',
                                    'admin.permessi.admin_permessi_acla.acla_migrazioni',
                                    'admin.ap_dispatcher.ap_dispatcher_control.GET',

                                    'am.*',

                                    'pg.pg_gest.modalita',
                                    'pg.pg_admin.conv_amb',
                                    'pg.pg_admin.acuxdbc',
                                    'pg.pg_admin.server',
                                    'pg.pg_admin.aggiornamenti',
                                    'pg.pg_admin.configurazione',
                                    'pg.pg_gest.rileggi',
                                    'pg.pg_gest.Ridotta',
                                    'pg.pg_gest.Carattere'];
BEGIN
   -- get id generatore
   generator_id = spbp034_get_id_generatore(caller);

   -- check utenti abilitati  SERVE ?!?!?

   -- crea utente adminl2 + anagrafica
   -- params: id_generatore int,
   --         login_name varchar,
   --         cognome varchar,
   --         nome varchar,
   --         anag_id bigint,
   --         uic_code int,
   --         flg_persona_fisica boolean,
   --         email varchar, password varchar,
   --         change_password boolean,
   --         flg_sso boolean
   SELECT * INTO ret_sp FROM spbp001_create_user(generator_id, username, username, username, NULL, NULL, True, NULL, sputils_encrypt_password(pwd), True, False);
   IF ret_sp[1] != '0' THEN
        -- errore
        -- ROLLBACK;  FIXME - possibile con Postgresql 9.11
        RETURN ret_sp;
   END IF;
   user_id = ret_sp[3]::int;

   -- aggiorna flag supporto
   UPDATE bp001_tbutenti SET bp001_flg_support_user = True WHERE bp001_id = user_id;
   IF NOT FOUND THEN
        -- errore
        -- ROLLBACK;  FIXME - possibile con Postgresql 9.11
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'Mancata generazione utente ' || username, NULL];
   END IF;

   -- aggiunge adminl2 al gruppo portale 'powerusers' se non è già presente
   SELECT bp002_id INTO group_id FROM bp002_tbgruppi WHERE bp002_nomegruppo = 'powerusers';
   IF NOT EXISTS (SELECT 1 FROM bp009_tbutentigruppi WHERE bp009_gruppo_id_bp002 = group_id AND bp009_utente_id_bp001 = user_id) THEN
	INSERT INTO bp009_tbutentigruppi (bp009_gruppo_id_bp002, bp009_utente_id_bp001) VALUES (group_id, user_id);
   END IF;

   -- FIXME
   -- FIXME per il momento utilizzo la stessa anagrafica per l'utente adminl2, azienda adminl2 e utente supervisor
   -- FIXME

   -- get id anagrafica adminl2
   SELECT bp004_id INTO anag_id FROM bp004_tbanagrafiche WHERE bp004_cognomeragsoc = username;
   IF anag_id IS NULL THEN
        -- errore
        -- ROLLBACK;  FIXME - possibile con Postgresql 9.11
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'Mancata generazione del ID anagrafica per ' || username, NULL];
   END IF;

   -- crea azienda adminl2
   -- params: id_generatore int,
   --         codice integer,
   --         ragsoc varchar,
   --         anag_id bigint,
   --         uic_code integer,
   --         flg_persona_fisica boolean
   SELECT * INTO ret_sp FROM spbp003_create_company(generator_id, NULL, NULL, anag_id, NULL, False);
   IF ret_sp[1] != '0' THEN
        -- errore
        -- ROLLBACK;  FIXME - possibile con Postgresql 9.11
        RETURN ret_sp;
   END IF;

   company_id = substring(ret_sp[3] from 1 for position(',' IN ret_sp[3])-1);

   -- aggiunge utente ad azienda
   -- params: id_azienda integer,
   --         id_utente integer,
   --         id_filiale integer,
   --         id_sede integer,
   --         flg_disabilitato boolean
   SELECT * INTO ret_str FROM spbp010_set_utente_aziendale_no_pref(company_id, user_id, -1, -1, False);
   IF ret_str = 'KO' THEN
        -- errore
        -- ROLLBACK;  FIXME - possibile con Postgresql 9.11
        RETURN ARRAY[spadmin_get_error_code('ERR_CODE_KEY_NOT_FOUND')::varchar,'Mancata associazione utente ad azienda per ' || username, NULL];
   END IF;

   -- crea gruppo aziendale 'supervisors' se non esiste
   SELECT bp021_id INTO group_id FROM bp021_tbga WHERE bp021_azienda_id_bp003 = company_id AND  bp021_siglaga = 'supervisors';
   IF NOT FOUND THEN
	INSERT INTO bp021_tbga (bp021_azienda_id_bp003, bp021_siglaga, bp021_ga) VALUES (company_id, 'supervisors', 'Gruppo aziendale di sistema') RETURNING bp021_id INTO group_id;
   END IF;

   -- crea utente supervisor
   supervisor_login = 'supervisor_' || anag_id::varchar;
   -- params: id_generatore int,
   --         login_name varchar,
   --         cognome varchar,
   --         nome varchar,
   --         anag_id bigint,
   --         uic_code int,
   --         flg_persona_fisica boolean,
   --         email varchar, password varchar,
   --         change_password boolean,
   --         flg_sso boolean
   SELECT * INTO ret_sp FROM spbp001_create_user(generator_id, supervisor_login, NULL, NULL, anag_id, NULL, True, NULL, sputils_encrypt_password(supervisor_login), True, False);
   IF ret_sp[1] != '0' THEN
        -- errore
        -- ROLLBACK;  FIXME - possibile con Postgresql 9.11
        RETURN ret_sp;
   END IF;
   supervisor_user_id = ret_sp[3]::int;

   -- associa l'utente supervisor all'azienda adminl2 ed al gruppo aziendale 'supervisors'
   -- params: id_user int,
   --         login_name varchar,
   --         id_azienda integer,
   --         cod_azienda integer,
   --         id_ga integer
   SELECT * INTO ret_sp FROM spbp010_add_user_to_company(supervisor_user_id, NULL, company_id, NULL, group_id);
   IF ret_sp[1] != '0' THEN
        -- errore
        -- ROLLBACK;  FIXME - possibile con Postgresql 9.11
        RETURN ret_sp;
   END IF;

   -- imposta il supervisore aziendale
   UPDATE bp003_tbaziende SET bp003_supervisor_id_bp001 = supervisor_user_id WHERE bp003_id = company_id;

   -- set preferenze utente per default pagina iniziale
   WITH new_values (bp011_utente_id_bp001, bp011_default_startpage) AS (values (user_id, start_page)),
      UPSERT AS (UPDATE bp011_tbpreferenze m
                    SET bp011_utente_id_bp001 = nv.bp011_utente_id_bp001,
                        bp011_default_startpage = start_page
                    FROM new_values nv WHERE m.bp011_utente_id_bp001 = nv.bp011_utente_id_bp001 RETURNING m.*)
      INSERT INTO bp011_tbpreferenze (bp011_utente_id_bp001, bp011_default_startpage)
             SELECT bp011_utente_id_bp001, bp011_default_startpage
             FROM new_values
             WHERE NOT EXISTS (SELECT 1 FROM bp011_tbpreferenze up
                               WHERE up.bp011_utente_id_bp001 = new_values.bp011_utente_id_bp001);

   -- set voci HIDDEN - per ogni voce esplode tutto il ramo
   FOREACH item_code IN ARRAY hidden_items LOOP
        UPDATE bp081_tbvoci_menu SET bp081_flg_hidden = True
            WHERE bp081_id IN (select * from sputils_get_all_branch_items_id(item_code) as (bp081_id bigint));
   END LOOP;

   -- set voci NOT HIDDEN - puntuale sulla voce
   FOREACH item_code IN ARRAY not_hidden_items LOOP
        UPDATE bp081_tbvoci_menu SET bp081_flg_hidden = False
            WHERE bp081_codice = item_code;
   END LOOP;

   -- cancellazione di tutte le regole ACLA per adminl2
   DELETE FROM bp240_tbaclautenti WHERE bp240_utente_id_bp001 = user_id;
   DELETE FROM bp243_tbaclautenti_portale WHERE bp243_utente_id_bp001 = user_id;

   -- abilita voci menu per adminl2
   FOREACH item_code IN ARRAY enabled_items LOOP
        SELECT bp081_id INTO item_id FROM bp081_tbvoci_menu WHERE bp081_codice = item_code;
        IF FOUND THEN
            PERFORM spbp240_set_acla_utente(company_id, user_id, item_id, True);
        END IF;
   END LOOP;
   -- disabilita voci menu per adminl2
   FOREACH item_code IN ARRAY disabled_items LOOP
        SELECT bp081_id INTO item_id FROM bp081_tbvoci_menu WHERE bp081_codice = item_code;
        IF FOUND THEN
            PERFORM spbp240_set_acla_utente(company_id, user_id, item_id, False);
        END IF;
   END LOOP;

   RETURN ARRAY[spadmin_get_error_code('RET_CODE_OK')::varchar, 'Elaborazione set adminl2 terminata correttamente', Null ];

   EXCEPTION
       WHEN others THEN
           -- errore DB non gestito
           RETURN ARRAY[spadmin_get_error_code('ERR_CODE_DB_ERROR')::varchar,'errore DB ' || SQLSTATE || ' non gestito in stored function sputils_set_admin_l2', NULL];

END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

-- 
---------------------------------------------------------------------------------------------------------
-- Admin - trigger functions
---------------------------------------------------------------------------------------------------------
/*
Questo trigger andrebbe messo dopo il caricamento dati 04_admin_data.sql perché altrimenti va in errore il caricamento
sarebbe da rivedere la sequenza degli script dove quello dei trigger anziché suffisso 03 dovrebbero essere 05 (da verificare)

CREATE OR REPLACE FUNCTION spadmin_protect_data()
    RETURNS trigger AS
$BODY$
BEGIN
    -- function trigger per proteggere INSERT/UPDATE/DELETE in una tabella

    IF (TG_OP = 'INSERT') THEN
        RAISE EXCEPTION 'Impossibile aggiungere dati nella tabella %', TG_TABLE_NAME;
    ELSIF (TG_OP = 'DELETE') THEN
        RAISE EXCEPTION 'Impossibile eliminare i dati della tabella %', TG_TABLE_NAME;
    ELSE
        RAISE EXCEPTION 'Impossibile modificare i dati della tabella %', TG_TABLE_NAME;
    END IF;
    RETURN NULL;
END;
$BODY$
LANGUAGE 'plpgsql' VOLATILE;

DROP TRIGGER IF EXISTS admin001_t_protect_data ON admin001_tbreturn_code;
CREATE TRIGGER admin001_t_protect_data
  BEFORE INSERT OR UPDATE OR DELETE
  ON admin001_tbreturn_code
  FOR EACH ROW EXECUTE PROCEDURE spadmin_protect_data();
*/
---------------------------------------------------------------------------------------------------------

COMMIT;
