BEGIN;
----------------------------------------------------------------------------------------
-- CANCELLAZIONE PREVENTIVA DI TUTTE LE TABELLE E VISTE SCHED - PER PROBLEMI IN UPDATE
----------------------------------------------------------------------------------------
DROP TABLE if exists sched001_tbconfig cascade;
DROP TABLE if exists sched002_tbjobs cascade;
DROP TABLE if exists sched003_tbjobsruntime cascade;
DROP TABLE if exists sched004_tbjobstorici cascade;
DROP TABLE if exists sched005_tbclosemodes cascade;
DROP TABLE if exists sched006_tbgiorni cascade;
DROP TABLE if exists sched007_stati cascade;
DROP TABLE if exists sched008_tipomessaggi cascade;

DROP FUNCTION if exists spsched002_candownloadjobres(integer);
DROP FUNCTION if exists spsched002_deschedulejob(bigint);
DROP FUNCTION if exists spsched002_eliminajob(integer);
DROP FUNCTION if exists spsched002_getdistinctambiente();
DROP FUNCTION if exists spsched002_getdistinctstati();
DROP FUNCTION if exists spsched002_getfreeslots(boolean);
DROP FUNCTION if exists spsched002_getimmjobtorun();
DROP FUNCTION if exists spsched002_getjobpercentage(bigint);
DROP FUNCTION if exists spsched002_getnormjobtorun();
DROP FUNCTION if exists spsched002_inseriscijobvergine();
DROP FUNCTION if exists spsched002_kill_reschedule(bigint);
DROP FUNCTION if exists spsched002_processtimeoutedjob(bigint);
DROP FUNCTION if exists spsched002_proclistener_update_output_path(character varying, bigint);
DROP FUNCTION if exists spsched002_promotejobimm(bigint);
DROP FUNCTION if exists spsched002_schedulerconfirmstop(bigint);
DROP FUNCTION if exists spsched002_startjob(bigint);
DROP FUNCTION if exists spsched002_stopjob(bigint);
DROP FUNCTION if exists spsched002_treattimeouted();
DROP FUNCTION if exists spsched002_updatejob(bigint, smallint, smallint, smallint, integer, smallint, character varying, bigint, character varying, boolean, character varying, bigint, bigint, boolean);
DROP FUNCTION if exists spsched002_updatejobgui(bigint, smallint, smallint, integer, smallint, character varying, character varying, boolean, boolean);
DROP FUNCTION if exists spsched002_updatejobvergine(bigint, smallint, smallint, integer, smallint, character varying, character varying, boolean, boolean, character varying, bigint, bigint);
DROP FUNCTION if exists spsched002_userstopjob(bigint);
DROP FUNCTION if exists spsched002_userstoppedjob(bigint);
DROP FUNCTION if exists spsched003_invokecrashmanager();
DROP FUNCTION if exists spsched003_proclistener(bigint, integer, character varying, bigint, bigint, integer);
DROP FUNCTION if exists spsched002_updatejobgui(bigint, smallint, smallint, integer, smallint, character varying, boolean);
DROP FUNCTION if exists spsched002_updatejobvergine(bigint, smallint, smallint, integer, smallint, character varying, character varying, boolean, boolean, character varying, bigint, bigint, character varying, character varying);


DROP FUNCTION if exists spsched003_logjobcreation() cascade;
DROP FUNCTION if exists spsched003_logjobupdate() cascade;

DROP FUNCTION if exists spsched001_eliminaconfigurazione(integer);
DROP FUNCTION if exists spsched001_inserisciconfigurazione(boolean, character varying, time without time zone, time without time zone, boolean, character varying, integer, integer, character varying, integer, integer);
DROP FUNCTION if exists spsched001_modificaconfigurazione(integer, boolean, character varying, time without time zone, time without time zone, boolean, character varying, integer, integer, character varying, integer, smallint);
DROP FUNCTION if exists spsched002_candownloadjobres(integer);
DROP FUNCTION if exists spsched002_deschedulejob(bigint);
DROP FUNCTION if exists spsched002_eliminajob(integer);
DROP FUNCTION if exists spsched002_getdistinctambiente();
DROP FUNCTION if exists spsched002_getdistinctstati();
DROP FUNCTION if exists spsched002_getfreeslots(boolean);
DROP FUNCTION if exists spsched002_getimmjobtorun();
DROP FUNCTION if exists spsched002_getjobpercentage(bigint);
DROP FUNCTION if exists spsched002_getnormjobtorun();
DROP FUNCTION if exists spsched002_inseriscijobvergine();
DROP FUNCTION if exists spsched002_kill_reschedule(bigint);
DROP FUNCTION if exists spsched002_processtimeoutedjob(bigint);
DROP FUNCTION if exists spsched002_proclistener_update_output_path(character varying, bigint);
DROP FUNCTION if exists spsched002_promotejobimm(bigint);
DROP FUNCTION if exists spsched002_schedulerconfirmstop(bigint);
DROP FUNCTION if exists spsched002_startjob(bigint);
DROP FUNCTION if exists spsched002_stopjob(bigint);
DROP FUNCTION if exists spsched002_treattimeouted();
DROP FUNCTION if exists spsched002_updatejob(bigint, smallint, smallint, smallint, integer, smallint, character varying, bigint, character varying, boolean, character varying, bigint, bigint, boolean);
DROP FUNCTION if exists spsched002_updatejobgui(bigint, smallint, smallint, integer, smallint, character varying, character varying, boolean, boolean);
DROP FUNCTION if exists spsched002_updatejobvergine(bigint, smallint, smallint, integer, smallint, character varying, character varying, boolean, boolean, character varying, bigint, bigint);
DROP FUNCTION if exists spsched002_userstopjob(bigint);
DROP FUNCTION if exists spsched002_userstoppedjob(bigint);
DROP FUNCTION if exists spsched003_invokecrashmanager();
DROP FUNCTION if exists spsched003_proclistener(bigint, integer, character varying, bigint, bigint, integer);

-------------------------------------------------------------------------------
-- SCHEMA PRIMA INSTALLAZIONE
-------------------------------------------------------------------------------
CREATE TABLE sched001_tbconfig
(
  sched001_id serial NOT NULL, -- Codice progressivo per template di configurazione.
  sched001_flg_attivo boolean NOT NULL DEFAULT false, -- Indica quale template � attivo (1=attivo,0=non attivo).
  sched001_nomecfg character varying(250) NOT NULL DEFAULT 'Default name'::character varying, -- Nome del template di configurazione dello schedulatore.
  sched001_iniziofinestra time(4) without time zone NOT NULL DEFAULT '00:00:00'::time without time zone, -- Orario formato (hh:mm) che indica l'inizio della finestra di esecuzione processi.
  sched001_finefinestra time(4) without time zone NOT NULL DEFAULT '00:00:00'::time without time zone, -- Orario formato (hh:mm) che indica la fine della finestra di esecuzione processi.
  sched001_flg_vettorejolly boolean NOT NULL DEFAULT false, -- Indica se lo schedulatore deve considerare attivo il "Vettore Giorni Jolly": 0=non considerare il vettore, 1=considera il vettore.
  sched001_vettorejolly character varying(7) NOT NULL DEFAULT '0000000'::character varying, -- Indica la rappresentazione per il vettore jolly (7 numeri, luned' 0 domenica 7) ex vettore totalmente attivo: 1234567. ex vettore totalmente disattivo: 0000000. Vettore attivo il Luned�,Sabato,Domenica 1000067.
  sched001_slotsmassimi integer NOT NULL DEFAULT 0, -- Numero massimo di processi concorrenti eseguiti dallo schedulatore.
  sched001_slotimmmassimi integer NOT NULL DEFAULT 0, -- Numero massimo di processi immediati concorrenti eseguiti dallo schedulatore.
  sched001_email character varying(1000), -- Email per le notifiche: indirizzi emails separati da ";".
  sched001_maxpeso integer NOT NULL DEFAULT 10, -- Indica quanti livelli di peso l'utente desidera configurare.
  sched001_tbconfig_id_sched005 smallint NOT NULL DEFAULT 0, -- Il campo indica come trattare i jobs running al momento della chiusura della finestra temporale di esecuzione:...
  CONSTRAINT sched001_tbconfig_pkey PRIMARY KEY (sched001_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE sched001_tbconfig
  OWNER TO postgres;
COMMENT ON COLUMN sched001_tbconfig.sched001_id IS 'Codice progressivo per template di configurazione.';
COMMENT ON COLUMN sched001_tbconfig.sched001_flg_attivo IS 'Indica quale template � attivo (1=attivo,0=non attivo).';
COMMENT ON COLUMN sched001_tbconfig.sched001_nomecfg IS 'Nome del template di configurazione dello schedulatore.
';
COMMENT ON COLUMN sched001_tbconfig.sched001_iniziofinestra IS 'Orario formato (hh:mm) che indica l''inizio della finestra di esecuzione processi.';
COMMENT ON COLUMN sched001_tbconfig.sched001_finefinestra IS 'Orario formato (hh:mm) che indica la fine della finestra di esecuzione processi.';
COMMENT ON COLUMN sched001_tbconfig.sched001_flg_vettorejolly IS 'Indica se lo schedulatore deve considerare attivo il "Vettore Giorni Jolly": 0=non considerare il vettore, 1=considera il vettore.';
COMMENT ON COLUMN sched001_tbconfig.sched001_vettorejolly IS 'Indica la rappresentazione per il vettore jolly (7 numeri, luned'' 0 domenica 7) ex vettore totalmente attivo: 1234567. ex vettore totalmente disattivo: 0000000. Vettore attivo il Luned�,Sabato,Domenica 1000067.
';
COMMENT ON COLUMN sched001_tbconfig.sched001_slotsmassimi IS 'Numero massimo di processi concorrenti eseguiti dallo schedulatore.';
COMMENT ON COLUMN sched001_tbconfig.sched001_slotimmmassimi IS 'Numero massimo di processi immediati concorrenti eseguiti dallo schedulatore. ';
COMMENT ON COLUMN sched001_tbconfig.sched001_email IS 'Email per le notifiche: indirizzi emails separati da ";".';
COMMENT ON COLUMN sched001_tbconfig.sched001_maxpeso IS 'Indica quanti livelli di peso l''utente desidera configurare.';
COMMENT ON COLUMN sched001_tbconfig.sched001_tbconfig_id_sched005 IS 'Il campo indica come trattare i jobs running al momento della chiusura della finestra temporale di esecuzione:
0=al termine della finestra i Jobs vengono killati e rischedulati.
1=al termine della finestra i Jobs possono continuare l''esecuzione fino al loro completamento.
';
CREATE TABLE sched002_tbjobs
(
  sched002_id serial NOT NULL, -- Codice progressivo per i Jobs creati
  sched002_modeesecuzioni smallint NOT NULL DEFAULT 1, -- Costante che indica la modalit� di esecuzione del Job (subprocess figlio dello schedulatore ("1"), via scd (sync("2") /async"3")))
  sched002_prioritacpu smallint NOT NULL DEFAULT 0, -- Indica la priorit� lato CPU con la quale il Job deve essere eseguito.
  sched002_pesi integer NOT NULL DEFAULT 0, -- Indica il peso con il quale il Job deve essere inserito nella coda.
  sched002_timeout integer NOT NULL DEFAULT 900, -- Timeout in secondi trascorso il quale un Job deve essere killato calcolandolo dal momento della sua esecuzione....
  sched002_retry smallint NOT NULL DEFAULT 0, -- Indica il numero di "retry run" che il job deve eseguire in caso di fallimento.
  sched002_email character varying(300), -- Indirizzo aggiuntivo/i (separati da ";") ove inviare le notifiche di Errore/Completamento.
  sched002_descrizioni character varying(1000) DEFAULT 'Descrizione di default'::character varying, -- Descrizione testuale del Job
  sched002_creati timestamp without time zone NOT NULL DEFAULT now(), -- Indica la data di creazione del Job.
  sched002_eseguiti timestamp without time zone, -- Timestamp che indica quando il Job � stato Eseguito.
  sched002_stati integer NOT NULL DEFAULT (-1), -- Indica lo stato del Job, default value 0 = "In coda esecuzione"
  sched002_flg_output boolean NOT NULL DEFAULT true, -- Indica se il Job produrr� a meno un file di output (txt,pdf,ecc...)
  sched002_outputfilename character varying(200), -- Indica solo il filename (contenuto nel filestorage del portale) ove vengono salvati i risultati se � attivo il flag "Produce Risultato Su File" (campo sched002_output).
  sched002_runasazienda_id_bp003 bigint NOT NULL, -- Fk Aziende Polyedro - Indica l'azienda con la quale la fake session viene innestata nella REQUEST che eseguir� il JOB
  sched002_runasuser_id_bp001 bigint NOT NULL DEFAULT 0, -- Fk Utenti Polyedro - Indica l'utente con la quale la fake session viene innestata nella REQUEST che eseguir� il JOB
  sched002_flg_esecuzioniimmediate boolean NOT NULL DEFAULT false, -- Valore boolean che indica se il Job attinger� slot di tipo "normali" o "immediati". Valore costanti: 0= "Slot Normali" 1="Slot Immediati".
  sched002_terminati timestamp without time zone, -- Indica quando un determinato Job termina (o per completamento o per fallimento quindi errore)
  sched002_percentualicomp integer DEFAULT 0, -- Indica l'ultimo valore relativo alla percentuale di completamento di un determinato Job tramite le stored procedure di Process Listener
  sched002_modulo character varying(512), -- Indica il modulo che il Job dovr� importare (in notazione www.sched.test_sched) per eseguire poi la funzione "sched_elabora".
  sched002_ambiente character varying(255),
  sched002_procedura character varying(255),
  CONSTRAINT sched002_tbjobs_pkey PRIMARY KEY (sched002_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE sched002_tbjobs
  OWNER TO postgres;
COMMENT ON COLUMN sched002_tbjobs.sched002_id IS 'Codice progressivo per i Jobs creati';
COMMENT ON COLUMN sched002_tbjobs.sched002_modeesecuzioni IS 'Costante che indica la modalit� di esecuzione del Job (subprocess figlio dello schedulatore ("1"), via scd (sync("2") /async"3")))';
COMMENT ON COLUMN sched002_tbjobs.sched002_prioritacpu IS 'Indica la priorit� lato CPU con la quale il Job deve essere eseguito.';
COMMENT ON COLUMN sched002_tbjobs.sched002_pesi IS 'Indica il peso con il quale il Job deve essere inserito nella coda.';
COMMENT ON COLUMN sched002_tbjobs.sched002_timeout IS 'Timeout in secondi trascorso il quale un Job deve essere killato calcolandolo dal momento della sua esecuzione.
Se impostato a 0 il timeout � "infinito".
';
COMMENT ON COLUMN sched002_tbjobs.sched002_retry IS 'Indica il numero di "retry run" che il job deve eseguire in caso di fallimento.
';
COMMENT ON COLUMN sched002_tbjobs.sched002_email IS 'Indirizzo aggiuntivo/i (separati da ";") ove inviare le notifiche di Errore/Completamento.';
COMMENT ON COLUMN sched002_tbjobs.sched002_descrizioni IS 'Descrizione testuale del Job';
COMMENT ON COLUMN sched002_tbjobs.sched002_creati IS 'Indica la data di creazione del Job.';
COMMENT ON COLUMN sched002_tbjobs.sched002_eseguiti IS 'Timestamp che indica quando il Job � stato Eseguito.';
COMMENT ON COLUMN sched002_tbjobs.sched002_stati IS 'Indica lo stato del Job, default value 0 = "In coda esecuzione"';
COMMENT ON COLUMN sched002_tbjobs.sched002_flg_output IS 'Indica se il Job produrr� a meno un file di output (txt,pdf,ecc...)
';
COMMENT ON COLUMN sched002_tbjobs.sched002_outputfilename IS 'Indica solo il filename (contenuto nel filestorage del portale) ove vengono salvati i risultati se � attivo il flag "Produce Risultato Su File" (campo sched002_output).';
COMMENT ON COLUMN sched002_tbjobs.sched002_runasazienda_id_bp003 IS 'Fk Aziende Polyedro - Indica l''azienda con la quale la fake session viene innestata nella REQUEST che eseguir� il JOB
';
COMMENT ON COLUMN sched002_tbjobs.sched002_runasuser_id_bp001 IS 'Fk Utenti Polyedro - Indica l''utente con la quale la fake session viene innestata nella REQUEST che eseguir� il JOB
';
COMMENT ON COLUMN sched002_tbjobs.sched002_flg_esecuzioniimmediate IS 'Valore boolean che indica se il Job attinger� slot di tipo "normali" o "immediati". Valore costanti: 0= "Slot Normali" 1="Slot Immediati".';
COMMENT ON COLUMN sched002_tbjobs.sched002_terminati IS 'Indica quando un determinato Job termina (o per completamento o per fallimento quindi errore)
';
COMMENT ON COLUMN sched002_tbjobs.sched002_percentualicomp IS 'Indica l''ultimo valore relativo alla percentuale di completamento di un determinato Job tramite le stored procedure di Process Listener
';
COMMENT ON COLUMN sched002_tbjobs.sched002_modulo IS 'Indica il modulo che il Job dovr� importare (in notazione www.sched.test_sched) per eseguire poi la funzione "sched_elabora".';
CREATE TABLE sched003_tbjobsruntime
(
  sched003_id serial NOT NULL, -- Codice progressivo che indica l'id assegnato all'esecuzione del processo.
  sched003_jobid_id_sched002 integer NOT NULL, -- FK sched002_id
  sched003_stati smallint NOT NULL DEFAULT 0, -- Stato del job
  sched003_retryrimanenti integer NOT NULL, -- Numero di retry a runtime rimanenti per il JOB (0 = infinito)
  sched003_flg_esecuzioniimmediate boolean NOT NULL, -- Boolean che indica se il Job sta utilizzando 0="slot normali" o 1="slot immediati".
  sched003_ultimicontatti timestamp without time zone DEFAULT now(), -- Timestamp che indica quando un utente esegue lo stop da interfaccia al fine di killare il thread/processo dopo x tempo
  sched003_ultimimessaggi character varying(10000), -- Messaggio testuale proveniente dal "Process Listener" che indica quale � stato il motivo dell'aggiornamento.
  sched003_pidprocessi integer, -- Pid del processo lanciato dallo schedulatore.
  sched003_tidthreads integer, -- Tid del thread lanciato dallo schedulatore.
  sched003_percentualicompletamento integer NOT NULL DEFAULT 0, -- Indica la percentuale di completamento a RUNTIME di un determinato Job.
  sched003_tipomessaggi integer, -- Tipologia dell'ultimo messaggio arrivato
  sched003_user_stop boolean NOT NULL DEFAULT false, -- Flag che indica se l'utente ha premuto il tasto STOP dalla user dashboard: ci� indica se l'utente ha richiesto lo stop del job da interfaccia.
  sched003_user_stop_time timestamp without time zone,
  sched003_completed boolean DEFAULT false, -- Indica il completamento di un determinato Job utilizzando il database come unico metodo di colloquio.
  sched003_blockedforerror boolean DEFAULT false,
  sched003_abortfordelete boolean DEFAULT false, -- Indica se il Job deve essere abortito (eliminato da db,dizionario,database)
  sched003_abortforkill boolean DEFAULT false, -- Indica se il Job deve essere abortito per una kill da interfaccia utente
  sched003_confirmedstop boolean DEFAULT false, -- Indica se è stata ricevuta conferma di STOP da un Job non python (lynfa)
  CONSTRAINT sched003_tbjobsruntime_pkey PRIMARY KEY (sched003_id),
  CONSTRAINT sched003_c01fk_sched002 FOREIGN KEY (sched003_jobid_id_sched002)
      REFERENCES sched002_tbjobs (sched002_id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE sched003_tbjobsruntime
  OWNER TO postgres;
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_id IS 'Codice progressivo che indica l''id assegnato all''esecuzione del processo.';
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_jobid_id_sched002 IS 'FK sched002_id
';
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_stati IS 'Stato del job ';
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_retryrimanenti IS 'Numero di retry a runtime rimanenti per il JOB (0 = infinito)
';
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_flg_esecuzioniimmediate IS 'Boolean che indica se il Job sta utilizzando 0="slot normali" o 1="slot immediati".';
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_ultimicontatti IS 'Timestamp che indica quando un utente esegue lo stop da interfaccia al fine di killare il thread/processo dopo x tempo';
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_ultimimessaggi IS 'Messaggio testuale proveniente dal "Process Listener" che indica quale � stato il motivo dell''aggiornamento.';
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_pidprocessi IS 'Pid del processo lanciato dallo schedulatore.';
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_tidthreads IS 'Tid del thread lanciato dallo schedulatore.';
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_percentualicompletamento IS 'Indica la percentuale di completamento a RUNTIME di un determinato Job.
';
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_tipomessaggi IS 'Tipologia dell''ultimo messaggio arrivato ';
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_user_stop IS 'Flag che indica se l''utente ha premuto il tasto STOP dalla user dashboard: ci� indica se l''utente ha richiesto lo stop del job da interfaccia.';
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_completed IS 'Indica il completamento di un determinato Job utilizzando il database come unico metodo di colloquio.';
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_abortfordelete IS 'Indica se il Job deve essere abortito (eliminato da db,dizionario,database)';
CREATE TABLE sched004_tbjobstorici
(
  sched004_id serial NOT NULL, -- Codice progressivo che indica l'id assegnato all'esecuzione del processo.
  sched004_jobid_id_sched002 integer NOT NULL, -- FK -> sched002_jobs.id
  sched004_stati integer NOT NULL, -- Stato del job, indica uno dei "Starting States","Stopping States" o "Sub States"
  sched004_tempiaggiornamenti timestamp without time zone NOT NULL, -- Indica l'orario di arrivo di uno dei messaggi provenienti dal "Process Listener" o dalla "user activity"
  sched004_tipimessaggi smallint NOT NULL, -- Tipologia del messaggio proveniente dal "Process Listener":...
  sched004_messaggi character varying(4000), -- Indica il testo del messaggio/errore proveniente dal "Process Listener" o dalla "User Activity Messages".
  CONSTRAINT sched004_tbjobstorici_pkey PRIMARY KEY (sched004_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE sched004_tbjobstorici
  OWNER TO postgres;
COMMENT ON COLUMN sched004_tbjobstorici.sched004_id IS 'Codice progressivo che indica l''id assegnato all''esecuzione del processo.';
COMMENT ON COLUMN sched004_tbjobstorici.sched004_jobid_id_sched002 IS 'FK -> sched002_jobs.id';
COMMENT ON COLUMN sched004_tbjobstorici.sched004_stati IS 'Stato del job, indica uno dei "Starting States","Stopping States" o "Sub States"';
COMMENT ON COLUMN sched004_tbjobstorici.sched004_tempiaggiornamenti IS 'Indica l''orario di arrivo di uno dei messaggi provenienti dal "Process Listener" o dalla "user activity"
';
COMMENT ON COLUMN sched004_tbjobstorici.sched004_tipimessaggi IS 'Tipologia del messaggio proveniente dal "Process Listener":
1 - Stared
2 - Stopped for error + Message
3 - Status Percentage
4 - Log Messages
5 - Completed
6 - Error Message
Tipologia del messaggio proveniente dall''attivit� utente:
7 - User Activity Messages
';
COMMENT ON COLUMN sched004_tbjobstorici.sched004_messaggi IS 'Indica il testo del messaggio/errore proveniente dal "Process Listener" o dalla "User Activity Messages".';
CREATE TABLE sched005_tbclosemodes
(
  sched005_id serial NOT NULL, -- PK
  sched003_closemode character varying(50) NOT NULL, -- Valore testuale per la close mode scelta a livello di configurazione (ex: "Kill & Reschedule")
  CONSTRAINT sched005_c01pk PRIMARY KEY (sched005_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE sched005_tbclosemodes
  OWNER TO postgres;
COMMENT ON COLUMN sched005_tbclosemodes.sched005_id IS 'PK
';
COMMENT ON COLUMN sched005_tbclosemodes.sched003_closemode IS 'Valore testuale per la close mode scelta a livello di configurazione (ex: "Kill & Reschedule")
';
CREATE TABLE sched006_tbgiorni
(
  sched006_id serial NOT NULL, -- PK
  sched006_giorni character varying(30) DEFAULT NULL::character varying, -- Valore testuale per i giorni della settimana (serve per la rederizzazione del vettore jolly in formato testuale)
  CONSTRAINT sched006_c01pk PRIMARY KEY (sched006_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE sched006_tbgiorni
  OWNER TO postgres;
COMMENT ON COLUMN sched006_tbgiorni.sched006_id IS 'PK
';
COMMENT ON COLUMN sched006_tbgiorni.sched006_giorni IS 'Valore testuale per i giorni della settimana (serve per la rederizzazione del vettore jolly in formato testuale)
';
CREATE TABLE sched007_stati
(
  sched007_id integer NOT NULL, -- PK
  sched007_idstato integer NOT NULL, -- Costante che all'interno del software definisce gli stati possibili per ogni JOB
  sched007_stato character varying NOT NULL, -- Stato del Job testuale
  CONSTRAINT sched007_c01pk PRIMARY KEY (sched007_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE sched007_stati
  OWNER TO postgres;
COMMENT ON COLUMN sched007_stati.sched007_id IS 'PK
';
COMMENT ON COLUMN sched007_stati.sched007_idstato IS 'Costante che all''interno del software definisce gli stati possibili per ogni JOB
';
COMMENT ON COLUMN sched007_stati.sched007_stato IS 'Stato del Job testuale
';
CREATE TABLE sched008_tipomessaggi
(
  sched008_id serial NOT NULL,
  sched008_idtipomessaggio integer,
  sched008_tipomessagio character varying
)
WITH (
  OIDS=FALSE
);
ALTER TABLE sched008_tipomessaggi
  OWNER TO postgres;

INSERT INTO sched001_tbconfig VALUES('1','1','Profilo di default','00:00:00','00:00:00','1',0000000,10,10,'',10,1);

INSERT INTO sched005_tbclosemodes VALUES (1, 'Interrompere e rimettere in coda');
INSERT INTO sched005_tbclosemodes VALUES (2, 'Continuare');

INSERT INTO sched006_tbgiorni VALUES (2, 'Mar');
INSERT INTO sched006_tbgiorni VALUES (1, 'Lun');
INSERT INTO sched006_tbgiorni VALUES (3, 'Mer');
INSERT INTO sched006_tbgiorni VALUES (4, 'Gio');
INSERT INTO sched006_tbgiorni VALUES (5, 'Ven');
INSERT INTO sched006_tbgiorni VALUES (6, 'Sab');
INSERT INTO sched006_tbgiorni VALUES (7, 'Dom');

INSERT INTO sched007_stati VALUES (1, 0, 'In coda');
INSERT INTO sched007_stati VALUES (2, 1, 'In esecuzione');
INSERT INTO sched007_stati VALUES (3, 2, 'Ritentando...');
INSERT INTO sched007_stati VALUES (4, 3, 'In Pausa');
INSERT INTO sched007_stati VALUES (5, 4, 'Completato');
INSERT INTO sched007_stati VALUES (6, 5, 'Bloccato da un utente');
INSERT INTO sched007_stati VALUES (7, 6, 'Fallito per timeout');
INSERT INTO sched007_stati VALUES (8, 7, 'Bloccando...');
INSERT INTO sched007_stati VALUES (9, 8, 'Errore durante blocco');
INSERT INTO sched007_stati VALUES (10, 9, 'Partendo');
INSERT INTO sched007_stati VALUES (11, 10, 'Bloccato da un errore');
INSERT INTO sched007_stati VALUES (12, -1, 'New');
INSERT INTO sched007_stati VALUES (13, 11, 'Killed');
INSERT INTO sched007_stati VALUES (14, 12, 'Killing...');

INSERT INTO sched008_tipomessaggi VALUES (1, 0, 'In avvio...');
INSERT INTO sched008_tipomessaggi VALUES (2, 1, 'Avvio');
INSERT INTO sched008_tipomessaggi VALUES (3, 2, 'Errore bloccante');
INSERT INTO sched008_tipomessaggi VALUES (4, 3, 'Progressione di stato');
INSERT INTO sched008_tipomessaggi VALUES (5, 4, 'Scrittura log');
INSERT INTO sched008_tipomessaggi VALUES (6, 5, 'Chiusura');
INSERT INTO sched008_tipomessaggi VALUES (7, 6, 'Messaggio di errore');
INSERT INTO sched008_tipomessaggi VALUES (8, 7, 'Messaggio personalizzato');
-------------------------------------------------------------------------------------------------
-- Patch DB SCHEDULER ver. 20150100 to 20150101
-------------------------------------------------------------------------------------------------

COMMENT ON COLUMN sched001_tbconfig.sched001_flg_attivo IS 'Indica lo stato del del template (1=attivo,0=non attivo).'
;
COMMENT ON COLUMN sched001_tbconfig.sched001_nomecfg IS 'Nome del template di configurazione dello schedulatore.
'
;
COMMENT ON COLUMN sched001_tbconfig.sched001_iniziofinestra IS 'Orario formato (hh:mm) che indica inizio finestra di esecuzione processi.'
;
COMMENT ON COLUMN sched001_tbconfig.sched001_finefinestra IS 'Orario formato (hh:mm) che indica la fine della finestra di esecuzione processi.'
;
COMMENT ON COLUMN sched001_tbconfig.sched001_flg_vettorejolly IS 'Indica se lo schedulatore deve considerare attivo il Vettore Giorni Jolly (0=non considerare il vettore, 1=considera il vettore).'
;
COMMENT ON COLUMN sched001_tbconfig.sched001_vettorejolly IS 'Indica la rappresentazione per il vettore jolly (7 numeri, lunedi 0 domenica 7) es vettore totalmente attivo: 1234567. es vettore totalmente disattivo: 0000000. Vettore attivo il Lunedi,Sabato,Domenica 1000067.
'
;
COMMENT ON COLUMN sched001_tbconfig.sched001_slotsmassimi IS 'Numero massimo di processi concorrenti eseguiti dallo schedulatore.'
;
COMMENT ON COLUMN sched001_tbconfig.sched001_slotimmmassimi IS 'Numero massimo di processi immediati concorrenti eseguiti dallo schedulatore. '
;
COMMENT ON COLUMN sched001_tbconfig.sched001_email IS 'Email per le notifiche: indirizzi emails separati da ; .'
;
COMMENT ON COLUMN sched001_tbconfig.sched001_maxpeso IS 'Indica quanti livelli di peso l''utente desidera configurare.'
;
COMMENT ON COLUMN sched001_tbconfig.sched001_tbconfig_id_sched005 IS 'Il campo indica come trattare i jobs running al momento della chiusura della finestra temporale di esecuzione:
0=al termine della finestra i Jobs vengono killati e rischedulati.
1=al termine della finestra i Jobs possono continuare l''esecuzione fino al loro completamento.'
;

COMMENT ON COLUMN sched002_tbjobs.sched002_modeesecuzioni IS 'Costante che indica la modalita di esecuzione del Job (subprocess figlio dello schedulatore (1), via scd (sync(2) - async3)))'
;
COMMENT ON COLUMN sched002_tbjobs.sched002_prioritacpu IS 'Indica la priorita lato CPU con la quale il Job deve essere eseguito.'
;
COMMENT ON COLUMN sched002_tbjobs.sched002_pesi IS 'Indica il peso con il quale il Job deve essere inserito nella coda.'
;
COMMENT ON COLUMN sched002_tbjobs.sched002_timeout IS 'Timeout in secondi trascorso il quale un Job deve essere killato calcolandolo dal momento della sua esecuzione.
Se impostato a 0 il timeout infinito.
'
;
COMMENT ON COLUMN sched002_tbjobs.sched002_retry IS 'Indica il numero di retry run che il job deve eseguire in caso di fallimento.
'
;
COMMENT ON COLUMN sched002_tbjobs.sched002_email IS 'Indirizzo aggiuntivo-i (separati da ;) ove inviare le notifiche di Errore-Completamento.'
;
COMMENT ON COLUMN sched002_tbjobs.sched002_descrizioni IS 'Descrizione testuale del Job'
;
COMMENT ON COLUMN sched002_tbjobs.sched002_creati IS 'Indica la data di creazione del Job.'
;
COMMENT ON COLUMN sched002_tbjobs.sched002_eseguiti IS 'Timestamp che indica quando il Job e stato eseguito.'
;
COMMENT ON COLUMN sched002_tbjobs.sched002_stati IS 'Indica lo stato del Job, default value 0 = In coda esecuzione'
;
COMMENT ON COLUMN sched002_tbjobs.sched002_flg_output IS 'Indica se il Job produrra o meno un file di output (txt,pdf,ecc...)
'
;
COMMENT ON COLUMN sched002_tbjobs.sched002_outputfilename IS 'Indica solo il filename (contenuto nel filestorage del portale) ove vengono salvati i risultati se attivo il flag  - Produce Risultato Su File - (campo sched002_output).'
;
COMMENT ON COLUMN sched002_tbjobs.sched002_flg_esecuzioniimmediate IS 'Valore boolean che indica se il Job attingera slot di tipo normali o immediati. Valore costanti: 0 = Slot Normali, 1=Slot Immediati.'
;
COMMENT ON COLUMN sched002_tbjobs.sched002_terminati IS 'Indica quando un determinato Job termina (o per completamento o per fallimento quindi errore)
'
;
COMMENT ON COLUMN sched002_tbjobs.sched002_percentualicomp IS 'Indica l''ultimo valore relativo alla percentuale di completamento di un determinato Job tramite le stored procedure di Process Listener
'
;
COMMENT ON COLUMN sched002_tbjobs.sched002_modulo IS 'Indica il modulo che il Job dovra importare (in notazione www.sched.test_sched) per eseguire poi la funzione "sched_elabora".'
;
COMMENT ON COLUMN sched002_tbjobs.sched002_ambiente IS 'ambiente di esecuzione'
;
COMMENT ON COLUMN sched002_tbjobs.sched002_procedura IS 'procedura di esecuzione'
;
COMMENT ON COLUMN sched002_tbjobs.sched002_runasazienda_id_bp003 IS 'Fk Aziende Polyedro - Indica azienda con la quale la fake session viene innestata nella REQUEST che eseguira il JOB'
;
COMMENT ON COLUMN sched002_tbjobs.sched002_runasuser_id_bp001 IS 'Pk Utenti Polyedro - Indica utente con la quale la fake session viene innestata nella REQUEST che eseguira il JOB'
;

COMMENT ON COLUMN sched003_tbjobsruntime.sched003_jobid_id_sched002 IS 'FK sched002_id
'
;
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_stati IS 'Stato del job '
;
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_retryrimanenti IS 'Numero di retry a runtime rimanenti per il JOB (0 = infinito)
'
;
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_flg_esecuzioniimmediate IS 'Boolean che indica se il Job sta utilizzando 0=slot normali o 1=slot immediati.'
;
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_ultimicontatti IS 'Timestamp che indica quando un utente esegue lo stop da interfaccia al fine di killare il thread/processo dopo x tempo'
;
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_ultimimessaggi IS 'Messaggio testuale proveniente dal Process Listener che indica quale motivo aggiornamento.'
;
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_pidprocessi IS 'Pid del processo lanciato dallo schedulatore.'
;
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_tidthreads IS 'Tid del thread lanciato dallo schedulatore.'
;
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_percentualicompletamento IS 'Indica la percentuale di completamento a RUNTIME di un determinato Job.
'
;
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_tipomessaggi IS 'Tipologia ultimo messaggio arrivato '
;
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_user_stop IS 'Flag che indica se utente ha premuto il tasto STOP dalla user dashboard: indica se utente ha richiesto lo stop del job da interfaccia.'
;
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_completed IS 'Indica il completamento di un determinato Job utilizzando il database come unico metodo di colloquio.'
;
COMMENT ON COLUMN sched003_tbjobsruntime.sched003_abortfordelete IS 'Indica se il Job deve essere abortito (eliminato da db,dizionario,database)'
;

COMMENT ON COLUMN sched004_tbjobstorici.sched004_stati IS 'Stato del job, indica uno dei Starting States, Stopping States o Sub States'
;
COMMENT ON COLUMN sched004_tbjobstorici.sched004_tempiaggiornamenti IS 'Indica orario di arrivo di uno dei messaggi provenienti dal Process Listener o dalla user activity
'
;
COMMENT ON COLUMN sched004_tbjobstorici.sched004_tipimessaggi IS 'Tipologia del messaggio proveniente dal Process Listener:
1 - Stared
2 - Stopped for error + Message
3 - Status Percentage
4 - Log Messages
5 - Completed
6 - Error Message
Tipologia del messaggio proveniente dall''attivita utente:
7 - User Activity Messages
'
;
COMMENT ON COLUMN sched004_tbjobstorici.sched004_messaggi IS 'Indica il testo del messaggio-errore proveniente dal Process Listener o dalla User Activity Messages.'
;

COMMENT ON COLUMN sched005_tbclosemodes.sched005_id IS '
'
;
COMMENT ON COLUMN sched005_tbclosemodes.sched003_closemode IS 'Valore testuale per la close mode scelta a livello di configurazione (es: Kill Reschedule)
'
;

COMMENT ON COLUMN sched006_tbgiorni.sched006_giorni IS 'Valore testuale per i giorni della settimana (serve per la rederizzazione del vettore jolly in formato testuale)
'
;

COMMENT ON COLUMN sched007_stati.sched007_idstato IS 'Costante che all''interno del software definisce gli stati possibili per ogni JOB
'
;
COMMENT ON COLUMN sched007_stati.sched007_stato IS 'Stato del Job testuale
'
;

-- Drop 1 relation --
ALTER TABLE sched003_tbjobsruntime DROP CONSTRAINT sched003_c01fk_sched002;

-- Create relationships section ------------------------------------------------- 

-- AB 19/03/2015: cancellazione preventiva dati inconsistenti trovati in fase di test
DELETE FROM sched003_tbjobsruntime WHERE NOT EXISTS (SELECT 1 FROM sched002_tbjobs WHERE sched002_id = sched003_jobid_id_sched002);

ALTER TABLE sched003_tbjobsruntime ADD CONSTRAINT sched003_c01fk_sched002 FOREIGN KEY (sched003_jobid_id_sched002) REFERENCES sched002_tbjobs (sched002_id) ON DELETE CASCADE ON UPDATE NO ACTION
;

-- AB 19/03/2015: cancellazione preventiva dati inconsistenti trovati in fase di test
DELETE FROM sched004_tbjobstorici WHERE NOT EXISTS (SELECT 1 FROM sched002_tbjobs WHERE sched002_id = sched004_jobid_id_sched002);

ALTER TABLE sched004_tbjobstorici ADD CONSTRAINT sched004_c01fk FOREIGN KEY (sched004_jobid_id_sched002) REFERENCES sched002_tbjobs (sched002_id) ON DELETE CASCADE ON UPDATE NO ACTION
;

ALTER TABLE sched002_tbjobs ADD CONSTRAINT sched002_c01fk FOREIGN KEY (sched002_runasazienda_id_bp003) REFERENCES bp003_tbaziende (bp003_id) ON DELETE CASCADE ON UPDATE NO ACTION
;

ALTER TABLE sched002_tbjobs ADD CONSTRAINT sched002_c02fk FOREIGN KEY (sched002_runasuser_id_bp001) REFERENCES bp001_tbutenti (bp001_id) ON DELETE CASCADE ON UPDATE NO ACTION
;

ALTER TABLE sched001_tbconfig ADD CONSTRAINT sched001_c01fk FOREIGN KEY (sched001_tbconfig_id_sched005) REFERENCES sched005_tbclosemodes (sched005_id) ON DELETE CASCADE ON UPDATE NO ACTION
;

-- Drop views section --------------------------------------------------- 
DROP VIEW IF EXISTS vsched002_tokilljobafterstop CASCADE
;
DROP VIEW IF EXISTS vsched002_timeoutedjobs CASCADE
;
DROP VIEW IF EXISTS vsched002_notifiche CASCADE
;
DROP VIEW IF EXISTS vsched002_jobqueuenormal CASCADE
;
DROP VIEW IF EXISTS vsched002_jobqueimmediate CASCADE
;
DROP VIEW IF EXISTS vsched002_jobinfo CASCADE
;
DROP VIEW IF EXISTS vsched002_dashboard CASCADE
;
DROP VIEW IF EXISTS vsched001_step3vettore CASCADE
;
DROP VIEW IF EXISTS vsched001_step2vettore CASCADE
;
DROP VIEW IF EXISTS vsched001_step1vettore CASCADE
;
DROP VIEW IF EXISTS vsched001_configurazione CASCADE
;

-- Create views section -------------------------------------------------

CREATE OR REPLACE VIEW vsched001_step1vettore
 AS
SELECT sched001_tbconfig.sched001_id,
    sched001_tbconfig.sched001_vettorejolly,
    regexp_split_to_table((sched001_tbconfig.sched001_vettorejolly)::text, ''::text) AS giorniattivi
   FROM sched001_tbconfig
  ORDER BY sched001_tbconfig.sched001_id, regexp_split_to_table((sched001_tbconfig.sched001_vettorejolly)::text, ''::text)
;

CREATE OR REPLACE VIEW vsched001_step2vettore
 AS
SELECT a.sched001_id,
    a.giorniattivi,
    b.sched006_giorni,
    b.sched006_id
   FROM (vsched001_step1vettore a
     JOIN sched006_tbgiorni b ON (((a.giorniattivi)::smallint = b.sched006_id)))
  ORDER BY a.sched001_id, a.giorniattivi
;

CREATE OR REPLACE VIEW vsched001_step3vettore
 AS
SELECT string_agg((vsched001_step2vettore.sched006_giorni)::text, '.'::text ORDER BY vsched001_step2vettore.sched006_id) AS vettore_testuale,
    vsched001_step2vettore.sched001_id
   FROM (sched001_tbconfig
     JOIN vsched001_step2vettore ON ((vsched001_step2vettore.sched001_id = sched001_tbconfig.sched001_id)))
  GROUP BY vsched001_step2vettore.sched001_id
;

CREATE OR REPLACE VIEW vsched001_configurazione
 AS
SELECT sched001_tbconfig.sched001_id,
    sched001_tbconfig.sched001_nomecfg,
    sched001_tbconfig.sched001_flg_attivo,
    sched001_tbconfig.sched001_iniziofinestra,
    sched001_tbconfig.sched001_finefinestra,
    sched001_tbconfig.sched001_flg_vettorejolly,
    vsched001_step3vettore.vettore_testuale,
    sched005_tbclosemodes.sched003_closemode,
    sched001_tbconfig.sched001_slotsmassimi,
    sched001_tbconfig.sched001_slotimmmassimi,
    sched001_tbconfig.sched001_email,
    sched001_tbconfig.sched001_maxpeso
   FROM ((sched001_tbconfig
     LEFT JOIN vsched001_step3vettore ON ((sched001_tbconfig.sched001_id = vsched001_step3vettore.sched001_id)))
     JOIN sched005_tbclosemodes ON ((sched001_tbconfig.sched001_tbconfig_id_sched005 = sched005_tbclosemodes.sched005_id)))
;

CREATE OR REPLACE VIEW vsched001_step2vettore
 AS
SELECT a.sched001_id,
    a.giorniattivi,
    b.sched006_giorni,
    b.sched006_id
   FROM (vsched001_step1vettore a
     JOIN sched006_tbgiorni b ON (((a.giorniattivi)::smallint = b.sched006_id)))
  ORDER BY a.sched001_id, a.giorniattivi
;

CREATE OR REPLACE VIEW vsched001_step3vettore
 AS
SELECT string_agg((vsched001_step2vettore.sched006_giorni)::text, '.'::text ORDER BY vsched001_step2vettore.sched006_id) AS vettore_testuale,
    vsched001_step2vettore.sched001_id
   FROM (sched001_tbconfig
     JOIN vsched001_step2vettore ON ((vsched001_step2vettore.sched001_id = sched001_tbconfig.sched001_id)))
  GROUP BY vsched001_step2vettore.sched001_id
;

CREATE OR REPLACE VIEW vsched002_dashboard
 AS
SELECT sched002_tbjobs.sched002_id,
    sched002_tbjobs.sched002_descrizioni,
    sched002_tbjobs.sched002_procedura,
    sched002_tbjobs.sched002_ambiente,
    sched002_tbjobs.sched002_creati,
    sched002_tbjobs.sched002_eseguiti,
    sched002_tbjobs.sched002_percentualicomp,
    sched002_tbjobs.sched002_terminati,
    sched002_tbjobs.sched002_stati,
    sched007_stati.sched007_stato,
    ( SELECT
                CASE sched002_tbjobs.sched002_flg_esecuzioniimmediate
                    WHEN true THEN 'Appena possibile'::text
                    WHEN false THEN ( SELECT ((to_char((sched001_tbconfig.sched001_iniziofinestra)::interval, 'HH24:MI'::text) || ' - '::text) || to_char((sched001_tbconfig.sched001_finefinestra)::interval, 'HH24:MI'::text)) AS coda
                       FROM sched001_tbconfig
                      WHERE (sched001_tbconfig.sched001_flg_attivo = true))
                    ELSE NULL::text
                END AS "case") AS tipo_coda,
    row_number() OVER (ORDER BY sched002_tbjobs.sched002_pesi DESC) AS postoincodaimm,
    sched007_stati.sched007_idstato,
    ( SELECT
                CASE sched002_tbjobs.sched002_stati
                    WHEN 0 THEN false
                    WHEN 5 THEN true
                    WHEN 6 THEN true
                    WHEN 10 THEN true
                    WHEN 11 THEN true
                    ELSE false
                END AS "case") AS can_play,
    ( SELECT
                CASE sched002_tbjobs.sched002_stati
                    WHEN 0 THEN true
                    WHEN 1 THEN true
                    ELSE false
                END AS "case") AS can_stop,
    ( SELECT
                CASE sched002_tbjobs.sched002_flg_output
                    WHEN true THEN
                    CASE sched002_tbjobs.sched002_stati
                        WHEN 4 THEN true
                        ELSE false
                    END
                    WHEN false THEN false
                    ELSE NULL::boolean
                END AS "case") AS can_download,
    sched002_tbjobs.sched002_email,
    sched002_tbjobs.sched002_pesi,
    sched002_tbjobs.sched002_retry,
    sched002_tbjobs.sched002_timeout,
    sched002_tbjobs.sched002_flg_output,
    sched002_tbjobs.sched002_flg_esecuzioniimmediate AS sched002_flg_tipo_coda,
    bp001_tbutenti.bp001_nomeutente AS utente,
    bp004_tbanagrafiche.bp004_cognomeragsoc AS azienda,
    sched002_tbjobs.sched002_runasuser_id_bp001 AS id_utente,
    sched002_tbjobs.sched002_runasazienda_id_bp003 AS id_azienda,
    ( SELECT
                CASE sched002_tbjobs.sched002_terminati
                    WHEN NULL::timestamp without time zone THEN NULL::text
                    ELSE to_char(( SELECT (sched002_tbjobs.sched002_terminati - sched002_tbjobs.sched002_eseguiti)), 'HH24:MI:SS'::text)
                END AS to_char) AS durata,
    ''::text AS img_kill,
    ''::text AS img_log,
    ''::text AS img_elimina
   FROM ((((sched002_tbjobs
     JOIN sched007_stati ON ((sched002_tbjobs.sched002_stati = sched007_stati.sched007_idstato)))
     JOIN bp001_tbutenti ON ((sched002_tbjobs.sched002_runasuser_id_bp001 = bp001_tbutenti.bp001_id)))
     JOIN bp003_tbaziende ON ((sched002_tbjobs.sched002_runasazienda_id_bp003 = bp003_tbaziende.bp003_id)))
     JOIN bp004_tbanagrafiche ON ((bp003_tbaziende.bp003_anagrafica_id_bp004 = bp004_tbanagrafiche.bp004_id)))
  WHERE (sched002_tbjobs.sched002_flg_esecuzioniimmediate = true)
UNION
 SELECT sched002_tbjobs.sched002_id,
    sched002_tbjobs.sched002_descrizioni,
    sched002_tbjobs.sched002_procedura,
    sched002_tbjobs.sched002_ambiente,
    sched002_tbjobs.sched002_creati,
    sched002_tbjobs.sched002_eseguiti,
    sched002_tbjobs.sched002_percentualicomp,
    sched002_tbjobs.sched002_terminati,
    sched002_tbjobs.sched002_stati,
    sched007_stati.sched007_stato,
    ( SELECT
                CASE sched002_tbjobs.sched002_flg_esecuzioniimmediate
                    WHEN true THEN 'Appena possibile'::text
                    WHEN false THEN ( SELECT ((to_char((sched001_tbconfig.sched001_iniziofinestra)::interval, 'HH24:MI'::text) || ' - '::text) || to_char((sched001_tbconfig.sched001_finefinestra)::interval, 'HH24:MI'::text)) AS coda
                       FROM sched001_tbconfig
                      WHERE (sched001_tbconfig.sched001_flg_attivo = true))
                    ELSE NULL::text
                END AS "case") AS tipo_coda,
    row_number() OVER (ORDER BY sched002_tbjobs.sched002_pesi DESC) AS postoincodaimm,
    sched007_stati.sched007_idstato,
    ( SELECT
                CASE sched002_tbjobs.sched002_stati
                    WHEN 0 THEN false
                    WHEN 5 THEN true
                    WHEN 6 THEN true
                    WHEN 10 THEN true
                    WHEN 11 THEN true
                    ELSE false
                END AS "case") AS can_play,
    ( SELECT
                CASE sched002_tbjobs.sched002_stati
                    WHEN 0 THEN true
                    WHEN 1 THEN true
                    ELSE false
                END AS "case") AS can_stop,
    ( SELECT
                CASE sched002_tbjobs.sched002_flg_output
                    WHEN true THEN
                    CASE sched002_tbjobs.sched002_stati
                        WHEN 4 THEN true
                        ELSE false
                    END
                    WHEN false THEN false
                    ELSE NULL::boolean
                END AS "case") AS can_download,
    sched002_tbjobs.sched002_email,
    sched002_tbjobs.sched002_pesi,
    sched002_tbjobs.sched002_retry,
    sched002_tbjobs.sched002_timeout,
    sched002_tbjobs.sched002_flg_output,
    sched002_tbjobs.sched002_flg_esecuzioniimmediate AS sched002_flg_tipo_coda,
    bp001_tbutenti.bp001_nomeutente AS utente,
    bp004_tbanagrafiche.bp004_cognomeragsoc AS azienda,
    sched002_tbjobs.sched002_runasuser_id_bp001 AS id_utente,
    sched002_tbjobs.sched002_runasazienda_id_bp003 AS id_azienda,
    ( SELECT
                CASE sched002_tbjobs.sched002_terminati
                    WHEN NULL::timestamp without time zone THEN NULL::text
                    ELSE to_char(( SELECT (sched002_tbjobs.sched002_terminati - sched002_tbjobs.sched002_eseguiti)), 'HH24:MI:SS'::text)
                END AS to_char) AS durata,
    ''::text AS img_kill,
    ''::text AS img_log,
    ''::text AS img_elimina
   FROM ((((sched002_tbjobs
     JOIN sched007_stati ON ((sched002_tbjobs.sched002_stati = sched007_stati.sched007_idstato)))
     JOIN bp001_tbutenti ON ((sched002_tbjobs.sched002_runasuser_id_bp001 = bp001_tbutenti.bp001_id)))
     JOIN bp003_tbaziende ON ((sched002_tbjobs.sched002_runasazienda_id_bp003 = bp003_tbaziende.bp003_id)))
     JOIN bp004_tbanagrafiche ON ((bp003_tbaziende.bp003_anagrafica_id_bp004 = bp004_tbanagrafiche.bp004_id)))
  WHERE (sched002_tbjobs.sched002_flg_esecuzioniimmediate = false)
;

CREATE OR REPLACE VIEW vsched002_jobinfo
 AS
SELECT sched002_tbjobs.sched002_id,
    sched002_tbjobs.sched002_outputfilename,
    sched002_tbjobs.sched002_email,
    sched002_tbjobs.sched002_runasazienda_id_bp003,
    sched002_tbjobs.sched002_runasuser_id_bp001
   FROM sched002_tbjobs
;

CREATE OR REPLACE VIEW vsched002_jobqueimmediate
 AS
SELECT sched002_tbjobs.sched002_id,
    sched002_tbjobs.sched002_modeesecuzioni,
    sched002_tbjobs.sched002_prioritacpu,
    sched002_tbjobs.sched002_pesi,
    sched002_tbjobs.sched002_timeout,
    sched002_tbjobs.sched002_retry,
    sched002_tbjobs.sched002_stati,
    sched002_tbjobs.sched002_runasazienda_id_bp003,
    sched002_tbjobs.sched002_runasuser_id_bp001
   FROM sched002_tbjobs
  WHERE ((sched002_tbjobs.sched002_flg_esecuzioniimmediate = true) AND (sched002_tbjobs.sched002_stati = 0))
  ORDER BY sched002_tbjobs.sched002_pesi DESC, sched002_tbjobs.sched002_id
;

CREATE OR REPLACE VIEW vsched002_jobqueuenormal
 AS
SELECT sched002_tbjobs.sched002_id,
    sched002_tbjobs.sched002_modeesecuzioni,
    sched002_tbjobs.sched002_prioritacpu,
    sched002_tbjobs.sched002_pesi,
    sched002_tbjobs.sched002_timeout,
    sched002_tbjobs.sched002_retry,
    sched002_tbjobs.sched002_stati,
    sched002_tbjobs.sched002_runasazienda_id_bp003,
    sched002_tbjobs.sched002_runasuser_id_bp001
   FROM sched002_tbjobs
  WHERE ((sched002_tbjobs.sched002_flg_esecuzioniimmediate = false) AND (sched002_tbjobs.sched002_stati = 0))
  ORDER BY sched002_tbjobs.sched002_pesi DESC, sched002_tbjobs.sched002_id
;

CREATE OR REPLACE VIEW vsched002_notifiche
 AS
SELECT sched002_tbjobs.sched002_id,
    sched002_tbjobs.sched002_descrizioni,
    sched002_tbjobs.sched002_creati,
    sched002_tbjobs.sched002_eseguiti,
    sched002_tbjobs.sched002_terminati,
    ( SELECT
                CASE sched002_tbjobs.sched002_terminati
                    WHEN NULL::timestamp without time zone THEN NULL::interval
                    ELSE ( SELECT (sched002_tbjobs.sched002_terminati - sched002_tbjobs.sched002_eseguiti))
                END) AS durata,
    sched002_tbjobs.sched002_email,
    sched002_tbjobs.sched002_runasuser_id_bp001
   FROM sched002_tbjobs
  ORDER BY sched002_tbjobs.sched002_id DESC
;

CREATE OR REPLACE VIEW vsched002_timeoutedjobs
 AS
SELECT sched002_tbjobs.sched002_id,
    sched003_tbjobsruntime.sched003_retryrimanenti
   FROM (sched002_tbjobs
     JOIN sched003_tbjobsruntime ON ((sched002_tbjobs.sched002_id = sched003_tbjobsruntime.sched003_jobid_id_sched002)))
  WHERE (((sched002_tbjobs.sched002_eseguiti + ((sched002_tbjobs.sched002_timeout)::double precision * '00:00:01'::interval)) <= now()) AND (sched002_tbjobs.sched002_timeout <> 0))
;

CREATE OR REPLACE VIEW vsched002_tokilljobafterstop
 AS
SELECT sched002_tbjobs.sched002_id,
    sched003_tbjobsruntime.sched003_retryrimanenti,
    sched003_tbjobsruntime.sched003_stati
   FROM (sched002_tbjobs
     JOIN sched003_tbjobsruntime ON ((sched002_tbjobs.sched002_id = sched003_tbjobsruntime.sched003_jobid_id_sched002)))
  WHERE ((((sched003_tbjobsruntime.sched003_user_stop_time + ((30)::double precision * '00:00:01'::interval)) <= now()) AND (sched003_tbjobsruntime.sched003_stati = 7)) AND (sched003_tbjobsruntime.sched003_abortforkill = true))
;

-- Function: spsched002_inseriscijobvergine()
DROP FUNCTION IF EXISTS spsched002_inseriscijobvergine();
CREATE OR REPLACE FUNCTION spsched002_inseriscijobvergine()
  RETURNS integer AS
$BODY$
declare id_inserted integer;

BEGIN
insert into sched002_tbjobs(
sched002_id,
sched002_modeesecuzioni,
sched002_prioritacpu,
sched002_pesi,
sched002_timeout,
sched002_retry,
sched002_email,
sched002_descrizioni,
sched002_creati,
sched002_eseguiti,
sched002_stati,
sched002_flg_output,
sched002_outputfilename,
sched002_runasazienda_id_bp003,
sched002_runasuser_id_bp001,
sched002_flg_esecuzioniimmediate)
values(
DEFAULT,
DEFAULT,
DEFAULT,
DEFAULT,
DEFAULT,
DEFAULT,
'',
'Default',
DEFAULT,
NULL,
DEFAULT,
DEFAULT,
NULL,
1,
1,
DEFAULT
) returning sched002_id into id_inserted;
return id_inserted;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

ALTER TABLE sched002_tbjobs ADD COLUMN sched002_workdir Text;

-- Function: spsched002_updatejobworkdir(bigint, character varying)

-- DROP FUNCTION spsched002_updatejobworkdir(bigint, character varying);

CREATE OR REPLACE FUNCTION spsched002_updatejobworkdir(psched002_id bigint, psched002_workdir character varying)
  RETURNS integer AS
$BODY$
declare id_updated integer;

BEGIN
update sched002_tbjobs set 
sched002_workdir = psched002_workdir
where sched002_id = psched002_id;
id_updated=psched002_id;
return id_updated;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_updatejobworkdir(bigint, character varying)
  OWNER TO postgres;
-- Modifico sched001_tbconfig_id_sched005
-- Devo droppare e ricreare la vsched001_configurazione solo perchè usa sched001_tbconfig_id_sched005.

DROP VIEW IF EXISTS vsched001_configurazione;

-- situazione impossibile, ma per sicurezza faccio update prima di SET NOT NULL:
UPDATE sched001_tbconfig
  SET sched001_tbconfig_id_sched005 = 1
  WHERE sched001_tbconfig_id_sched005 IS NULL;

ALTER TABLE sched001_tbconfig
    ALTER COLUMN sched001_tbconfig_id_sched005 TYPE integer,
    ALTER COLUMN sched001_tbconfig_id_sched005 SET NOT NULL,
    ALTER COLUMN sched001_tbconfig_id_sched005 DROP DEFAULT;

-- Modifico sched002_runasazienda_id_bp003 e sched002_runasuser_id_bp001
-- Devo droppare e ricreare le viste vsched002_jobqueuenormal
-- e vsched002_jobqueimmediate solo perchè usano sched002_runasazienda_id_bp003.

DROP VIEW IF EXISTS vsched002_jobqueuenormal;
DROP VIEW IF EXISTS vsched002_jobqueimmediate;
DROP VIEW IF EXISTS vsched002_jobinfo;
DROP VIEW IF EXISTS vsched002_dashboard;
DROP VIEW IF EXISTS vsched002_notifiche;

-- situazione impossibile, ma per sicurezza faccio update prima di SET NOT NULL:
UPDATE sched002_tbjobs
  SET sched002_runasazienda_id_bp003 = 1
  WHERE sched002_runasazienda_id_bp003 IS NULL;
-- situazione impossibile, ma per sicurezza faccio update prima di SET NOT NULL:
UPDATE sched002_tbjobs
  SET sched002_runasuser_id_bp001 = 1
  WHERE sched002_runasuser_id_bp001 IS NULL;

ALTER TABLE sched002_tbjobs
    ALTER COLUMN sched002_runasazienda_id_bp003 TYPE integer,
    ALTER COLUMN sched002_runasazienda_id_bp003 SET NOT NULL,
    ALTER COLUMN sched002_runasuser_id_bp001 TYPE integer,
    ALTER COLUMN sched002_runasuser_id_bp001 SET NOT NULL,
    ALTER COLUMN sched002_runasuser_id_bp001 DROP DEFAULT;

-- Creo SEQUENCE e CONSTRAINT:
DO
$$
BEGIN
    CREATE SEQUENCE sched007_stati_sched007_id_seq START WITH 1 INCREMENT BY 1 NO MINVALUE NO MAXVALUE CACHE 1;
EXCEPTION WHEN duplicate_table THEN
        -- do nothing, it's already there
END
$$ LANGUAGE plpgsql;

ALTER TABLE public.sched007_stati_sched007_id_seq OWNER TO postgres;
ALTER SEQUENCE sched007_stati_sched007_id_seq OWNED BY sched007_stati.sched007_id;
ALTER TABLE ONLY sched007_stati ALTER COLUMN sched007_id SET DEFAULT nextval('sched007_stati_sched007_id_seq'::regclass);

DO
$$
BEGIN
    ALTER TABLE ONLY sched008_tipomessaggi ADD CONSTRAINT sched008_c01pk PRIMARY KEY (sched008_id);
EXCEPTION WHEN invalid_table_definition THEN
        -- do nothing, it's already there
END
$$ LANGUAGE plpgsql;
-------------------------------------------------------------------------------------------------
-- Patch DB SCHEDULER ver. 20150103 to 20160100
-------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------
-- Patch DB SCHEDULER ver. 20160100 to 20170001
-------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------
-- Patch DB SCHEDULER ver. 20170001 to 20170002
-------------------------------------------------------------------------------------------------
ALTER TABLE sched004_tbjobstorici
ALTER COLUMN sched004_tipimessaggi DROP NOT NULL;

ALTER TABLE sched004_tbjobstorici
ALTER COLUMN sched004_tipimessaggi TYPE INTEGER;

ALTER TABLE sched001_tbconfig
ADD COLUMN sched001_maxcoda INTEGER DEFAULT 0 NOT NULL;

COMMENT ON COLUMN sched001_tbconfig.sched001_maxcoda
IS 'Numero massimo di processi in coda dopo il quale viene inviata la notifica';

ALTER TABLE sched001_tbconfig
ADD COLUMN sched001_min_notifica_coda INTEGER DEFAULT 0 NOT NULL;

COMMENT ON COLUMN sched001_tbconfig.sched001_min_notifica_coda
IS 'Frequenza (in minuti) di controllo lunghezza coda';ALTER TABLE sched003_tbjobsruntime
ALTER COLUMN sched003_tidthreads TYPE BIGINT;

ALTER TABLE sched003_tbjobsruntime
ALTER COLUMN sched003_pidprocessi TYPE BIGINT;
-- 
-- Create views section -------------------------------------------------
CREATE OR REPLACE VIEW vsched001_step1vettore
 AS
SELECT sched001_tbconfig.sched001_id,
    sched001_tbconfig.sched001_vettorejolly,
    regexp_split_to_table((sched001_tbconfig.sched001_vettorejolly)::text, ''::text) AS giorniattivi
   FROM sched001_tbconfig
  ORDER BY sched001_tbconfig.sched001_id, regexp_split_to_table((sched001_tbconfig.sched001_vettorejolly)::text, ''::text)
;
CREATE OR REPLACE VIEW vsched001_step2vettore
 AS
SELECT a.sched001_id,
    a.giorniattivi,
    b.sched006_giorni,
    b.sched006_id
   FROM (vsched001_step1vettore a
     JOIN sched006_tbgiorni b ON (((a.giorniattivi)::smallint = b.sched006_id)))
  ORDER BY a.sched001_id, a.giorniattivi
;
CREATE OR REPLACE VIEW vsched001_step3vettore
 AS
SELECT string_agg((vsched001_step2vettore.sched006_giorni)::text, '.'::text ORDER BY vsched001_step2vettore.sched006_id) AS vettore_testuale,
    vsched001_step2vettore.sched001_id
   FROM (sched001_tbconfig
     JOIN vsched001_step2vettore ON ((vsched001_step2vettore.sched001_id = sched001_tbconfig.sched001_id)))
  GROUP BY vsched001_step2vettore.sched001_id
;
CREATE OR REPLACE VIEW vsched001_configurazione
 AS
SELECT sched001_tbconfig.sched001_id,
    sched001_tbconfig.sched001_nomecfg,
    sched001_tbconfig.sched001_flg_attivo,
    sched001_tbconfig.sched001_iniziofinestra,
    sched001_tbconfig.sched001_finefinestra,
    sched001_tbconfig.sched001_flg_vettorejolly,
    vsched001_step3vettore.vettore_testuale,
    sched005_tbclosemodes.sched003_closemode,
    sched001_tbconfig.sched001_slotsmassimi,
    sched001_tbconfig.sched001_slotimmmassimi,
    sched001_tbconfig.sched001_email,
    sched001_tbconfig.sched001_maxpeso
   FROM ((sched001_tbconfig
     LEFT JOIN vsched001_step3vettore ON ((sched001_tbconfig.sched001_id = vsched001_step3vettore.sched001_id)))
     JOIN sched005_tbclosemodes ON ((sched001_tbconfig.sched001_tbconfig_id_sched005 = sched005_tbclosemodes.sched005_id)))
;
CREATE OR REPLACE VIEW vsched002_dashboard
 AS
SELECT sched002_tbjobs.sched002_id,
    sched002_tbjobs.sched002_descrizioni,
    sched002_tbjobs.sched002_procedura,
    sched002_tbjobs.sched002_ambiente,
    sched002_tbjobs.sched002_creati,
    sched002_tbjobs.sched002_eseguiti,
    sched002_tbjobs.sched002_percentualicomp,
    sched002_tbjobs.sched002_terminati,
    sched002_tbjobs.sched002_stati,
    sched007_stati.sched007_stato,
    ( SELECT
                CASE sched002_tbjobs.sched002_flg_esecuzioniimmediate
                    WHEN true THEN 'Appena possibile'::text
                    WHEN false THEN ( SELECT ((to_char((sched001_tbconfig.sched001_iniziofinestra)::interval, 'HH24:MI'::text) || ' - '::text) || to_char((sched001_tbconfig.sched001_finefinestra)::interval, 'HH24:MI'::text)) AS coda
                       FROM sched001_tbconfig
                      WHERE (sched001_tbconfig.sched001_flg_attivo = true))
                    ELSE NULL::text
                END AS "case") AS tipo_coda,
    row_number() OVER (ORDER BY sched002_tbjobs.sched002_pesi DESC) AS postoincodaimm,
    sched007_stati.sched007_idstato,
    ( SELECT
                CASE sched002_tbjobs.sched002_stati
                    WHEN 0 THEN false
                    WHEN 5 THEN true
                    WHEN 6 THEN true
                    WHEN 10 THEN true
                    WHEN 11 THEN true
                    ELSE false
                END AS "case") AS can_play,
    ( SELECT
                CASE sched002_tbjobs.sched002_stati
                    WHEN 0 THEN true
                    WHEN 1 THEN true
                    ELSE false
                END AS "case") AS can_stop,
    ( SELECT
                CASE sched002_tbjobs.sched002_flg_output
                    WHEN true THEN
                    CASE sched002_tbjobs.sched002_stati
                        WHEN 4 THEN true
                        ELSE false
                    END
                    WHEN false THEN false
                    ELSE NULL::boolean
                END AS "case") AS can_download,
    sched002_tbjobs.sched002_email,
    sched002_tbjobs.sched002_pesi,
    sched002_tbjobs.sched002_retry,
    sched002_tbjobs.sched002_timeout,
    sched002_tbjobs.sched002_flg_output,
    sched002_tbjobs.sched002_flg_esecuzioniimmediate AS sched002_flg_tipo_coda,
    bp001_tbutenti.bp001_nomeutente AS utente,
    bp004_tbanagrafiche.bp004_cognomeragsoc AS azienda,
    sched002_tbjobs.sched002_runasuser_id_bp001 AS id_utente,
    sched002_tbjobs.sched002_runasazienda_id_bp003 AS id_azienda,
    ( SELECT
                CASE sched002_tbjobs.sched002_terminati
                    WHEN NULL::timestamp without time zone THEN NULL::text
                    ELSE to_char(( SELECT (sched002_tbjobs.sched002_terminati - sched002_tbjobs.sched002_eseguiti)), 'HH24:MI:SS'::text)
                END AS to_char) AS durata,
    ''::text AS img_kill,
    ''::text AS img_log,
    ''::text AS img_elimina
   FROM ((((sched002_tbjobs
     JOIN sched007_stati ON ((sched002_tbjobs.sched002_stati = sched007_stati.sched007_idstato)))
     JOIN bp001_tbutenti ON ((sched002_tbjobs.sched002_runasuser_id_bp001 = bp001_tbutenti.bp001_id)))
     JOIN bp003_tbaziende ON ((sched002_tbjobs.sched002_runasazienda_id_bp003 = bp003_tbaziende.bp003_id)))
     JOIN bp004_tbanagrafiche ON ((bp003_tbaziende.bp003_anagrafica_id_bp004 = bp004_tbanagrafiche.bp004_id)))
  WHERE (sched002_tbjobs.sched002_flg_esecuzioniimmediate = true)
UNION
 SELECT sched002_tbjobs.sched002_id,
    sched002_tbjobs.sched002_descrizioni,
    sched002_tbjobs.sched002_procedura,
    sched002_tbjobs.sched002_ambiente,
    sched002_tbjobs.sched002_creati,
    sched002_tbjobs.sched002_eseguiti,
    sched002_tbjobs.sched002_percentualicomp,
    sched002_tbjobs.sched002_terminati,
    sched002_tbjobs.sched002_stati,
    sched007_stati.sched007_stato,
    ( SELECT
                CASE sched002_tbjobs.sched002_flg_esecuzioniimmediate
                    WHEN true THEN 'Appena possibile'::text
                    WHEN false THEN ( SELECT ((to_char((sched001_tbconfig.sched001_iniziofinestra)::interval, 'HH24:MI'::text) || ' - '::text) || to_char((sched001_tbconfig.sched001_finefinestra)::interval, 'HH24:MI'::text)) AS coda
                       FROM sched001_tbconfig
                      WHERE (sched001_tbconfig.sched001_flg_attivo = true))
                    ELSE NULL::text
                END AS "case") AS tipo_coda,
    row_number() OVER (ORDER BY sched002_tbjobs.sched002_pesi DESC) AS postoincodaimm,
    sched007_stati.sched007_idstato,
    ( SELECT
                CASE sched002_tbjobs.sched002_stati
                    WHEN 0 THEN false
                    WHEN 5 THEN true
                    WHEN 6 THEN true
                    WHEN 10 THEN true
                    WHEN 11 THEN true
                    ELSE false
                END AS "case") AS can_play,
    ( SELECT
                CASE sched002_tbjobs.sched002_stati
                    WHEN 0 THEN true
                    WHEN 1 THEN true
                    ELSE false
                END AS "case") AS can_stop,
    ( SELECT
                CASE sched002_tbjobs.sched002_flg_output
                    WHEN true THEN
                    CASE sched002_tbjobs.sched002_stati
                        WHEN 4 THEN true
                        ELSE false
                    END
                    WHEN false THEN false
                    ELSE NULL::boolean
                END AS "case") AS can_download,
    sched002_tbjobs.sched002_email,
    sched002_tbjobs.sched002_pesi,
    sched002_tbjobs.sched002_retry,
    sched002_tbjobs.sched002_timeout,
    sched002_tbjobs.sched002_flg_output,
    sched002_tbjobs.sched002_flg_esecuzioniimmediate AS sched002_flg_tipo_coda,
    bp001_tbutenti.bp001_nomeutente AS utente,
    bp004_tbanagrafiche.bp004_cognomeragsoc AS azienda,
    sched002_tbjobs.sched002_runasuser_id_bp001 AS id_utente,
    sched002_tbjobs.sched002_runasazienda_id_bp003 AS id_azienda,
    ( SELECT
                CASE sched002_tbjobs.sched002_terminati
                    WHEN NULL::timestamp without time zone THEN NULL::text
                    ELSE to_char(( SELECT (sched002_tbjobs.sched002_terminati - sched002_tbjobs.sched002_eseguiti)), 'HH24:MI:SS'::text)
                END AS to_char) AS durata,
    ''::text AS img_kill,
    ''::text AS img_log,
    ''::text AS img_elimina
   FROM ((((sched002_tbjobs
     JOIN sched007_stati ON ((sched002_tbjobs.sched002_stati = sched007_stati.sched007_idstato)))
     JOIN bp001_tbutenti ON ((sched002_tbjobs.sched002_runasuser_id_bp001 = bp001_tbutenti.bp001_id)))
     JOIN bp003_tbaziende ON ((sched002_tbjobs.sched002_runasazienda_id_bp003 = bp003_tbaziende.bp003_id)))
     JOIN bp004_tbanagrafiche ON ((bp003_tbaziende.bp003_anagrafica_id_bp004 = bp004_tbanagrafiche.bp004_id)))
  WHERE (sched002_tbjobs.sched002_flg_esecuzioniimmediate = false)
;
CREATE OR REPLACE VIEW vsched002_jobinfo
 AS
SELECT sched002_tbjobs.sched002_id,
    sched002_tbjobs.sched002_outputfilename,
    sched002_tbjobs.sched002_email,
    sched002_tbjobs.sched002_runasazienda_id_bp003,
    sched002_tbjobs.sched002_runasuser_id_bp001
   FROM sched002_tbjobs
;
CREATE OR REPLACE VIEW vsched002_jobqueimmediate
 AS
SELECT sched002_tbjobs.sched002_id,
    sched002_tbjobs.sched002_modeesecuzioni,
    sched002_tbjobs.sched002_prioritacpu,
    sched002_tbjobs.sched002_pesi,
    sched002_tbjobs.sched002_timeout,
    sched002_tbjobs.sched002_retry,
    sched002_tbjobs.sched002_stati,
    sched002_tbjobs.sched002_runasazienda_id_bp003,
    sched002_tbjobs.sched002_runasuser_id_bp001
   FROM sched002_tbjobs
  WHERE ((sched002_tbjobs.sched002_flg_esecuzioniimmediate = true) AND (sched002_tbjobs.sched002_stati = 0))
  ORDER BY sched002_tbjobs.sched002_pesi DESC, sched002_tbjobs.sched002_id
;
CREATE OR REPLACE VIEW vsched002_jobqueuenormal
 AS
SELECT sched002_tbjobs.sched002_id,
    sched002_tbjobs.sched002_modeesecuzioni,
    sched002_tbjobs.sched002_prioritacpu,
    sched002_tbjobs.sched002_pesi,
    sched002_tbjobs.sched002_timeout,
    sched002_tbjobs.sched002_retry,
    sched002_tbjobs.sched002_stati,
    sched002_tbjobs.sched002_runasazienda_id_bp003,
    sched002_tbjobs.sched002_runasuser_id_bp001
   FROM sched002_tbjobs
  WHERE ((sched002_tbjobs.sched002_flg_esecuzioniimmediate = false) AND (sched002_tbjobs.sched002_stati = 0))
  ORDER BY sched002_tbjobs.sched002_pesi DESC, sched002_tbjobs.sched002_id
;
CREATE OR REPLACE VIEW vsched002_notifiche
 AS
SELECT sched002_tbjobs.sched002_id,
    sched002_tbjobs.sched002_descrizioni,
    sched002_tbjobs.sched002_creati,
    sched002_tbjobs.sched002_eseguiti,
    sched002_tbjobs.sched002_terminati,
    ( SELECT
                CASE sched002_tbjobs.sched002_terminati
                    WHEN NULL::timestamp without time zone THEN NULL::interval
                    ELSE ( SELECT (sched002_tbjobs.sched002_terminati - sched002_tbjobs.sched002_eseguiti))
                END) AS durata,
    sched002_tbjobs.sched002_email,
    sched002_tbjobs.sched002_runasuser_id_bp001
   FROM sched002_tbjobs
  ORDER BY sched002_tbjobs.sched002_id DESC
;
CREATE OR REPLACE VIEW vsched002_timeoutedjobs
 AS
SELECT sched002_tbjobs.sched002_id,
    sched003_tbjobsruntime.sched003_retryrimanenti
   FROM (sched002_tbjobs
     JOIN sched003_tbjobsruntime ON ((sched002_tbjobs.sched002_id = sched003_tbjobsruntime.sched003_jobid_id_sched002)))
  WHERE (((sched002_tbjobs.sched002_eseguiti + ((sched002_tbjobs.sched002_timeout)::double precision * '00:00:01'::interval)) <= now()) AND (sched002_tbjobs.sched002_timeout <> 0))
;
CREATE OR REPLACE VIEW vsched002_tokilljobafterstop
 AS
SELECT sched002_tbjobs.sched002_id,
    sched003_tbjobsruntime.sched003_retryrimanenti,
    sched003_tbjobsruntime.sched003_stati
   FROM (sched002_tbjobs
     JOIN sched003_tbjobsruntime ON ((sched002_tbjobs.sched002_id = sched003_tbjobsruntime.sched003_jobid_id_sched002)))
  WHERE ((((sched003_tbjobsruntime.sched003_user_stop_time + ((30)::double precision * '00:00:01'::interval)) <= now()) AND (sched003_tbjobsruntime.sched003_stati = 7)) AND (sched003_tbjobsruntime.sched003_abortforkill = true))
;

-- 
CREATE OR REPLACE FUNCTION spsched003_logjobupdate()
  RETURNS trigger AS
$BODY$
BEGIN
insert into sched004_tbjobstorici(
sched004_jobid_id_sched002,
sched004_stati,
sched004_tempiaggiornamenti,
sched004_tipimessaggi,
sched004_messaggi) 
VALUES
(NEW.sched003_jobid_id_sched002,
NEW.sched003_stati,   --stato di starting, costante
NOW(),
NEW.sched003_tipomessaggi,
NEW.sched003_ultimimessaggi --sostituire con messaggi da tabella
);
return NEW;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched003_logjobupdate()
  OWNER TO postgres;



CREATE OR REPLACE FUNCTION spsched003_logjobcreation()
  RETURNS trigger AS
$BODY$
BEGIN
insert into sched004_tbjobstorici(
sched004_jobid_id_sched002,
sched004_stati,
sched004_tempiaggiornamenti,
sched004_tipimessaggi,
sched004_messaggi) 
VALUES
(NEW.sched003_jobid_id_sched002,
9,   --stato di starting, costante
NOW(),
0,
'Il batch si sta avviando'
);
return NEW;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched003_logjobcreation()
  OWNER TO postgres;



CREATE OR REPLACE FUNCTION spsched001_eliminaconfigurazione(psched001_id integer)
  RETURNS integer AS
$BODY$
declare id_eliminato integer;
declare id_active integer;
BEGIN
IF(select count(*) sched001_id from sched001_tbconfig where sched001_flg_attivo=True) > 0 THEN
          select sched001_id into id_active from sched001_tbconfig where sched001_flg_attivo=True;
ELSE
          id_active=0;
END IF;

IF id_active=psched001_id THEN
    id_eliminato = 0;
ELSE
    IF(select count(*) sched001_id from sched001_tbconfig where sched001_id=psched001_id) > 0 THEN
        delete from sched001_tbconfig where sched001_id=psched001_id ;
        id_eliminato = psched001_id;
    ELSE
        id_eliminato = 0;
    END IF;
END IF;
return id_eliminato;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched001_eliminaconfigurazione(integer)
  OWNER TO postgres;
  
  
  
-- Function: spsched001_inserisciconfigurazione(boolean, character varying, time without time zone, time without time zone, boolean, character varying, integer, integer, character varying, integer, integer)

-- DROP FUNCTION spsched001_inserisciconfigurazione(boolean, character varying, time without time zone, time without time zone, boolean, character varying, integer, integer, character varying, integer, integer);

CREATE OR REPLACE FUNCTION spsched001_inserisciconfigurazione(pflg_attivo boolean, pnomecfg character varying, piniziofinestra time without time zone, pfinefinestra time without time zone, pflg_vettorejolly boolean, pvettorejolly character varying, pslotsmassimi integer, pslotimmmassimi integer, pemail character varying, pmaxpeso integer, pflg_jobclosemode integer)
  RETURNS integer AS
$BODY$
declare id_inserted integer;
declare id_template_attivo integer;
BEGIN
--se non esistono configurazioni: la prima configurazione salvata viene subito attivata ( sched001_flg_attivo = TRUE )
IF(select count(*) from sched001_tbconfig) = 0 THEN
          insert into sched001_tbconfig(sched001_id,sched001_flg_attivo,sched001_nomecfg,sched001_iniziofinestra,sched001_finefinestra,sched001_flg_vettorejolly,sched001_vettorejolly,sched001_slotsmassimi,sched001_slotimmmassimi,sched001_email,sched001_maxpeso,sched001_tbconfig_id_sched005) values(DEFAULT,True,pnomecfg ,piniziofinestra ,pfinefinestra ,pflg_vettorejolly,pvettorejolly,pslotsmassimi,pslotimmmassimi ,pemail,pmaxpeso,pflg_jobclosemode) returning sched001_id into id_inserted;
ELSE
    --se esiste già un template di configurazione attivo e ne viene creato uno nuovo , ed impostato come attivo, lo sostituisce.
    IF (select count(sched001_id) from sched001_tbconfig where sched001_flg_attivo=True) = 1 and pflg_attivo THEN
          --trovo l'id del template attivo
          select sched001_id into id_template_attivo  from sched001_tbconfig where sched001_flg_attivo=True;
          --disattivo il vecchio template
          update sched001_tbconfig set sched001_flg_attivo=False where sched001_id=id_template_attivo;
          --attivo ed inserisco il nuovo template 
          insert into sched001_tbconfig(sched001_id,sched001_flg_attivo,sched001_nomecfg,sched001_iniziofinestra,sched001_finefinestra,sched001_flg_vettorejolly,sched001_vettorejolly,sched001_slotsmassimi,sched001_slotimmmassimi,sched001_email,sched001_maxpeso,sched001_tbconfig_id_sched005) values(DEFAULT,pflg_attivo,pnomecfg ,piniziofinestra ,pfinefinestra ,pflg_vettorejolly,pvettorejolly,pslotsmassimi,pslotimmmassimi ,pemail,pmaxpeso,pflg_jobclosemode) returning sched001_id into id_inserted;
    --il template (con flg_Attivo=False) viene inserito cosi come viene presentato      
    ELSE
          insert into sched001_tbconfig(sched001_id,sched001_flg_attivo,sched001_nomecfg,sched001_iniziofinestra,sched001_finefinestra,sched001_flg_vettorejolly,sched001_vettorejolly,sched001_slotsmassimi,sched001_slotimmmassimi,sched001_email,sched001_maxpeso,sched001_tbconfig_id_sched005) values(DEFAULT,pflg_attivo,pnomecfg ,piniziofinestra ,pfinefinestra ,pflg_vettorejolly,pvettorejolly,pslotsmassimi,pslotimmmassimi ,pemail,pmaxpeso,pflg_jobclosemode) returning sched001_id into id_inserted;
    END IF;
END IF;    
return id_inserted;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched001_inserisciconfigurazione(boolean, character varying, time without time zone, time without time zone, boolean, character varying, integer, integer, character varying, integer, integer)
  OWNER TO postgres;
  
  
  
-- Function: spsched001_modificaconfigurazione(integer, boolean, character varying, time without time zone, time without time zone, boolean, character varying, integer, integer, character varying, integer, smallint)

-- DROP FUNCTION spsched001_modificaconfigurazione(integer, boolean, character varying, time without time zone, time without time zone, boolean, character varying, integer, integer, character varying, integer, smallint);

DROP FUNCTION IF EXISTS spsched001_modificaconfigurazione (integer, boolean, character varying, time without time zone, time without time zone, boolean, character varying, integer, integer, character varying, integer, smallint) ;

CREATE OR REPLACE FUNCTION spsched001_modificaconfigurazione (
  pidtemplate integer,
  pflg_attivo boolean,
  pnomecfg varchar,
  piniziofinestra time,
  pfinefinestra time,
  pflg_vettorejolly boolean,
  pvettorejolly varchar,
  pslotsmassimi integer,
  pslotimmmassimi integer,
  pemail varchar,
  pmaxpeso integer,
  pjobclosemode smallint,
  maxcoda integer,
  minnotifiche integer
)
RETURNS integer AS
$body$
declare id_updated integer;
declare id_template_attivo integer;
BEGIN
--verifico se il template richiesto per la modifica esiste
IF (select count(sched001_id) from sched001_tbconfig where sched001_id=pidtemplate) > 0 THEN
   --se esiste già un template di configurazione attivo ed il corrente viene modificato come attivo, lo sostituisce.  
   IF (select count(sched001_id) from sched001_tbconfig where sched001_flg_attivo=True) = 1 and pflg_attivo THEN
      --trovo l'id del template attivo
      select sched001_id into id_template_attivo  from sched001_tbconfig where sched001_flg_attivo=True;
      --disattivo il vecchio template
      update sched001_tbconfig set sched001_flg_attivo=False where sched001_id=id_template_attivo;
      --attivo ed inserisco il nuovo template 
      update sched001_tbconfig SET sched001_flg_attivo=pflg_attivo,sched001_nomecfg=pnomecfg,sched001_iniziofinestra=piniziofinestra,sched001_finefinestra=pfinefinestra,sched001_flg_vettorejolly=pflg_vettorejolly,sched001_vettorejolly=pvettorejolly,sched001_slotsmassimi=pslotsmassimi,sched001_slotimmmassimi=pslotimmmassimi,sched001_email=pemail,sched001_maxpeso=pmaxpeso,sched001_tbconfig_id_sched005=pjobclosemode, sched001_maxcoda= maxcoda, sched001_min_notifica_coda = minnotifiche where sched001_id=pidtemplate;
      id_updated=pidtemplate;
      --il template (con flg_Attivo=False) viene inserito cosi come viene presentato      
   ELSE
       --se non esiste un template attivo imposto solo i nuovi valori del template
       update sched001_tbconfig SET sched001_flg_attivo=pflg_attivo,sched001_nomecfg=pnomecfg,sched001_iniziofinestra=piniziofinestra,sched001_finefinestra=pfinefinestra,sched001_flg_vettorejolly=pflg_vettorejolly,sched001_vettorejolly=pvettorejolly,sched001_slotsmassimi=pslotsmassimi,sched001_slotimmmassimi=pslotimmmassimi,sched001_email=pemail,sched001_maxpeso=pmaxpeso,sched001_tbconfig_id_sched005=pjobclosemode, sched001_maxcoda= maxcoda, sched001_min_notifica_coda = minnotifiche  where sched001_id=pidtemplate;
       id_updated=pidtemplate; 
   END IF;
ELSE 
id_updated=0;
END IF;
return id_updated;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;
  


-- Function: spsched002_candownloadjobres(integer)

-- DROP FUNCTION spsched002_candownloadjobres(integer);

CREATE OR REPLACE FUNCTION spsched002_candownloadjobres(psched002_id integer)
  RETURNS integer AS
$BODY$
declare id_download integer;
BEGIN
select sched002_id from sched002_tbjobs into id_download where sched002_flg_output=True and sched002_outputfilename is not Null and sched002_id=psched002_id;
return id_download;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_candownloadjobres(integer)
  OWNER TO postgres;
  
  
  
-- Function: spsched002_deschedulejob(bigint)

-- DROP FUNCTION spsched002_deschedulejob(bigint);

CREATE OR REPLACE FUNCTION spsched002_deschedulejob(psched002_id bigint)
  RETURNS integer AS
$BODY$
declare result bigint;
BEGIN

IF (select CAST(count(sched003_jobid_id_sched002) as integer) from sched003_tbjobsruntime where sched003_jobid_id_sched002=psched002_id) = 0 THEN
	IF (select CAST(count(sched002_tbjobs) as integer) from sched002_tbjobs where sched002_stati = 0 and sched002_id = psched002_id) = 1 THEN
		select sched002_id into result from sched002_tbjobs where sched002_id = psched002_id;
		delete from sched002_tbjobs where sched002_id=psched002_id;
	END IF;
ELSE
    result=0;
END IF;
return result;

END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_deschedulejob(bigint)
  OWNER TO postgres;
  
  
  
-- Function: spsched002_eliminajob(integer)

-- DROP FUNCTION spsched002_eliminajob(integer);

CREATE OR REPLACE FUNCTION spsched002_eliminajob(psched002_id integer)
  RETURNS integer AS
$BODY$
declare id_eliminato integer;
BEGIN
delete from sched002_tbjobs where sched002_id=psched002_id ;
id_eliminato = psched002_id;
return id_eliminato;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_eliminajob(integer)
  OWNER TO postgres;
  
  
  
-- Function: spsched002_getdistinctambiente()

-- DROP FUNCTION spsched002_getdistinctambiente();

CREATE OR REPLACE FUNCTION spsched002_getdistinctambiente()
  RETURNS SETOF character varying AS
$BODY$
BEGIN
RETURN QUERY EXECUTE 'select distinct sched002_ambiente from sched002_tbjobs';
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100
  ROWS 1000;
ALTER FUNCTION spsched002_getdistinctambiente()
  OWNER TO postgres;
  
  
  
-- Function: spsched002_getdistinctstati()

-- DROP FUNCTION spsched002_getdistinctstati();

CREATE OR REPLACE FUNCTION spsched002_getdistinctstati()
  RETURNS SETOF character varying AS
$BODY$
BEGIN
RETURN QUERY EXECUTE 'select distinct sched007_stato from sched007_stati where sched007_idstato >= 0';
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100
  ROWS 1000;
ALTER FUNCTION spsched002_getdistinctstati()
  OWNER TO postgres;
  
  
  
-- Function: spsched002_getfreeslots(boolean)

-- DROP FUNCTION spsched002_getfreeslots(boolean);

CREATE OR REPLACE FUNCTION spsched002_getfreeslots(sched002_flg_esecuzioniimmediate boolean)
  RETURNS integer AS
$BODY$
declare freeslots integer;
BEGIN
IF sched002_flg_esecuzioniimmediate THEN
   select (select sched001_slotimmmassimi from sched001_tbconfig where sched001_flg_attivo=True  ) - 
          (select count(*) from sched003_tbjobsruntime where sched003_flg_esecuzioniimmediate=True ) into freeslots  ;
ELSE
      select (select sched001_slotsmassimi from sched001_tbconfig where sched001_flg_attivo=True) - 
          (select count(*) from sched003_tbjobsruntime where sched003_flg_esecuzioniimmediate=False) into freeslots;
END IF;
return freeslots;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_getfreeslots(boolean)
  OWNER TO postgres;
  
  
  
-- Function: spsched002_getimmjobtorun()

-- DROP FUNCTION spsched002_getimmjobtorun();

CREATE OR REPLACE FUNCTION spsched002_getimmjobtorun()
  RETURNS SETOF integer AS
$BODY$
declare _limit bigint;
BEGIN
select cast( spsched002_getfreeslots(True) as bigint) into _limit;

IF _limit > 0 THEN   
    RETURN QUERY EXECUTE 'select sched002_id from vsched002_jobqueimmediate LIMIT $1' USING _limit;
ELSE
    RETURN QUERY EXECUTE 'select 0 as sched002_id where 1=0;';
END IF;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100
  ROWS 1000;
ALTER FUNCTION spsched002_getimmjobtorun()
  OWNER TO postgres;




-- Function: spsched002_getjobpercentage(bigint)
-- DROP FUNCTION spsched002_getjobpercentage(bigint);
CREATE OR REPLACE FUNCTION spsched002_getjobpercentage(psched002_id bigint)
  RETURNS integer AS
$BODY$
BEGIN
select sched002_percentualicomp into psched002_id from sched002_tbjobs where sched002_id = psched002_id;
return psched002_id;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_getjobpercentage(bigint)
  OWNER TO postgres;
  
  
  
-- Function: spsched002_getnormjobtorun()

-- DROP FUNCTION spsched002_getnormjobtorun();

CREATE OR REPLACE FUNCTION spsched002_getnormjobtorun()
  RETURNS SETOF integer AS
$BODY$
declare _limit bigint;
BEGIN
select cast( spsched002_getfreeslots(False) as bigint) into _limit;
IF _limit > 0 THEN	
	RETURN QUERY EXECUTE 'select sched002_id from vsched002_jobqueuenormal LIMIT $1' USING _limit;
ELSE 
	RETURN QUERY EXECUTE 'select 0 as sched002_id where 1=0;';
END IF;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100
  ROWS 1000;
ALTER FUNCTION spsched002_getnormjobtorun()
  OWNER TO postgres;



-- Function: spsched002_inseriscijobvergine()

-- DROP FUNCTION spsched002_inseriscijobvergine();

CREATE OR REPLACE FUNCTION spsched002_inseriscijobvergine()
  RETURNS integer AS
$BODY$
declare id_inserted integer;
BEGIN
insert into sched002_tbjobs(
sched002_id,
sched002_modeesecuzioni,
sched002_prioritacpu,
sched002_pesi,
sched002_timeout,
sched002_retry,
sched002_email,
sched002_descrizioni,
sched002_creati,
sched002_eseguiti,
sched002_stati,
sched002_flg_output,
sched002_outputfilename,
sched002_runasazienda_id_bp003,
sched002_runasuser_id_bp001,
sched002_flg_esecuzioniimmediate) 
values(
DEFAULT,
DEFAULT,
DEFAULT,
DEFAULT,
DEFAULT,
DEFAULT,
'',
'Default',
DEFAULT,
NULL,
DEFAULT,
DEFAULT,
NULL,
1,
1,
DEFAULT
) returning sched002_id into id_inserted;
return id_inserted;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_inseriscijobvergine()
  OWNER TO postgres;
  
  
  
-- Function: spsched002_updatejobworkdir(bigint, character varying)

-- DROP FUNCTION spsched002_updatejobworkdir(bigint, character varying);

CREATE OR REPLACE FUNCTION spsched002_updatejobworkdir(psched002_id bigint, psched002_workdir character varying)
  RETURNS integer AS
$BODY$
declare id_updated integer;
BEGIN
update sched002_tbjobs set 
sched002_workdir = psched002_workdir
where sched002_id = psched002_id;
id_updated=psched002_id;
return id_updated;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_updatejobworkdir(bigint, character varying)
  OWNER TO postgres;



-- Function: spsched002_kill_reschedule(bigint)

-- DROP FUNCTION spsched002_kill_reschedule(bigint);

CREATE OR REPLACE FUNCTION spsched002_kill_reschedule(psched002_id bigint)
  RETURNS integer AS
$BODY$
BEGIN
delete from sched003_tbjobsruntime where sched003_jobid_id_sched002=psched002_id; 
update sched002_tbjobs set sched002_stati=0 where sched002_id=psched002_id;
INSERT INTO sched004_tbjobstorici(sched004_jobid_id_sched002, sched004_stati, sched004_tempiaggiornamenti, sched004_tipimessaggi, sched004_messaggi) 
VALUES (psched002_id, 0, NOW(), 7, 'Called kill_reschedule()');
return psched002_id;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_kill_reschedule(bigint)
  OWNER TO postgres;
  
  
  
-- Function: spsched002_processtimeoutedjob(bigint)

-- DROP FUNCTION spsched002_processtimeoutedjob(bigint);

CREATE OR REPLACE FUNCTION spsched002_processtimeoutedjob(psched002_id bigint)
  RETURNS integer AS
$BODY$
declare jobid bigint;
BEGIN

IF (select CAST(count(sched003_jobid_id_sched002) as integer) from sched003_tbjobsruntime where sched003_jobid_id_sched002=psched002_id and sched003_retryrimanenti > 0) > 0 THEN
    update sched003_tbjobsruntime set sched003_ultimimessaggi='Retrying',sched003_tipomessaggi=7 where sched003_jobid_id_sched002=psched002_id ;
    update sched003_tbjobsruntime set sched003_retryrimanenti=sched003_retryrimanenti-1,sched003_stati=9,sched003_ultimimessaggi='Starting' where sched003_jobid_id_sched002=psched002_id ;
    update sched002_tbjobs set sched002_stati=9,sched002_eseguiti=NOW() where sched002_id=psched002_id;
    jobid=psched002_id;
ELSE
    IF(select CAST(count(sched003_jobid_id_sched002) as integer) from sched003_tbjobsruntime where sched003_jobid_id_sched002=psched002_id and sched003_retryrimanenti > 0) = 0 THEN
        select spsched002_schedulerconfirmstop(psched002_id) into jobid;
        update sched002_tbjobs set sched002_stati=6,sched002_terminati=NOW() where sched002_id=psched002_id;
    ELSE 
        jobid=0;
    END IF;
END IF;

IF jobid <> 0 THEN
    INSERT INTO sched004_tbjobstorici(sched004_jobid_id_sched002, sched004_stati, sched004_tempiaggiornamenti, sched004_tipimessaggi, sched004_messaggi) 
    VALUES (jobid, 0, NOW(), 7, 'Called processtimeoutedjob()');
END IF;

return jobid;

END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_processtimeoutedjob(bigint)
  OWNER TO postgres;
  
  
  
-- Function: spsched002_proclistener_update_output_path(character varying, bigint)

-- DROP FUNCTION spsched002_proclistener_update_output_path(character varying, bigint);

CREATE OR REPLACE FUNCTION spsched002_proclistener_update_output_path(psched002_outputfilename character varying, psched002_id bigint)
  RETURNS integer AS
$BODY$
BEGIN
update sched002_tbjobs set sched002_outputfilename=psched002_outputfilename where sched002_id=psched002_id;
return psched002_id;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_proclistener_update_output_path(character varying, bigint)
  OWNER TO postgres;
  
  
  
-- Function: spsched002_promotejobimm(bigint)

-- DROP FUNCTION spsched002_promotejobimm(bigint);

CREATE OR REPLACE FUNCTION spsched002_promotejobimm(id bigint)
  RETURNS integer AS
$BODY$
DECLARE
  status integer;
BEGIN
update sched002_tbjobs
   set sched002_flg_esecuzioniimmediate = True, sched002_stati = 0
 where sched002_id = id
   and sched002_stati in (0, 5, 6, 10, 11);
IF FOUND THEN
    INSERT INTO sched004_tbjobstorici(sched004_jobid_id_sched002, sched004_stati, sched004_tempiaggiornamenti, sched004_tipimessaggi, sched004_messaggi) 
    VALUES (id, 0, NOW(), 7, 'Called promotejobimm() - UPDATED');
ELSE
    SELECT sched002_stati FROM sched002_tbjobs WHERE sched002_id = id INTO status;
    IF FOUND THEN
        INSERT INTO sched004_tbjobstorici(sched004_jobid_id_sched002, sched004_stati, sched004_tempiaggiornamenti, sched004_tipimessaggi, sched004_messaggi) 
        VALUES (id, status, NOW(), 7, 'Called promotejobimm() - NOT UPDATED');
    ELSE
        INSERT INTO sched004_tbjobstorici(sched004_jobid_id_sched002, sched004_stati, sched004_tempiaggiornamenti, sched004_tipimessaggi, sched004_messaggi) 
        VALUES (id, -1, NOW(), 7, 'Called promotejobimm() - NOT FOUND');
    END IF;
END IF;
return id;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_promotejobimm(bigint)
  OWNER TO postgres;
  
  
  
-- Function: spsched002_schedulerconfirmstop(bigint)

-- DROP FUNCTION spsched002_schedulerconfirmstop(bigint);

CREATE OR REPLACE FUNCTION spsched002_schedulerconfirmstop(psched002_id bigint)
  RETURNS integer AS
$BODY$
BEGIN

IF (select CAST(count(sched002_id) as integer) from sched002_tbjobs where sched002_id=psched002_id) = 1 THEN
   update sched003_tbjobsruntime set sched003_stati=5,sched003_tipomessaggi=1,sched003_ultimicontatti=NOW(),sched003_ultimimessaggi='Batch fermato da utente' where  sched003_jobid_id_sched002=psched002_id;
   delete from sched003_tbjobsruntime where sched003_jobid_id_sched002 = psched002_id;
   update sched002_tbjobs set sched002_terminati=NOW(),sched002_stati=5 where sched002_id=psched002_id;
   return psched002_id;
ELSE
    return 0;
END IF;


END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_schedulerconfirmstop(bigint)
  OWNER TO postgres;
  
  
  
-- Function: spsched002_startjob(bigint)

-- DROP FUNCTION spsched002_startjob(bigint);

CREATE OR REPLACE FUNCTION spsched002_startjob(psched002_id bigint)
  RETURNS integer AS
$BODY$
BEGIN

IF (select CAST(count(sched003_jobid_id_sched002) as integer) from sched003_tbjobsruntime where sched003_jobid_id_sched002=psched002_id) = 0 THEN

   insert into sched003_tbjobsruntime(
       sched003_jobid_id_sched002 ,
       sched003_stati,
       sched003_retryrimanenti,
       sched003_flg_esecuzioniimmediate
       ) 
   VALUES
       (
       psched002_id,
       9,   --stato di starting, costante
       (select sched002_retry from sched002_tbjobs where sched002_id=psched002_id), --imposto il retry come da configurazione job
       (select sched002_flg_esecuzioniimmediate from sched002_tbjobs where sched002_id=psched002_id)
       );

   update sched002_tbjobs set sched002_eseguiti=NOW(),sched002_stati=9 where sched002_id=psched002_id;

   INSERT INTO sched004_tbjobstorici(sched004_jobid_id_sched002, sched004_stati, sched004_tempiaggiornamenti, sched004_tipimessaggi, sched004_messaggi) 
   VALUES (psched002_id, 0, NOW(), 7, 'Called startjob()');

   return psched002_id;

ELSE
    return 0;
END IF;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_startjob(bigint)
  OWNER TO postgres;
  
  
  
-- Function: spsched002_stopjob(bigint)

-- DROP FUNCTION spsched002_stopjob(bigint);

CREATE OR REPLACE FUNCTION spsched002_stopjob(psched002_id bigint)
  RETURNS integer AS
$BODY$
BEGIN

IF (select CAST(count(sched003_jobid_id_sched002) as integer) from sched003_tbjobsruntime where sched003_jobid_id_sched002=psched002_id) = 1 THEN
   update sched003_tbjobsruntime set sched003_stati=7,sched003_ultimicontatti=NOW(),sched003_tipomessaggi=1,sched003_ultimimessaggi='stopping' where sched003_jobid_id_sched002=psched002_id; 
   update sched002_tbjobs set sched002_stati=7 where sched002_id=psched002_id;
   return psched002_id;
ELSE
    return 0;
END IF;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_stopjob(bigint)
  OWNER TO postgres;
  
  
  
-- Function: spsched002_treattimeouted()

-- DROP FUNCTION spsched002_treattimeouted();

CREATE OR REPLACE FUNCTION spsched002_treattimeouted()
  RETURNS character varying AS
$BODY$
DECLARE r vsched002_timeoutedjobs%ROWTYPE;
DECLARE _sched002_id bigint;
DECLARE _ids_retry varchar;
DECLARE _ids_retry_res varchar;
DECLARE _ids_failed varchar;
DECLARE _ids_failed_res varchar;
DECLARE p1 varchar;
DECLARE p2 varchar;
DECLARE separatore varchar;
DECLARE risultato varchar;
BEGIN
risultato := '';
_sched002_id := 0;  
_ids_retry := Null;
_ids_failed := Null;
separatore := ',';
p1:= '';
p2:= '';
_ids_retry_res = '';
_ids_failed_res = ''; 
 
FOR r IN select sched002_id,sched003_retryrimanenti from vsched002_timeoutedjobs
LOOP
    IF r.sched003_retryrimanenti > 0 THEN
         IF _ids_retry IS NULL THEN 
              _ids_retry = cast(r.sched002_id as varchar) || ',' ;
         ELSE 
              _ids_retry = _ids_retry || cast(r.sched002_id as varchar) || ',';
         END IF;    
    ELSE
        IF _ids_failed IS NULL THEN 
           _ids_failed = cast(r.sched002_id as varchar) || ','; 
        ELSE
            _ids_failed = _ids_failed || cast(r.sched002_id as varchar) || ',';
        END IF;
    END IF;
    select * from spsched002_processtimeoutedjob(r.sched002_id) into _sched002_id;
END LOOP;

select substring(_ids_retry from char_length(_ids_retry)+0 for char_length(_ids_retry)+1) into p1;
select substring(_ids_failed from char_length(_ids_failed)+0 for char_length(_ids_failed)+1) into p2;

IF  p1 = ',' THEN 
    select trim(trailing ',' from _ids_retry) into _ids_retry_res;
END IF;

IF  p2 like ',' THEN 
    select trim(trailing ',' from _ids_failed) into _ids_failed_res;
END IF;

risultato := _ids_retry_res || '%' || _ids_failed_res;
RETURN  risultato;

END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_treattimeouted()
  OWNER TO postgres;
  
  
  
-- Function: spsched002_updatejob(bigint, smallint, smallint, smallint, integer, smallint, character varying, bigint, character varying, boolean, character varying, bigint, bigint, boolean)

-- DROP FUNCTION spsched002_updatejob(bigint, smallint, smallint, smallint, integer, smallint, character varying, bigint, character varying, boolean, character varying, bigint, bigint, boolean);

CREATE OR REPLACE FUNCTION spsched002_updatejob(psched002_id bigint, psched002_modeesecuzioni smallint, psched002_prioritacpu smallint, psched002_pesi smallint, psched002_timeout integer, psched002_retry smallint, psched002_email character varying, psched002_comando_id bigint, psched002_descrizioni character varying, psched002_flgoutput boolean, psched002_outputfilename character varying, psched002_runasaziendaid bigint, psched002_runasuserid bigint, psched002_flgeximm boolean)
  RETURNS integer AS
$BODY$
declare id_updated integer;

BEGIN
update sched002_tbjobs set 
sched002_id=psched002_id,sched002_modeesecuzioni=psched002_modeesecuzioni,
sched002_prioritacpu=psched002_prioritacpu,sched002_pesi=psched002_pesi,
sched002_timeout=psched002_timeout,sched002_retry=psched002_retry,
sched002_email=psched002_email,sched002_comando_id_nometab=psched002_comando_id,
sched002_descrizioni=psched002_descrizioni,
sched002_flg_output=psched002_flgoutput,sched002_outputfilename=psched002_outputfilename,
sched002_runasazienda_id_bp003=psched002_runasaziendaid,
sched002_runasuser_id_bp001=psched002_runasuserid,
sched002_flg_esecuzioniimmediate=psched002_flgeximm where sched002_id = psched002_id;
id_updated=psched002_id;
return id_updated;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_updatejob(bigint, smallint, smallint, smallint, integer, smallint, character varying, bigint, character varying, boolean, character varying, bigint, bigint, boolean)
  OWNER TO postgres;
-- Function: spsched002_updatejobgui(bigint, smallint, smallint, integer, smallint, character varying, boolean)

-- DROP FUNCTION spsched002_updatejobgui(bigint, smallint, smallint, integer, smallint, character varying, boolean);

CREATE OR REPLACE FUNCTION spsched002_updatejobgui(psched002_id bigint, psched002_modeesecuzioni smallint, psched002_pesi smallint, psched002_timeout integer, psched002_retry smallint, psched002_descrizioni character varying, psched002_flgeximm boolean)
  RETURNS integer AS
$BODY$
declare id_updated integer;

BEGIN
update sched002_tbjobs set 
sched002_modeesecuzioni=psched002_modeesecuzioni,
sched002_pesi=psched002_pesi,
sched002_timeout=psched002_timeout,sched002_retry=psched002_retry,
sched002_descrizioni=psched002_descrizioni,
sched002_flg_esecuzioniimmediate=psched002_flgeximm where sched002_id = psched002_id;
id_updated=psched002_id;
return id_updated;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_updatejobgui(bigint, smallint, smallint, integer, smallint, character varying, boolean)
  OWNER TO postgres;
  
  
  
-- Function: spsched002_updatejobgui(bigint, smallint, smallint, integer, smallint, character varying, character varying, boolean, boolean)

-- DROP FUNCTION spsched002_updatejobgui(bigint, smallint, smallint, integer, smallint, character varying, character varying, boolean, boolean);

CREATE OR REPLACE FUNCTION spsched002_updatejobgui(psched002_id bigint, psched002_modeesecuzioni smallint, psched002_pesi smallint, psched002_timeout integer, psched002_retry smallint, psched002_email character varying, psched002_descrizioni character varying, psched002_flgoutput boolean, psched002_flgeximm boolean)
  RETURNS integer AS
$BODY$
declare id_updated integer;

BEGIN
update sched002_tbjobs set 
sched002_modeesecuzioni=psched002_modeesecuzioni,
sched002_pesi=psched002_pesi,
sched002_timeout=psched002_timeout,sched002_retry=psched002_retry,
sched002_email=psched002_email,
sched002_descrizioni=psched002_descrizioni,
sched002_flg_output=psched002_flgoutput,
sched002_flg_esecuzioniimmediate=psched002_flgeximm where sched002_id = psched002_id;
id_updated=psched002_id;
return id_updated;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_updatejobgui(bigint, smallint, smallint, integer, smallint, character varying, character varying, boolean, boolean)
  OWNER TO postgres;
  
  
  
-- Function: spsched002_updatejobvergine(bigint, smallint, smallint, integer, smallint, character varying, character varying, boolean, boolean, character varying, bigint, bigint, character varying, character varying)

-- DROP FUNCTION spsched002_updatejobvergine(bigint, smallint, smallint, integer, smallint, character varying, character varying, boolean, boolean, character varying, bigint, bigint, character varying, character varying);

CREATE OR REPLACE FUNCTION spsched002_updatejobvergine(psched002_id bigint, psched002_modeesecuzioni smallint, psched002_pesi smallint, psched002_timeout integer, psched002_retry smallint, psched002_email character varying, psched002_descrizioni character varying, psched002_flgoutput boolean, psched002_flgeximm boolean, psched002_modulo character varying, psched002_runasaziendaid bigint, psched002_runasuserid bigint, psched002_ambiente character varying, psched002_procedura character varying)
  RETURNS integer AS
$BODY$
declare id_updated integer;

BEGIN
update sched002_tbjobs set 
sched002_modeesecuzioni=psched002_modeesecuzioni,
sched002_pesi=psched002_pesi,
sched002_timeout=psched002_timeout,sched002_retry=psched002_retry,
sched002_email=psched002_email,
sched002_descrizioni=psched002_descrizioni,
sched002_flg_esecuzioniimmediate=psched002_flgeximm,
sched002_stati=0,
sched002_runasazienda_id_bp003 = psched002_runasaziendaid ,
sched002_runasuser_id_bp001 = psched002_runasuserid ,
sched002_ambiente = psched002_ambiente,
sched002_procedura = psched002_procedura,
sched002_modulo=psched002_modulo 
where sched002_id = psched002_id;
id_updated=psched002_id;
return id_updated;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_updatejobvergine(bigint, smallint, smallint, integer, smallint, character varying, character varying, boolean, boolean, character varying, bigint, bigint, character varying, character varying)
  OWNER TO postgres;
  
  
  
-- Function: spsched002_updatejobvergine(bigint, smallint, smallint, integer, smallint, character varying, character varying, boolean, boolean, character varying, bigint, bigint)

-- DROP FUNCTION spsched002_updatejobvergine(bigint, smallint, smallint, integer, smallint, character varying, character varying, boolean, boolean, character varying, bigint, bigint);

CREATE OR REPLACE FUNCTION spsched002_updatejobvergine(psched002_id bigint, psched002_modeesecuzioni smallint, psched002_pesi smallint, psched002_timeout integer, psched002_retry smallint, psched002_email character varying, psched002_descrizioni character varying, psched002_flgoutput boolean, psched002_flgeximm boolean, psched002_modulo character varying, psched002_runasaziendaid bigint, psched002_runasuserid bigint)
  RETURNS integer AS
$BODY$
declare id_updated integer;

BEGIN
update sched002_tbjobs set 
sched002_modeesecuzioni=psched002_modeesecuzioni,
sched002_pesi=psched002_pesi,
sched002_timeout=psched002_timeout,sched002_retry=psched002_retry,
sched002_email=psched002_email,
sched002_descrizioni=psched002_descrizioni,
sched002_flg_esecuzioniimmediate=psched002_flgeximm,
sched002_stati=0,
sched002_runasazienda_id_bp003 = psched002_runasaziendaid ,
sched002_runasuser_id_bp001 = psched002_runasuserid ,
sched002_modulo=psched002_modulo where sched002_id = psched002_id;
id_updated=psched002_id;
return id_updated;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_updatejobvergine(bigint, smallint, smallint, integer, smallint, character varying, character varying, boolean, boolean, character varying, bigint, bigint)
  OWNER TO postgres;
  
  
  
-- Function: spsched002_userstopjob(bigint)

-- DROP FUNCTION spsched002_userstopjob(bigint);

CREATE OR REPLACE FUNCTION spsched002_userstopjob(psched002_id bigint)
  RETURNS integer AS
$BODY$
BEGIN

IF (select CAST(count(sched003_jobid_id_sched002) as integer) from sched003_tbjobsruntime where sched003_jobid_id_sched002=psched002_id) = 1 THEN
   update sched003_tbjobsruntime set sched003_stati=7,sched003_ultimicontatti=NOW(),sched003_ultimimessaggi='stopping',sched003_user_stop=True where sched003_jobid_id_sched002=psched002_id; 
   update sched002_tbjobs set sched002_stati=7 where sched002_id=psched002_id;
   return psched002_id;
ELSEIF (select CAST(count(sched002_id) as integer) from sched002_tbjobs where sched002_id=psched002_id and sched002_Stati=0) = 1 THEN
     update sched002_tbjobs set sched002_stati=5,sched002_terminati=NOW() where sched002_id=psched002_id;
     return psched002_id;
ELSE
    return 0;
END IF;

END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_userstopjob(bigint)
  OWNER TO postgres;
  


-- Function: spsched002_userkilljob(bigint)

-- DROP FUNCTION spsched002_userkilljob(bigint);
CREATE OR REPLACE FUNCTION public.spsched002_userkilljob (
  psched002_id bigint
)
RETURNS integer AS
$body$
BEGIN

IF (select CAST(count(sched003_jobid_id_sched002) as integer) from sched003_tbjobsruntime where sched003_jobid_id_sched002=psched002_id) = 1 THEN
   update sched003_tbjobsruntime set 
   									sched003_stati=7,
                                    sched003_ultimicontatti=NOW(),
                                    sched003_ultimimessaggi='stopping',
                                    sched003_user_stop=True, 
                                    sched003_user_stop_time = NOW(),
                                    sched003_abortforkill= True 
   			where sched003_jobid_id_sched002=psched002_id; 
   update sched002_tbjobs set sched002_stati=7 where sched002_id=psched002_id;
   return psched002_id;
ELSEIF (select CAST(count(sched002_id) as integer) from sched002_tbjobs where sched002_id=psched002_id and sched002_Stati=0) = 1 THEN
     update sched002_tbjobs set sched002_stati=5,sched002_terminati=NOW() where sched002_id=psched002_id;
     return psched002_id;
ELSE
    return 0;
END IF;

END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;
  


  
-- Function: spsched002_userstoppedjob(bigint)

-- DROP FUNCTION spsched002_userstoppedjob(bigint);

CREATE OR REPLACE FUNCTION spsched002_userstoppedjob(psched002_id bigint)
  RETURNS boolean AS
$BODY$
declare count bigint;
BEGIN

select count(*) into count from sched003_tbjobsruntime where sched003_jobid_id_sched002=psched002_id and sched003_user_stop=True;
IF (count = 1) THEN
   return True;
ELSE 
   return False;
END IF;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched002_userstoppedjob(bigint)
  OWNER TO postgres;
-- Function: spsched003_invokecrashmanager()

DROP FUNCTION IF EXISTS spsched003_invokecrashmanager();



-- Function: spsched003_proclistener(bigint, integer, character varying, bigint, bigint, integer)

-- DROP FUNCTION spsched003_proclistener(bigint, integer, character varying, bigint, bigint, integer);

CREATE OR REPLACE FUNCTION spsched003_proclistener(pproclistener_jobid bigint, pproclistener_msgtype integer, pproclistener_msg character varying, proclistener_tid bigint, proclistener_pid bigint, proclistener_percentage integer)
  RETURNS integer AS
$BODY$
declare jobid integer;

BEGIN
jobid=0;
CASE pproclistener_msgtype
     WHEN 1 THEN
          IF proclistener_tid is not NULL THEN
             IF proclistener_pid is NULL THEN             
                update sched003_tbjobsruntime set sched003_stati=1,sched003_tidthreads=proclistener_tid,sched003_ultimicontatti=DEFAULT,sched003_ultimimessaggi=pproclistener_msg,sched003_tipomessaggi=1 where sched003_jobid_id_sched002=pproclistener_jobid;
                update sched002_tbjobs set sched002_stati=1 where sched002_id=pproclistener_jobid;
                jobid = pproclistener_jobid;
             END IF;
          END IF;
          IF proclistener_pid is not NULL THEN
             IF proclistener_tid is NULL THEN
                update sched003_tbjobsruntime set sched003_stati=1,sched003_pidprocessi=proclistener_pid,sched003_ultimicontatti=DEFAULT,sched003_ultimimessaggi=pproclistener_msg,sched003_tipomessaggi=1 where sched003_jobid_id_sched002=pproclistener_jobid;
                update sched002_tbjobs set sched002_stati=1 where sched002_id=pproclistener_jobid;
                jobid = pproclistener_jobid;
              END IF;
          END IF;
     WHEN 2 THEN
          update sched003_tbjobsruntime set sched003_stati=10,sched003_ultimicontatti=DEFAULT,sched003_ultimimessaggi=pproclistener_msg,sched003_tipomessaggi=2 where sched003_jobid_id_sched002=pproclistener_jobid;
          update sched002_tbjobs set sched002_stati=10 where sched002_id=pproclistener_jobid;
          delete from sched003_tbjobsruntime  where sched003_jobid_id_sched002=pproclistener_jobid;
          jobid=pproclistener_jobid;
     WHEN 3 THEN
          update sched003_tbjobsruntime set sched003_percentualicompletamento=proclistener_percentage,sched003_ultimicontatti=DEFAULT,sched003_ultimimessaggi=pproclistener_msg,sched003_tipomessaggi=3 where sched003_jobid_id_sched002=pproclistener_jobid;
          update sched002_tbjobs set sched002_percentualicomp=proclistener_percentage where sched002_id=pproclistener_jobid;
          jobid=pproclistener_jobid;   
     WHEN 4 THEN
          update sched003_tbjobsruntime set sched003_ultimicontatti=DEFAULT,sched003_ultimimessaggi=pproclistener_msg,sched003_tipomessaggi=4 where sched003_jobid_id_sched002=pproclistener_jobid;
          jobid=pproclistener_jobid;          
     WHEN 5 THEN
          update sched002_tbjobs set sched002_stati=4,sched002_terminati=NOW(),sched002_percentualicomp=100 where sched002_id=pproclistener_jobid;
          update sched003_tbjobsruntime set sched003_stati=4,sched003_ultimicontatti=DEFAULT,sched003_ultimimessaggi=pproclistener_msg,sched003_tipomessaggi=5 where sched003_jobid_id_sched002=pproclistener_jobid;
          delete from sched003_tbjobsruntime where sched003_jobid_id_sched002=pproclistener_jobid;
          jobid=pproclistener_jobid;          
     WHEN 6 THEN
          update sched003_tbjobsruntime set sched003_stati=1,sched003_ultimicontatti=DEFAULT,sched003_ultimimessaggi=pproclistener_msg,sched003_tipomessaggi=6 where sched003_jobid_id_sched002=pproclistener_jobid;
          jobid=pproclistener_jobid;          
     END CASE;
return jobid;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION spsched003_proclistener(bigint, integer, character varying, bigint, bigint, integer)
  OWNER TO postgres;

-- 
DROP TRIGGER IF EXISTS sched003_t01i_jobscreate ON sched003_tbjobsruntime CASCADE;
CREATE TRIGGER sched003_t01i_jobscreate
  AFTER INSERT
  ON sched003_tbjobsruntime
  FOR EACH ROW
  EXECUTE PROCEDURE spsched003_logjobcreation();

DROP TRIGGER IF EXISTS sched003_t02u_jobsupdate ON sched003_tbjobsruntime cascade;
CREATE TRIGGER sched003_t02u_jobsupdate
  AFTER UPDATE
  ON sched003_tbjobsruntime
  FOR EACH ROW
  EXECUTE PROCEDURE spsched003_logjobupdate();

COMMIT;
