var ALYCE_PROTOCOL = new function () {

    this.send_command = function (cmd) {
        cmd["_cx"] = GE_CHANNEL;
        var data = JSON.stringify(cmd);
        data += "\n";
        if (WS_CONNECTION.isConnected()) {
            WS_CONNECTION.send(data);
        }
    };

    this.parseAlyceMessage = function (msg) {
        var cmd = msg['proteotodevicecommand'];
        if (cmd === 'vbrenderaction' || cmd === 'VBRenderAction') {
            var part, iii;
            for (iii = 0; iii < msg.parts.length; iii++) {
                part = msg.parts[iii];
                part['_cx'] = msg['_cx'];
                PROTOCOL.parseRequest(part);
            }
        } else {
            var err = "ignorato messaggio alyce";
            console.log(err, msg);
            throw new Error(err);
        }
    };

    this.onMessage = function (data) {
        var direction = data['direction'];
        if (direction === 'ProteoToDevice') {
            this.parseAlyceMessage(data);
        } else {
            var err = 'unhandled message';
            console.log(err, data);
            throw new Error(err);
        }
    };

    this.alyceHeaderCommand = function (messagetype, direction, ignoreActiveWindowHandle) {
        var command = {
            "id": this.guid(),
            "action": "proteo",
            "messagetype": messagetype, //"Request",        		
            "direction": direction
        }
        

        // ma.montesi - 15/07/2015
        // chiamo getActiveWindow con il flag di override per farmi tornare SEMPRE l'id della form attiva, anche in caso di modali
        // altrimenti i messaggi di ritorno delle dialog non avrebbero il parametro formId 
        // e non potrebbero essere indirizzati alla form corretta
        var aw = UI.getActiveWindow(true);
        if (aw) {            
            if (ignoreActiveWindowHandle === true) {
                console.log('command.formid not set');
            } else {
                command.formid = aw.handle;
            }
        }
        return command;
    };

    /**
     * Get the right widget form id
     * @param widgetInstance
     * @returns {*}
     */
    this.getWidgetFormId = function (widgetInstance,ignoreActiveWindowHandle) {
        var formId;
        if(widgetInstance && widgetInstance.getTopParent && widgetInstance.getTopParent()){
            formId = widgetInstance.getTopParent().handle;
            return formId;
        }

        // ma.montesi - 15/07/2015
        // chiamo getActiveWindow con il flag di override per farmi tornare SEMPRE l'id della form attiva, anche in caso di modali
        // altrimenti i messaggi di ritorno delle dialog non avrebbero il parametro formId
        // e non potrebbero essere indirizzati alla form corretta
        var aw = UI.getActiveWindow(true);
        if (aw) {
            if (ignoreActiveWindowHandle === true) {
                console.log('command.formid not set');
            } else {
                formId = aw.handle;
            }
        }
        return formId
    };

    this.alyceCommand = function (command, commandType, parts) {
        var properties = {
            "devicetoproteocommand": commandType,
            "parts": parts
        }
        return this.join(properties, command);
    };

    this.join = function (properties, command) {
        for (var attrname in properties) {
            if (properties[attrname] != null)
                command[attrname] = properties[attrname];
        }
        return command;
    };

    this.guid = (function () {
        function s4() {
            return Math.floor((1 + Math.random()) * 0x10000)
                .toString(16)
                .substring(1);
        }

        return function () {
            return s4() + s4() + '-' + s4() + '-' + s4() + '-' +
                s4() + '-' + s4() + s4() + s4();
        };
    })();

    this.queryData = function (cx, handle) {
        UI.showLoadingCursor(true, true);
        var part = '{"_cx":' + cx + ',"action":"querydata","control":"' + handle + '"}';
        var parts = [{
            type: 'VBRenderAction',
            vbrenderaction: part
        }];
        var header = ALYCE_PROTOCOL.alyceHeaderCommand("Action", "DeviceToProteo");
        var command = ALYCE_PROTOCOL.alyceCommand(header, "VBRenderAction", parts);
        command.hosttype = 2; // HostType.Component        
        var msg = JSON.stringify(command) + '\n';
        WS_CONNECTION.send(msg);
    };
};