/* Italian initialisation for the jQuery UI date picker plugin. */
(function( factory ) {
    if ( typeof define === "function" && define.amd ) {

        // AMD. Register as an anonymous module.
        define([ "../jquery.ui.datepicker" ], factory );
    } else {

        // Browser globals
        if (jQuery.datepicker) {
            factory(jQuery.datepicker);
        }
    }
}(function( datepicker ) {
    datepicker.regional['de'] = {
        closeText: 'Schließen',
        prevText: 'Vormonat',
        nextText: 'Nächster Monat',
        currentText: 'Heute',
        monthNames: ['Januar', 'Februar', 'März', 'April', 'Mai', 'Juni', 'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember'],
        monthNamesShort: ['Jan', 'Feb', 'Mär', 'Apr', 'Mai', 'Jun', 'Jul', 'Aug', 'Sep', 'Okt', 'Nov', 'Dez'],
        dayNames: ['Sonntag', 'Montag', 'Dienstag', 'Mittwoch', 'Donnerstag', 'Freitag', 'Samstag'],
        dayNamesShort: ['Son', 'Mon', 'Die', 'Mit', 'Don', 'Fre', 'Sam'],
        dayNamesMin: ['Son', 'Mon', 'Die', 'Mit', 'Don', 'Fre', 'Sam'],
        weekHeader: 'Woc',
        dateFormat: 'dd/mm/yy',
        firstDay: 1,
        isRTL: false,
        showMonthAfterYear: false,
        yearSuffix: ''
	};
//    datepicker.setDefaults(datepicker.regional['de']);
    return datepicker.regional['de'];

}));
