/**
 * Enable support for jquery.ui.draggable on touchable device.
 * @author Domenico D'Ercole
 */
(function($){
    $(document).on('ready', function(){
        /**
         * Check if the app is running on a mobile device.
         * @type {boolean}
         */
        var isMobileDev = false;
        try {
            if(isMobileDevice()){
                isMobileDev = true;
            }
        } catch(ex){
            console.log("isMobileDevice is not defined");
            if('ontouchstart' in document){
                // touch device
                isMobileDev = true;
            }
        }
        if(!isMobileDev){
            return;
        }
        /**
         * This handler dispatch fake mouse event based on touch event.
         * @param event
         * @private
         */
        function touchHandler(event) {
            try {
                var touch = event.changedTouches[0],
                    target = touch.target;
                if(!$(target).hasClass('ui-draggable-handle') && !$(target).parent().hasClass('ui-draggable-handle')){
                    // this restriction prevent every issue with scrollable (therefore not draggable) widgets.
                    // ex. combobox and so on!
                    return;
                }
                var type = {
                    touchstart: "mousedown",
                    touchmove: "mousemove",
                    touchend: "mouseup",
                    touchcancel: "mouseup"
                }[event.type];
                if(event.type === 'touchmove'){
                    event.preventDefault();
                }
                var customEvent = document.createEvent("MouseEvent");
                // init new simulated event, using touch event
                customEvent.initMouseEvent(
                    type,          // type
                    true,          // bubbles
                    true,          // cancelable
                    window,        // view
                    1,             // detail
                    touch.screenX, // screenX
                    touch.screenY, // screenY
                    touch.clientX, // clientX
                    touch.clientY, // clientY
                    false,         // ctrlKey
                    false,         // altKey
                    false,         // shiftKey
                    false,         // metaKey
                    0,             // button
                    null           // relatedTarget
                );
                target.dispatchEvent(customEvent);
            } catch(ex){
                console.error(ex);
            }
        }
        // add events listener on capture
        document.addEventListener("touchstart", touchHandler, true);
        document.addEventListener("touchmove", touchHandler, true);
        document.addEventListener("touchend", touchHandler, true);
        document.addEventListener("touchcancel", touchHandler, true);
    });
})(jQuery);
