/**
 * Created by s.cosma on 18/07/2016.
 */
require([
    'plugins/dom_grid/GridManager',
    "plugins/dom_grid/modules/CustomHeader",
    'dojo/_base/lang'
], function (GridManager, CustomHeader, lang) {
    grid = new GridManager({
        id: 'grid-1',
        width: 900,
        height: 400,
        container: 'grid-c-cnt',
        modules: ["plugins/dom_grid/modules/CustomHeader"],
        layout: [
            {
                id: 'name',
                name: 'Nome',
                width: '300px',
                sorted: 'ASC',
                band: "band1"
            },
            {
                id: 'surname',
                name: 'Cognome',
                width: '300px',
                headerAlign: 'center',
                align: 'left',
                band: "band1"
            },
            {
                id: 'address',
                name: 'Indirizzo',
                width: '300px',
                sorted: 'ASC',
                band: "band2"
            }
        ],
        data: [{
            id: 1,
            name: 'Simone',
            surname: 'Cosma',
            address: 'Fabriano'
        }, {
            id: 2,
            name: 'Domenico',
            surname: 'D\'Ercole',
            address: 'Matera'

        }],
        options: {
            idProperty: 'id',
            bands: true
        },
        advOptions:{
            bandsDefinition: [
                {id: 'band1', name: 'Informazioni'},
                {id: 'band2', name: 'Ind'}
            ],
            bandsHideOnStart: false,
            headerHidden: false,
            headerHiddenColumnsTitle: true
        }
    });
    grid.startup();
});