/**
 * Created by s.cosma on 18/07/2016.
 */
require([
    'plugins/dom_grid/GridManager',
    "plugins/dom_grid/modules/CustomHeader"
], function (GridManager, CustomHeader) {

    var data = [];

    for(var i= 0; i<300;i++){
        data.push({
            id: i,
            name: 'Simone',
            surname: 'Cosma',
            address: ['Fabriano', i].join(' ')
        });
    }

    grid = new GridManager({
        id: 'grid-1',
        width: 400,
        height: 400,
       // mobile: true,
        container: 'grid-c-cnt',
        modules: ["plugins/dom_grid/modules/CustomHeader"],
        layout: [
            {
                id: 'name',
                name: 'Nome',
                width: '300px',
                sorted: 'ASC',
                band: "band1"
            },
            {
                id: 'surname',
                name: 'Cognome',
                width: '300px',
                headerAlign: 'center',
                align: 'left',
                band: "band1"
            },
            {
                id: 'address',
                name: 'Indirizzo',
                width: '900px',
                sorted: 'ASC',
                band: "band2"
            }
        ],
        data: data,
        options: {
            idProperty: 'id',
            enableMobileScrollbars: true
        },
        advOptions:{
            bandsDefinition: [
                {id: 'band1', name: 'Informazioni'},
                {id: 'band2', name: 'Ind'}
            ],
            headerHidden: false
        },
        onVScroll: function (e) {
            console.log(e,"sa");
        }

    });
    grid.startup();
});