/**
 * Created by s.cosma on 18/07/2016.
 */
require([
    'plugins/dom_grid/GridManager',
    "plugins/dom_grid/modules/CustomHeader",
    'dojo/_base/lang'
], function (GridManager, CustomHeader, lang) {
    grid = new GridManager({
        id: 'grid-1',
        width: 610,
        height: 400,
        container: 'grid-c-cnt',
        modules: ["plugins/dom_grid/modules/CustomHeader"],
        layout: [
            {
                id: 'name',
                name: 'Nome Utente1',
                width: '300px',
                sorted: 'ASC',
                filters: {},
                content: {
                    type:'span',
                    contentClass: "icon-thumbs-up",
                    extraClass: "headerIconZeroLeft",
                    callback: function(e, id) {
                        var nextClass = grid.col('name').def().content.contentClass == 'icon-thumbs-up'? 'icon-thumbs-down' : 'icon-thumbs-up';
                        grid.gridx.customHeader.changeCustomClass(id, nextClass);
                    }
                }
            },
            {
                id: 'utente',
                name: 'Utente Attivo',
                width: '300px',
                type: 'checkbox',
                headerAlign: 'center',
                align: 'left'
            }
        ]
    });
    grid.startup();
});