require(['plugins/dom_grid/base',
         'plugins/dom_grid/editable',
         'dojo/on',
         'dojo/aspect',
         'dojo/_base/lang'
    ], function( dom_grid, editable_dom_grid, on, aspect, lang ){

    VBR_DEBUG = true;

    //datastore
    names = [
        "Mario Rossi",
        "Mario Bianchi",
        "Mario Verdi",
        "John Doe",
        "John Smith",
        "Foo",
        "Jimi Hendrix",
        "Frank Sinatra",
        "Andres Segovia",
        "Dixie dregs"
    ];
    ds =  [];
    comboStore = [
      { id: 0, Name: "" },
      { id: 1, Name: "Bari"},
      { id: 2, Name: "Fabriano"},
      { id: 3, Name: "Matera"},
      { id: 4, Name: "Pesaro"}
    ];

    cStore2 = [
      { id: 0, Name: "" },
      { id: 1, Name: "Milano"},
      { id: 2, Name: "Bologna"},
      { id: 3, Name: "Firenze"},
      { id: 4, Name: "Napoli"}
    ];

    _iconsDictionary = {
        0: "icon_test",
        1: "icon_test2"
    };

    var b64_example = "data:image/jpeg;base64,/9j/4AAQSkZJRgABAQEAYABgAAD/4QBoRXhpZgAATU0AKgAAAAgABAEaAAUAAAABAAAAPgEbAAUAAAABAAAARgEoAAMAAAABAAIAAAExAAIAAAASAAAAT"
                        +"gAAAAAAAABgAAAAAQAAAGAAAAABUGFpbnQuTkVUIHYzLjUuMTEA/9sAQwABAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQE"
                        +"BAQEB/9sAQwEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEB/8AAEQgAEAAQAwEiAAIRAQMRAf/EAB8AAAEFAQEBAQ"
                        +"EBAAAAAAAAAAABAgMEBQYHCAkKC//EALUQAAIBAwMCBAMFBQQEAAABfQECAwAEEQUSITFBBhNRYQcicRQygZGhCCNCscEVUtHwJDNicoIJChYXGBkaJSYnKCkqNDU2Nzg5OkNERUZHSE"
                        +"lKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6g4SFhoeIiYqSk5SVlpeYmZqio6Slpqeoqaqys7S1tre4ubrCw8TFxsfIycrS09TV1tfY2drh4uPk5ebn6Onq8fLz9PX29/j5+v/EAB8BAAM"
                        +"BAQEBAQEBAQEAAAAAAAABAgMEBQYHCAkKC//EALURAAIBAgQEAwQHBQQEAAECdwABAgMRBAUhMQYSQVEHYXETIjKBCBRCkaGxwQkjM1LwFWJy0QoWJDThJfEXGBkaJicoKSo1Njc4OTpDR"
                        +"EVGR0hJSlNUVVZXWFlaY2RlZmdoaWpzdHV2d3h5eoKDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uLj5OXm5+jp6vLz9PX29/j5+v/aAAwD"
                        +"AQACEQMRAD8A/nu/4KHf8E/Rrw8RftBfA/SguvKNR8Q/E/wLaEAa+ANa17xH8QtIuNR1bA18DyI9R8K6XY418b9R0qH/AISD7Va+IPFP2Lf2PP7A/sf4yfFbTFbXmW21TwH4RvY4pY9Djlis"
                        +"r/S/F+qiK6df+Eg2vJ/Zei3tsr+HHVNSu0XxCtpH4f8A6HK8A+Ingi5sri78S6WJ7uwu53udWtQJJ7jTrmeS2j+0WcMFq0s2mTStcXmpS3E7SaTI0lxuOjmQaN/qT9J76KuX4bFY/wAVvD/K5"
                        +"+yU6mN4s4WwNCLw2Hm+eriOJcsw0LSjQjJe0zbAUKc6dFzlmdOFPDU8Z7L8p/YVfS0+j9ivpEcIeEf0zs1h7bkwOB8AuK+J6+HXBeJ46WLo0sn4Y8RsTi7xliJRdOnwNmGY1IZVXziFDK86nUxVTJvbf//Z";

    function example_callback( e, cell )
    {
        alert("click on widget");
    };
    function example_callback2( e, cell )
    {
        alert("click on widget 2");
        console.log( "click on widget 2", e, cell );
    };

    if(false === true)
    {
        for (var index = 0; index < 20; index ++ )
        {
            ds.push({
                kid: "00"+index,
                //expandCol: { text: "TreeCell Text Example", icon1Class: "icon_test", callbackIcon1: example_callback, icon2: b64_example, callbackIcon2: example_callback },
                Name: names[Math.floor((Math.random()*10))]/*+ "_" +Math.floor((Math.random()*10)+1)*/,
                Date: '14/01/'+(Math.floor((Math.random()*10)+1)+2000),
                Number: Math.floor(Math.random()*30)+1,
                Active: Math.round(Math.random()),
                City: Math.floor(Math.random()*4)+1,//comboStore[Math.floor((Math.random()*4))].Name,
                Image: index > 10 ? 0 : { icon: b64_example, height: "16px", width: "16px", callback: example_callback }, // b64 example. n.b. all url type supported
                ImageByClass: index > 10 ? undefined : { class: "icon_test", height: "16px", width: "16px", callback: example_callback }, // class example
                Hyperlink: index > 10 ? undefined : { text: "Esegui!", callback: example_callback },
                Time: '12:00',
                children: []
            });
        }
        //for (var index = 0; index < 20; index ++ )
        //{
        //    ds[0].children.push({
        //        kid: "01"+index,
        //        Name: names[Math.floor((Math.random()*10))]/*+ "_" +Math.floor((Math.random()*10)+1)*/,
        //        Date: '14/01/'+(Math.floor((Math.random()*10)+1)+2000),
        //        Number: Math.floor(Math.random()*30)+1,
        //        Active: Math.round(Math.random()),
        //        City: Math.floor(Math.random()*4)+1,//comboStore[Math.floor((Math.random()*4))].Name,
        //        //Image: index > 10 ? undefined : { icon: b64_example, height: "16px", width: "16px", callback: example_callback }, // b64 example. n.b. all url type supported
        //        //ImageByClass: index < 10 ? "" : { "class": "icon_test", height: "16px", width: "16px", callback: example_callback }, // class example
        //        //Hyperlink: index < 10 ? "" : { text: "click here", callback: example_callback },
        //        Time: '12:00'
        //    });
        //}

        layout = [
            { field: "Active", name:"Active", width: '40px', editable: true, alwaysEditing: true, type: 'boolean', props : { widget: 'checkbox' /* or use 'custom' template */ } },
            { field: "Name", name:"Name", editable: true, alwaysEditing: true, type: 'string' /*, expandLevel: 'all'*/ }, // add expandLevel: 'all' for grouping support
            { field: "Date", name:"Date", width: '70px', editable: true, alwaysEditing: true, type: 'date', props: { /*format: 'MM/dd/yyyy'*/ } },
            { field: "City", name:"City", align: "right", width: '70px', editable: true, alwaysEditing: true, type: 'combobox', props: { source: comboStore, text: "Name"/*, value: "id", fired: "id"*/ } },
            { field: "Time", name: "Time", width: '50px', editable: true, alwaysEditing: true, type: 'time' },
            { field: "Number", name:"Number", width: '60px', editable: true, alwaysEditing: true, type: 'number' },
            { field: "Image", name:"Image", width: '60px', type: 'image', props: { callback: example_callback2, source: _iconsDictionary } },
            { field: "ImageByClass", name:"ImageByClass", width: '60px', type: 'image', props: { callback: example_callback2 } },
            { field: "Hyperlink", name:"Hyperlink", width: '60px', type: 'hyperlink', props: { callback: example_callback2 } }
        ];

        bands1 = [
            { id: "band1", name: "Dati principali", locked: true, align: 'left', columns: [ "Active" ] },
            { id: "band2", name: "Informazioni", columns: ["Name", "City"] }
        ];

        grid = new dom_grid({
        //grid = new editable_dom_grid({
            id: 'dom_grid_id',
            container: "dom_grid_container", // or use: 'grid.placeAt("dom_grid_container")', default is:  'document.body'
            height: 300,
            width: 650,
            data: ds,
            layout: layout,
            //bands: bands1,
            modules: [],
            options: {
                //dataSourceIdentifier: 'qid', // optional, kid = default
                //rowHeader: true,
                resizable: true,
                //sorting: 'single',    // or multiple, disable is default
                //columsToLock: 1,      // num of left-locked cols
                columnsDnd: true, // false is default
                //columnsDndViewMode: false, // false is default
                groupable: true,      // false is default
                //groupRowsViewMode: true,
                //groupRowsHideGroupBarOnStartup: true,
                //groupRowsDisableGroupingOnStartup: true,
                treeGrid: true,
                selection: 'single'     // or multiple, none is default
            },
            onRowClick: function(event){
                //console.log("click", event, "x: " + event.offsetX + ", y: " + event.offsetY);
                console.log("click", grid.getRowById(event.rowId), event);
            },
            onRowDblClick: function(event){
                console.log("dbl-clck", grid.getRowById(event.rowId));
            },/*,
            onStart: function(){
                console.log("started");
            },
            onDestroy: function(){
                //console.log("destroyed");
            },
            onBeginEdit: function(cell){
                console.log("onBeginEdit", cell);
            },
            onEndEdit: function(cell, success){
                console.log("onEndEdit", grid.getCellValue(cell.row.id, cell.column.id), success);
            }*/
        });
        //grid.placeAt("dom_grid_container");
        //grid.startup();

        // grouping event
        //grid.onRowGrouping(function(groups, target, action)
        //{
        //    console.log("Grouping event: ", groups, ", target: ", target, ", action: ", action);
        //});

        //grid.onStoreUpdate(function( e )
        //{
        //    console.log("storeUpdate: " + e.emit_type);
        //});

        //grid.setDataStore([]);

        //grid.refresh();

        //grid.resize(w=600, h=500);


        //eventi gestiti a run-time
    //    grid.onRowClick(function(event)
    //    {
    //        console.log("clck", event.rowId);
    //    });
    //    grid.onRowDblClick(function(event)
    //    {
    //        console.log("dbl-clck", event.rowId);
    //    });

    //    grid.onBeginEdit(function(cell)
    //    {
    //        document.editedCell = cell;
    //        console.log(cell);
    //    });


        // regenerate tests
        //layout.push({ field: "myCol", name: "MyCol", type: "image" });
        //layout[2].width = "20px";

        newLayout = [
                  { field: "Name", name:"Name" },
                  { field: "Active", name:"Active", width: '40px', editable: true, alwaysEditing: true, type: 'boolean', props : { widget: 'checkbox' } },
                  { field: "Number", name:"Number" }
              ];

        //grid.onRegenerate(function(){ console.log("regenerated"); });
        //grid.regenerate(layout);


        //tools
        //grid.query("expandLevel", "all", grid.layout);

        //combo view mode val()
        //grid.getCell("003", "City").widget().val()

        //for (var index = 0; index < 10; index ++ )
        //{
        //    grid.addRow({
        //        kid: "1"+index,
        //        Name: "num_1",
        //        Date: '01/01/2012',
        //        Number: 1,
        //        Active: true,
        //        Time: '00:00',
        //        City: 1,
        //        Image: "",
        //        ImageByClass: "",
        //        Hyperlink: "",
        //        parentId: "000"
        //    });
        //}
        //for (var index = 0; index < 10; index ++ )
        //{
        //    grid.addRow({
        //        kid: "2"+index,
        //        Name: "num_2",
        //        Date: '01/01/2013',
        //        Number: 2,
        //        Active: false,
        //        Time: '00:01',
        //        City: 2,
        //        Image: "",
        //        ImageByClass: "",
        //        Hyperlink: "",
        //        parentId: "10"
        //    });
        //}
        //grid.refresh()

        //grid.onTopRowChange(function(rowId)
        //{
        //    console.log("rowOnTop", rowId);
        //});
        //grid.onLeftColumnChange(function(colId)
        //{
        //    console.log("columnOnLeft", colId);
        //});
        //grid.onColumnResize(function(colId, newWidth, oldWidth)
        //{
        //    console.log("columnResize: ", colId, newWidth, oldWidth);
        //});
        //
        //grid.onColumnHide(function(colId)
        //{
        //    console.log("columnHide: ", colId);
        //});
        //grid.onColumnShow(function(colId)
        //{
        //    console.log("columnShow: ", colId);
        //});
        //
        //grid.onColumnDnd(function(origId, destId, origIndex, destIndex)
        //{
        //    console.log("columnDnd: ", origId, destId, origIndex, destIndex);
        //    //grid.moveColumn( origId, destId );
        //});
        //
        //grid.onRowExpand(function(rowId)
        //{
        //    console.log("onRowExpand: ", rowId);
        //});
        //grid.onRowCollapse(function(rowId)
        //{
        //    console.log("onRowCollapse: ", rowId);
        //});

        document.menu = $("#menu").dom_menu({
           width : 200
        }, function callback(msg){
           console.log("selected: " + msg);
        });
        document.menu.add({
               id    : "sayHello",
               text    : "Say Hello!",
               value    : "Say Hello!"
            });
        document.menu.close();
        grid.onDxClick(function(event, gridTarget)
        {
            console.log("Right-click", gridTarget);
            document.menu.add({
               id    : gridTarget.type+"_"+gridTarget.columnId+"_"+gridTarget.rowId,
               text    : gridTarget.type+"_"+gridTarget.columnId+"_"+gridTarget.rowId,
               value    : gridTarget.type+"_"+gridTarget.columnId+"_"+gridTarget.rowId
            });
            document.menu.open(event.pageX, event.pageY);
        });

        //[ GRID 2 ] ---------------------------------------------------------------------------------------------
        layout2 = [
            { field: "Active", name:"Active", width: '100px', editable: true, alwaysEditing: true, type: 'boolean', props : { widget: 'checkbox' } },
            { field: "Name", name:"Name", editable: true, alwaysEditing: true, type: 'string' },
            { field: "Date", name:"Date", width: '70px', editable: true, alwaysEditing: true, type: 'date' },
            { field: "City", name:"City", align: "right", width: '70px', editable: true, alwaysEditing: true, type: 'combobox', props: { source: comboStore, text: "Name" } },
            { field: "Time", name: "Time", width: '50px', editable: true, alwaysEditing: true, type: 'time' },
            { field: "Number", name:"Number", width: '60px', align: "center", editable: true, alwaysEditing: true, type: 'number' },
            { field: "Image", name:"Image", width: '60px', type: 'image' },
            { field: "ImageByClass", name:"ImageByClass", width: '60px', type: 'image' },
            { field: "Hyperlink", name:"Hyperlink", width: '60px', type: 'hyperlink', align: "center" }
        ];

        layout3 = [
                   {"field":"DESCR","name":"Etichetta","width":"160px","align":"left","displayformat":"","bandindex":0,"columtype":{"type_num":1}},
                   {"field":"VALORE","name":"Valore","width":"267px","align":"left","displayformat":"","bandindex":0,"columtype":{"type_num":1}}
                   ];

        ds2 = [];
        ds2.push({
            kid: "0",
            Name: "1st group",
            City: 1,
            //_expandCol: "1st group",
            _iconsDictionary__: { i: 0, s: 1 },
            children: []
        });
        for (var index = 0; index < 5000; index ++ )
        {
            ds2[0].children.push({
                kid: "00"+index,
                Name: names[Math.floor((Math.random()*10))]+ "_" +Math.floor((Math.random()*10)+1),
                Date: '14/01/'+(Math.floor((Math.random()*10)+1)+2000),
                Number: Math.floor(Math.random()*30)+1,
                Active: Math.round(Math.random()),
                City: Math.floor(Math.random()*4)+1,//comboStore[Math.floor((Math.random()*4))].Name,
                Image: index < 10 ? "" : { icon: b64_example, height: "16px", width: "16px", callback: example_callback }, // b64 example. n.b. all url type supported
                ImageByClass: index < 10 ? "" : { class: "icon_test", height: "16px", width: "16px", callback: example_callback }, // class example
                Hyperlink: index < 10 ? "" : { text: "click here", callback: example_callback },
                Time: '12:00',
                __extra__: { i: 1, s: 0 }
            });
        }

        //ds3 = [{"DESCR":"Codice menu","VALORE":"36428"},
        //       {"DESCR":"Descrizione","VALORE":"Anagrafiche di Base"},
        //       {"DESCR":"IdVoceTs","VALORE":""},{"DESCR":"Pgm. da eseguire","VALORE":""},
        //       {"DESCR":"Percorso pgm.","VALORE":""},{"DESCR":"Parametro","VALORE":""},
        //       {"DESCR":"Alias","VALORE":""},{"DESCR":"Tipo voce","VALORE":"Modulo"},
        //       {"DESCR":"Applicazione","VALORE":"Tutti"},
        //       //{"DESCR":"Modalit&_224; esecuzione","VALORE":"###"},
        //       //{"DESCR":"Modalità apertura","VALORE":""},
        //       {"DESCR":"Tipo programma","VALORE":""},
        //       {"DESCR":"Richiesta azienda","VALORE":"No"},
        //       {"DESCR":"Visibile","VALORE":"Si"},{"DESCR":"Helpfile","VALORE":""},{"DESCR":"Range licenza, da","VALORE":""},
        //       {"DESCR":"Range licenza, a","VALORE":""},{"DESCR":"Schedulabile","VALORE":"No"},
        //       {"DESCR":"Data inserimento","VALORE":"1/1/2008"},
        //       {"DESCR":"Data modifica","VALORE":"1/1/2008"},{"DESCR":"Rel. di pubblicazione","VALORE":"03.01.00"}];

        grid2 = new /*editable_*/dom_grid({
            id: 'dom_grid_id_2',
            container: "dom_grid_container_2",
            height: 300,
            width: 650,
            data: ds2,
            layout: layout2,
            //dataSourceIdentifier : "DESCR",
            modules: [],
            options: {
                //dataSourceIdentifier: 'qid', // optional, kid = default
                //dataSourceIdentifier : "DESCR",
                //rowHeader: true,
                resizable: true,
                sorting: 'single',    // or multiple, disable is default
                //columsToLock: 1,      // num of left-locked cols
                columnsDnd: true, // false is default
                //columnsDndViewMode: false, // false is default
                //groupable: true,      // false is default
                //groupRowsViewMode: true,
                //groupRowsHideGroupBarOnStartup: true,
                //groupRowsDisableGroupingOnStartup: true,
                treeGrid: true,
                selection: 'single'     // or multiple ( ctrl+click for multi-row selection ), none is default
            }
        });
        grid2.stateIconsMap = _iconsDictionary;
        grid2.imageIconsMap = _iconsDictionary;

        //grid2.startup();

        grid2.onDxClick(function(event, gridTarget)
        {
            console.log("Right-click", gridTarget);
            document.menu.add({
               id    : gridTarget.type+"_"+gridTarget.columnId+"_"+gridTarget.rowId,
               text    : gridTarget.type+"_"+gridTarget.columnId+"_"+gridTarget.rowId,
               value    : gridTarget.type+"_"+gridTarget.columnId+"_"+gridTarget.rowId
            });
            document.menu.open(event.pageX, event.pageY);
        });


        //on( grid2.domNode, "onRowStateClick", function(e){
        //    var rowId = e._state.cell.row.id;
        //    console.log("onRowStateClick", rowId);
        //} );
        grid2.onRowStateClick( function(e){
            var rowId = e._state.cell.row.id;
            console.log("onRowStateClick", rowId);
        });

        //on( grid2.domNode, "onRowImageClick", function(e){
        //    var rowId = e._state.cell.row.id;
        //    console.log("onRowImageClick", rowId);
        //} );
        grid2.onRowImageClick( function(e){
            var rowId = e._state.cell.row.id;
            console.log("onRowImageClick", rowId);
        });

        grid2.onRowClick(function(event)
        {
            console.log("clck", event.rowId);
        });

        grid2.onStoreUpdate(function(e){
                console.log(e);
            });

        testSetIconsIndex = function()
        {
            console.time("testSetIconsIndex");
            for( var index=0; index<1000; index++ )
            {
                //setTimeout(function(){
                    //grid2.setStateIndex("0", Math.round(Math.random()));
                    //grid2.setStateIndex("000", Math.round(Math.random()));
                //}, 20);
                grid2.setCellValue("000", "Name", "Domenico"+(+new Date()));
            }
            console.timeEnd("testSetIconsIndex");
        };

        //grid2.onBeginEdit(function(cell)
        //{
        //    console.log("onBeginEdit", cell.row.id, cell.column.id);
        //});
        //grid2.onEndEdit(function(cell, success)
        //{
        //    console.log("onEndEdit", cell.row.id, cell.column.id, success);
        //});










        //[ GRID 3 ] ---------------------------------------------------------------------------------------------
        layout4 = [
            { field: "Name", name:"Name", band: "band1", type: 'string', editable: true, alwaysEditing: true },
            { field: "Active", name:"Active", band: "band2", type: 'boolean', props : { widget: 'checkbox', callback: example_callback2 }, editable: true, alwaysEditing: true },
            { field: "Age", name:"Age", band: "band2", type: 'string', editable: true, alwaysEditing: true },
            { field: "City", name:"City", band: "band1", width: '70px', editable: true, alwaysEditing: true, type: 'combobox', props: { source: comboStore, text: "Name" } }
        ];
        layout4_1 = [
            { field: "Name", name:"Name", band: "band1", type: 'string', editable: true, alwaysEditing: true },
            { field: "City", name:"City", band: "band1", align: "right", width: '70px', editable: true, alwaysEditing: true, type: 'combobox', props: { source: comboStore, text: "Name" } },
            { field: "Active", name:"Active", band: "band2", type: 'boolean', props : { widget: 'checkbox', callback: example_callback2 }, editable: true, alwaysEditing: true }
        ];

        bands = [
            { id: "band1", name: "Dati principali", locked: true, align: 'left', clocked: true, columns: ["City", "Age"] },
            { id: "band2", name: "Informazioni", columns: ["Active", "Name"] }
        ];
        bands2 = [
            { id: "band1", name: "Dati principali", locked: true, align: 'left', clocked: true, columns: ["City", "Name", "Age"] },
            { id: "band2", name: "Informazioni", columns: ["Active"] }
        ];
        bands3 = [
            { id: "band1", name: "Dati principali", locked: true, align: 'left', clocked: true, columns: [] },
            { id: "band2", name: "Informazioni", columns: [] }
        ];


        ds4 = [];
        //ds4.push({
        //    kid: "0",
        //    Name: "Gruppo",
        //    _expandCol: "--- Gruppo ---"
        //});
        //ds4[0].children = [];
        for (var index = 0; index < 500; index ++ )
        {
            //ds4[0].children.push({
            ds4.push({
                kid: "00"+index,
                Name: names[Math.floor((Math.random()*10))]+ "_" +Math.floor((Math.random()*10)+1),
                City: comboStore[1]['Name']+ "_" +Math.floor((Math.random()*10)+1),
                Active: Math.round(Math.random())
            });
        }

        grid3 = new /*editable_*/dom_grid({
            id: 'dom_grid_id_3',
            container: "dom_grid_container_3",
            height: 300,
            width: 650,
            data: ds4,
            layout: lang.clone(layout4),
            bandsLayout: lang.clone(bands3),
            modules: [],
            options: {
                //dataSourceIdentifier: 'qid', // optional, kid = default
                //dataSourceIdentifier : "DESCR",
                //rowHeader: true,
                resizable: true,

                bands: true,
                bandsColumnsMode: true,
                //bandsHideOnStart: true,

                sorting: 'single',    // or multiple, disable is default
                //columsToLock: 1,      // num of left-locked cols
                columnsDnd: true, // false is default
                //columnsDndViewMode: true, // false is default
                //columnsDndDisableOnStartup: true,
                groupable: true,      // false is default
                //groupRowsViewMode: true,
                //groupRowsHideGroupBarOnStartup: true,
                //groupRowsDisableGroupingOnStartup: true,
                //treeGrid: true,
                selection: 'single'     // or multiple ( ctrl+click for multi-row selection ), none is default
            }
        });
        grid3.startup();
        grid3.onDxClick(function(event, gridTarget)
        {
            console.log("Right-click", gridTarget);
            if( gridTarget.type !== "band" )
            {
                document.menu.add({
                   id   : gridTarget.type+"_"+gridTarget.columnId+"_"+gridTarget.rowId,
                   text : gridTarget.type+"_"+gridTarget.columnId+"_"+gridTarget.rowId,
                   value    : gridTarget.type+"_"+gridTarget.columnId+"_"+gridTarget.rowId
                });
                document.menu.open(event.pageX, event.pageY);
            }
            else
            {
                document.menu.add({
                    id   : gridTarget.type+"_"+gridTarget.bandId,
                    text : gridTarget.type+"_"+gridTarget.bandId,
                    value    : gridTarget.type+"_"+gridTarget.bandId
                 });
                document.menu.open(event.pageX, event.pageY);
            }

            //if( event.ctrlKey === true )
            //{
            //    //var elem = $("#menu1"); var parent = elem.parent(); elem.detach(); delete elem; $("<div id='menu1'></div>").appendTo(parent);
            //    obj = $("#menu1").data("dom_menu");
            //    if( !obj )
            //    {
            //        document.menu1 = $("#menu1").dom_menu({
            //            width : 200
            //        }, function callback(msg){
            //            console.log("selected: " + msg);
            //        });
            //    }
            //    else
            //    {
            //        //delete obj.ul;
            //        //obj.empty();
            //        //obj.repaint({
            //        //    width : 200,
            //        //    height: 800
            //        //});
            //    }
            //
            //    for( var index=0; index<147; index++ )
            //    {
            //        document.menu1.add({
            //            id   : "testooooooooooooooooooooooooooooooooo_"+index,
            //            text : "testooooooooooooooooooooooooooooooooo_"+index,
            //            value: "testooooooooooooooooooooooooooooooooo_"+index
            //        });
            //    }
            //}
            //
            //document.menu1.open(event.pageX, event.pageY);
        });

        //bands tests
        if( grid3.gridx.bands )
        {
            //add new column and new band
            //grid3.addColumn( { field: "Number", name:"Number", width: '60px', editable: true, alwaysEditing: true, type: 'number' } )
            //newBand = { id: "band3", name: "Band 3", columns: ["Number"] };
            //newBand2 = grid3.gridx.bands.create( "band4", "Desc. Banda 4", undefined, undefined, undefined, ["Number"] )
            //grid3.gridx.bands.add( newBand, 2 );
    //
    //
    //        grid3.gridx.bands.move("band1", 1)

            //grid3.gridx.bands.hide();
            //grid3.gridx.bands.show();

            //grid3.gridx.bands.remove("band2");

            var b = grid3.gridx.bands.create("banda_3"); // new band with default + auto settings
            grid3.gridx.bands.add( b );

        }

        grid3.onColumnAdd(function( colId ){
            console.log("add_col: " + colId);
        });
        grid3.onColumnRemove(function( col ){
            console.log("rem_col:", col);
        });




        //grid3.onBeginEdit(function(cell){
        //    console.log("BeginEdit: " + cell.row.id, cell.column.id);
        //});
        //grid3.onEndEdit(function(cell){
        //    console.log("EndEdit: " + cell.row.id, cell.column.id);
        //});

        //grid3.lazyRefresh( 10, function(){
        //    console.log( "refresh 1" );
        //});
        //
        //grid3.lazyRefresh( 10, function(){
        //    console.log( "refresh 2" );
        //});
        //grid3.setDataStore(ds4);

        //grid3.onStart(function(){
        //
        //    grid3.setDataStore([
        //        {kid: 0, Name: "Domenico 1", Active: 0},
        //        {kid: 1, Name: "Domenico 2", Active: 0},
        //        {kid: 2, Name: "Domenico 3", Active: 0}
        //    ]);
        //
        //    grid3.updateRow(
        //        { kid: 0, _expandCol: "Active: 1", Name: "", children: [
        //                                {kid: 10, Name: "Francesco 1", Active: 1},
        //                                {kid: 11, Name: "Francesco 2", Active: 1}
        //                            ]}
        //    );
        //    grid3.gridx.groupRows.appendGroup("Name", "Name");
        //
        //
        //
        //});
        //
        //grid3.onStoreUpdate(function(e){
        //            console.log(e);
        //        });

//                     for virtual sorting
//                        require([
//                        'dojo/dom-construct',
//                        'gridx/modules/HeaderRegions'
//                        ], function(domConstruct){
//
//                            var hr = grid3.gridx.headerRegions;
//                            hr.add(function(col){
//                                return domConstruct.create('div', {
//                                    style: 'height: 13px; width: 10px; background-color: red;',
//                                                    'class': 'virtualSortIcon'
//                                });
//                            }, 0, 0);
//                            hr.refresh();
//                        });
    }

















    // grid ----------------------------------------------------------------------------->
    if(true === true)
    {
        layout5 = [
            {
                field: "Name", name:"Name", type: 'string', editable: true,
                Caption: "Nome",
            },
            {
                field: "Age", name:"Age", type: 'string', editable: true,
                Caption: "Anni",
                content: {
                    type:'span',
                    contentClass: "hederIconTest",
                    callback: function(){
                        console.log("click");
                    }
                }
            },
            {
                field: "City", name:"City", type: 'combobox', editable: true,
                Caption: "Città",
                props: {
                    source: cStore2,
                    text: "Name"
                }
            }
        ];
        //for(var i=0; i<10; i++) layout5.push({id: "col_"+i, type: "string", name: "Colonna "+i});
        var rowsNum = 50;
        idsStore = [];
        simulateStore = {};
        for(var index = 0; index < rowsNum; index ++)
        {
            if(index===0)
            {
                idsStore.push({
                    kid: "0",
                    Name: "Domenico",
                    Age: 29,
                    City: 1,
                    iL_i: true
                });
            }
            else
            {
                idsStore.push({
                    kid: "0"+index
                });
            }
        }
        idsStore[0]._ch_ = [];

        cmp_ds =
        {
            m: ["kid", "Name", "City", "Age"],
            d: [
                {
                    r: ["0", "Domenico", 1, 29 ],
                    c: [
                            {
                                r: ["0-0", "Matteo", 3, 18 ],
                                c: [
                                        {
                                            r: ["0-0-0", "Giuseppe", 2, 18 ],
                                            c: []
                                        }
                                ]
                            },
                            {
                                r: ["0-1", "Carlo", 1, 78 ],
                                c: [
                                        {
                                            r: ["0-1-0", "Vito", 3, 89 ]
                                        }
                                ]
                            }
                    ]
                },
                {
                    r: ["1", "Mario", 2, 49 ],
                    c: [
                            {
                                r: ["1-0", "Francesco", 3, 30 ],
                                c: []
                            }
                    ]
                }
            ]
        };
        cmp_ds_2 =
        {
            m: ["kid", "Name", "City", "Age", "iL_i", "imgx"],
            d: [
                {
                    r: ["0", "Domenico", 1, 29, true, {i: 1, s: 3} ],
                    c: [
                            {
                                r: ["0-0", "Matteo", 3, 18, false ],
                                c: [
                                        {
                                            r: ["0-0-0", "Giuseppe", 2, 18, true ],
                                            c: []
                                        }
                                ]
                            },
                            {
                                r: ["0-1", "Carlo", 1, 78, true ],
                                c: [
                                        {
                                            r: ["0-1-0", "Vito", 3, 89, true ]
                                        }
                                ]
                            }
                    ]
                },
                {
                    r: ["1", "Mario", 2, 49, true ],
                    c: [
                            {
                                r: ["1-0", "Francesco", 3, 30, true ],
                                c: []
                            }
                    ]
                }
            ]
        };

        ds4 = [];
        //ds4.push({
        //    kid: "0",
        //    Name: "Gruppo",
        //    _expandCol: "--- Gruppo ---"
        //});
        //ds4[0].children = [];
        for (var index = 0; index < 500; index ++ )
        {
            //ds4[0].children.push({
            ds4.push({
                kid: "0-0-"+index,
                Name: names[Math.floor((Math.random()*10))]+ "_" +Math.floor((Math.random()*10)+1),
                City: comboStore[Math.floor((Math.random()*4))]['Name'],
                Active: Math.round(Math.random()),
                Age: Math.floor((Math.random()*100)+1)
            });
        }

        grid = new /*editable_*/dom_grid({
            id: 'dom_grid_id_6',
            container: "dom_grid_container_2",
            height: 500,
            width: 650,
            data: ds4,/*cmp_ds_2,*//*idsStore,*/
            layout: layout5,
            options: {
                rowHeight: 25,
                childrenIdentifier: "_ch_",
                //bandsColumnsMode: true,
                /*optimizationProfile: {
                    //isLoadIdentifier: "__hasAll__", // default = "iL_i"
                    isLoadIdentifier: "iL_i",
                    serverStore: "hybrid",//true, // false = default
                    preloadNum: 20,
                    //reqsMaxCount: 5, // 0=default, disabled
                    compressedInMessage: true // false = default
                },*/
                selection: 'single',
                sorting: 'multiple',

                groupable: true,
                columnsDnd: true,
                //expandColKey: 2,

                //treeGrid: true
            },
            modules: [
                // altri moduli della gridx
                "plugins/dom_grid/modules/CustomHeader"
            ],
            advOptions: {
                // opzioni della gridx. N.B. Prevalgono le opzioni della dom_grid

                //bodyDefaultRowHeight: 25 // FIXME: ???

                //vScrollerLazy: true, // false = default
                //vScrollerLazyTimeout: 1000000,
                vScrollerBuffSize: 3,

                vScrollerPxSize: 50, // default = row height // TODO:
                vScrollerMouseup: true//true

                ,groupRowsStickerTitleKey: "Caption"
                ,columnHeaderDndStickerTitleKey: "Caption"
            },
            onRowClick: function(e)
            {
                console.log("click", e.rowId);
            },
            onRowDblClick: function(event){
                console.log("dbl-clck", grid.getRowById(event.rowId));
            },
            onRowGrouping: function(groups, target, type)
            {
                console.log("rowGrouping: ", groups, target, type);
            }
            ,onGroupDragOut: function(dragId, dropId, isBefore, bandId)
            {
                console.log("dragout", dragId, dropId, isBefore, bandId);
            }
            ,onTopRowChange: function(rowid)
            {
                console.log("topRow", rowid);
            }
//            ,onBottomRowChange: function(rowid)
//            {
//                console.log("bottomRow", rowid);
//            }
        });

        grid. setDataStore(ds4);

        grid.startup();

        //var customStyles = grid.getHTMLStyle("customStyles", true);
        /*grid.setStyleRule(customStyles, ".hederIconTest", {
            display: 'block',
            height: '16px',
            width: '16px',
            backgroundColor: 'lime',
            position: 'absolute',
            left: '50%',
            marginLeft: '-8px'
        }, false);*/
        /*grid.gridx.customHeader.addCustom("Age", {
            type:'span',
            contentClass: "hederIconTest",
            callback: function(){
                console.log("click");
            }
        });*/

        /*grid.attachCommands(function(){
            //this.expandRow("0-0-0");

            var rowRule = grid.setCellStyles("0", undefined, {backgroundColor: "yellow"});
            var columnRule = grid.setCellStyles(undefined, "Name", {backgroundColor: "lime"});
            var cellRule = grid.setCellStyles("0-0-0", "City", {color: "red", backgroundColor: "#36d3e0"});

            grid.setRowsHeight(50);

            var cellRule = grid.setCellStyles("0", "City", {fontSize: "30px"});
            //grid.resetCellStyles("0", "City")
        });*/

        // [serverStore tests] ----------------------------------------------------------------------
        grid.onRowNeed(function(rowsid){

            //setTimeout(function(){
                console.log("need", rowsid);
                /*simulate server resp.*/
                var rowsData = [];
                for(var i=0; i< rowsid.length; i++)
                {
                    var simulateObj = {
                        kid: rowsid[i],
                        Name: names[Math.floor((Math.random()*10))]+ "_" +Math.floor((Math.random()*10)+1),
                        Age: Math.round(Math.random()*10),
                        City: Math.floor((Math.random()*4))
                    };
                    if(rowsid[i] !== "0-0-0-0")
                        rowsData.push(simulateObj);

                    //grid.loadRow(rowsid[i], simulateObj); // simulate resp.
                }
                /*simulate server resp.*/

                // compressed test
                rowsData = {m: ["kid", "Name", "Age", "City"], d: []};
                for(var i=0; i< rowsid.length; i++)
                {
                    var simulateObj = {r: [
                        rowsid[i],
                        names[Math.floor((Math.random()*10))]+ "_" +Math.floor((Math.random()*10)+1),
                        Math.round(Math.random()*10),
                        Math.floor((Math.random()*4))
                    ]};
                    if(rowsid[i] !== "0-0-0-0")
                        rowsData.d.push(simulateObj);

                    //grid.loadRow(rowsid[i], simulateObj); // simulate resp.
                }

                //grid.loadRows([id_row: { ... }, id_row_2: { ... }]); //<--------- id typeof param[0] === "Object" ----> multiplo else no!
                grid.loadRows(rowsData);

            //}, 3000);
        });
        // [serverStore tests] ----------------------------------------------------------------------

        /*grid.attachCommands(function(){

            this.setColumns([
                {"field":"ID","name":"Id_Key","editable":false,"hidden":true},
                {"field":"FW06_ID","name":"Id","editable":false,"hidden":true},
                {"field":"PADRE","name":"IdPadre","editable":false,"hidden":true},
                {"field":"FW06_CODICE","name":"Utenti&#92;Gruppi","editable":false,"hidden":false},
                {"field":"FW06_DESCR","caption":"Descrizione","editable":false,"hidden":false},
                {"field":"FW07_DATACREAZIONE","name":"Data creazione","editable":false,"hidden":false},
                {"field":"FW07_LASTPWDCHANGE","name":"Ultima mod. pwd","editable":false,"hidden":false},
                {"field":"FW07_FLGGRP","name":"Perm.gruppo","editable":false,"hidden":false},
                {"field":"FW07_FLGISADMIN","name":"Amministratore","editable":false,"hidden":false}
            ]);

            this.setDataStore({
            "m":["kid","kpid","ID","FW06_ID","PADRE","FW06_CODICE","FW06_DESCR","FW07_DATACREAZIONE","FW07_LASTPWDCHANGE","FW07_FLGGRP","FW07_FLGISADMIN","__extra__","__hasAll__"],
            "d":[
                {"r":["3","0","3","3","0","ADMIN","Amministratori","","","","",{"i":0},true],"c":[]},
                {"r":["5","0","5","5","0","ASS","Assistenza","","","","",{"i":0},true],"c":[]},
                {"r":["4","0","4","4","0","COMM","Commerciale","","","","",{"i":0},true],"c":[]},
                {"r":["6","0","6","6","0","INS","Installatori","","","","",{"i":0},true],"c":[]},
                {"r":["7","0","7","7","0","TEAMPORTAL","Utenti Teamportal","","","","",{"i":0},true],"c":[]}]
            });
        });*/



        //grid.dataSource[0]._ch_.length = 100; grid.clearCache(); grid.refreshGraphic();

        //[compressedInMessage]------------------------->
        //grid.setDataStore(grid.uncmp(cmp_ds));
    }
});
