require(['plugins/dom_grid/qgrid',
         'plugins/dom_grid/editable_qgrid',
         //'plugins/dom_grid/tgrid',
         //'plugins/dom_grid/editable_tgrid',
         'dojo/on',
         'dojo/query',
         'dojo/aspect',
         'dojo/_base/lang',
         'dojox/html/entities',
        'dojo/store/Memory'
    ], function( dom_grid, editable_dom_grid, /*tgrid, edit_tgrid,*/ on, query, aspect, lang, htmlEntities, Memory, Select ){

    VBR_DEBUG = true;

    //datastore
    names = [
        "Mario Rossi",
        "Mario Bianchi",
        "Mario Verdi",
        "John Doe",
        "John Smith",
        "Foo",
        "Jimi Hendrix",
        "Frank Sinatra",
        "Andres Segovia",
        "Dixie dregs"
    ];
    ds =  [];
    cStore = [
      { id: 0, Name: "" },
      { id: 1, Name: "Bari"},
      { id: 2, Name: "Fabriano"},
      { id: 3, Name: "Matera"},
      { id: 4, Name: "Pesaro"}
    ];

    cStore2 = [
      { id: 0, Name: "" },
      { id: 1, Name: "Milano"},
      { id: 2, Name: "Bologna"},
      { id: 3, Name: "Firenze"},
      { id: 4, Name: "Napoli"}
    ];

    _iconsDictionary = {
        0: "icon_test",
        1: "icon_test2"
    };

    _descrsDict = {
        0: "text_1",
        1: "text_2"
    };

    var b64_example = "data:image/jpeg;base64,/9j/4AAQSkZJRgABAQEAYABgAAD/4QBoRXhpZgAATU0AKgAAAAgABAEaAAUAAAABAAAAPgEbAAUAAAABAAAARgEoAAMAAAABAAIAAAExAAIAAAASAAAAT"
                        +"gAAAAAAAABgAAAAAQAAAGAAAAABUGFpbnQuTkVUIHYzLjUuMTEA/9sAQwABAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQE"
                        +"BAQEB/9sAQwEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEB/8AAEQgAEAAQAwEiAAIRAQMRAf/EAB8AAAEFAQEBAQ"
                        +"EBAAAAAAAAAAABAgMEBQYHCAkKC//EALUQAAIBAwMCBAMFBQQEAAABfQECAwAEEQUSITFBBhNRYQcicRQygZGhCCNCscEVUtHwJDNicoIJChYXGBkaJSYnKCkqNDU2Nzg5OkNERUZHSE"
                        +"lKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6g4SFhoeIiYqSk5SVlpeYmZqio6Slpqeoqaqys7S1tre4ubrCw8TFxsfIycrS09TV1tfY2drh4uPk5ebn6Onq8fLz9PX29/j5+v/EAB8BAAM"
                        +"BAQEBAQEBAQEAAAAAAAABAgMEBQYHCAkKC//EALURAAIBAgQEAwQHBQQEAAECdwABAgMRBAUhMQYSQVEHYXETIjKBCBRCkaGxwQkjM1LwFWJy0QoWJDThJfEXGBkaJicoKSo1Njc4OTpDR"
                        +"EVGR0hJSlNUVVZXWFlaY2RlZmdoaWpzdHV2d3h5eoKDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uLj5OXm5+jp6vLz9PX29/j5+v/aAAwD"
                        +"AQACEQMRAD8A/nu/4KHf8E/Rrw8RftBfA/SguvKNR8Q/E/wLaEAa+ANa17xH8QtIuNR1bA18DyI9R8K6XY418b9R0qH/AISD7Va+IPFP2Lf2PP7A/sf4yfFbTFbXmW21TwH4RvY4pY9Djlis"
                        +"r/S/F+qiK6df+Eg2vJ/Zei3tsr+HHVNSu0XxCtpH4f8A6HK8A+Ingi5sri78S6WJ7uwu53udWtQJJ7jTrmeS2j+0WcMFq0s2mTStcXmpS3E7SaTI0lxuOjmQaN/qT9J76KuX4bFY/wAVvD/K5"
                        +"+yU6mN4s4WwNCLw2Hm+eriOJcsw0LSjQjJe0zbAUKc6dFzlmdOFPDU8Z7L8p/YVfS0+j9ivpEcIeEf0zs1h7bkwOB8AuK+J6+HXBeJ46WLo0sn4Y8RsTi7xliJRdOnwNmGY1IZVXziFDK86nUxVTJvbf//Z";

    /**     * Description     * @param {type} e Description     * @param {type} cell Description     */
    function example_callback( e, cell )
    {
        alert("click on widget");
    }
    function example_callback2( e, cell )
    {
        alert("click on widget 2");
        //console.log( "click on widget 2", e, cell );
    }

    //[ GRID 3 ] ---------------------------------------------------------------------------------------------
    layout4 = [
        {   field: "Name", name:"Name", band: "band1", type: 'string', editable: true, /*alwaysEditing: true,*/ align: "left", sorted: "ASC",
            content: {
                type:'span',
                contentClass: "hederIconTest headerIconZeroLeft",
                callback: function(){
                    console.log("click");
                }
            },
            filters: {
                combobox: {
                    isEnabled: true,
                    data: [
                        { id: 0, label: "Tutti" },
                        { id: 1, label: "Personalizza..." }
                    ],
                    labelKey: 'label',
                    valueKey: 'id',
                    callback: function(colid, value){
                        console.log( "combobox_callback: ", colid, value );
                        if(value === 1)
                        {
                            grid3.gridx.tpFilters.openAdvDialog(colid, true);
                        }
                    }
                }
            }
        },
        {   field: "Active", name:"Active__", caption: "Attivo", align: "right", band: "band1", type: 'boolean', editable: true, /*alwaysEditing: true,*/ band: "band2",
            props: {
                widget: 'checkbox2',
                //callback: example_callback2,
                checkedValue: 0
            },
            filters: {
                checkbox: {
                    isEnabled: true,
                    //checked: false,
                    callback: function(e, colId, isChecked){
                        console.log( "checkbox_callback: ", colId, isChecked );
                    }
                }
            }
        },
        {
            field: "Age", name:"Age", band: "band3", type: 'string', editable: true, /*alwaysEditing: true,*/ width: "100px", hidden: false, sorted: "DESC"
        },
        {
            field: "City", name:"City", band: "band3", editable: true, /*alwaysEditing: true,*/ width: "100px", type: 'combobox',
            props: {
                source: cStore,
                text: "Name"
                //,readonly: false
            }
        },
        { field: "Image", name:"Image", width: '60px', type: 'image', align: "center", props: { callback: example_callback2, source: _iconsDictionary, width: '18px' } }
        /*{ field: "ImageByClass", name:"ImageByClass", width: '60px', type: 'image', props: { callback: example_callback2, width: '18px' } },
        { field: "Hyperlink", name:"Hyperlink", width: '60px', type: 'hyperlink', props: { callback: example_callback2 } }*/
    ];

    //for( var i=0; i<30; i++)
    //    layout4.push({ field: "col"+i, name:"Col-"+i, band: "band3", type: 'boolean', props : { widget: 'checkbox', callback: example_callback2 }, width: "50px" });

    layout4_1 = [
        { field: "Name", name:"Name", band: "band1", type: 'string', editable: true, alwaysEditing: true },
        { field: "City", name:"City", band: "band1", align: "right", width: '70px', editable: true, alwaysEditing: true, type: 'combobox', props: { source: cStore, text: "Name" } },
        { field: "Active", name:"Active", band: "band2", type: 'boolean', props : { widget: 'checkbox', callback: example_callback2 }, editable: true, alwaysEditing: true },

        { field: "Image", name:"Image", band: "band2", type: 'image', props : { source: _iconsDictionary, width: '16px', callback: example_callback2 } }
    ];

    bands = [
        { id: "band1", name: "Dati principali", align: 'left', locked: "right", clocked: false, columns: ["Active", "Name"] },
        { id: "band2", name: "Banda Centrale", clocked: false, columns: ["City"] },
        { id: "band3", name: "Informazioni", clocked: false, columns: ["Age", "Image"] }
    ];
    bands2 = [
        { id: "band1", name: "Dati principali", locked: "left", /*clocked: true, */columns: ["City"] },
        { id: "band2", name: "Informazioni", columns: ["Active", "Name", "Age"] }
    ];
    bands3 = [
        { id: "band1", name: "Dati principali", locked: "left", align: 'left', clocked: true, columns: [] },
        { id: "band2", name: "Banda Centrale", clocked: true, columns: [], align: 'center' },
        { id: "band3", name: "Informazioni", /*locked: 'right',*/ columns: [], align: 'left' }
    ];

    ds4 = [];
    /*ds4.push({
        kid: "0",
        //Name: "Gruppo",
        _expandCol: "--- Gruppo ---"
    });
    ds4[0].children = [];*/
    for(index = 0; index < 40; index ++ )
    {
//        ds4[0].children.push({
        ds4.push({
            kid: "00"+index,
            Name: names[Math.floor((Math.random()*10))]+ "_" +Math.floor((Math.random()*10)+1),
            City: /*cStore[1]['Name']+ "_" +*/Math.floor((Math.random()*5)),
            Active: Math.round(Math.random()),
            Age: Math.round(Math.random()*10),
            Image: index > 10 ? 0 : { value: 1, icon: b64_example, height: "16px", width: "16px", callback: example_callback, descriptions: _descrsDict, show_description: true, visualmode: 0 }/*, // b64 example. n.b. all url type supported
            ImageByClass: index > 10 ? undefined : { class: "icon_test", height: "16px", width: "16px", callback: example_callback }, // class example
            Hyperlink: index > 10 ? undefined : { text: "Esegui!", callback: example_callback }*/
        });
    }
    /*ds4[0].children[0].children = [];
    for (var index = 0; index < 5; index ++ )
    {
        ds4[0].children[0].children.push({
        //ds4.push({
            kid: "10"+index,
            Name: names[Math.floor((Math.random()*10))]+ "_" +Math.floor((Math.random()*10)+1),
            City: cStore[1]['Name']+ "_" +Math.floor((Math.random()*10)+1),
            Active: Math.round(Math.random()),
            Image: 0
        });
    }
*/
    // GroupFooter Test
    /*ds4[0].children.push({
        kid: "2000",
        Name: "Hello!!!",
        Active: "Nessun valore",
        _isGroupFooter: true
    });*/

    if(true === true)
    {
        grid3 = new editable_dom_grid({
            id: 'dom_grid_id_3',
            container: "dom_grid_container_3",
            height: 500,
            width: 650,
            data: ds4,
            layout: lang.clone(layout4),
            bandsLayout: lang.clone(bands),
            bars: {
                title: { content: "Griglia di Test", visible: true/*, style: "font-size: 16px; color: #9fd2ff;", className: "class1 class2"*/ },
                footer: {
                    visible: true,
                    columns: {
                        Name: { content: "valore 1", className: "classe1" },
                        Age: { content: "valore 2", className: "classe2" },
                        Active: { content: "valore 3", className: "classe3" },
                        City: { content: "valore 4", className: "classe4" }
                    }
                }
            },
            //modules: [
            //    "plugins/dom_grid/modules/CustomHeader"
            //],
            options: {
                //dataSourceIdentifier: 'qid', // optional, kid = default
                rowHeight: 50,
                //rowHeader: true,
                resizable: true,
                //sorting: 'multiple',    // or multiple, disable is default
                //columsToLock: 1,      // num of left-locked cols

                //oneClickEditing: true,

                bands: true,
                //bandsColumnsMode: true,
                //bandsHideOnStart: true,

                //columnsDnd: true, // false is default
                //columnsDndViewMode: true, // false is default
                //columnsDndDisableOnStartup: true,

                //groupable: true,      // false is default
                //groupRowsViewMode: true,
                //groupRowsHideGroupBarOnStartup: true,
                //groupRowsDisableGroupingOnStartup: true,
                //treeGrid: true,
                //expandColKey: 3,

                //filtering: true,

                selection: 'single'     // or multiple ( ctrl+click for multi-row selection ), none is default
            },
            advOptions: {
                vScrollerMouseup: true,
                groupRowsStickerTitleKey: "caption",
                columnHeaderDndStickerTitleKey: "caption"
                //,editOneClickEditing: false
            },
            /*onStart: function()
            {
                console.log("started");
            },*/
            onRowClick: function(e)
            {
                //console.log("click", e.rowId);
            },
            /*onRowDblClick: function(e)
            {
                console.log("dbl-click", e);
            },
            onDxClick: function(e, target)
            {
                console.log("dx-click", target, e.columnId);
            },*/
            onBeginEdit: function(cell)
            {
                //console.log("Begin Edit: ", cell);
            },
            onEndEdit: function(cell, success)
            {
                console.log("End Edit: ", grid3.getCellValue(cell.row.id, cell.column.id)/*cell, success*/);
            },
            onCancelEdit: function(cell)
            {
                //console.log("Cancel Edit: ", cell);
            }/*,
            onLeftColumnChange: function(colId)
            {
                console.log("left column change: ", colId);
            }*/
            ,onGroupDragOut: function(dragId, dropId, isBefore, bandId)
            {
                //console.log("dragout", dragId, dropId, isBefore, bandId);
            }
        });

        /*e = grid3.attachEvent("rowClick", function(e){ console.log("click_pausable", e.originalEvent.rowId); }, "pausable");
        e.promise.then(function(grid){console.log("attach complete!");});*/

        grid3.startup();

        /*eeevt = grid3.onRowClick(function(e)
        {
            console.log("click", e.rowId);
        });*/

        //var evts = grid3.getAttachedEvents();
        //grid3.detachEvent(e.id); // by id
        //grid3.detachEvent(null, "rowClick"); // by eventType
        //grid3.detachEvent(null, null, true); // all

        if( grid3.gridx )
        {
            /*for(var i in ds4)
            {
                grid3.addRow(ds4[i]);
            }*/
            // [ bands tests ] ---------------------------------------------------------------------
            /*if( grid3.gridx )
            {
                grid3.removeColumn("City"); // grid3.gridx.columnController.remove("City")

                //grid3.addColumn({ id: "NewCol", name: "New Column"  }); // grid3.gridx.columnController.add({ id: "NewCol", name: "New Column"  });
            }*/

            // [edit tests] ------------------------------------------------------------------------
            if(grid3.gridx.edit)
            {
                var cell = grid3.getCell("000", "Name");
                var bool1 = grid3.gridx.edit._cellCanEdit(cell);
                var bool2 = grid3.gridx.edit._setCellEdit(cell, false);
                grid3.gridx.edit._backupCell(cell);

                // edit

                var promise = grid3.gridx.edit._restoreCell(cell);
                grid3.refreshCell("000", "Name");

            }


            // [ bands tests ] ---------------------------------------------------------------------
            if( grid3.gridx.bands )
            {
                //grid3.gridx.bands.rename("band1", "Test rename");
                //grid3.gridx.bands.hide();
                //grid3.gridx.bands.show();

                //var newBand = grid3.gridx.bands.create("band4", "Nuova banda");
                //grid3.gridx.bands.add(newBand, 1);


                //grid3.gridx.bandLock.lock("band1", "left");

                //grid3.gridx.bandLock.lock("band3", "right")


                //grid3.gridx.bandLock.unlock();
                //grid3.hideColumn("Age")
            }


            //// [ vScrolling tests ] ----------------------------------------------------------------
            if( grid3.gridx.virtualSorting )
            {
                /*grid3.onRowSorting(function( colId, state, type ){
                    console.log( colId, state, type );
                });*/
            }

            //// [ Filters tests ] ----------------------------------------------------------------
            if( grid3.gridx.tpFilters )
            {

            }

            //// [ Bars tests ] -------------------------------------------------------------------
            if( grid3.gridx.titleBar )
            {
                //////grid3 -> bars: { title: { content: "anche html", style: "cod css", visible: true\false(true =default) } }
                //grid3.gridx.titleBar.setVisibility(true);
                //grid3.gridx.titleBar.setContent("Nuovo titolo !");
                //grid3.gridx.titleBar.setStyle("font-size: 16px; color: red;");
                //grid3.gridx.titleBar.addClass(["gridxSpecialClass", "gridxSpecialClass_2"]);
                //grid3.gridx.titleBar.removeClass("gridxSpecialClass_2");
                //grid3.gridx.titleBar.addClass("gridxSpecialClass_3");
            }
            if( grid3.gridx.footerBar )
            {
                // dev only
                //grid3.gridx.footerBar._updateUI();
                /*grid3.gridx.footerBar.setVisibility(true);
                grid3.gridx.footerBar._addColumn("Name");
                grid3.gridx.footerBar._addColumn("Age");
                grid3.gridx.footerBar._removeColumn("Age")
                grid3.gridx.footerBar._getColumnNode(0);*/

                // public method
                // bar method
                /*grid3.gridx.footerBar.setContent("hello");
                grid3.gridx.footerBar.setVisibility(false);
                grid3.gridx.footerBar.setStyle({backgroundColor: "yellow"});
                grid3.resize();*/

                // columns method
                /*grid3.gridx.footerBar.setColumnStyle("Name", { background: "#000"});
                grid3.gridx.footerBar.setColumnContent("Age", "Nuovo Valore");*/

                //grid3.gridx.footerBar.addClassToColumn("Age", "newClass");
                //grid3.gridx.footerBar.removeClassFromColumn("Age", "newClass");
                //console.log(grid3.gridx.footerBar.columns);
                //grid3.gridx.footerBar.setColumnStyle("Age", { color: 'red' }); grid3.gridx.footerBar.resetColumnStyle("Age");

            }

            //// [ GroupFooter tests ] -------------------------------------------------------------
            if(grid3.gridx.groupFooter)
            {
                //grid3.gridx.groupFooter.setCellDecorator("2000", "Name", function(){ /*...*/}, function(data, storeData, widget){ /*...*/ })
                //grid3.gridx.groupFooter.setCellDecorator("2000", "Active");
            }

            if(grid3.gridx.tpFilters)
            {
                /*grid3.gridx.tpFilters.set("Name", "checkbox", {
                    isEnabled: true,
                    callback: function(e, colId, isChecked){
                        console.log( "checkbox_callback: ", colId, isChecked );
                    }
                });*/

                /*var comboDS = [];
                for(var i=0; i<50; i++)
                    comboDS.push({ id: i, label: "Label " + i });
                grid3.gridx.tpFilters.set("City", "combobox", {
                    isEnabled: true,
                    data: comboDS,
                    callback: function(colid, value){
                        console.log( "combobox_callback: ", colid, value );
                    }
                });
                grid3.gridx.tpFilters.set("Name", "combobox", {
                    isEnabled: true,
                    data: [
                        { id: 0, label: "Tutti" },
                        { id: 1, label: "Personalizza..." }
                    ],
                    callback: function(colid, value){
                        console.log( "combobox_callback: ", colid, value );
                    }
                });*/

                /*grid3.gridx.tpFilters.addMenuItem(
                    "City",
                    {   id: 3,
                        label: "Test 2"
                    },
                    function(colid){
                        console.log("click: " + colid);
                    }
                );

                grid3.refreshHeader();*/
            }

            // [ events ] ---------------------------------------------------------------------------
            //grid3.onRowClick(function(e){
            //    console.log("click on row", e);
            //});
            //grid3.onRowDblClick(function(e){
            //    console.log("dbl-click on row", e);
            //});
            /*grid3.onDxClick(function(e, target){
                console.log("dx-click", target, e.columnId);
            });*/

            if(grid3.onColumnDnd)
            {
                grid3.onColumnDnd(function(o,d,oi,di,isBefore,bandId, originalEvent)
                {
                    //console.log(o,d,oi,di,isBefore,bandId);
                    console.log("isMoveSuccess: ", originalEvent.isMoveSuccess);
                });
            }

            if(grid3.onRowGrouping)
            {
                grid3.onRowGrouping(function(groups, target, type)
                {
                    console.log("rowGrouping: ", groups, target, type);
                });
            }

        //    grid3.onAfterColumnMove(function(e)
        //    {
        //        //console.log(o,d,oi,di,isBefore,bandId);
        //        console.log("afterMove: ", e);
        //    });

            // [ select by cell ] -------------------------------------------------------------------
            //grid3.setSelectionByCell(true);
            //grid3.selectCell("105", "Active");
            //grid3.getSelectedCell();


        }
    }

    // test simple grid
    if(false === true)
    {
        layout5 = [
            {   field: "Name", name:"Name", type: 'string'

//                ,filters: {
//                    combobox: {
//                        isEnabled: true,
//                        data: [
//                            { id: 0, label: "Tutti" },
//                            { id: 1, label: "Personalizza..." }
//                        ],
//                        labelKey: 'label',
//                        valueKey: 'id',
//                        callback: function(colid, value){
//                            console.log( "combobox_callback: ", colid, value );
//                            if(value === 1)
//                            {
//                                grid.gridx.tpFilters.openAdvDialog(colid, true);
//                            }
//                        }
//                    },
//                    advanced: {
//                        isEnabled: true,
//                        maxFilters: 2,
//                        toShow: 2
//                        //,operators: {ok: 0, no: 1}
//                        //,boolOperators: [/*...*/]
//                    }
//                }
            },
            {
                field: "Age", name:"Age", type: 'string'
            },
            {
                field: "City", name:"City", type: 'combobox',
                props: {
                    source: cStore,
                    text: "Name"
                }
            }
        ];

        ds5 = [];
        for (var index = 0; index < 30; index ++ )
        {
            ds5.push({
                kid: "0"+index,
                Name: names[Math.floor((Math.random()*10))]+ "_" +Math.floor((Math.random()*10)+1),
                Age: Math.round(Math.random()*10),
                City: cStore[1]['Name']+ "_" +Math.floor((Math.random()*10)+1),
            });
        }


        grid = new dom_grid({
            id: 'dom_grid_id_5',
            container: "dom_grid_container_2",
            height: 500,
            width: 650,
            data: ds5,
            layout: layout5,
            bars: {
                title: { content: "Griglia di Test", visible: true, style: "font-size: 16px; color: #9fd2ff;"/*, className: "class1 class2"*/ },
                footer: {
                    visible: true,
                    columns: {
                        Name: { content: "valore 1", className: "classe1" },
                        Age: { content: "valore 2", className: "classe2" },
                        Active: { content: "valore 3", className: "classe3" },
                        City: { content: "valore 4", className: "classe4" }
                    }
                }
            },
            options: {
                rowHeader: true,
                selection: 'single',
                filtering: true,
                resizable: true
            },
            advOptions: {
                vScrollerMouseup: true
            },
            onRowClick: function(e)
            {
                console.log("click");
            }
        });
        grid.startup();

        if(grid.gridx)
        {
            if(grid.gridx.tpFilters)
            {
                f = grid.gridx.tpFilters;
                c = grid._getColumn("Name");

                // --> tip: f.BOOL_OPERATORS.get(0); -> return key of boolOperator
                // --> tip: f.OPERATORS.get(0); -> return key of operator

                // 1st filter
                f.add("Name", {
                    operator: f.OPERATORS.otGreater,
                    value: 10,
                    //boolOperator: f.BOOL_OPERATORS.boAnd,
                    displayText: "testo_footer_filtro_1"
                });

                //2nd filter
                f.add("Name", {
                    operator: f.OPERATORS.otLess,
                    value: 50,
                    boolOperator: f.BOOL_OPERATORS.boAnd,
                    displayText: "testo_footer_filtro_2"
                });
                console.log( f.get("Name") );

                grid.attachCommands(function(){
                    grid.gridx.tpFilters.openAdvDialog("Name");

                    grid.onSaveAdvFilters(function(colid){
                        console.log("adv save ", colid);
                    });
                    grid.onCancelAdvFilters(function(colid){
                        console.log("adv cancel ", colid);
                    });
                });

                //f.remove("Name", 1);
                //console.log( f.get("Name") );

                //f._removeFilterOption(1); // remove one HTML_filter from dialog (1st in this case)
            }
        }

        /// paginate load test s
        //grid.gridx.view.visualCount = 200; grid.gridx.vScroller._syncHeight();
        //grid.addRow({kid: 30, Name: "Domenico", Age: "29"});
    }


    // test editable grid
    if(false === true)
    {
        bands5 = [
            { id: "band1", name: "Dati principali", align: 'left'/*, locked: "left"*/, clocked: false, columns: ["Name"] },
            { id: "band2", name: "Banda Centrale", clocked: false, columns: ["Age"] },
            { id: "band3", name: "Informazioni", clocked: false, columns: ["City"] }
        ];
        layout5 = [
            {   field: "Name", name:"Name", type: 'string', editable: true, //alwaysEditing: true,
                filters: {
                    combobox: {
                        isEnabled: true,
                        data: [
                            { id: 0, label: "Tutti" },
                            { id: 1, label: "Personalizza..." }
                        ],
                        labelKey: 'label',
                        valueKey: 'id',
                        callback: function(colid, value){
                            console.log( "combobox_callback: ", colid, value );
                            if(value === 1)
                            {
                                grid.gridx.tpFilters.openAdvDialog(colid, true);
                            }
                        }
                    }/*,
                    advanced: {
                        isEnabled: true,
                        maxFilters: 2,
                        toShow: 2
                        //,operators: {ok: 0, no: 1}
                        //,boolOperators: []
                    }*/
                }
            },
            {
                field: "Age", name:"Age", type: 'string', editable: true,
                filters: {
                    combobox: {
                        isEnabled: true,
                        data: [
                            { id: 0, label: "Tutti" },
                            { id: 1, label: "Personalizza..." }
                        ],
                        labelKey: 'label',
                        valueKey: 'id',
                        callback: function(colid, value){
                            console.log( "combobox_callback: ", colid, value );
                            if(value === 1)
                            {
                                grid.gridx.tpFilters.openAdvDialog(colid, true);
                            }
                        }
                    }
                }
            },
            {
                field: "City", name:"City", type: 'combobox', editable: true, //alwaysEditing: true,
                props: {
                    source: cStore2,
                    text: "Name"
                }
            },
            {
                field: "City2", name:"City2", type: 'combobox', editable: true,
                props: {
                    source: cStore,
                    text: "Name"
                }
            }
        ];
        //for(var i=0; i<10; i++) layout5.push({id: "col_"+i, type: "string", name: "Colonna "+i});
        var rowsNum = 50;
        idsStore = [];
        simulateStore = {};
        for(var index = 0; index < rowsNum; index ++)
        {
            if(index===0)
            {
                idsStore.push({
                    kid: "0",
                    Name: "Domenico",
                    Age: 29,
                    City: 1,
                    __hasAll__: true
                });
            }
            else
            {
                idsStore.push({
                    kid: "0"+index
                });
            }
        }
        idsStore[0]._ch_ = [];
        /*for (var index = 0; index < 50; index ++ )
        {
            idsStore[0]._ch_.push({
                kid: "1"+index
            });
        }*/

        /*for (var index = 0; index < rowsNum; index ++ )
        {
            simulateStore["0"+index] = {
                Name: names[Math.floor((Math.random()*10))]+ "_" +Math.floor((Math.random()*10)+1),
                Age: Math.round(Math.random()*10),
                City: Math.floor((Math.random()*4))//cStore[1]['Name']+ "_" +Math.floor((Math.random()*10)+1),
            };
        }
        for (var index = 0; index < 50; index ++ )
        {
            simulateStore["1"+index] = {
                Name: names[Math.floor((Math.random()*10))]+ "_" +Math.floor((Math.random()*10)+1),
                Age: Math.round(Math.random()*10),
                City: Math.floor((Math.random()*4))//cStore[1]['Name']+ "_" +Math.floor((Math.random()*10)+1),
            };
        }*/

        var en_US = {
            otIsNull: "Null",
            otEqual: "Equal",
            otGreater: "Greater",
            otLess: "Less",
            otGreaterEqual: "Greater or Equal",
            otLessEqual: "Less Equal",
            boAnd: "And",
            boOr: "Or"
        };

        grid = new editable_dom_grid({
            id: 'dom_grid_id_6',
            container: "dom_grid_container_2",
            height: 500,
            width: 650,
            data: idsStore,
            layout: layout5,
            bandsLayout: lang.clone(bands5),
            bars: {
                title: { content: "Griglia di Test", visible: true, style: "font-size: 16px; color: #9fd2ff;"/*, className: "class1 class2"*/ },
                footer: {
                    visible: true,
                    columns: {
                        Name: { content: "valore 1", className: "classe1" },
                        Age: { content: "valore 2", className: "classe2" },
                        Active: { content: "valore 3", className: "classe3" },
                        City: { content: "valore 4", className: "classe4" }
                    }
                }
            },
            options: {
                rowHeight: 50,
                childrenIdentifier: "_ch_",
                optimizationProfile: {
                    serverStore: "hybrid",//true, // false = default
                    preloadNum: 20,
                    compressedInMessage: true // false = default
                },
                //rowHeader: true,
                selection: 'single',
                //filtering: true,
                resizable: true,
                treeGrid: true,

                groupable: true,
                //groupRowsViewMode: true,
                expandColKey: 2,

                //bands: true/*,
                //oneClickEditing: true, // if oneClickEditing=false then see alwaysEditing, if alwaysEditing=false then dbl-click editing
                filtersDefaultConfig: {
                    isEnabled: true,
                    maxFilters: 2,
                    toShow: 2
                    //,langDictionary: en_US
                    //,operators: {hello: 0, ciao: 1}
                    //,boolOperators: []
                }
            },
            advOptions: {
                vScrollerMouseup: true,
                groupRowsStickerTitleKey: "Caption"
            },
            onDestroy: function(e)
            {
                console.log("destroyed", this, e);
            },
            onRowClick: function(e)
            {
                console.log("click");
            },
            onRowDblClick: function(e)
            {
                console.log("dbl-click");
            },
            onBeginEdit: function(cell)
            {
                console.log("Begin Edit: ", cell);
            },
            onEndEdit: function(cell, success)
            {
                console.log("End Edit: ", cell, success);
            },
            onCancelEdit: function(cell)
            {
                console.log("Cancel Edit: ", cell);
            },
            onRemoveFiltersReq: function()
            {
                console.log("Remove Filters Req.");
            },
            onRowExpand: function(rowid) {
                var isEmpty = false;
                if(isEmpty)
                {
                    var childs = [];
                    for (var index = 0; index < 50; index ++ )
                    {
                        //grid.addRow({kid: "1"+index, parentId: rowid}); // test
                        childs.push({kid: "1"+index, parentId: rowid/*, Name: "Ok", __hasAll__: true*/});
                    }
                    grid.addRowChilds(rowid, childs);
                }
            }
        });
        console.log("step 1", grid.id);
        grid.startup();

        // [serverStore tests] ----------------------------------------------------------------------
        /*grid.attachCommands(function()
        {
            grid.setViewedRowsNum(rowsNum);

        }).then(null, function(this_grid){
            console.warn("ERROR", this_grid.id);
        });*/
        grid.onRowNeed(function(rowsid){
            console.log(rowsid);
            for(var i=0; i< rowsid.length; i++)
            {
                var simulateObj = {
                    Name: names[Math.floor((Math.random()*10))]+ "_" +Math.floor((Math.random()*10)+1),
                    Age: Math.round(Math.random()*10),
                    City: Math.floor((Math.random()*4)),
                    City2: Math.floor((Math.random()*4))
                };

                grid.loadRow(rowsid[i], simulateObj); // simulate resp.

                //grid.loadRows([id_row: { ... }, id_row_2: { ... }]); //<--------- id typeof param[0] === "Object" ----> multiplo else no!
            }
        });
        // [serverStore tests] ----------------------------------------------------------------------

        ////////var promise = grid.attachCommands(function(){
        ////////    console.log("step 2", this.id); // this = this grid
        ////////});
        ////////
        ////////promise.then(function(this_grid){
        ////////    console.log("step 3", this_grid.id);
        ////////});
        ////////
        ////////grid.attachCommands(function(){
        ////////    this.setRowsHeight(40, false);
        ////////    console.log("step 4", this.id);
        ////////
        ////////    this.fake.error = true; // test error
        ////////
        ////////    grid.attachCommands(function(){
        ////////        console.log("step 5", this.id);
        ////////    });
        ////////
        ////////}).then(function(this_grid){
        ////////    console.log("step 6, OK", this_grid.id); // all success
        ////////},function(this_grid){
        ////////    console.log("step 6, ERROR", this_grid.id, ", NB step 5 not executed!"); // exception to manage
        ////////});
        ////////
        ////////grid.onStart(function(){
        ////////    this.fake.error = true; // test error
        ////////    console.log("step 7", this.id);
        ////////});
        ////////
        //////////console.log("step 1", grid.id);
        //////////grid.startup();

        if(false===true)
        {
            if(grid.editable) grid._getColumn("City").__cStore.add({id: 6, Name: "Lucca"/*"<span onclick='alert(\"ciao\");'>Lucca</span>"*/}); // escape test

            grid.attachCommands(function()
            {
                if(grid.gridx.tpFilters)
                {
                    f = grid.gridx.tpFilters;
                    c = grid._getColumn("Name");

                    // --> tip: f.BOOL_OPERATORS.get(0); -> return key of boolOperator
                    // --> tip: f.OPERATORS.get(0); -> return key of operator

                    // 1st filter
                    f.add("Name", {
                        operator: f.OPERATORS.otGreater,
                        value: 10,
                        //boolOperator: f.BOOL_OPERATORS.boAnd,
                        displayText: "testo_footer_filtro_1"
                    });

                    //2nd filter
                    f.add("Name", {
                        operator: f.OPERATORS.otLess,
                        value: 50,
                        boolOperator: f.BOOL_OPERATORS.boAnd,
                        displayText: "testo_footer_filtro_2"
                    });
                    //console.log( f.get("Name") );

                    //f.remove("Name", 1);
                    //console.log( f.get("Name") );

                    //f._removeFilterOption(1); // remove one HTML_filter from dialog (1st in this case)

                    grid.gridx.tpFilters.setVisibility(true);
                    /*grid.gridx.tpFilters.setContent("Hello");
                    grid.gridx.tpFilters.setContentStyle({color: "red"});
                    grid.gridx.tpFilters.setStyle({backgroundColor: "black"});
                    grid.gridx.tpFilters.addClass("class1");
                    grid.gridx.tpFilters.removeClass("class1");

                    ////grid.gridx.tpFilters.resetStyles();
                    ////grid.gridx.tpFilters.resetClasses();
                    grid.gridx.tpFilters.emptyBar();*/
                }
            });
        }
    }

    //grid.attachCommands(function()
    //{
    //    this.setRowsHeight(18);
    //});
    //grid3.attachCommands(function()
    //{
    //    this.setRowsHeight(18);
    //});

    // [TEST MENU] ----------------------------------------------------
    /*var gt = grid3;
    document.menu = $("#menu").dom_menu({
       width : 200
    }, function callback(msg){
       //console.log("selected: " + msg);
    });

    // bands test
    if( gt.gridx.bands )
    {
        document.menu.add({
            id: "bands-main",
            text: "Bande",
            value: "Bande"
        });
        document.menu.add({
            parent: "bands-main",
            id: "bands",
            text: "Bande",
            value: "Bande",
            action: function(){
                alert("Set visibility false to 'band1'");
                gt.gridx.bands.setVisibility("band1", false);
            }
        });
        document.menu.add({
            parent: "bands-main",
            id: "bandLock",
            text: "Lock Bande",
            value: "LockBande"
        });
    }

    document.menu.close();
    gt.onDxClick(function(event, gridTarget)
    {
        document.menu.open(event.pageX, event.pageY);
    });*/

    //arr = [ {kid:1}, {kid:2}, {kid:4}, {kid:3}, {kid:0} ];
    //test = function(){
    //    return arr.sort(function(a, b){
    //        if(a.kid >= b.kid){
    //            return 1;
    //        }else{
    //            return 0;
    //        }
    //    });
    //}

    //grid3.gridx.bands.setVisibility("band2", false); grid3.gridx.bands.setVisibility("band3", false);

    // [QGRID] -----------------------------------------------------------
    if( true === true )
    {
        qgrid = new dom_grid({
            id: 'grid_id_1',
            container: "dom_grid_container",
            height: 500,
            width: 650,
            data: ds4,
            layout: lang.clone(layout4),
            //bandsLayout: lang.clone(bands),
            modules: [
            ],
            options: {
                rowHeight: 50,
                //selection: "single",
                //groupable: true,
                //sorting: "single",
                resizable: true//,
                //columnsDnd: true, // false is default

                //bands: true,
                //bandsColumnsMode: true
                //bandsHideOnStart: true,


            },
            advOptions: {
                vScrollerMouseup: true,

                //columnsDndViewMode: true, // false is default
                //columnsDndDisableOnStartup: true,

                groupRowsStickerTitleKey: "id",
                groupRowsHideGroupBarOnStartup: false,
                groupRowsDisableGroupingOnStartup: false,
                groupRowsViewMode: true,
                groupRowsGroupList: [
                    {F: "Name", T: "Nome"},
                    {F: "Age", T: "Anni"}
                ]
            },
            onStart: function()
            {
                console.log(this.id+" started");
            },
            onRowClick: function(e)
            {
                console.log("click", e.rowId);
            }
        });
        qgrid.startup();
    }

    // [TGRID] -----------------------------------------------------------
    if( true === true )
    {
        simpleLayout = [
            {field: "name", name: "name", type: "string"},
            {field: "age", name: "age", type: "number"}
        ];

        treeStore = []; // use with simpleLayout
        uid = 0;
        for(var index = 0; index < 1000; index ++ )
        {
            treeStore.push({kid: (uid++).toString(), name: "Name_"+index, age: index, children: []});
        }
        //var ch = [];
        //for (var j = 10000; j < 10111; j ++ )
        //{
        //    treeStore[0].children.push({kid: j.toString(), name: "Name_"+j, age: j});
        //}

        tgrid = new dom_grid({
            id: 'grid_id_2',
            container: "dom_grid_container_2",
            height: 500,
            width: 650,
            //data: [{kid: 0, name: "Dodo", age: 29}],
            data: treeStore,
            layout: lang.clone(simpleLayout),
            modules: [
                //"gridx/modules/Pagination"
            ],
            options: {
                rowHeight: 22,
                rowHeader: true,
                selection: "single",
                resizable: true,
                treeGrid: true
            },
            advOptions: {
                vScrollerMouseup: true

                ,vScrollerViewMode: true
                ,vScrollerCount: treeStore.length
            },
            onStart: function()
            {
                console.log(this.id+" started");
            },
            onRowClick: function(e)
            {
                console.log("click", e.rowId);
            },
            onRowExpand: function(rowid)
            {
                var isEmpty = false;
                if(isEmpty)
                {
                    var ch = [];
                    for (var j = 0; j < 10; j ++ )
                    {
                        ch.push({kid: (uid++).toString(), name: "Name_"+rowid+"_"+j, age: j, children: []});
                    }
                    tgrid.addRowChilds(rowid, ch);
                }
                var length = tgrid.gridx.store.getChildren(tgrid.gridx.store.get(rowid)).length;
                tgrid.gridx.vScroller.setSize({count: tgrid.gridx.vScroller.count+length});
            },
            onRowCollapse: function(rowid)
            {
                var length = tgrid.gridx.store.getChildren(tgrid.gridx.store.get(rowid)).length;
                tgrid.gridx.vScroller.setSize({count: tgrid.gridx.view.visualCount});
            }
        });
        tgrid.startup();

        tgrid.connect('vScroller', 'onScrollEnd', function(value, type){
            //tgrid.gridx.body.renderRows(value, tgrid.gridx.vScroller._blockSize, false);
            //tgrid.gridx.vScroller.scrollToRow(value);
        });
    }

});
