require(['plugins/dom_grid/editable',
    'plugins/dom_grid/base',
    'dojo/on',
    'dojo/query',
    'dojo/aspect',
    'dojo/_base/lang',
    'dojo/store/Memory',
    'dojo/_base/Deferred',
    'plugins/dom_grid/extensions/Tools'
], function(editable, base, on, query, aspect, lang, Memory, Deferred, domTools){
    var longText = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec egestas, turpis ac gravida iaculis, sem purus finibus nulla, dictum porta...";

    VBR_DEBUG = true;
    ENVIRONMENT = {
        FONT_SIZE: 2
    };

    var cStore = [
        { id: 0, Name: "nessun valore" },
        { id: 1, Name: "doc < <<ARG01>> &#20107;"},
        { id: 2, Name: "Fabriano &#20107;"},
        { id: 3, Name: "Matera"},
        { id: 4, Name: "Pesaro &acute;"}
    ];

    var _iconsDictionary = {
        0: "icon_test",
        1: "icon_test2"
    };

    var layout = [
        { field: "name", name: longText,

            filters: {
                combobox: {
                    isEnabled: true,
                    data: [
                        { id: 0, label: "Tutti" },
                        { id: 1, label: "Personalizza..." }
                    ],
                    labelKey: 'label',
                    valueKey: 'id',
                    callback: function(colid, value){
                        console.log( "combobox_callback: ", colid, value );
                        if(value === 1)
                        {
                            g.tpFilters.openAdvDialog(colid, true);
                        }
                    }
                }
            },

            headerAlign: "right",
            align: "left",

            'headerClass': "prova_headerClassString",
            'class': "prova_classString",
            /*'headerClass': function(col){
             return "prova_headerClassFunc";
             },
             'class': function(cell){
             if(cell.row.rawData().totalRow){
             return "gridxTotalRow";
             }
             return "prova_classFunc";
             },*/

            band: "band1", width: 100, hidden: false, sorted: "DESC", editable: true, draggable: false
        },
        { field: "time", name:"Time", band: "band1", type: 'time', width: "150px", hidden: false, sorted: "DESC",
            editable: false,
            props: {

            }
        },
        { field: "age", name:"Age", band: "band1", type: 'boolean', width: 100, hidden: true, sorted: "DESC", align: "right", editable: true,
            props: {
                checkedValue: "ok",
                callback: function(e, cell){
                    console.log("Test click:", cell);
                }
            },
            sortable: false
        },
        { field: "quantity", name:"Quantity", band: "band1", type: 'numeric', width: "150px", hidden: false, sorted: "ASC",
            editable: true,
            props: {
                decimalSeparator: ",",
                places: 0,
                max: 10,
                min: 1
            }
        },
        { field: "code", name:"Code", band: "band2", type: 'text', width: "150px", hidden: false, sorted: "ASC",
            editable: true,
            props: {
                callback: function(e, cell){
                    alert("Test click:", cell);
                }
            }
        },
        {
            field: "city", name:"City", band: "band2", editable: true, width: "150px", type: 'combobox',
            props: {
                source: cStore,
                text: "Name",
                onChange: function(rowId, colId, newValue){
                    console.log("combobox change: ", rowId, colId, newValue);
                }
                //,readonly: false
            }
        }
    ];

    var bands = [
        { id: "band1", name: "Band 1", align: 'left'/*, locked: "left"/*, clocked: false*/ },
        { id: "band2", name: "Band 2", align: 'center', clocked: true },
        { id: "band3", name: "Band 3", align: 'right'/*, clocked: false*/}
    ];

    function createChilds(parentId, num, levels){
        var childs = [];
        for(var i=0; i<num; i++){
            var child = {};
            child['kid'] = parentId+"-"+i;
            child['name'] = "name-"+parentId+"-"+i;
            child['iL_i'] = true;
            if(levels){
                //for(var j=0; j<levels; j++){
                child['ch'] = createChilds(child['kid']+"-"+levels, num, levels-1);
                //}
            }
            childs.push(child);
        }
        return childs;
    }
    var data = [];
    var rowsNum = 200/*2000000*/;
    for(var i=0; i<rowsNum; i++)
    {
        var row = {kid: i+"", name: "prova "+i, ch: createChilds(i, 2, 0), iL_i: true, exp: "123"};
        data.push(row);
    }

    //var prevTextMap = {};
    //for(var i=0; i<100; i++){
    //    prevTextMap[i] = {
    //        "TE": "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam tempus, elit non finibus euismod, justo arcu feugiat velit, quis facilisis enim diam mattis mauris. Fusce vitae mollis sapien, maximus pharetra orci. Maecenas ac arcu lacus. Pellentesque id posuere ipsum. Cras non pharetra lectus. Curabitur auctor finibus leo. Cras lacinia porta lectus, ut dapibus justo pellentesque a. Vivamus sollicitudin arcu a ullamcorper interdum. Sed pretium accumsan massa. Phasellus mollis tempor urna, eu suscipit tellus venenatis non. Nulla facilisi. Etiam blandit dapibus urna tempus aliquam.",
    //        //"TE": "&quot;doc&quot; 'ok' < <<ARG01>> &#20107; &amp;#20107;",
    //        "FC": (i%2)?"red":"lime",
    //        "BC": "#fff",
    //        "Auto": (i%2)?false:true,
    //        "Lines": (i%2)?(3):(-1)
    //    };
    //}
    //
    //var groupFooterMap = {};
    //for(var i=0; i<100; i++){
    //    groupFooterMap[i] = {'name': "Total 1", code: "Total 2" };
    //}
    var config = {
        id: 'dom_grid_1',
        container: "dom_grid_container",
        height: 500,
        width: 650,
        data: data,
        layout: layout,
        //bars: {
        //    title: {
        //        content: "Griglia di Test",
        //        visible: true/*,
        //         style: "font-size: 16px; color: #9fd2ff;",
        //         className: "class1 class2"*/
        //    },
        //    footer: {
        //        visible: true,
        //        columns: {
        //            name: { content: "valore 1", className: "classe1" },
        //            age: { content: "valore 2" },
        //            code: { content: "valore 3" },
        //            city: { content: "valore 4" }
        //        }
        //    }
        //},
        options: {
            childrenIdentifier: "ch",
            // extraProperty: "ex",

            //oneClickEditing: true,

            // rowHeight: 50,
            // rowHeader: true,
            // resizable: true,
            //hideSelection: true,
            // sorting: 'multiple',

            // treeGrid: false,
            groupable: true,

            //widgets: false,

            // bands: true,

            // filtering: true,

            columnsDnd: true, // false is default
            // columnsDndViewMode: false, // false is default
            //columnsDndDisableOnStartup: true,

            //groupRowsViewMode: true,
            selection: 'single' //'single'     // or multiple ( ctrl+click for multi-row selection ), none is default
            /*, navigableCell: false*/

            //,headerMinRowCount: 2

            //, autoSearch: true
        },
        advOptions: {

            //groupRowsGroupList: [
            //    {id: "code", name: "Codice"}
            //],

            groupRowsExpandProperty: 'exp',

            rowHeaderVisibility: true,

            // BandsNEW parameters
            bandsHideOnStart: false,
            bandsDefinition: bands,

            vScrollerMouseup: true,
            vScrollerLazy: true
            //,
            //treeStateIconsMap: _iconsDictionary,
            //treeImageIconsMap: _iconsDictionary,
            //
            //bodyWidgetReplacement: false,
            //bodyCellsRender: {
            //    0: { code: "city" },
            //    1: { code: "age" },
            //    2: { city: "name" }
            //},
            //
            //previewTextEnabled: false,
            //previewTextProps: {
            //    "Lines": 1,
            //    "MaxLength": 2000,
            //    "Indent": 150,
            //    //"BO": true,
            //    "IT": true,
            //    "Auto": false
            //},
            //previewTextDeafultHeight: 1,
            //previewTextAutoHeightEnabled: true,
            //previewTextMap: prevTextMap,
            //
            //headerMinRowCount: 2,
            //bandsRowCount: 2,
            //
            //groupFooterEnabled: true,
            //groupFooterProps: {},
            //groupFooterMap: groupFooterMap
        },
        // onStart: function(){
        //     console.log("Started!");
        // },
        onRowClick: function(e)
        {
            console.log("onRowClick");
            // var g = gm.gridx;
            // console.log("onRowClick: row-> ", e.rowId, ", column-> ", e.columnId);
            // var cell = g.cell(e.rowId, e.columnId, true);
            // if(cell && (!cell.isEditing || (cell.isEditing && cell.isEditing() !== true)))
            // {
            //     cell.node().focus();
            // }
        },
        onRowDblClick: function(e)
        {
            console.log("onRowDblClick");
            // console.log("onRowDblClick: row-> ", e.rowId, ", column-> ", e.columnId);
        },
        // onDxClick: function(e)
        // {
        //     console.log("contextmenu: ", e);
        // },
        // onTopRowChange: function(rowid)
        // {
        //     console.log("TopRowChange:", rowid);
        // },
        // onRowStateClick: function(e)
        // {
        //     console.log(e);
        // },
        // onRowImageClick: function(e)
        // {
        //     console.log(e);
        // },
        // onRowSelection: function(rowId)
        // {
        //     console.log("onRowSelected: ", rowId);
        // },
        // onBeginEdit: function(cell) {
            // console.log("beginEdit: ", cell);
        // },
        onEndEdit: function(cell, success, value) {
            // console.log("endEdit: ", value, " - encodato: ", value ? text2HtmlEntities(value) : "");
            console.log("endEdit");
        }
        // onCancelEdit: function(cell)
        // {
        //     console.log("cancelEdit: ", cell);
        // },
        // onLockedCellClick: function(cell)
        // {
        //     console.log("lockedCellClick: ", cell);
        // },
        // onGroupDragOut: function(orig, dest, isBef, band)
        // {
        //     console.log("onGroupDragOut: ", orig, dest, isBef, band);
        // },
        // onFocus: function()
        // {
        //     console.log("Grid focus...");
        // },
        // onBlur: function()
        // {
        //     console.log("Grid blur...");
        // },
        // onKeyDown: function(e, keys, eventManager)
        // {
        //     console.log("grid key: ", e.keyCode);
        //     if([keys.UP_ARROW, keys.DOWN_ARROW, keys.RIGHT_ARROW, keys.LEFT_ARROW].indexOf(e.keyCode) !== -1)
        //     {
        //         if(e.target.tagName !== "INPUT")
        //         {
        //             eventManager.stop(e);
        //         }
        //     }
        // },
        // onMouseDown: function(e) {
        //     e.extra && console.log("mousedown: ", e.extra.rowId, e.extra.columnId);
        // }
        // onColumnResizerDblClick: function(colId){
        //     console.log("onColumnResizerDblClick: ", colId);
        // }
    };
    gm = new editable(config);
    gm.startup();
});