/**
 * Created by Dodo on 24/02/2015.
 */

require([
    'plugins/dom_grid/wsBaseGrid',
    'plugins/dom_grid/wsEditableGrid',
    'plugins/dom_grid/base',
    'dojo/on',
    'dojo/query',
    'dojo/aspect',
    'dojo/_base/lang',
    'dojo/store/Memory',
    'dojo/_base/Deferred',
    'plugins/dom_grid/extensions/Tools',
    'plugins/dom_grid/extensions/EventTools',
    'dojo/Deferred',
    'dojo/when'/*,
    'dojo/DeferredList'*/
], function(Grid, EditableGrid, Base, on, query, aspect, lang, Memory, Deferred, domTools, domEventTools, Deferred, when/*, DeferredList*/) {

    window.domTools = domTools;
    window.domEventTools = domEventTools;
    VBR_DEBUG = true;

    layout = [
        {field: "name", name: "Name", width: 100, type: "text"},
        {field: "lastName", name: "Last Name", width: 100, type: "text", editable: 1},
        {field: "active", name: "Active", width: 100, type: "boolean", props: {}}
    ];

    function createDataStore(rowsNum, childsNum, layout, idProp){
        var data = [],
            chAttr = "ch";
        for(var i=0; i<rowsNum; i++){
            var item = {kid: idProp+i, iL_i: false};
            //for(var j=0; j<layout.length; j++){
            //    var col = layout[j];
            //    item[col.field] = col.name+"-"+i;
            //}
            if(childsNum != null){
                /*if(childsNum === 0){
                    item[chAttr] = {length: 1};
                } else {*/
                    item[chAttr] = createDataStore(childsNum, null, layout, "ch-"+idProp+i+"-");
                /*}*/
            }
            data.push(item);
        }
        return data;
    }
    dataStore = createDataStore(200, 4, layout, "id");
    var first = dataStore[0].ch[0];
    first.ch = createDataStore(4, 1, layout, first.kid);
    //first.ch[0].ch = {length: 1};

    var config = {
        id: 'dom_grid_1',
        container: "dom_grid_container",
        height: 500,
        width: 650,
        data: dataStore,
        layout: layout,
        options: {
            childrenIdentifier: "ch",
            extraProperty: "ex",

            rowHeight: 18,
            rowHeader: true,
            resizable: true,
            hideSelection: true,
            sorting: 'multiple',

            treeGrid: true,
            //groupable: true,

            columnsDnd: true, // false is default
            selection: 'single',     // or multiple ( ctrl+click for multi-row selection ), none is default

            optimizationProfile: {
                isLoadIdentifier: "iL_i",
                serverStore: "hybrid", //true,
                //preloadNum: 20,
                compressedInMessage: true // false = default
            }
        },
        advOptions: {

        },
        onQueryData: function(query, options, responseCallback){
            /* AJAX request test */
            console.log("SEND > ", query, options);
            $.ajax(lang.mixin({
                url: "http://192.168.111.128:1337/",
                type: "POST",
                dataType: "json",
                data: query, // FIXME: remove parentItem from query?
                success: function(data){
                    console.log("RECV > ", data);
                    responseCallback && responseCallback(data); // fire response logic - store.resolve(resp) in specific async solution (ex. websocket)
                }
            }, options));
        },
        onRowNeed: function(ids){
            var items = [];
            for(var i=0; i<ids.length; i++){
                items.push({kid: ids[i], name: "Name"+ids[i], iL_i: true});
            }
            gm.loadRows(items);
        },
        onRowClick: function(row){
            console.log("Click row: ", row);
        },
        onEndEdit: function(cell, success, value, isChange){
            console.log("Edit end: row-"+cell.row.id, "col-"+cell.column.id, "value: "+value, "isChanged? "+isChange);
        },
        onRowExpand: function(id){
            console.log("expand:", id);
        },
        onTopRowChange: function(id){
            console.log("topRowChange:", this.id, id);
        },
        onRowExpandRequest: function(parentId, isRendered){
            console.log("Childs required: ", parentId, isRendered);
            setTimeout(function(){
                gm.addRowChilds(parentId, [
                    {kid: parentId+"-chhh-1", name: "Dom"},
                    {kid: parentId+"-chhh-2", name: "Dom2"}
                ], true, function(){
                    console.log("addRowChilds fatto!", parentId);
                });
                //g.gridx.tree.expand(parentId, false/*!g.gridx.body._getRowNode(parentId)*/);
            }, 500);



            //_ff(parentId);

            //return;




        }
    };
    gm = new EditableGrid(config);
    //gm.startup();

    setNewDataStore = function(){
        //g.clearDataStore();
        gm.setDataStore(createDataStore(100, 2, layout, "id"), function(){
            console.log("setDataStore compete!!!")
        });
    };

    //g2 = new EditableGrid(lang.mixin(config, {
    //    id: 'dom_grid_2',
    //    container: "dom_grid_container_2",
    //    data: createDataStore(10, 4, layout, "id"),
    //    layout: lang.clone(layout.concat([
    //        {field: "time", name: "Time", type: "time", width: 30, editable: true}
    //    ]))
    //}));
    //g2.startup();


    // griglia base
    /*g2 = new Base(lang.mixin(config, {
        id: 'dom_grid_2',
        container: "dom_grid_container_2",
        data: lang.clone(dataStore),
        layout: lang.clone(layout)
    }));
    g2.startup();*/

    /*_ff = function(id){
        var t = g.gridx.view,
            d = new Deferred();
        t.model.when({
            parentId: id,
            start: 0,
            count: 1
        }, function(){
            if(t._expand(id)){
                t._updateVC();
            }
            console.log("Fatto !");
        }).then(function(){
            d.callback();
        }, function(e){
            d.errback(e);
        });
        return d;
    };*/

});