var Polyedro_Gantt = function (opts) {

    /**
     * E' l'istanza del controllo Gantt.
     * @type {object}
     * @private
     */
    this._ganttChart = undefined;
    this._domId = opts.domId || "gantt-container";
    this._options = {};



    /**
     * Il comando layout è inviato dal server per inizializzare il gantt
     * @param {object} args
     * @private
     */
    this.init = function (args) {
        var //self = this,
            timelineScale = 'm';

        this._options = args;
        this._setTaskCellsBackground = args.taskCellBackgroundFunction;

        // Il controllo è già stato istanziato? In caso affermativo non ho niente da fare.
        if (this._ganttChart) {
            return;
        }

        this._options['onTaskRowClick'] = $.proxy(function (taskId, row, evt) {
           //console.log('onTaskRowClick', arguments);
        }, this);

        this._options['onTaskClick'] = $.proxy(function (taskId, evt) {
            var task;
            if(taskId) {
                task = this._ganttChart.getTask(taskId);
            }
            console.log('onTaskClick', task);
        }, this);

        this._options['onTaskDblClick'] = $.proxy(function (taskId, evt) {
            var task;
            if(taskId) {
                task = this._ganttChart.getTask(taskId);
            }
            console.log('onTaskDblClickAAAAAAAAAAAAAAAAAAAAAAAAAA', task);
        }, this);





        // Istanzio il Gantt
        this._ganttChart = new GanttChart(this._options);

        if (timelineScale) {
            if (timelineScale instanceof Array) {
                /*if (timelineScale.length > 1) {
                 options['headerHeight'] *= timelineScale.length;
                 }*/
                this._ganttChart.setScales(timelineScale);
            } else {
                this._ganttChart.setPredefinedScale(timelineScale);
            }
        }

        if (typeof args['highlighted_dates'] !== 'undefined') {
            this._ganttChart.setHighlightedDates(args['highlighted_dates']);
        }
    };

    /**
     * Il comando datainit è inviato dal server con i dati iniziali da inserire nel gantt
     * @param {object} args
     * @private
     */
    this.setData = function (args) {
        // Quando mi arrivano i dati iniziali inizializzo anche il controllo gantt
        if (args && Object.keys(args).length > 0) {

            if (args['mindate'] !== undefined && args['maxdate'] !== undefined) {
                this._minDate = this._ganttChart.stringToDate(args['mindate'] + ' 00:00:00');
                this._maxDate = this._ganttChart.stringToDate(args['maxdate'] + ' 00:00:00');
            }

            if (this._minDate && this._maxDate) {
                this._fitWidthWithExtraColumns(this._minDate, this._maxDate);
            }

            this._hasData = true;


            args.data = this._setTaskCellBackground ? this._setTaskCellBackground(args.data) : args.data;

            this._ganttChart.loadData(args);

            if (this._initialFirstVisibleDate) {
                this._scrollToDate(this._initialFirstVisibleDate);
                this._initialFirstVisibleDate = null;
            }
        }
        this._renderTreeIcons();
    };

    this._fitWidthWithExtraColumns = function (initDate, endDate) {
        var columnsCount,
            columnWidth,
            columnsExtent,
            extraColumnsCount,
            vacuumSpace,
            config,
            dateUtils,
            minDate,
            maxDate,
            shortestScale = 'day',
            weightedScales = {
                "year": 6,
                "month": 5,
                "week": 4,
                "day": 3,
                "hour": 2,
                "minute": 1
            },
            oneDay = 24 * 60 * 60 * 1000,
            days = Math.round(Math.abs((endDate.getTime() - initDate.getTime()) / (oneDay)));

        days++; // Conto anche il giorno finale

        // Cerco quale è la scala più piccola tra quelle specificate
        if (this.timeLines !== undefined) {
            for (var timeline, i = 0, n = this.timeLines.length; i < n; i++) {
                timeline = this.timeLines[i];
                if (weightedScales[timeline.scale_unit] < weightedScales[shortestScale]) {
                    shortestScale = timeline.scale_unit;
                }
            }
        }

        // In base alla scala, calcolo il numero di colonne che sono comprese tra le date
        if (shortestScale == 'minute') {
            columnsCount = days * 86400;
        } else if (shortestScale == 'hour') {
            columnsCount = days * 24;
        } else if (shortestScale == 'day') {
            columnsCount = days;
        } else if (shortestScale == 'week') {
            columnsCount = Math.ceil(days / 7);
        } else if (shortestScale == 'month') {
            columnsCount = Math.ceil(days / 30);
        } else if (shortestScale == 'year') {
            columnsCount = Math.ceil(days / 365);
        }

        config = this._ganttChart.getConfiguration();

        columnWidth = config.chartColumnsWidth;

        columnsExtent = columnsCount * columnWidth;
        if (columnsExtent < this.width) {
            vacuumSpace = this.width - columnsExtent;

            extraColumnsCount = Math.ceil(vacuumSpace / columnWidth);

            dateUtils = this._ganttChart.dateUtils();

            minDate = dateUtils.add(initDate, -1, shortestScale);//initDate;
            maxDate = dateUtils.add(endDate, extraColumnsCount, shortestScale);

            this._ganttChart.setDateRange(minDate, maxDate);

            return true;
        }

        return false;
    };


    /**
     * Renderizza le icone dell'albero contenuto nella griglia
     * @private
     */
    this._renderTreeIcons = function () {
        var icons = this._options.icons || [];
        for (var icon, i = 0, n = icons.length; i < n; i++) {
            icon = icons[i];
            this._ganttChart.changeNodeIcon(icon.idtask, icon.idicon);
        }
        if (icons.length > 0) {
            this._ganttChart.refreshGrid();
        }
    };

    /**
     * Funzione che imposta lo sfondo delle cella della griglia
     * in base a determinati valori preimpostati
     * @param data
     * @returns {*}
     * @private
     */
    this._setTaskCellBackground = function (data) {
        for (var i = 0; i< data.length;i++){
            var task = data[i];
            var backgroundColors = {};

            // Set logic here
            if(task.stato > 0 && task.stato < 20){
                backgroundColors.stato = "#3063E8";
            }

            if(task.tipo === "2"){
                backgroundColors.tipo = "#FF7D42";
            }

            task.grid_backgrounds = backgroundColors;
        }

        return data;
    };
};
