require([
    'plugins/dom_grid/GridManager'
    , 'dojo/_base/lang'
], function (GridManager, lang) {
    grid = new GridManager({
        id: 'grid-c',
        width: 610,
        height: 400,
        container: 'grid-c-cnt',

        editable: true, // forza il GridManager ad istanziare la griglia editabile (/editable.js o /mobileEditable.js).

        bars: {
           title: {
               content: "Griglia di Test"
               , visible: true
               // , style: "font-size: 16px; color: #9fd2ff;"
               // , className: "class1 class2"
           },
           footer: {
               visible: true,
               columns: {
                   name: { content: "valore 1", className: "classe1" },
                   active: { content: "valore 3" },
                   age: { content: "valore 2" }
               }
           }
        },
        layout: [
            {
                field: 'name', // obbligatorio. id colonna. usare in alternativa. l'attributo id viene impostato uguale al field.
                name: 'Nome Utente', // obbligatorio. testo del column header.
                width: '300px', // obbligatorio. larghezza della colonna in px. accetta interi.
                type: 'text', // default=text. imposta il tipo di colonna per i widget di visualizzazione\modifica. vedi /extensions/Widget.js e /editable.js per l'elenco completo.

                headerAlign: 'center', // default=left. right|left|center|undefined. allineamento testo celle header
                align: 'center', // default=left. right|left|center|undefined. allineamento testo celle body

                sorted: 'ASC', // ASC|DESC|undefined. imposta lo stile del pulsante di ordinamento.
                sortable: true, // default=true. indica se una colonna può essere ordinata. ha effetto sulla visibilà del bottone.
                editable: true, // default=false. attiva l'editabilità al click singolo delle celle nella colonna.
                filters: {
                    // filtro comobobx visibile come button a destra nell'header di colonna.
                    // la callback non applica un filtro autonomamente sulla griglia ma genera un evento verso il server.
                    // sarà il server ad aggiornare il menù popup e i filtri attivi.
                    combobox: {
                        isEnabled: true,
                        data: [
                            { id: 0, label: "Tutti" },
                            { id: 1, label: "Personalizza..." }
                        ],
                        labelKey: 'label',
                        valueKey: 'id',
                        callback: function(colid, value){
                            console.log( "combobox filter callback: ", colid, value );
                            grid.gridx.tpFilters.openAdvDialog(colid, true);
                        }
                    },
                    // checkbox visibile a sinistra nell'header.
                    // la callback non applica un filtro autonomamente sulla griglia ma genera un evento verso il server.
                    checkbox: {
                        callback: function(e, colid, isChecked){
                            console.log("checkbox filter callback: ", colid, isChecked);
                        },
                        checked: false,
                        isEnabled: true
                    },
                    // filtri attivi e visibili nella dialog dei filtri avanzati . questi vengono impostati dal server.
                    active: [{
                        operator: 1,
                        value: '1&#176; semestre'
                    }, {
                        operator: 2,
                        boolOperator: 1, // or
                        value: 'Fondazioni'
                    }]
                },

                band: 'band1' // obbligatorio se bands è attivo. definisce l'appartenza alla banda(id).
            },
            {field: 'active', name: 'Utente Attivo', width: '150px', type: 'checkbox', headerAlign: 'center', align: 'center', band: 'band2'},
            {field: 'age', name: 'Anni', width: '100px', type: 'text', headerAlign: 'center', align: 'right', band: 'band2'}
        ],
        data: [{
            id: 1,
            name: 'Domenico',
            active: true,
            _il: true
        }, {
            id: 2,
            name: 'Simone',
            active: false,
            _il: false // questo indica che la riga non è completa. Partirà un evento onRowNeed.
        }, {
            id: 3,
            name: 'Marco',
            active: true,
            _il: true
        }],
        options: {
            idProperty: 'id' // il default è 'kid', rappresenta l'attributo con cui identificare univocamente le righe nello store.
            , optimizationProfile: { // profilo di ottimizzazione per la richiesta dati.
                serverStore: 'hybrid' //(bind con _rowsHybridReq) o true(bind con _rowsReq). su Alyante usiamo 'hybrid'. E' utile per impostare le righe con il solo id e richiedere i dati al solo render delle stesse nel caso in cui il parametro isLoadIdentifier(_il) della riga è != true.
                , isLoadIdentifier: '_il' // è un parametro utilizzato per marcare una riga come incompleta ed attivare la logica di richiesta al server.
                , compressedInMessage: true // attiva il supporto interno della griglia ai dataSource del tipo {m, d}.
            }

            , rowHeight: 25 // default=18. imposta un'altezza custom delle righe. Su Alyante è calcolato in automatico sulla base del font.
            , rowHeader: true // blocco di selezione a sinistra.

            , columnsDnd: true // se true al drop sull'header di altre colonne genera l'evento onColumnDnd.
            , columnsDndViewMode: true // se false non effettua il move delle colonne al drop sull'header di altre colonne.

            , sorting: 'single' // single|multiple. il default in gamma è single. rende visibili i pulsanti per il sorting delle colonne.
            , resizable: true // default=false. attiva il resize delle colonne.

            , selection: 'single' // default=single. single|cell|multiple. gamma utilizza single e cell.

            , bands: true // attiva le bande e bandLock.

            , filtering: true // attiva i filtri sulle colonne.

            //, hideSelection: true // default=false. Disattiva i colori di selezione.


        },
        advOptions: {
            headerMinRowCount: 2 // default=1. altezza minina Header di colonna.

            , bandsHideOnStart: false // default=false. nasconde le bande allo startup.
            , bandsRowCount: 2 // default=1. altezza minina bande.
            , bandsDefinition: [{
                id: 'band1' // id banda
                , name: 'Band 1' // testo
                //, locked: "left" // right|left|undefined. banda bloccata allo startup. possono esserci al più due bande uan locked a dx e una a sn.
                , clocked: false // blocco colonne sulla banda in caso di dnd tra bande.
            }, {
                id: 'band2', name: 'Band 2'
            }]

            // l'altezza della previewtext concorre all'altezza totale della riga su cui è iniettata.
            , previewTextEnabled: true // attivazione logica riga di dettaglio.
            , previewTextProps: { // opzionale. proprietà di default applicate a ciascuna riga.
               "Lines": 1 // numero di linee della riga di dettaglio.
               , "MaxLength": 2000 // numero di caratteri massimo.
               , "Indent": 150 // padding a sinistra del testo
               , "BO": false // grassetto
               , "IT": false // italic
               , "Auto": false // auto height
            }
            , previewTextDeafultHeight: 1 // è il numero di lines utilizzato se una riga ha lines=-1
            , previewTextAutoHeightEnabled: true // disattiva il calcolo dell' auto height ed attiva lo scrolling+deafultHeight.
            , previewTextMap: {
                1: {
                    "TE": "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam tempus, elit non finibus euismod, justo arcu feugiat velit, quis facilisis enim diam mattis mauris. Fusce vitae mollis sapien, maximus pharetra orci. Maecenas ac arcu lacus. Pellentesque id posuere ipsum. Cras non pharetra lectus. Curabitur auctor finibus leo. Cras lacinia porta lectus, ut dapibus justo pellentesque a. Vivamus sollicitudin arcu a ullamcorper interdum. Sed pretium accumsan massa. Phasellus mollis tempor urna, eu suscipit tellus venenatis non. Nulla facilisi. Etiam blandit dapibus urna tempus aliquam.",
                    "FC": "red", // colore testo
                    "BC": "#fff", // colore background
                    "Auto": false, // auto height
                    "Lines": -1, // viene utilizzato il line definito a livello globale su previewTextProps.
                    "BO": true, // grassetto
                    "IT": true // italic
                },
                2: {
                    "TE": "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam tempus, elit non finibus euismod, justo arcu feugiat velit, quis facilisis enim diam mattis mauris. Fusce vitae mollis sapien, maximus pharetra orci.",
                    "FC": "#000", // colore testo
                    "BC": "lime", // colore background
                    "Auto": true // auto height
                },
                3: {
                    "TE": "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam tempus, elit non finibus euismod, justo arcu feugiat velit, quis facilisis enim diam mattis mauris. Fusce vitae mollis sapien, maximus pharetra orci. Maecenas ac arcu lacus. Pellentesque id posuere ipsum. Cras non pharetra lectus. Curabitur auctor finibus leo. Cras lacinia porta lectus, ut dapibus justo pellentesque a. Vivamus sollicitudin arcu a ullamcorper interdum. Sed pretium accumsan massa. Phasellus mollis tempor urna, eu suscipit tellus venenatis non. Nulla facilisi. Etiam blandit dapibus urna tempus aliquam.",
                    "FC": "blue", // colore testo
                    "BC": "yellow", // colore background
                    "Indent": 50,
                    "Lines": 2 // sovrascriviamo il lines di default.
                }
            }
        },
        onStart: function(){
            console.log('startup');
        },
        onRowSorting: function(){
            console.log('row-sorting:', arguments);
        },
        onRowNeed: function(rows){
            // Qui viene utilizzata una tecnica di debounce che raggruppa più richieste in modo da ottenere un array di id.
            console.log('row-need:', rows);

            var rowsData = [];
            for(var i=0; i<rows.length; i++){
                rowsData.push({id: rows[i], age: 21, _il: true}); // _il: true marca la riga come completa, quindi non verrà più richiesta tramite rowNeed.
            }
            grid.loadRows(rowsData); // Aggiorniamo le righe rimuovendole dalle lista delle righe richieste e non in cache.
        },
        onColumnDnd: function(){
            console.log('column-dnd:', arguments);
        },
        onBeginEdit: function(){
            console.log('cell-edit-start:', arguments);
        },
        onCancelEdit: function(){
            console.log('cell-edit-cancel:', arguments);
        },
        onEndEdit: function(){
            console.log('cell-edit-end:', arguments);
        }
    });

    grid.startup().then(lang.hitch(grid, function(){

        // Utilizza questo codice se vuoi reimpostare il dataSource.
        // this.setDataStore([{
        //     id: 1,
        //     name: 'Domenico',
        //     active: true
        // }, {
        //     id: 2,
        //     name: 'Simone',
        //     active: false
        // }]);

    }));
});