/**
 * Created by s.cosma on 14/07/2016.
 */
require(
    ['plugins/dom_grid/GridManager'],
    function (GridManager) {
        grid = new GridManager({
            id: 'my-grid',
            height: 500,
            width: 800,
            container: 'grid-1-cnt',
            editable: true,
            layout: [
                {field: 'name', name: 'Name', editable: true},
                {field: 'surname', name: 'Surname'},
                {field: 'age', name: 'Age', type: 'numeric', editable: true},
                {field: 'address', name: 'Address', type: 'text'},
                {field: 'boolean', name: 'True/False', type:'checkbox'},
                {field: 'link', name: 'Link', type:'hyperlink', props:{
                    callback: function(a, b) {
                        console.log(grid.getRowById(b.row.id).link);
                        window.location = grid.getRowById(b.row.id).link;
                    }
                }},
                {field: 'combo', name: 'Combobox', type: 'combobox', editable: true, props: {
                    text: 'textField',
                    source: [{
                        id: 1, textField: 'Valore Combo 1'
                    }, {
                        id: 2, textField: 'Valore Combo 2'
                    }]
                }}
            ],
            data: [
                {
                    id: 1,
                    name: 'Simone',
                    surname: 'Cosma',
                    age: -20,
                    address: 'Fabriano',
                    boolean:true,
                    exp: 'aaaa',
                    value: 'Valore1',
                    link: 'http://www.google.it',
                    combo: 1,
                    ch:[{
                        id: 3,
                        name: 'Simone',
                        surname: 'Cosma',
                        address: 'Fabriano',
                        boolean:true,
                        iL_i:true
                    }
                    ], iL_i:true},
                {id: 2, name: 'AAA', surname: 'BBBB', address: 'Fabriano',boolean:false, ch:[], iL_i:true}
            ],
            options:{
                dataSourceIdentifier: 'id',
                //sorting: 'single',
                //groupable: true,
                columnsDndViewMode: false, // false is default
                expandProperty: 'name',
               // bands: true,
                //resizable: true,
                childrenIdentifier: "ch",
                extraProperty: "ex",
                columnsDnd: true
            },
            // bars: {
            //     title: {
            //         content: 'Prova Barra',
            //         visible: true
            //     }
            // },
            onRowSorting: function() {
                console.log(arguments);
            }


            }
        );
        grid.startup();
    }
)