require([
    'plugins/dom_grid/GridManager'
    , 'dojo/_base/lang'
], function (GridManager, lang) {
    qgrid = new GridManager({
        id: 'grid-q',
        width: 600,
        height: 400,
        container: 'grid-q-cnt',
        layout: [
            {field: 'name', name: 'Nome Utente', width: '300px', sorted: 'ASC', groupText: 'Sticker Name'},
            {field: 'active', name: 'Utente Attivo', width: '300px', type: 'checkbox', headerAlign: 'center', align: 'left', groupText: 'Sticker Active'}
        ],
        data: [{
            kid: 1,
            _expInfo: 'Famiglia D\'Ercole',
            ch: [
                { kid: 5, _expInfo: 'Figlio di Domenico', ch:[
                    { kid: 6, name: 'Figlio di Figlio di Domenico 1', active: true },
                    { kid: 7, name: 'Figlio di Figlio di Domenico 2', active: true }
                ]}
              // non specifico i figli. All'espansione del nodo partire un evento onRowExpand.
            ]
        }, {
            kid: 20,
            _expInfo: 'Famiglia Cosma',
            ch:[
                { kid: 3, _expInfo: 'Figlio di Simone', ch:[
                    { kid: 4, name: 'Figlio di Figlio di Simone', active: true }
                ] }
            ]
        }],
        options: {
            childrenProperty: 'ch', // utile per identificare il parametro in cui passare l'array di oggetti (figli della riga). undefined o false per definire una riga non nidificata.
            expandProperty: '_expInfo', // utilizzato per mostrare nella colonna di espansione il testo del gruppo leggendolo dall'oggetto riga in corrispondenza del parametro '_expInfo'. Utile anche dopo il move delle colonne.
            groupable: true // attiva la logica di raggruppamento (barra di raggruppamento, blocchi draggabili e  righe nidificate con stile specifico).
        },
        advOptions: {
            groupRowsStickerTitleKey: "groupText", // parametro dell'oggetto colonna da cui leggere il testo del blocchetto di raggruppamento. il default è 'name'.
            groupRowsGroupList: [{id:'name', name: 'Hello!'}], // gruppi attivi allo startup. è possibile specificare il name solo se non si passa il layout in fase di configurazione e in caso contrario viene utilizzato l'id.
            groupRowsViewMode: true, // true è il default e ad oggi non supportiamo il raggruppamento lato client(false).
            groupRowsHideGroupBarOnStartup: false, // nasconde la groupbar posta in testa alla griglia
            groupRowsDisableGroupingOnStartup: false, // disattiva la logica di grouping
            groupRowsHasIndexIdentifier: true, // comunica alla griglia che le righe al livello root hanno un id === index (1-base) per rendere più veloce lo scrollToRow.

            // l'altezza della groupfooter concorre all'altezza totale della riga su cui è iniettata.
            groupFooterEnabled: false, // Attiva la renderizzazione e le logiche del groupFooter
            groupFooterMap: { // mappa dei groupFooter
                1: {name: 'Sub-Totale 1', active: 'Sub-Totale 2'}, // con riferimento al gruppo con kid 1
                2: {name: 'Sub-Totale 1', active: 'Sub-Totale 2'} // con riferimento al gruppo con kid 2
            }
        },
        onRowGrouping: function(){
            // scatenato al drop
            console.log('grouping:', arguments);
        },
        onRowNeed: function(){
            console.log('row-need:', arguments);
        },
        onRowExpand: function(){
            console.log('row-expand:', arguments);
        },
        onRowCollapse: function(){
            console.log('row-collapse:', arguments);
        },
        onRowExpandRequest: function(){
            console.log('row-expand-request:', arguments);

        }
    });

    qgrid.startup().then(lang.hitch(grid, function(){
        // codice da eseguire post-inizializzazione griglia
    }));
});