require([
    'plugins/dom_grid/GridManager'
    , 'dojo/_base/lang'
], function (GridManager, lang) {
    tgrid = new GridManager({
        id: 'grid-t',
        width: 600,
        height: 400,
        container: 'grid-t-cnt',
        layout: [
            {field: 'name', name: 'Nome Utente', width: '300px', sorted: 'ASC'},
            {field: 'active', name: 'Utente Attivo', width: '300px', type: 'checkbox', headerAlign: 'center', align: 'left'}
        ],
        data: [{
            kid: 1,
            name: 'Domenico',
            ch: [
              // non specifico i figli. All'espansione del nodo partire un evento onRowExpand.
            ]
        }, {
            kid: 2,
            name: 'Simone',
            ex: {i: 1, s: 0}, // sono le informazioni extra(image\stateIcon)
            ch:[
                { kid: 3, name: 'Figlio di Simo',
                    ch: [
                        {
                            kid: 6,
                            name: 'Figlio del Figlio'
                        }
                    ],
                    active: true }
            ]
        }],
        options: {
            childrenProperty: 'ch', // utile per identificare il parametro in cui passare l'array di oggetti (figli della riga). undefined o false per definire una riga non nidificata.
            treeGrid: true, // attiva la logica del tree-view.
            extraProperty: "ex" // proprietà che identifica il dizionario per informazioni extra (es. image\stateIcon)
        },
        advOptions: {
            treeStateIconsMap: { // è il dizionario delle classi applicabili al nodo di espansione (stateIcon)
                0: "dir-icon", // valore -> nome classe
                1: "checked-icon"
            },
            treeImageIconsMap: { // è il dizionario delle classi applicabili al nodo di espansione (imageIcon)
                0: "dir-icon",
                1: "checked-icon"
            }
        },
        onRowNeed: function(){
            console.log('row-need:', arguments);
        },
        onRowExpand: function(){
            console.log('row-expand:', arguments);
        },
        onRowCollapse: function(){
            console.log('row-collapse:', arguments);
        },
        onRowExpandRequest: function(){
            console.log('row-expand-request:', arguments);
            tgrid.addRowChilds(1, [
                { kid: 4, name: 'Figlio1 di Domenico', active: true },
                { kid: 5, name: 'Figlio2 di Domenico', active: false }
            ]);
        }
    });

    tgrid.startup().then(lang.hitch(grid, function(){
        // codice da eseguire post-inizializzazione griglia
    }));
});