KeyCodes = {
    VK_CANCEL: 3,
    VK_HELP: 6,
    VK_BACK_SPACE: 8,
    VK_TAB: 9,
    VK_CLEAR: 12,
    VK_RETURN: 13,
    VK_SHIFT: 16,
    VK_CONTROL: 17,
    VK_ALT: 18,
    VK_PAUSE: 19,
    VK_CAPS_LOCK: 20,
    VK_ESCAPE: 27,
    VK_SPACE: 32,
    VK_PAGE_UP: 33,
    VK_PAGE_DOWN: 34,
    VK_END: 35,
    VK_HOME: 36,
    VK_LEFT: 37,
    VK_UP: 38,
    VK_RIGHT: 39,
    VK_DOWN: 40,
    VK_PRINTSCREEN: 44,
    VK_INSERT: 45,
    VK_DELETE: 46,
    VK_0: 48,
    VK_1: 49,
    VK_2: 50,
    VK_3: 51,
    VK_4: 52,
    VK_5: 53,
    VK_6: 54,
    VK_7: 55,
    VK_8: 56,
    VK_9: 57,
    VK_A: 65,
    VK_B: 66,
    VK_C: 67,
    VK_D: 68,
    VK_E: 69,
    VK_F: 70,
    VK_G: 71,
    VK_H: 72,
    VK_I: 73,
    VK_J: 74,
    VK_K: 75,
    VK_L: 76,
    VK_M: 77,
    VK_N: 78,
    VK_O: 79,
    VK_P: 80,
    VK_Q: 81,
    VK_R: 82,
    VK_S: 83,
    VK_T: 84,
    VK_U: 85,
    VK_V: 86,
    VK_W: 87,
    VK_X: 88,
    VK_Y: 89,
    VK_Z: 90,
    VK_NUMPAD0: 96,
    VK_NUMPAD_DIVIDE: 111,
    VK_F1: 112,
    VK_F2: 113,
    VK_F3: 114,
    VK_F4: 115,
    VK_F5: 116,
    VK_F6: 117,
    VK_F7: 118,
    VK_F8: 119,
    VK_F9: 120,
    VK_F10: 121,
    VK_F11: 122,
    VK_F12: 123,
    VK_NUMLOCK: 144,
    VK_OPEN_BRACKET: 186,
    VK_CLOSE_BRACKET: 187,
    VK_AT: 192,
    VK_SHARP: 222,
    ALL: -100
};

$(document).on("ready", function(){

    var defaultIcon = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNvyMY98AAAA5SURBVDhPpcixDQAgDMCw/v904QAPRETykrntJ86Cs+AsOAvOgrPgLDgLzoKz4Cw4C86Cs+B8NHsAm8z/AS15iaAAAAAASUVORK5CYII=';
    //var data = [
    //    {id: "id-0", text: 'elem-0', state: 'enabled'/*'disabled'*/, value: 0, checked: true, icon: defaultIcon, parent: "alyante"},
    //    {id: "id-0-0", text: 'elem-0-0', value: 2, checked: false, icon: null, /*icon: defaultIcon,*/ parent: "id-0", iconClass: 'default-icon'},
    //    {parent: "alyante", type: "separator"},
    //    {id: "id-1", text: 'elem-1', disabled: false, value: 1, checked: false, icon: null, parent: "alyante"},
    //    {parent: "id-0", separator: true},
    //    {id: "id-2", text: 'elem-2', disabled: true, value: 1, checked: true, icon: null, parent: "alyante"}
    //];
    var main = [
        {id:"alyante", text:"Alyante", parent: null, iconClass: "ui-icon ui-icon-star"},
        {id:"alyante-next", text:"Alyante Next", parent: null, iconClass: "ui-icon ui-icon-link"}
    ];
    var unsorted = ([
        {value:"proteo:app_testformcontainer", text:"Test FormContainer", parent: "alyante-next"},
        {value:"proteo:app_testcontotextvalue", text:"Test Conto", parent: "alyante-next"},
        {value:"proteo:app_testradiobuttons", text:"Test RadioButtons", parent: "alyante-next"},
        {value:"proteo:app_testlists", text:"Test Lists", parent: "alyante-next"},
        {value:"proteo:app_testform", text:"Test Form", parent: "alyante-next"},
        {value:"proteo:app_testtabcontainer", text:"Test TabContainer", parent: "alyante-next"},
        {value:"proteo:app_testsidebarcontainer", text:"Test SideBarContainer", parent: "alyante-next"},
        {value:"proteo:app_testsidebarmenu", text:"Test SideBarMenu", parent: "alyante-next"},
        {value:"proteo:app_testgridlayout", text:"Test GridLayout", parent: "alyante-next"},
        {value:"proteo:app_testgrid_query", text:"Test Grid Query", parent: "alyante-next"},
        {value:"proteo:app_testgrid_database", text:"Test Grid Dati", parent: "alyante-next"},
        {value:"000.050.010.010", text:"Legacy:Codici IVA", parent: "alyante-next"},
        {value:"proteo:app_codivaform", text:"AlyanteNext:Codici IVA", parent: "alyante-next"},
        {value:"proteo:app_anagclifor", text:"AlyanteNext: Anagrafica Clienti/Fornitori", parent: "alyante-next"},
        {value:"proteo:app_anaggen", text:"AlyanteNext: Anagrafica Generale", parent: "alyante-next"},
        {value:"proteo:app_azienda", text:"AlyanteNext: Anagrafica Azienda", parent: "alyante-next"},
        {value:"proteo:app_sedi", text:"AlyanteNext: Anagrafica Sedi", parent: "alyante-next"},
        {value:"proteo:app_naturagiuridica", text:"AlyanteNext: Natura Giuridica", parent: "alyante-next"},
        {value:"proteo:app_flussografico", text:"AlyanteNext: Flusso Grafico", parent: "alyante-next"},
        {value:"proteo:app_gruppiutenti", text:"AlyanteNext: Gruppi/Utenti", parent: "alyante-next"},
        {value:"000.270.090.070", text:"Lancio in produzione", parent: "alyante"},
        {value:"000.300.050.020.020", text:"Versamento Tempi", parent: "alyante"},
        {value:"000.050.040.090.010", text:"Scheda Cliente", parent: null}, //000.050.060.010
        {value:"000.050.010.010", text:"Codici IVA", parent: null},
        {value:"000.050.010.020", text:"Natura giuridica", parent: null},
        {value:"000.050.030.010", text:"Anagrafica azienda", parent: "alyante"},
        {value:"000.050.040.010", text:"Anagrafica generale", parent: "alyante"},
        {value:"000.050.040.020", text:"Anagrafica clienti", parent: "alyante"},
        {value:"000.050.040.030", text:"Anagrafica fornitori", parent: "alyante"},
        {value:"000.100.010.010.010", text:"Causali contabili", parent: "alyante"},
        {value:"000.100.010.010.070", text:"Configurazione contabilità", parent: "alyante"},
        {value:"000.100.070.010.010", text:"Movimenti prima nota", parent: "alyante"},
        {value:"000.100.180.010.020", text:"Interrogazioni e stampa effetti attivi/passivi", parent: "alyante"},
        {value:"000.250.010.010.010", text:"Produzione/Parametri Generali", parent: "alyante"},
        {value:"000.050.030.160.010", text:"Divisioni/Anagrafica divisioni", parent: "alyante"},
        {value:"000.300.050.010.010", text:"Versamento tempi/Quantità di produzione", parent: "alyante"},
        {value:"000.150.040.020.030", text:"Flusso grafico documenti", parent: null},
        {value:"000.500.010.050.030", text:"Gestione tabelle precaricate", parent: "alyante"},
        {value:"000.500.010.050.010", text:"Flussi operativi/tab. precaricate", parent: "alyante"},
        {value:"000.150.070.010.010", text:"Gestione composizione prodotti", parent: "alyante"},
        {value:"000.270.010.020.010", text:"Fashion/Console anagrafiche", parent: "alyante"},
        {value:"000.250.040.010.050", text:"Fabbisogni/Elaborazione MRP (progress alta con dettaglio e barra di progresso bassa)", parent: "alyante"},
        {value:"000.300.010.010.040", text:"Prog./Par. e Tab. Com./Attività", parent: "alyante"},
        {value:"000.300.010.010.020", text:"Prog./Par. e Tab. Com./Progetto", parent: "alyante"},
        {value:"000.500.040.250.110", text:"Correlazione liste-libere-programmi", parent: "alyante"},
        {value:"000.500.040.100.160", text:"Configurazione esportazione su file", parent: "alyante"},
        {value:"000.500.050.100.020", text:"Interrogazione registro stampe", parent: "alyante"},
        {value:"000.500.040.250.050", text:"Config. invio liste di distribuzione", parent: "alyante"},
        {value:"000.500.050.140.010", text:"Interrogazione log elaborazioni", parent: "alyante"},
        {value:"000.100.010.020.020", text:"Anagrafica piano dei conti generale", parent: "alyante"},
        {value:"000.150.090.010.030", text:"Dettaglio calendario risorsa di trasporto", parent: "alyante"},
        {value:"000.500.020.030", text:"Utenti, gruppi e aut. / Gruppi/Utenti", parent: "alyante"},
        {value:"000.150.190.900.100", text:"Raggruppamenti righe ordini", parent: "alyante"},
        {value:"000.350.010.010.140", text:"Provide proposta commerciale", parent: "alyante"},
        {value:"000.250.040.020.030", text:"Accorpamento proposte d'ordine", parent: "alyante"},
        {value:"000.500.100.030", text:"Schedulazione applicativi", parent: "alyante"},
        {value:"000.250.040.010.180", text:"Console risultati MRP", parent: "alyante"},
        {value:"000.500.180.510", text:"Regole autoavanzamento", parent: "alyante"},
        {value:"000.500.150.180.010", text:"Raggruppamenti eventi gestionali", parent: "alyante"},
        {value:"000.500.150.100", text:"Gestione messaggistica", parent: "alyante"},
        {value:"000.500.070.020.010", text:"Configurazione stampe gestionali (listbox single-column)", parent: "alyante"},
        {value:"000.511.011", text:"Test QGrid", parent: "alyante"},
        {value:"000.150.190.050", text:"Console blocco e assegnazione", parent: null},
        {value:"000.250.020.020.010", text:"Legami distinta base", parent: null},
        {value:"000.500.170.010", text:"Anagrafica attributi", parent: "alyante"},
        {value:"000.350.030.100.050", text:"Movimenti ...", parent: "alyante"},
        {value:"000.500.010.870.210", text:"Personalizzazione testi delle applicazioni", parent: "alyante"},
        {value:"000.500.010.050.040", text:"Attivazione aggiornamento automatico", parent: "alyante"},
        {value:"000.500.010.990.050", text:"Utility allineamento database (progressbar con dettaglio)", parent: "alyante"},
        {value:"000.150.020.040.020", text:"Interrogazione progressivi (da progressbar header + dettaglio a indeterminata)", parent: "alyante"},
        {value:"000.500.030.050", text:"Anagrafica funzioni", parent: "alyante"},
        {value:"000.250.240.040", text:"Visualizzazione C.R.P.", parent: "alyante"},
        {value:"000.500.060.010", text:"Parametri Generali Hypermedia (progressbar senza testo)", parent: "alyante"},
        {value:"000.250.040.020.040", text:"Generazione ordini fornitori da proposte d'ordine (progressbar con dettaglio ma senza progress)", parent: "alyante"},
        {value:"000.150.010.030.020", text:"Anagrafica articoli estesa (listbox multi-columns checked)", parent: "alyante"},
        {value:"000.050.070.010", text:"Gestione criteri di determinazione (listbox single-column)", parent: "alyante"},
        {value:"000.100.070.010.040", text:"Consolidamento movimenti prima nota (#687 e progressbar con header)", parent: "alyante"},
        {value:"000.500.010.870.240", text:"Gestione colori", parent: "alyante"},
        {value:"000.160.050.030", text:"Configurazione Integrazione Tustena", parent: "alyante"},
        {value:"000.250.040.010.120", text:"Produzione / Fabbisogni materiali / Sviluppo fabbisogni / Suggerimenti/Cancella (messagebox ok)", parent: "alyante"},
        {value:"000.250.140.160", text:"Console ordini (messagebox yes/no)", parent: "alyante"},
        {value:"000.450.040.510.050", text:"Dati aggiuntivi clienti per gruppi d'acquisto", parent: "alyante"},
        {value:"000.150.040.010.040", text:"Personalizzazione documenti azienda", parent: "alyante"},
        {value:"000.250.030.180", text:"Variazione calendario per qualifiche e dipendenti", parent: "alyante"},
        {value:"000.150.040.010.020", text:"Parametri generali documenti", parent: "alyante"},
        {value:"000.370.020.020.010", text:"Movimenti estratto conto", parent: "alyante"},
        {value:"000.100.070.040.260", text:"Interrogazione liquidazione IVA", parent: "alyante"},
        {value:"000.100.070.010.130", text:"Consolidamento progressivi per bilanci comparati", parent: "alyante"},
        {value:"000.100.070.040.480", text:"Modello richiesta rimborsi IVA infrannuali", parent: "alyante"},
        {value:"000.100.070.040.490", text:"Comunicazioni annuali dati IVA", parent: "alyante"},
        {value:"000.100.070.110.240", text:"Modifica data riferimento doc. note variazione IVA", parent: "alyante"},
        {value:"000.250.010.010.040", text:"Parametri e tabelle comuni / Macchine (datepicker da menù contestuale)", parent: "alyante"},
        {value:"000.300.020.030.010", text:"Configuratore di W.B.S.", parent: "alyante"},
        {value:"000.250.040.010.010", text:"Elaborazione fabbisogni lordi", parent: "alyante"},
        {value:"000.100.160.140", text:"Modulo INTRA", parent: "alyante"},
        {value:"000.100.070.010.070", text:"Situazione economica/patrimoniale", parent: "alyante"},
        {value:"000.050.010.090", text:"Scaglioni di pagamento generale (combo required)", parent: "alyante"},
        {value:"000.150.040.020.010", text:"tta documenti (gridnav con molti pulsanti)", parent: "alyante"},
        {value:"000.050.020.090", text:"Stampa comuni (radio e check con shortcut)", parent: "alyante"},
        {value:"000.050.030.120.010", text:"Sedi azienda", parent: "alyante"},
        {value:"000.150.040.030.020", text:"Manutenzione documenti (listbox disabled)", parent: "alyante"},
        {value:"000.100.070.010.030", text:"Interrogazione partitari", parent: "alyante"},
        {value:"000.100.180.010.200", text:"Distinta calcolo interessi Art. 62 (complex con errore di validazione)", parent: "alyante"},
        {value:"000.100.010.030.190", text:"Configurazione modello descrizione aggiuntiva (label con caratteri tra parentesi angolate)", parent: "alyante"},
        {value:"000.100.070.040.540", text:"Modello di comunicazione polivalente", parent: "alyante"},
        {value:"000.300.060.070", text:"Console pianificazione gantt", parent: "alyante"},
        {value:"000.500.180.050", text:"Anagrafica flussi / stati (canvas scrollabile)", parent: "alyante"},
        {value:"000.250.040.010.070", text:"Stampa situazione dinamica fabbisogni (test z-index)", parent: "alyante"},
        {value:"000.300.010.010.120", text:"Note di progetto", parent: "alyante"},
        {value:"000.300.040.010", text:"Anagrafica piani di fatturazione", parent: "alyante"},
        {value:"000.100.260.120.020", text:"Controllo elisioni intercompany", parent: "alyante"},
        {value:"000.150.090.020.010", text:"Gestione piani di carico", parent: "alyante"},
        {value:"000.500.010.870.100", text:"Personalizzazione login", parent: "alyante"},
        {value:"000.150.200.020.900.010", text:"Anagrafica rischio", parent: "alyante"},
        {value:"000.150.010.020.190", text:"Schede anagrafiche", parent: "alyante"},
        {value:"000.250.080.090", text:"Analisi e aggiornamenti costi (tab disabilitato)", parent: "alyante"},
        {value:"000.150.140.020.030", text:"Configuratore commerciale / Regole di configurazione (progress header + dettaglio)", parent: "alyante"},
        {value:"000.150.010.020.920", text:"Console configurazione varianti", parent: "alyante"},
        {value:"000.150.040.040.010", text:"Configurazione fatturazione elettronica", parent: "alyante"},
        {value:"000.100.070.010.190", text:"Comparazione bilanci", parent: "alyante"},
        {value:"000.300.030.020.060", text:"Console progetto", parent: "alyante"},
        {value:"000.150.010.010.010", text:"Tabelle comuni / Operatori", parent: "alyante"},
        {value:"000.150.040.020.010", text:"Emissione diretta documenti"}
    ]).sort(function(a, b){
        return a.text > b.text ? 1 : (a.text < b.text ? -1 : 0);
    });
    menu = $("#contextmenu")
        .dom_menu({
            //bindBlur: true,
            //width: 300,
            //maxWidth: 300,
            //maxHeight: 600
        }, function(value){
            console.log(value);
        })
        //.addClass('ui-widget-content')
        .close()
        .addElements(main.concat([{separator: true}]).concat(unsorted));
    $('#menu-toggler').on('click', function(e){
        var cr = e.currentTarget.getBoundingClientRect();
        menu.toggle(cr.left, cr.top+cr.height);
    });

    //menu.clear();
    //menu.addElements([{"text":"Attiva raggruppamenti","Checked":true,"id":2},{"text":"Filtri avanzati","Enabled":false,"id":524799},{"text":"Attiva","id":4,"parent":524799},{"text":"Disattiva","id":5,"parent":524799},{"text":"Attiva su tutte","id":7,"parent":524799},{"text":"Disattiva su tutte","id":8,"parent":524799},{"text":"Attiva autosearch","id":9},{"text":"Opzioni visualizzazione","id":262461},{"text":"Visualizza bande","Checked":true,"id":11,"parent":262461},{"text":"Assegna a banda","id":721199,"parent":262461},{"text":"Dati principali","id":13,"parent":721199},{"text":"Informazioni","id":87,"parent":721199},{"text":"Fissa banda","id":262455,"parent":262461},{"text":"Sinistra","id":15,"parent":262455},{"text":"Destra","id":16,"parent":262455},{"text":"Blocca colonne su banda","id":17,"parent":262461},{separator: true,"Enabled":false,"id":21},{"text":"Gestione layout","id":262451},{"text":"Salva","id":23,"parent":262451},{"text":"Carica","id":24,"parent":262451},{"text":"Elimina","id":25,"parent":262451},{"text":"Imposta standard","id":27,"parent":262451},{"text":"Personalizza...","id":28,"parent":262451},{"text":"Nascondi colonna","id":29,"parent":262451},{"text":"Layout gruppi","id":2294059,"parent":262451},{"text":"Salva","id":262457,"parent":2294059},{"text":"ADMIN - Amministratori","id":33,"parent":262457},{"text":"ASS - Assistenza","id":88,"parent":262457},{"text":"COMM - Commerciale","id":89,"parent":262457},{"text":"INS - Installatori","id":90,"parent":262457},{"text":"TEAMPORTAL - Utenti Teamportal","id":91,"parent":262457},{"text":"Carica","id":262449,"parent":2294059},{"text":"ADMIN - Amministratori","id":35,"parent":262449},{"text":"TEAMPORTAL - Utenti Teamportal","id":92,"parent":262449},{"text":"Elimina","id":262459,"parent":2294059},{"text":"ADMIN - Amministratori","id":37,"parent":262459},{"text":"TEAMPORTAL - Utenti Teamportal","id":93,"parent":262459},{separator: true,"Enabled":false,"id":46},{"text":"Esportazione","id":262453},{"text":"Excel...","id":48,"parent":262453},{"text":"XML...","id":49,"parent":262453},{"text":"HTML...","id":50,"parent":262453}]);

    /**
     * Scrollbars logic.
     */
    vscroll = $("#v-scroll").dom_scrollbar({
        height: 213,
        width: 25,
        orientation: "vertical",
        show_button: true, // has +\- 1 buttons
        value: 0, // startup value
        min: 0, // min val
        max: 258, //real: max - pager, is max viewed rows(on server)
        pager: 12, // is num of rows for page
        showTooltip: true,
        tooltipContent: function(val, max){
            return (val+1) + " / " + max;
        },
        dropOnStop: true,
        wheelSensibility: 50 // smaller is best
    }, function(value, type){
        console.log(value, type);
        $("#v-scroll-value").html(value, type);

        //vtooltip.tooltipWidget('open', 500).then(function(closeDefer){
        //    console.log("open defer");
        //    closeDefer.then(function(){
        //        console.log("close defer");
        //    })
        //}).then(function(){
        //    console.log("open defer 2");
        //});


    });
    $("#v-scroll-value").html(vscroll.value);

    hscroll = $("#h-scroll").dom_scrollbar({
        height: 25,
        width: 800,
        orientation: "horizontal",
        show_button: true, // has +\- 1 buttons
        value: 0, // startup value
        min: 5, // min val
        max: 21, //real: max - pager, is max viewed rows(on server)
        pager: 1, // is num of rows for page
        showTooltip: true,
        tooltipContent: function(val, max){
            return (val+1) + " / " + max;
        },
        dropOnStop: true,
        //lazy: true,
        //lazyTimeout: 500,
        wheelSensibility: 50 // smaller is best
    }, function(value, type){
        console.log(value, type);
        $("#h-scroll-value").html(value, type);

        //htooltip.tooltipWidget('open');
        //setTimeout(function(){
        //    htooltip.tooltipWidget('close');
        //}, 500);

    });
    $("#h-scroll-value").html(hscroll.value);


    /**
     * Panel with vScroller
     */
    //var $panel = $("#combo-vscroll"),
    //    $ul = $(".scrollable-node", $panel),
    //    ul = $ul.get(0),
    //    $ghost = $('<li class="ghost-elem"></li>').appendTo($ul),
    //    elemHeight = $ghost.outerHeight(); // 30
    //$ghost.remove();
    //var combo_vscroll = $(".v-scroll", $panel).dom_scrollbar({
    //    height: $panel.innerHeight(),
    //    width: 18,
    //    orientation: "vertical",
    //    show_button: true, // has +\- 1 buttons
    //    value: 0, // startup value
    //    min: 0, // min val
    //    max: Math.ceil((ul.scrollHeight-ul.offsetHeight)/elemHeight)+1, //real: max - pager, is max viewed rows(on server)
    //    pager: 1, // is num of rows for page
    //    //showTooltip: true,
    //    //tooltipContent: function(val, max){
    //    //    return (val+1) + " / " + max;
    //    //},
    //    dropOnStop: false,
    //    //lazy: true,
    //    //lazyTimeout: 1000,
    //    wheelSensibility: 50 // smaller is best
    //}, function(value, type){
    //    $ul.scrollTop(value*elemHeight);
    //});
    //$ul.onMouseWheel(combo_vscroll.scrollByEvent);

    /**
     * Combobox logic.
     */
    combo = $("#combo").dom_combobox({
        width : 200,
        height : 30,
        editable : false,
        selectionBoxHeight : '200',
        placeholder: "Seleziona una città...",
        fireChangeOnClose: false
    }).addElements([
        {group: "CAT-1"},
        {text: "<i>é</i>&#20107;事", value: "test1", index:"0"},
        {text: "Matera", value: "mat", icon: "man-icon"},
        {group: "CAT-2"},
        {text: "Fabriano", value: "fab"},
        {text: "Bari", value: "bar"},
        {text: "Ancona", value: "anc", index:"1"},
        {text: "", value: "ic-1", icon: "default-icon centered"},
        {text: "", value: "ic-2", icon: "bookmark-icon centered"},
        {text: "", value: "ic-3", icon: "man-icon centered"},
        {text: "       ", value: "test2"},
        {text: "", value: ""},
        {text: "", value: ""},
        {text: "", value: ""},
        {text: "", value: ""},
        {text: "", value: ""},
        {text: "Milano", value: "mil"}
    ]).on('getfocus', function(){
        console.log('getfocus');
        // mobileLog && mobileLog.warn('focusin');
        $("#combo-focus-state").html("is focus");
    }).on('lostfocus', function(){
        console.log('lostfocus');
        // mobileLog && mobileLog.error('focusout');
        $("#combo-focus-state").html("focus lost");
    }).on('blur', function(){
        console.log('blur');
        // mobileLog && mobileLog.error('blur');
        $("#combo-focus-state").html("is blur");
    }).on('change', function(e, value, oldValue){
        console.log('change', value, oldValue);
        // mobileLog && mobileLog('change', value, oldValue);
        $("#combo-change-value").html("current value: "+value+", old value: "+oldValue);
    });
    $("#combo-deselect").on('click', function(){
        combo.deselectAll();
    });
    $("#combo-select-0Index").on('click', function(){
        combo.selectIndex(0);
    });

    /**
     * Tooltips logic.
     */
    tooltip = $("#tooltip").tooltipWidget({
        target: '#tooltip-placeholder', // reference node
        effectDuration: 200, // fadein\out duration
        position: {
            my: "left center",
            at: "right+15 center"
        },
        content: function(){
            return "tooltip text";
        }
    });
    tooltip.tooltipWidget('open',/*auto-close time*/3000, 'auto-close in 3s').then(function(promise){
        // open complete

        setTimeout(function(){
            tooltip.tooltipWidget('updateContent', 'closing in 1s');
        }, 2000);

        promise.then(function(){
            // auto-close complete
        });
    });
    $("#tooltip-placeholder").on('click', function(){
        if(tooltip.tooltipWidget('isOpened')){
            tooltip.tooltipWidget('close').then(function(){
                // close complete
                $("#tooltip-placeholder").html('Open');
            });
        } else {
            tooltip.tooltipWidget('open').then(function(){
                // open complete
                $("#tooltip-placeholder").html('Close');
            });
        }
    });

    // Multitext
    // create new widget instance.
    multi = $('#multi').multitext({
        classes: 'ui-control-multitext',
        subFieldClasses: 'ui-control-textfield',
        // events
        onfocus: function(){
            // code
        },
        onblur: function(){
            // code
        },
        onchange: function(e, data/*object*/){
            // data.value
            // data.index
        },
        ontab: function(e, data/*object*/){
            // data.dir === 1 -> 'go-next'
            // data.dir === -1 -> 'go-prev'
        },
        onafternodecreate: function(e, $node/*jQuery*/){
            // code
        },
        validationCheck: function(value /*string*/, index /*number*/, field /*object*/){
            console.log('value', value);
            console.log('index', index);
            console.log('field', field);
            var defer = $.Deferred();
            // code
            if(value === 'AA') {
                defer.resolve(false);
            } else {
                defer.resolve(true);
            }
            return defer;
        },
        validate: true, // validateCheck is called on maxlength, shift+tab, tab, backspace and enter
        textRuler: function(charsNum/*integer*/){
            // you can customize this method.
            return charsNum*15; // it return px dimension
        },
        disabled: false, // initial disabled state
        // placeholder: '...', // optional
        width: 450,
        align: 'center', // undefined for default (left)
        mask: {
            maxlength: 5,
            transform: 'uppercase' // or lowercase: true
        },
        fields: [{
            type: 'text', // undefined is default. Input accept all characters.
            mask: {
                transform: 'uppercase', // or transform: 'lowercase'
                maxlength: 2
            },
            // validate: false, // true or false
            align: undefined,
            classes: 'sub-test-class',
            disabled: false,
            value: 'IT', // initial value
            placeholder: 'SN'
        }, {
            type: 'number',
            disabled: false,
            mask: {
                maxlength: 2,
                transform: 'lowercase'
            },
            value: 2,
            placeholder: 'CC'
        }]
    });
});