BEGIN;
/*
Created: 30/05/2013
Modified: 29/10/2015
Project: Portale
Model: Unified Communication
Company: TeamSystem
Author: Software Di Base 
Version: 20150001
Database: PostgreSQL 8.1
*/
SET client_encoding = 'LATIN1'; -- per inserire i commenti 
SET backslash_quote = true;     -- per inserire i commenti 
SET client_min_messages = error;
SET search_path = public, pg_catalog;
SET default_tablespace = '';
SET default_with_oids = false;
-- Create tables section -------------------------------------------------
-- Table public.uc001_tbserver
CREATE TABLE uc001_tbserver(
 uc001_id BigSerial NOT NULL,
 uc001_id_pbx Character varying(255),
 uc001_descrizione_server Text,
 uc001_host_ip Character varying(255),
 uc001_porta Integer,
 uc001_chiave_rsa Text,
 uc001_ultimo_cron_callreport Timestamp with time zone,
 uc001_utente_creazione_id_bp001 Integer,
 uc001_dataora_creazione Timestamp NOT NULL,
 uc001_utente_modifica_id_bp001 Integer,
 uc001_dataora_modifica Timestamp with time zone NOT NULL,
 uc001_admin_username Character varying(255),
 uc001_admin_password Character varying(255),
 uc001_external_ui BOOLEAN DEFAULT false NOT NULL
)
WITHOUT OIDS
;
COMMENT ON TABLE uc001_tbserver IS '[caption:"Server"]'
;
COMMENT ON COLUMN uc001_tbserver.uc001_id IS '[alias:"ID"]'
;
COMMENT ON COLUMN uc001_tbserver.uc001_id_pbx IS '[alias:"ID pbx"]'
;
COMMENT ON COLUMN uc001_tbserver.uc001_descrizione_server IS '[alias:"Descrizione"]'
;
COMMENT ON COLUMN uc001_tbserver.uc001_host_ip IS '[alias:"Host IP"]'
;
COMMENT ON COLUMN uc001_tbserver.uc001_porta IS '[alias:"Numero porta"]'
;
COMMENT ON COLUMN uc001_tbserver.uc001_chiave_rsa IS '[alias:"Chiave RSA"]'
;
COMMENT ON COLUMN uc001_tbserver.uc001_ultimo_cron_callreport IS '[alias:"Ultima sincronizzazione callreport"]'
;
COMMENT ON COLUMN uc001_tbserver.uc001_utente_creazione_id_bp001 IS '[alias:"ID utente creazione"]'
;
COMMENT ON COLUMN uc001_tbserver.uc001_dataora_creazione IS '[alias:"Data ora creazione"]'
;
COMMENT ON COLUMN uc001_tbserver.uc001_utente_modifica_id_bp001 IS '[alias:"ID utente ultima modifica"]'
;
COMMENT ON COLUMN uc001_tbserver.uc001_dataora_modifica IS '[alias:"Data ora creazione"]'
;
COMMENT ON COLUMN uc001_tbserver.uc001_admin_username IS '[alias:"Nome utente amministratore"]'
;
COMMENT ON COLUMN uc001_tbserver.uc001_admin_password IS '[alias:"Password amministratore"]'
;
COMMENT ON COLUMN uc001_tbserver.uc001_external_ui IS '[alias:"Interfaccia VOIspeed esterna"]'
;
-- Add keys for table public.uc001_tbserver
ALTER TABLE uc001_tbserver ADD CONSTRAINT uc001_c01pk PRIMARY KEY (uc001_id)
;
-- Table public.uc002_tbassociazioni
CREATE TABLE uc002_tbassociazioni(
 uc002_id BigSerial NOT NULL,
 uc002_server_id_uc001 Bigint NOT NULL,
 uc002_azienda_id_bp003 Integer DEFAULT nextval('bp003_tbaziende_bp003_id_seq'::regclass) NOT NULL,
 uc002_flg_abilitato Boolean DEFAULT true NOT NULL
)
WITHOUT OIDS
;
COMMENT ON TABLE uc002_tbassociazioni IS '[caption:"Associazione azienda server"]'
;
COMMENT ON COLUMN uc002_tbassociazioni.uc002_id IS '[alias:"ID"]'
;
COMMENT ON COLUMN uc002_tbassociazioni.uc002_server_id_uc001 IS '[alias:"ID server"]'
;
COMMENT ON COLUMN uc002_tbassociazioni.uc002_azienda_id_bp003 IS '[alias:"ID azienda"]'
;
COMMENT ON COLUMN uc002_tbassociazioni.uc002_flg_abilitato IS '[alias:"Fleg abilitato"]'
;
-- Add keys for table public.uc002_tbassociazioni
ALTER TABLE uc002_tbassociazioni ADD CONSTRAINT uc002_c01pk PRIMARY KEY (uc002_id)
;
-- Table public.uc003_tbpreferenze_utente
CREATE TABLE uc003_tbpreferenze_utente(
 uc003_id BigSerial NOT NULL,
 uc003_nome Character varying(128) NOT NULL,
 uc003_valore Text,
 uc003_utente_id_bp001 Integer,
 uc003_azienda_id_bp003 Integer,
 uc003_dataora_modifica Timestamp with time zone NOT NULL
)
WITHOUT OIDS
;
COMMENT ON TABLE uc003_tbpreferenze_utente IS '[caption:"Preferenze utente"]'
;
COMMENT ON COLUMN uc003_tbpreferenze_utente.uc003_id IS '[alias:"ID"]'
;
COMMENT ON COLUMN uc003_tbpreferenze_utente.uc003_nome IS '[alias:"Nome preferenza"]'
;
COMMENT ON COLUMN uc003_tbpreferenze_utente.uc003_valore IS '[alias:"valore preferenza"]'
;
COMMENT ON COLUMN uc003_tbpreferenze_utente.uc003_utente_id_bp001 IS '[alias:"ID utente"]'
;
COMMENT ON COLUMN uc003_tbpreferenze_utente.uc003_azienda_id_bp003 IS '[alias:"ID azienda"]'
;
COMMENT ON COLUMN uc003_tbpreferenze_utente.uc003_dataora_modifica IS '[alias:"Data ora ultima modifica"]'
;
-- Add keys for table public.uc003_tbpreferenze_utente
ALTER TABLE uc003_tbpreferenze_utente ADD CONSTRAINT uc003_c02pk PRIMARY KEY (uc003_id)
;
-- Table public.uc004_tbcoda_notifiche
CREATE TABLE uc004_tbcoda_notifiche(
 uc004_id BigSerial NOT NULL,
 uc004_server_id_uc001 Bigint NOT NULL,
 uc004_dataora_inserimento Time with time zone NOT NULL,
 uc004_tipo_entita Character varying(25) NOT NULL,
 uc004_id_entita Integer NOT NULL,
 uc004_azione Character varying(25) NOT NULL,
 uc004_dati Text,
 uc004_azienda_id_bp003 Integer DEFAULT nextval('bp003_tbaziende_bp003_id_seq'::regclass) NOT NULL
)
WITHOUT OIDS
;
COMMENT ON TABLE uc004_tbcoda_notifiche IS '[caption:"Coda Notifiche"]'
;
COMMENT ON COLUMN uc004_tbcoda_notifiche.uc004_id IS '[alias:"ID"]'
;
COMMENT ON COLUMN uc004_tbcoda_notifiche.uc004_server_id_uc001 IS '[alias:"ID server"]'
;
COMMENT ON COLUMN uc004_tbcoda_notifiche.uc004_dataora_inserimento IS '[alias:"Data ora inserimento"]'
;
COMMENT ON COLUMN uc004_tbcoda_notifiche.uc004_tipo_entita IS '[alias:"Tipo entita"]'
;
COMMENT ON COLUMN uc004_tbcoda_notifiche.uc004_id_entita IS '[alias:"ID entita"]'
;
COMMENT ON COLUMN uc004_tbcoda_notifiche.uc004_azione IS '[alias:"Tipo azione"]'
;
COMMENT ON COLUMN uc004_tbcoda_notifiche.uc004_dati IS '[alias:"Dati"]'
;
COMMENT ON COLUMN uc004_tbcoda_notifiche.uc004_azienda_id_bp003 IS '[alias:"ID azienda"]'
;
-- Add keys for table public.uc004_tbcoda_notifiche
ALTER TABLE uc004_tbcoda_notifiche ADD CONSTRAINT uc004_c01pk PRIMARY KEY (uc004_id)
;
-- Table public.uc005_tbutenti_sincronizzazione
CREATE TABLE uc005_tbutenti_sincronizzazione(
 uc005_id BigSerial NOT NULL,
 uc005_utente_id_bp001 Integer NOT NULL,
 uc005_azienda_id_bp003 Integer NOT NULL
)
WITHOUT OIDS
;
COMMENT ON TABLE uc005_tbutenti_sincronizzazione IS '[caption:"Sincronizzazione utenti"]'
;
COMMENT ON COLUMN uc005_tbutenti_sincronizzazione.uc005_id IS '[alias:"ID"]'
;
COMMENT ON COLUMN uc005_tbutenti_sincronizzazione.uc005_utente_id_bp001 IS '[alias:"ID utenti"]'
;
COMMENT ON COLUMN uc005_tbutenti_sincronizzazione.uc005_azienda_id_bp003 IS '[alias:"ID azienda"]'
;
-- Add keys for table public.uc005_tbutenti_sincronizzazione
ALTER TABLE uc005_tbutenti_sincronizzazione ADD CONSTRAINT uc005_c01pk PRIMARY KEY (uc005_id)
;
-- Create relationships section ------------------------------------------------- 
ALTER TABLE uc003_tbpreferenze_utente ADD CONSTRAINT uc003_c02fk FOREIGN KEY (uc003_azienda_id_bp003) REFERENCES bp003_tbaziende (bp003_id) ON DELETE NO ACTION ON UPDATE NO ACTION
;
ALTER TABLE uc005_tbutenti_sincronizzazione ADD CONSTRAINT uc005_c01fk FOREIGN KEY (uc005_azienda_id_bp003) REFERENCES bp003_tbaziende (bp003_id) ON DELETE NO ACTION ON UPDATE NO ACTION
;
ALTER TABLE uc005_tbutenti_sincronizzazione ADD CONSTRAINT uc005_c02fk FOREIGN KEY (uc005_utente_id_bp001) REFERENCES bp001_tbutenti (bp001_id) ON DELETE NO ACTION ON UPDATE NO ACTION
;
ALTER TABLE uc002_tbassociazioni ADD CONSTRAINT uc002_c01fk FOREIGN KEY (uc002_server_id_uc001) REFERENCES uc001_tbserver (uc001_id) ON DELETE NO ACTION ON UPDATE NO ACTION
;
ALTER TABLE uc001_tbserver ADD CONSTRAINT uc001_c02fk FOREIGN KEY (uc001_utente_modifica_id_bp001) REFERENCES bp001_tbutenti (bp001_id) ON DELETE NO ACTION ON UPDATE NO ACTION
;
ALTER TABLE uc001_tbserver ADD CONSTRAINT uc001_c01fk FOREIGN KEY (uc001_utente_creazione_id_bp001) REFERENCES bp001_tbutenti (bp001_id) ON DELETE NO ACTION ON UPDATE NO ACTION
;
ALTER TABLE uc004_tbcoda_notifiche ADD CONSTRAINT uc004_c01fk FOREIGN KEY (uc004_server_id_uc001) REFERENCES uc001_tbserver (uc001_id) ON DELETE NO ACTION ON UPDATE NO ACTION
;
ALTER TABLE uc003_tbpreferenze_utente ADD CONSTRAINT uc003_c01fk FOREIGN KEY (uc003_utente_id_bp001) REFERENCES bp001_tbutenti (bp001_id) ON DELETE NO ACTION ON UPDATE NO ACTION
;
ALTER TABLE uc004_tbcoda_notifiche ADD CONSTRAINT uc004_c02fk FOREIGN KEY (uc004_azienda_id_bp003) REFERENCES bp003_tbaziende (bp003_id) ON DELETE NO ACTION ON UPDATE NO ACTION
;
ALTER TABLE uc002_tbassociazioni ADD CONSTRAINT uc002_c02fk FOREIGN KEY (uc002_azienda_id_bp003) REFERENCES bp003_tbaziende (bp003_id) ON DELETE CASCADE ON UPDATE CASCADE
;
CREATE TABLE uc006_tbtipiavviso (
  uc006_id SERIAL, 
  uc006_descrizione VARCHAR(30) NOT NULL, 
  uc006_tiporec_sigla VARCHAR(16) DEFAULT 'USER'
) WITHOUT OIDS;
ALTER TABLE uc006_tbtipiavviso ADD CONSTRAINT uc006_c01pk PRIMARY KEY (uc006_id);
ALTER TABLE uc006_tbtipiavviso ADD CONSTRAINT uc006_c02uq UNIQUE (uc006_descrizione);
COMMENT ON TABLE uc006_tbtipiavviso IS '[caption:"Tipi avviso"]';
COMMENT ON COLUMN uc006_tbtipiavviso.uc006_id IS '[alias:"Id Tipo avvisi"]';
COMMENT ON COLUMN uc006_tbtipiavviso.uc006_descrizione IS '[alias:"Descrizione"]';
COMMENT ON COLUMN uc006_tbtipiavviso.uc006_tiporec_sigla IS '[alias:"Sigla tipo record default ''USER''"]';
CREATE TABLE uc007_tbavvisi (
  uc007_id SERIAL, 
  uc007_azienda_id_bp003 INTEGER NOT NULL, 
  uc007_utente_id_bp001 INTEGER NOT NULL, 
  uc007_entita_id_bp124 INTEGER, 
  uc007_anagrafica_id_bp004 INTEGER NOT NULL, 
  uc007_tipoavviso_id_uc006 INTEGER NOT NULL, 
  uc007_stato INTEGER NOT NULL, 
  uc007_datacreazione TIMESTAMP WITHOUT TIME ZONE, 
  uc007_flg_bloccante BOOLEAN, 
  uc007_datavalidita DATE, 
  uc007_datascadenza DATE, 
  uc007_messaggio TEXT, 
  uc007_oggetto TEXT, 
  uc007_allegato VARCHAR(50),
  uc007_datachiusura TIMESTAMP WITHOUT TIME ZONE
) WITHOUT OIDS;
ALTER TABLE uc007_tbavvisi ADD CONSTRAINT uc007_c01pk PRIMARY KEY (uc007_id);
ALTER TABLE uc007_tbavvisi ADD CONSTRAINT uc007_c01fk FOREIGN KEY (uc007_anagrafica_id_bp004) REFERENCES bp004_tbanagrafiche (bp004_id) ON DELETE RESTRICT ON UPDATE RESTRICT;
ALTER TABLE uc007_tbavvisi ADD CONSTRAINT uc007_c02fk FOREIGN KEY (uc007_tipoavviso_id_uc006) REFERENCES uc006_tbtipiavviso (uc006_id) ON DELETE RESTRICT ON UPDATE RESTRICT;
ALTER TABLE uc007_tbavvisi ADD CONSTRAINT uc007_c03fk FOREIGN KEY (uc007_entita_id_bp124) REFERENCES bp124_tbentita (bp124_id) ON DELETE RESTRICT ON UPDATE RESTRICT;
ALTER TABLE uc007_tbavvisi ADD CONSTRAINT uc007_c04fk FOREIGN KEY (uc007_utente_id_bp001) REFERENCES bp001_tbutenti (bp001_id) ON DELETE RESTRICT ON UPDATE RESTRICT;
ALTER TABLE uc007_tbavvisi ADD CONSTRAINT uc007_c05fk FOREIGN KEY (uc007_azienda_id_bp003) REFERENCES bp003_tbaziende (bp003_id) ON DELETE RESTRICT ON UPDATE RESTRICT;
COMMENT ON TABLE uc007_tbavvisi IS '[caption:"Avvisi"]';
COMMENT ON COLUMN uc007_tbavvisi.uc007_id IS '[alias:"Id Avviso"]';
COMMENT ON COLUMN uc007_tbavvisi.uc007_azienda_id_bp003 IS '[alias:"Id azienda"]';
COMMENT ON COLUMN uc007_tbavvisi.uc007_utente_id_bp001 IS '[alias:"Id utente"]';
COMMENT ON COLUMN uc007_tbavvisi.uc007_entita_id_bp124 IS '[alias:"Id entit�"]';
COMMENT ON COLUMN uc007_tbavvisi.uc007_anagrafica_id_bp004 IS '[alias:"Id anagrafica"]';
COMMENT ON COLUMN uc007_tbavvisi.uc007_tipoavviso_id_uc006 IS '[alias:"Id tipo avviso"]';
COMMENT ON COLUMN uc007_tbavvisi.uc007_stato IS '[alias:"Stato"]';
COMMENT ON COLUMN uc007_tbavvisi.uc007_datacreazione IS '[alias:"Data creazione"]';
COMMENT ON COLUMN uc007_tbavvisi.uc007_flg_bloccante IS '[alias:"Flag bloccante"]';
COMMENT ON COLUMN uc007_tbavvisi.uc007_datavalidita IS '[alias:"Data validita"]';
COMMENT ON COLUMN uc007_tbavvisi.uc007_datascadenza IS '[alias:"Data scadenza"]';
COMMENT ON COLUMN uc007_tbavvisi.uc007_messaggio IS '[alias:"Messaggio"]';
COMMENT ON COLUMN uc007_tbavvisi.uc007_oggetto IS '[alias:"Oggetto messaggio"]';
COMMENT ON COLUMN uc007_tbavvisi.uc007_allegato IS '[alias:"Allegato"]';
COMMENT ON COLUMN uc007_tbavvisi.uc007_datachiusura IS '[alias:"Data chiusura"]';
CREATE TABLE uc008_tbannotazioniavviso (
  uc008_id SERIAL, 
  uc008_avviso_id_uc007 INTEGER NOT NULL, 
  uc008_utente_id_bp001 INTEGER NOT NULL, 
  uc008_data TIMESTAMP WITHOUT TIME ZONE, 
  uc008_messaggio TEXT
) WITHOUT OIDS;
ALTER TABLE uc008_tbannotazioniavviso ADD CONSTRAINT uc008_c01pk PRIMARY KEY (uc008_id);
ALTER TABLE uc008_tbannotazioniavviso ADD CONSTRAINT uc008_c01fk FOREIGN KEY (uc008_utente_id_bp001) REFERENCES bp001_tbutenti (bp001_id) ON DELETE RESTRICT ON UPDATE RESTRICT;
ALTER TABLE uc008_tbannotazioniavviso ADD CONSTRAINT uc008_c02fk FOREIGN KEY (uc008_avviso_id_uc007) REFERENCES uc007_tbavvisi (uc007_id) ON DELETE RESTRICT ON UPDATE RESTRICT;
COMMENT ON TABLE uc008_tbannotazioniavviso IS '[caption:"Azioni avviso"]';
COMMENT ON COLUMN uc008_tbannotazioniavviso.uc008_id IS '[alias:"Id annotazione"]';
COMMENT ON COLUMN uc008_tbannotazioniavviso.uc008_avviso_id_uc007 IS '[alias:"Id avviso"]';
COMMENT ON COLUMN uc008_tbannotazioniavviso.uc008_utente_id_bp001 IS '[alias:"Id utente"]';
COMMENT ON COLUMN uc008_tbannotazioniavviso.uc008_data IS '[alias:"Data azione"]';
COMMENT ON COLUMN uc008_tbannotazioniavviso.uc008_messaggio IS '[alias:"Messaggio annotazione"]';
CREATE TABLE uc009_tbpermessi (
  uc009_id SERIAL, 
  uc009_azienda_id_bp003 INTEGER NOT NULL, 
  uc009_tipoavviso_id_uc006 INTEGER, 
  uc009_entita_id_bp124 INTEGER NOT NULL, 
  uc009_descrizione VARCHAR(32) NOT NULL
) WITHOUT OIDS;
ALTER TABLE uc009_tbpermessi ADD CONSTRAINT uc009_c01pk PRIMARY KEY (uc009_id);
ALTER TABLE uc009_tbpermessi ADD CONSTRAINT uc009_c01fk FOREIGN KEY (uc009_azienda_id_bp003) REFERENCES bp003_tbaziende (bp003_id) ON DELETE RESTRICT ON UPDATE RESTRICT;
ALTER TABLE uc009_tbpermessi ADD CONSTRAINT uc009_c02fk FOREIGN KEY (uc009_tipoavviso_id_uc006) REFERENCES uc006_tbtipiavviso (uc006_id) ON DELETE RESTRICT ON UPDATE RESTRICT;
ALTER TABLE uc009_tbpermessi ADD CONSTRAINT uc009_c03fk FOREIGN KEY (uc009_entita_id_bp124) REFERENCES bp124_tbentita (bp124_id) ON DELETE RESTRICT ON UPDATE RESTRICT;
COMMENT ON TABLE uc009_tbpermessi IS '[caption:"Permessi per tipo avviso e azienda"]';
COMMENT ON COLUMN uc009_tbpermessi.uc009_id IS '[alias:"Id permesso"]';
COMMENT ON COLUMN uc009_tbpermessi.uc009_azienda_id_bp003 IS '[alias:"Id azienda"]';
COMMENT ON COLUMN uc009_tbpermessi.uc009_tipoavviso_id_uc006 IS '[alias:"Id tipo avviso"]';
COMMENT ON COLUMN uc009_tbpermessi.uc009_entita_id_bp124 IS '[alias:"Id entit�"]';
COMMENT ON COLUMN uc009_tbpermessi.uc009_descrizione IS '[alias:"Descrizione permesso"]';
ALTER TABLE uc009_tbpermessi ADD CONSTRAINT uc009_c01uq UNIQUE (uc009_azienda_id_bp003, uc009_tipoavviso_id_uc006);
ALTER TABLE uc009_tbpermessi ADD CONSTRAINT uc009_c02uq UNIQUE (uc009_azienda_id_bp003, uc009_descrizione);
CREATE TABLE uc010_tbconfig (
  uc010_id SERIAL, 
  uc010_codice SMALLINT DEFAULT 1, 
  uc010_gestionepermessi CHAR(1) DEFAULT 'N'
) WITHOUT OIDS;
ALTER TABLE uc010_tbconfig ADD CONSTRAINT uc010_c01pk PRIMARY KEY (uc010_id);
ALTER TABLE uc010_tbconfig ADD CONSTRAINT uc010_c01uq UNIQUE (uc010_codice);
COMMENT ON TABLE uc010_tbconfig IS '[caption:"Tabella configurazione"]';
COMMENT ON COLUMN uc010_tbconfig.uc010_id IS '[alias:"Id configurazione"]';
COMMENT ON COLUMN uc010_tbconfig.uc010_codice IS '[alias:"Codice sempre valorizzato a 1"]';
COMMENT ON COLUMN uc010_tbconfig.uc010_gestionepermessi IS '[alias:"Gestione permessi"]';
CREATE TABLE uc011_tbprocedure (
  uc011_id SERIAL, 
  uc011_procedura_id_bp090 BIGINT NOT NULL, 
  uc011_abilitata BOOLEAN DEFAULT false NOT NULL
) WITHOUT OIDS;
COMMENT ON TABLE uc011_tbprocedure IS '[caption:"Abilitazione procedure"]';
COMMENT ON COLUMN uc011_tbprocedure.uc011_id IS '[alias:"Id abilitazione procedura"]';
COMMENT ON COLUMN uc011_tbprocedure.uc011_procedura_id_bp090 IS '[alias:"Id procedura"]';
COMMENT ON COLUMN uc011_tbprocedure.uc011_abilitata IS '[alias:"Flag abilitazione"]';
ALTER TABLE uc011_tbprocedure ADD CONSTRAINT uc011_c01pk PRIMARY KEY (uc011_id);
ALTER TABLE uc011_tbprocedure ADD CONSTRAINT uc011_c01uq UNIQUE (uc011_procedura_id_bp090);
ALTER TABLE uc011_tbprocedure ADD CONSTRAINT uc011_c01fk FOREIGN KEY (uc011_procedura_id_bp090) REFERENCES bp090_tbprocedure (bp090_id) ON DELETE CASCADE ON UPDATE CASCADE;
-- 
INSERT INTO uc006_tbtipiavviso (uc006_id,uc006_descrizione,uc006_tiporec_sigla) VALUES (1,'Generico','STANDARD');
COMMIT;
