BEGIN;
CREATE TABLE uc006_tbtipiavviso (
  uc006_id SERIAL, 
  uc006_descrizione VARCHAR(30) NOT NULL, 
  uc006_tiporec_sigla VARCHAR(16) DEFAULT 'USER'
) WITHOUT OIDS;

ALTER TABLE uc006_tbtipiavviso ADD CONSTRAINT uc006_c01pk PRIMARY KEY (uc006_id);

ALTER TABLE uc006_tbtipiavviso ADD CONSTRAINT uc006_c02uq UNIQUE (uc006_descrizione);

COMMENT ON TABLE uc006_tbtipiavviso IS '[caption:"Tipi avviso"]';

COMMENT ON COLUMN uc006_tbtipiavviso.uc006_id IS '[alias:"Id Tipo avvisi"]';

COMMENT ON COLUMN uc006_tbtipiavviso.uc006_descrizione IS '[alias:"Descrizione"]';

COMMENT ON COLUMN uc006_tbtipiavviso.uc006_tiporec_sigla IS '[alias:"Sigla tipo record default ''USER''"]';

INSERT INTO uc006_tbtipiavviso (uc006_id,uc006_descrizione,uc006_tiporec_sigla) VALUES (1,'Generico','STANDARD');


CREATE TABLE uc007_tbavvisi (
  uc007_id SERIAL, 
  uc007_azienda_id_bp003 INTEGER NOT NULL, 
  uc007_utente_id_bp001 INTEGER NOT NULL, 
  uc007_entita_id_bp124 INTEGER, 
  uc007_anagrafica_id_bp004 INTEGER NOT NULL, 
  uc007_tipoavviso_id_uc006 INTEGER NOT NULL, 
  uc007_stato INTEGER NOT NULL, 
  uc007_datacreazione TIMESTAMP WITHOUT TIME ZONE, 
  uc007_flg_bloccante BOOLEAN, 
  uc007_datavalidita DATE, 
  uc007_datascadenza DATE, 
  uc007_messaggio TEXT, 
  uc007_oggetto TEXT, 
  uc007_allegato VARCHAR(50),
  uc007_datachiusura TIMESTAMP WITHOUT TIME ZONE
) WITHOUT OIDS;

ALTER TABLE uc007_tbavvisi ADD CONSTRAINT uc007_c01pk PRIMARY KEY (uc007_id);

ALTER TABLE uc007_tbavvisi ADD CONSTRAINT uc007_c01fk FOREIGN KEY (uc007_anagrafica_id_bp004) REFERENCES bp004_tbanagrafiche (bp004_id) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE uc007_tbavvisi ADD CONSTRAINT uc007_c02fk FOREIGN KEY (uc007_tipoavviso_id_uc006) REFERENCES uc006_tbtipiavviso (uc006_id) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE uc007_tbavvisi ADD CONSTRAINT uc007_c03fk FOREIGN KEY (uc007_entita_id_bp124) REFERENCES bp124_tbentita (bp124_id) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE uc007_tbavvisi ADD CONSTRAINT uc007_c04fk FOREIGN KEY (uc007_utente_id_bp001) REFERENCES bp001_tbutenti (bp001_id) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE uc007_tbavvisi ADD CONSTRAINT uc007_c05fk FOREIGN KEY (uc007_azienda_id_bp003) REFERENCES bp003_tbaziende (bp003_id) ON DELETE RESTRICT ON UPDATE RESTRICT;

COMMENT ON TABLE uc007_tbavvisi IS '[caption:"Avvisi"]';

COMMENT ON COLUMN uc007_tbavvisi.uc007_id IS '[alias:"Id Avviso"]';

COMMENT ON COLUMN uc007_tbavvisi.uc007_azienda_id_bp003 IS '[alias:"Id azienda"]';

COMMENT ON COLUMN uc007_tbavvisi.uc007_utente_id_bp001 IS '[alias:"Id utente"]';

COMMENT ON COLUMN uc007_tbavvisi.uc007_entita_id_bp124 IS '[alias:"Id entit�"]';

COMMENT ON COLUMN uc007_tbavvisi.uc007_anagrafica_id_bp004 IS '[alias:"Id anagrafica"]';

COMMENT ON COLUMN uc007_tbavvisi.uc007_tipoavviso_id_uc006 IS '[alias:"Id tipo avviso"]';

COMMENT ON COLUMN uc007_tbavvisi.uc007_stato IS '[alias:"Stato"]';

COMMENT ON COLUMN uc007_tbavvisi.uc007_datacreazione IS '[alias:"Data creazione"]';

COMMENT ON COLUMN uc007_tbavvisi.uc007_flg_bloccante IS '[alias:"Flag bloccante"]';

COMMENT ON COLUMN uc007_tbavvisi.uc007_datavalidita IS '[alias:"Data validita"]';

COMMENT ON COLUMN uc007_tbavvisi.uc007_datascadenza IS '[alias:"Data scadenza"]';

COMMENT ON COLUMN uc007_tbavvisi.uc007_messaggio IS '[alias:"Messaggio"]';

COMMENT ON COLUMN uc007_tbavvisi.uc007_oggetto IS '[alias:"Oggetto messaggio"]';

COMMENT ON COLUMN uc007_tbavvisi.uc007_allegato IS '[alias:"Allegato"]';

COMMENT ON COLUMN uc007_tbavvisi.uc007_datachiusura IS '[alias:"Data chiusura"]';

CREATE TABLE uc008_tbannotazioniavviso (
  uc008_id SERIAL, 
  uc008_avviso_id_uc007 INTEGER NOT NULL, 
  uc008_utente_id_bp001 INTEGER NOT NULL, 
  uc008_data TIMESTAMP WITHOUT TIME ZONE, 
  uc008_messaggio TEXT
) WITHOUT OIDS;

ALTER TABLE uc008_tbannotazioniavviso ADD CONSTRAINT uc008_c01pk PRIMARY KEY (uc008_id);

ALTER TABLE uc008_tbannotazioniavviso ADD CONSTRAINT uc008_c01fk FOREIGN KEY (uc008_utente_id_bp001) REFERENCES bp001_tbutenti (bp001_id) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE uc008_tbannotazioniavviso ADD CONSTRAINT uc008_c02fk FOREIGN KEY (uc008_avviso_id_uc007) REFERENCES uc007_tbavvisi (uc007_id) ON DELETE RESTRICT ON UPDATE RESTRICT;

COMMENT ON TABLE uc008_tbannotazioniavviso IS '[caption:"Azioni avviso"]';

COMMENT ON COLUMN uc008_tbannotazioniavviso.uc008_id IS '[alias:"Id annotazione"]';

COMMENT ON COLUMN uc008_tbannotazioniavviso.uc008_avviso_id_uc007 IS '[alias:"Id avviso"]';

COMMENT ON COLUMN uc008_tbannotazioniavviso.uc008_utente_id_bp001 IS '[alias:"Id utente"]';

COMMENT ON COLUMN uc008_tbannotazioniavviso.uc008_data IS '[alias:"Data azione"]';

COMMENT ON COLUMN uc008_tbannotazioniavviso.uc008_messaggio IS '[alias:"Messaggio annotazione"]';

CREATE TABLE uc009_tbpermessi (
  uc009_id SERIAL, 
  uc009_azienda_id_bp003 INTEGER NOT NULL, 
  uc009_tipoavviso_id_uc006 INTEGER, 
  uc009_entita_id_bp124 INTEGER NOT NULL, 
  uc009_descrizione VARCHAR(32) NOT NULL
) WITHOUT OIDS;

ALTER TABLE uc009_tbpermessi ADD CONSTRAINT uc009_c01pk PRIMARY KEY (uc009_id);

ALTER TABLE uc009_tbpermessi ADD CONSTRAINT uc009_c01fk FOREIGN KEY (uc009_azienda_id_bp003) REFERENCES bp003_tbaziende (bp003_id) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE uc009_tbpermessi ADD CONSTRAINT uc009_c02fk FOREIGN KEY (uc009_tipoavviso_id_uc006) REFERENCES uc006_tbtipiavviso (uc006_id) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE uc009_tbpermessi ADD CONSTRAINT uc009_c03fk FOREIGN KEY (uc009_entita_id_bp124) REFERENCES bp124_tbentita (bp124_id) ON DELETE RESTRICT ON UPDATE RESTRICT;

COMMENT ON TABLE uc009_tbpermessi IS '[caption:"Permessi per tipo avviso e azienda"]';

COMMENT ON COLUMN uc009_tbpermessi.uc009_id IS '[alias:"Id permesso"]';

COMMENT ON COLUMN uc009_tbpermessi.uc009_azienda_id_bp003 IS '[alias:"Id azienda"]';

COMMENT ON COLUMN uc009_tbpermessi.uc009_tipoavviso_id_uc006 IS '[alias:"Id tipo avviso"]';

COMMENT ON COLUMN uc009_tbpermessi.uc009_entita_id_bp124 IS '[alias:"Id entit�"]';

COMMENT ON COLUMN uc009_tbpermessi.uc009_descrizione IS '[alias:"Descrizione permesso"]';

ALTER TABLE uc009_tbpermessi ADD CONSTRAINT uc009_c01uq UNIQUE (uc009_azienda_id_bp003, uc009_tipoavviso_id_uc006);
ALTER TABLE uc009_tbpermessi ADD CONSTRAINT uc009_c02uq UNIQUE (uc009_azienda_id_bp003, uc009_descrizione);

CREATE TABLE uc010_tbconfig (
  uc010_id SERIAL, 
  uc010_codice SMALLINT DEFAULT 1, 
  uc010_gestionepermessi CHAR(1) DEFAULT 'N'
) WITHOUT OIDS;

ALTER TABLE uc010_tbconfig ADD CONSTRAINT uc010_c01pk PRIMARY KEY (uc010_id);

ALTER TABLE uc010_tbconfig ADD CONSTRAINT uc010_c01uq UNIQUE (uc010_codice);

COMMENT ON TABLE uc010_tbconfig IS '[caption:"Tabella configurazione"]';

COMMENT ON COLUMN uc010_tbconfig.uc010_id IS '[alias:"Id configurazione"]';

COMMENT ON COLUMN uc010_tbconfig.uc010_codice IS '[alias:"Codice sempre valorizzato a 1"]';

COMMENT ON COLUMN uc010_tbconfig.uc010_gestionepermessi IS '[alias:"Gestione permessi"]';


CREATE TABLE public.uc011_tbprocedure (
  uc011_id SERIAL, 
  uc011_procedura_id_bp090 BIGINT NOT NULL, 
  uc011_abilitata BOOLEAN DEFAULT false NOT NULL
) WITHOUT OIDS;

COMMENT ON TABLE public.uc011_tbprocedure IS '[caption:"Abilitazione procedure"]';

COMMENT ON COLUMN public.uc011_tbprocedure.uc011_id IS '[alias:"Id abilitazione procedura"]';

COMMENT ON COLUMN public.uc011_tbprocedure.uc011_procedura_id_bp090 IS '[alias:"Id procedura"]';

COMMENT ON COLUMN public.uc011_tbprocedure.uc011_abilitata IS '[alias:"Flag abilitazione"]';

ALTER TABLE uc011_tbprocedure ADD CONSTRAINT uc011_c01pk PRIMARY KEY (uc011_id);

ALTER TABLE uc011_tbprocedure ADD CONSTRAINT uc011_c01uq UNIQUE (uc011_procedura_id_bp090);

ALTER TABLE uc011_tbprocedure ADD CONSTRAINT uc011_c01fk FOREIGN KEY (uc011_procedura_id_bp090) REFERENCES bp090_tbprocedure (bp090_id) ON DELETE RESTRICT ON UPDATE RESTRICT;ALTER TABLE uc011_tbprocedure DROP CONSTRAINT uc011_c01fk;
ALTER TABLE uc011_tbprocedure ADD CONSTRAINT uc011_c01fk FOREIGN KEY (uc011_procedura_id_bp090) REFERENCES bp090_tbprocedure (bp090_id) ON DELETE CASCADE ON UPDATE CASCADE;--------------------------------------------------------------------------------
-- Patch DB uc ver. 20190100 to 20210001
--------------------------------------------------------------------------------

ALTER TABLE uc001_tbserver ADD COLUMN uc001_external_ui BOOLEAN DEFAULT false NOT NULL;
COMMENT ON COLUMN uc001_tbserver.uc001_external_ui IS '[alias:"Interfaccia VOIspeed esterna"]';
-- 

COMMIT;
