/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class NotaInt {
    public DefaultHttpClient httpclient = new DefaultHttpClient();
    public String url = null;
    public String urlval = "https://tebeni.infocamere.it/teniWeb/TebeServiceValidateRequest";
    public String urlvis = "https://tebenitra.infocamere.it/teniWeb/TebeServiceTransformRequest";
    public String testurlval = "https://tebenicl.infocamere.it/teniWeb/TebeServiceValidateRequest";
    public String testurlvis = "https://tebenitracl.infocamere.it/teniWeb/TebeServiceTransformRequest";
    public String UscitaHtml = "uscita.html";
    public String UscitaXml = "uscita.xml";
    public String UscitaPdf = "uscita.pdf";
    public String filin = null;
    private String sproxyhost = new String("");
    private String sproxyport = new String("");
    private String servizio = new String("");
    private String tkauth = new String("");
    private String lingua = new String("");
    private String srv = new String("");
    private String lng = new String("");
    private String tkn = new String("");
    private int iproxyport = 0;
    private String direttorio = new String("");
    private static String FS = File.separator;
    private boolean buio = false;
    private boolean urlarg = false;

    public static void main(String[] args) throws Throwable {
        HttpResponse hr;
        NotaInt tb = new NotaInt();
        System.out.println("Parametri:");
        int i = 0;
        while (i < args.length) {
            System.out.println(args[i].toString().trim());
            ++i;
        }
        tb.controllaparametri(args);
        if (tb.servizio.equals("view")) {
            tb.url = tb.urlvis;
            if (tb.urlarg) {
                tb.url = tb.testurlvis;
            }
        } else {
            tb.url = tb.urlval;
            if (tb.urlarg) {
                tb.url = tb.testurlval;
            }
        }
        System.out.println("URL: " + tb.url);
        String filepath = tb.direttorio + FS + args[0];
        String respkind = args[1];
        tb.filin = args[0].replaceFirst("[.][^.]+$", "");
        HttpPost hp = tb.generapost(tb.url, filepath, tb.tkauth, respkind);
        if (hp == null) {
            System.exit(-1);
        }
        if ((hr = tb.eseguimetodopost(hp)) == null) {
            System.exit(-2);
        }
        if (hr.getStatusLine().getStatusCode() != 200) {
            System.exit(-2);
        }
        HttpEntity he = hr.getEntity();
        if (hr == null) {
            System.exit(-3);
        }
        String pathout = "";
        if (respkind.equals("html")) {
            pathout = tb.direttorio + FS + tb.filin + tb.UscitaHtml;
        }
        if (respkind.equals("xml")) {
            pathout = tb.direttorio + FS + tb.filin + tb.UscitaXml;
        }
        if (respkind.equals("pdf")) {
            pathout = tb.direttorio + FS + tb.filin + tb.UscitaPdf;
        }
        File delfile = new File(pathout);
        delfile.delete();
        int count = 0;
        byte[] bytes = new byte[20000];
        FileOutputStream fout = null;
        BufferedInputStream br = null;
        fout = new FileOutputStream(pathout);
        br = new BufferedInputStream(he.getContent());
        count = br.read(bytes);
        while (count != -1 && count <= 20000) {
            fout.write(bytes, 0, count);
            count = br.read(bytes);
        }
        if (count != -1) {
            fout.write(bytes, 0, count);
        }
        br.close();
        fout.flush();
        fout.close();
        if (!tb.buio) {
            tb.visuaoutput(pathout);
        }
        System.exit(0);
    }

    public HttpPost generapost(String Url, String filename, String aute, String resp) {
        HttpPost httpost = new HttpPost(Url);
        try {
            MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("validationProfile", "base"));
            if (this.servizio.equals("")) {
                nvps.add(new BasicNameValuePair("serviceRequired", "validate"));
                System.out.println("ValidazioneDefault");
            } else if (this.servizio.equals("view")) {
                nvps.add(new BasicNameValuePair("serviceRequired", this.servizio));
                System.out.println("Visualizzazione in formato " + this.servizio);
            } else {
                nvps.add(new BasicNameValuePair("serviceRequired", "validate"));
                System.out.println("Validazione");
            }
            System.out.println("aute = " + aute);
            if (aute.equals("")) {
                System.out.println("TOKEN");
                nvps.add(new BasicNameValuePair("token", "TebeniService_d6452f0e"));
            } else {
                nvps.add(new BasicNameValuePair("token", aute));
            }
            if (this.servizio.equals("view")) {
                if (resp.equals("html")) {
                    nvps.add(new BasicNameValuePair("outputTF", "html"));
                } else {
                    nvps.add(new BasicNameValuePair("outputTF", "pdf"));
                }
                if (this.lingua.equals("") || this.lingua.equals("it") || this.lingua.equals("en") || this.lingua.equals("fr") || this.lingua.equals("de")) {
                    if (this.lingua.equals("")) {
                        nvps.add(new BasicNameValuePair("tfLanguage", "it"));
                    } else {
                        nvps.add(new BasicNameValuePair("tfLanguage", this.lingua));
                    }
                }
            } else {
                nvps.add(new BasicNameValuePair("showWarnings", "true"));
                if (resp.equals("html")) {
                    nvps.add(new BasicNameValuePair("teberesponse", "html"));
                } else {
                    nvps.add(new BasicNameValuePair("teberesponse", "xml"));
                }
            }
            int k = 0;
            while (k < nvps.size()) {
                NameValuePair n = (NameValuePair)nvps.get(k);
                try {
                    reqEntity.addPart(n.getName(), new StringBody(n.getValue()));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                ++k;
            }
            FileBody bin = new FileBody(new File(filename));
            reqEntity.addPart("xbrlInstanceCompletePath", bin);
            httpost.setEntity(reqEntity);
            return httpost;
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.chiamaerrore(7);
            return null;
        }
    }

    public HttpResponse eseguimetodopost(HttpPost httpost) {
        try {
            if (this.iproxyport != 0) {
                HttpHost proxysenig = new HttpHost(this.sproxyhost, this.iproxyport);
                this.httpclient.getParams().setParameter("http.route.default-proxy", proxysenig);
                ArrayList<String> authPrefs = new ArrayList<String>(2);
                authPrefs.add("Basic");
                authPrefs.add("Digest");
                this.httpclient.getParams().setParameter("http.auth.proxy-scheme-pref", authPrefs);
                this.httpclient.getParams().setParameter("http.auth.target-scheme-pref", authPrefs);
            }
            CloseableHttpResponse response = this.httpclient.execute(httpost);
            return response;
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.chiamaerrore(8);
            return null;
        }
    }

    public void chiamaerrore(int errore) {
    }

    public void controllaparametri(String[] parametri) {
        if (parametri.length < 4) {
            System.out.println("\nPer controllo usa i parametri: file-xbrl tipo-risposta token-autenticazione \"DIRETTORIO=XXXXX\" <\"PROXY=HOST:PORT\">\n");
            System.exit(1);
        }
        int k = 0;
        while (k < parametri.length) {
            String daprocessare = parametri[k].trim();
            int indiceuguale = parametri[k].indexOf("=");
            int indiceduepunti = parametri[k].indexOf(":");
            if (daprocessare.toUpperCase().startsWith("TOKEN") && indiceuguale != -1) {
                this.tkn = daprocessare.substring(indiceuguale + 1);
                this.tkauth = this.tkn.trim();
                if (this.tkn.equals("")) {
                    System.out.println("Token di default\n");
                }
            }
            if (daprocessare.toUpperCase().startsWith("DIRETTORIO") && indiceuguale != -1) {
                this.direttorio = daprocessare.substring(indiceuguale + 1);
                File chkdir = new File(this.direttorio);
                if (!chkdir.isDirectory()) {
                    System.out.println("Direttorio di interscambio non valido");
                    System.exit(2);
                }
            }
            if (daprocessare.toUpperCase().startsWith("PROXY") && indiceduepunti != -1) {
                this.sproxyhost = daprocessare.substring(indiceuguale + 1, indiceduepunti);
                this.sproxyport = daprocessare.substring(indiceduepunti + 1);
                try {
                    this.iproxyport = Integer.parseInt(this.sproxyport.trim());
                }
                catch (Throwable t) {
                    System.out.println("Port Proxy non valida\n");
                    System.exit(3);
                }
                if (this.sproxyhost.length() == 0) {
                    System.out.println("Host Proxy non valido (len=0)\n");
                    System.exit(4);
                }
            }
            if (daprocessare.toUpperCase().startsWith("SERVIZIO") && indiceuguale != -1) {
                this.srv = daprocessare.substring(indiceuguale + 1);
                this.servizio = this.srv.trim();
                if (this.srv.equals("")) {
                    System.out.println("Servizio di default = validazione \n");
                }
            }
            if (daprocessare.toUpperCase().startsWith("LINGUA") && indiceuguale != -1) {
                this.lng = daprocessare.substring(indiceuguale + 1);
                this.lingua = this.lng.trim();
                if (this.lng.equals("")) {
                    System.out.println("Servizio di default = validazione \n");
                }
            }
            if (daprocessare.toUpperCase().equals("BUIO")) {
                this.buio = true;
            }
            if (daprocessare.toUpperCase().equals("URLTEST")) {
                this.urlarg = true;
            }
            ++k;
        }
        if (this.direttorio.length() == 0) {
            System.out.println("\nPer controllo usa i parametri: file-xbrl tipo-risposta token-autenticazione \"DIRETTORIO=XXXXX\" <\"PROXY=HOST:PORT\">\n");
            System.exit(4);
        }
    }

    public void visuaoutput(String perco) {
        try {
            String cmd = "rundll32 url.dll,FileProtocolHandler " + perco;
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmd);
            int exitVal = proc.waitFor();
            System.out.println("ExitValue: " + exitVal);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

